/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.serializer.math;

public class Countdown {
    private final int startValue;
    private int remainingValue;

    public Countdown(int startValue) {
        if (startValue < 0) {
            throw new IllegalArgumentException("Countdown value may not be negative: " + startValue);
        }
        this.startValue = startValue;
        this.remainingValue = startValue;
    }

    public int getStartValue() {
        return this.startValue;
    }

    public int getRemainingValue() {
        return this.remainingValue;
    }

    public String toString() {
        return Integer.toString(this.remainingValue);
    }

    public int decrement() {
        if (this.remainingValue == 0) {
            return 1;
        }
        --this.remainingValue;
        return 0;
    }

    public int decrease(int offset) {
        if (offset < 0) {
            throw new IllegalArgumentException(String.valueOf(this.getClass().getSimpleName()) + " decrease offset may not be negative: " + offset);
        }
        int value = this.remainingValue;
        if (value == 0) {
            return offset;
        }
        if (offset > value) {
            this.remainingValue = 0;
            return offset - value;
        }
        this.remainingValue = value - offset;
        return 0;
    }

    private int manipulateRemainingValue(int newValue) {
        int value = this.remainingValue;
        this.remainingValue = newValue;
        return value;
    }

    public int reset() {
        return this.manipulateRemainingValue(this.startValue);
    }

    public int expire() {
        return this.manipulateRemainingValue(0);
    }

    public boolean isActive() {
        return this.remainingValue > 0;
    }

    public boolean isExpired() {
        return this.remainingValue == 0;
    }

    public boolean isAtStart() {
        return this.remainingValue == this.startValue;
    }
}

