/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.serializer.io;

import java.io.Closeable;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.charset.Charset;
import java.nio.file.CopyOption;
import java.nio.file.DirectoryStream;
import java.nio.file.FileAlreadyExistsException;
import java.nio.file.FileSystem;
import java.nio.file.FileSystems;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.FileAttribute;
import java.util.Arrays;
import java.util.function.Consumer;
import java.util.function.Predicate;
import org.eclipse.serializer.chars.VarString;
import org.eclipse.serializer.chars.XChars;
import org.eclipse.serializer.collections.BulkList;
import org.eclipse.serializer.collections.XArrays;
import org.eclipse.serializer.exceptions.IORuntimeException;
import org.eclipse.serializer.functional.XFunc;
import org.eclipse.serializer.io.FilePathException;
import org.eclipse.serializer.io.IoOperation;
import org.eclipse.serializer.io.IoOperationR;
import org.eclipse.serializer.io.IoOperationS;
import org.eclipse.serializer.io.IoOperationSR;
import org.eclipse.serializer.memory.XMemory;
import org.eclipse.serializer.util.UtilStackTrace;
import org.eclipse.serializer.util.X;

public final class XIO {
    public static char fileSuffixSeparator() {
        return '.';
    }

    public static char filePathSeparator() {
        return '/';
    }

    public static String addFileSuffix(String fileName, String fileSuffix) {
        return fileSuffix != null ? String.valueOf(fileName) + XIO.fileSuffixSeparator() + fileSuffix : fileName;
    }

    public static String getFileSuffix(Path file) {
        return XIO.getFileSuffix(XIO.getFileName(file));
    }

    public static String getFileSuffix(String fileName) {
        if (XChars.hasNoContent(fileName)) {
            return null;
        }
        int fileSuffixSeparatorIndex = fileName.lastIndexOf(XIO.fileSuffixSeparator());
        if (fileSuffixSeparatorIndex < 0) {
            return null;
        }
        return fileName.substring(fileSuffixSeparatorIndex + 1);
    }

    public static String getFilePrefix(Path file) {
        return XIO.getFilePrefix(XIO.getFileName(file));
    }

    public static String getFilePrefix(String fileName) {
        if (XChars.hasNoContent(fileName)) {
            return null;
        }
        int fileSuffixSeparatorIndex = fileName.lastIndexOf(XIO.fileSuffixSeparator());
        if (fileSuffixSeparatorIndex < 0) {
            return fileName;
        }
        return fileName.substring(0, fileSuffixSeparatorIndex);
    }

    public static void unchecked(IoOperation operation) throws IORuntimeException {
        try {
            operation.execute();
        }
        catch (IOException e) {
            throw UtilStackTrace.cutStacktraceByOne(new IORuntimeException(e));
        }
    }

    public static <T> T unchecked(IoOperationR<T> operation) throws IORuntimeException {
        try {
            return operation.executeR();
        }
        catch (IOException e) {
            throw UtilStackTrace.cutStacktraceByOne(new IORuntimeException(e));
        }
    }

    public static <S> void unchecked(IoOperationS<S> operation, S subject) throws IORuntimeException {
        try {
            operation.executeS(subject);
        }
        catch (IOException e) {
            throw UtilStackTrace.cutStacktraceByOne(new IORuntimeException(e));
        }
    }

    public static <S, R> R unchecked(IoOperationSR<S, R> operation, S subject) throws IORuntimeException {
        try {
            return operation.executeSR(subject);
        }
        catch (IOException e) {
            throw UtilStackTrace.cutStacktraceByOne(new IORuntimeException(e));
        }
    }

    public static <C extends Closeable> C close(C closable, Throwable suppressed) throws IOException {
        if (closable == null) {
            return null;
        }
        try {
            closable.close();
        }
        catch (IOException e) {
            if (suppressed != null) {
                e.addSuppressed(suppressed);
            }
            throw e;
        }
        return closable;
    }

    public static <C extends AutoCloseable> C close(C closable, Throwable suppressed) throws Exception {
        if (closable == null) {
            return null;
        }
        try {
            closable.close();
        }
        catch (Exception e) {
            if (suppressed != null) {
                e.addSuppressed(suppressed);
            }
            throw e;
        }
        return closable;
    }

    public static String ensureNormalizedPathSeperators(String path) {
        if (path.indexOf(92) < 0) {
            return path;
        }
        return path.replace('\\', '/');
    }

    public static String ensureTrailingSlash(String path) {
        if (path.charAt(path.length() - 1) == '/') {
            return path;
        }
        return String.valueOf(path) + '/';
    }

    public static String buildFilePath(String ... items) {
        return VarString.New().list("/", items).toString();
    }

    public static Path Path(String path) {
        return XIO.Path(FileSystems.getDefault(), path);
    }

    public static Path Path(FileSystem fileSystem, String path) {
        return fileSystem.getPath(path, new String[0]);
    }

    public static Path Path(String ... items) {
        return XIO.Path(FileSystems.getDefault(), items);
    }

    public static Path Path(FileSystem fileSystem, String ... items) {
        if (items == null) {
            throw new NullPointerException();
        }
        if (items.length > 0 && "".equals(items[0])) {
            return fileSystem.getPath(Character.toString(XIO.filePathSeparator()), items);
        }
        return items.length == 1 ? fileSystem.getPath(items[0], new String[0]) : fileSystem.getPath(items[0], Arrays.copyOfRange(items, 1, items.length));
    }

    public static Path Path(Path parent, String ... items) {
        if (parent == null) {
            return XIO.Path(items);
        }
        return parent.getFileSystem().getPath(parent.toString(), items);
    }

    public static String getFilePath(Path file) {
        return file != null ? file.toString() : null;
    }

    public static String getFileName(Path file) {
        return file != null ? file.getFileName().toString() : null;
    }

    public static String[] splitPath(Path path) {
        String pathString = path.toString();
        String separator = path.getFileSystem().getSeparator();
        return XChars.splitSimple(pathString, separator);
    }

    public static VarString assemblePath(VarString vs, CharSequence ... elements) {
        return XChars.assembleSeparated(vs, XIO.filePathSeparator(), elements);
    }

    public static boolean isDirectory(Path path) throws IOException {
        return Files.isDirectory(path, new LinkOption[0]);
    }

    public static boolean exists(Path path) throws IOException {
        return Files.exists(path, new LinkOption[0]);
    }

    public static long size(Path file) throws IOException {
        return Files.size(file);
    }

    public static boolean delete(Path path) throws IOException {
        return Files.deleteIfExists(path);
    }

    public static Path[] listEntries(Path directory) throws IOException {
        return XIO.listEntries(directory, XFunc.all());
    }

    public static Path[] listEntries(Path directory, Predicate<? super Path> selector) throws IOException {
        return XIO.listEntries(directory, BulkList.New(), selector).toArray(Path.class);
    }

    public static <C extends Consumer<? super Path>> C listEntries(Path directory, C target) throws IOException {
        return XIO.iterateEntries(directory, target);
    }

    public static <C extends Consumer<? super Path>> C listEntries(Path directory, C target, Predicate<? super Path> selector) throws IOException {
        return XIO.iterateEntries(directory, target, selector);
    }

    public static <C extends Consumer<? super Path>> C iterateEntries(Path directory, C logic) throws IOException {
        return XIO.iterateEntries(directory, logic, XFunc.all());
    }

    public static <C extends Consumer<? super Path>> C iterateEntries(Path directory, C logic, Predicate<? super Path> selector) throws IOException {
        Throwable throwable = null;
        Object var4_5 = null;
        try (DirectoryStream<Path> stream = Files.newDirectoryStream(directory);){
            for (Path p : stream) {
                if (!selector.test(p)) continue;
                logic.accept((Path)p);
            }
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
        return logic;
    }

    public static boolean hasNoFiles(Path directory) throws IOException {
        Throwable throwable = null;
        Object var2_4 = null;
        try (DirectoryStream<Path> stream = Files.newDirectoryStream(directory);){
            boolean bl = !stream.iterator().hasNext();
            return bl;
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    public static long lastModified(Path file) throws IOException {
        return Files.getLastModifiedTime(file, new LinkOption[0]).toMillis();
    }

    public static String toAbsoluteNormalizedPath(Path file) {
        return file.toAbsolutePath().normalize().toString();
    }

    public static <P extends Path> P ensureDirectory(P directory) throws IOException {
        Files.createDirectories(directory, new FileAttribute[0]);
        return directory;
    }

    public static <P extends Path> P ensureDirectoryAndFile(P file) throws IOException {
        Path parent = file.getParent();
        if (parent != null) {
            XIO.ensureDirectory(parent);
        }
        return XIO.ensureFile(file);
    }

    public static <P extends Path> P ensureFile(P file) throws IOException {
        if (Files.notExists(file, new LinkOption[0])) {
            try {
                Files.createFile(file, new FileAttribute[0]);
            }
            catch (FileAlreadyExistsException fileAlreadyExistsException) {
            }
            catch (IOException e) {
                throw e;
            }
        }
        return file;
    }

    public static <P extends Path> P ensureWriteableFile(P file) throws IOException, FilePathException {
        XIO.ensureFile(file);
        if (!Files.isWritable(file)) {
            throw new FilePathException(file, "Unwritable file");
        }
        return file;
    }

    public static FileChannel openFileChannelReading(Path file) throws IOException {
        return FileChannel.open(file, StandardOpenOption.READ);
    }

    public static FileChannel openFileChannelWriting(Path file) throws IOException {
        return FileChannel.open(file, StandardOpenOption.WRITE);
    }

    public static FileChannel openFileChannelRW(Path file) throws IOException {
        return FileChannel.open(file, StandardOpenOption.READ, StandardOpenOption.WRITE);
    }

    public static FileChannel openFileChannelReading(Path file, OpenOption ... options) throws IOException {
        return XIO.openFileChannel(file, XArrays.ensureContained(options, StandardOpenOption.READ));
    }

    public static FileChannel openFileChannelWriting(Path file, OpenOption ... options) throws IOException {
        return XIO.openFileChannel(file, XArrays.ensureContained(options, StandardOpenOption.WRITE));
    }

    public static FileChannel openFileChannelRW(Path file, OpenOption ... options) throws IOException {
        return XIO.openFileChannelWriting(file, XArrays.ensureContained(options, StandardOpenOption.READ));
    }

    public static FileChannel openFileChannel(Path file, OpenOption ... options) throws IOException {
        return FileChannel.open(file, options);
    }

    public static <T> T readOneShot(Path file, IoOperationSR<FileChannel, T> operation) throws IOException {
        return XIO.performClosingOperation(XIO.openFileChannelReading(file), operation);
    }

    public static String readString(String filePath) throws IOException {
        return XIO.readString(XIO.Path(filePath));
    }

    public static String readString(String filePath, Charset charSet) throws IOException {
        return XIO.readString(XIO.Path(filePath), charSet);
    }

    public static String readString(Path file) throws IOException {
        return XIO.readString(file, XChars.standardCharset());
    }

    public static String readString(Path file, Charset charSet) throws IOException {
        byte[] bytes = XIO.read_bytes(file);
        return XChars.String(bytes, charSet);
    }

    public static String readString(FileChannel fileChannel) throws IOException {
        return XIO.readString(fileChannel, XChars.standardCharset());
    }

    public static String readString(FileChannel fileChannel, Charset charSet) throws IOException {
        byte[] bytes = XIO.read_bytes(fileChannel);
        return XChars.String(bytes, charSet);
    }

    public static byte[] read_bytes(Path file) throws IOException {
        ByteBuffer content = XIO.read(file);
        byte[] bytes = XMemory.toArray(content);
        XMemory.deallocateDirectByteBuffer(content);
        return bytes;
    }

    public static byte[] read_bytes(FileChannel fileChannel) throws IOException {
        ByteBuffer bb = XIO.read(fileChannel);
        byte[] bytes = XMemory.toArray(bb);
        XMemory.deallocateDirectByteBuffer(bb);
        return bytes;
    }

    public static ByteBuffer read(Path file) throws IOException {
        return XIO.readOneShot(file, XIO::read);
    }

    public static <T> T writeOneShot(Path file, IoOperationSR<FileChannel, T> operation) throws IOException {
        XIO.ensureWriteableFile(file);
        return XIO.performClosingOperation(XIO.openFileChannelWriting(file), operation);
    }

    public static long write(Path file, String string) throws IOException {
        return XIO.write(file, string, XChars.standardCharset());
    }

    public static long write(Path file, String string, Charset charset) throws IOException {
        byte[] bytes = string.getBytes(charset);
        return XIO.write(file, bytes);
    }

    public static long write(Path file, byte[] bytes) throws IOException {
        ByteBuffer dbb = XIO.wrapInDirectByteBuffer(bytes);
        Long writeCount = XIO.write(file, dbb);
        XMemory.deallocateDirectByteBuffer(dbb);
        return writeCount;
    }

    public static long write(Path file, ByteBuffer buffer) throws IOException {
        return XIO.writeOneShot(file, fc -> XIO.write(fc, buffer));
    }

    public static void truncate(Path file, long newSize) throws IOException {
        XIO.writeOneShot(file, fc -> fc.truncate(newSize));
    }

    public static long writePositioned(Path file, long filePosition, String string) throws IOException {
        return XIO.writePositioned(file, filePosition, string, XChars.standardCharset());
    }

    public static long writePositioned(Path file, long filePosition, String string, Charset charset) throws IOException {
        byte[] bytes = string.getBytes(charset);
        return XIO.writePositioned(file, filePosition, bytes);
    }

    public static long writePositioned(Path file, long filePosition, byte[] bytes) throws IOException {
        ByteBuffer dbb = XIO.wrapInDirectByteBuffer(bytes);
        Long writeCount = XIO.writePositioned(file, filePosition, dbb);
        XMemory.deallocateDirectByteBuffer(dbb);
        return writeCount;
    }

    public static long writePositioned(Path file, long filePosition, ByteBuffer buffer) throws IOException {
        return XIO.writeOneShot(file, fc -> XIO.writePositioned(fc, filePosition, buffer));
    }

    public static long writeAppending(Path file, String string) throws IOException {
        return XIO.writeAppending(file, string, XChars.standardCharset());
    }

    public static long writeAppending(Path file, String string, Charset charset) throws IOException {
        byte[] bytes = string.getBytes(charset);
        return XIO.writeAppending(file, bytes);
    }

    public static long writeAppending(Path file, byte[] bytes) throws IOException {
        ByteBuffer dbb = XIO.wrapInDirectByteBuffer(bytes);
        Long writeCount = XIO.writeAppending(file, dbb);
        XMemory.deallocateDirectByteBuffer(dbb);
        return writeCount;
    }

    public static long writeAppending(Path file, ByteBuffer buffer) throws IOException {
        return XIO.writeOneShot(file, fc -> XIO.writeAppending(fc, buffer));
    }

    public static void mergeBinary(Iterable<Path> sourceFiles, Path targetFile, Predicate<? super Path> selector) {
        FileChannel channel = null;
        try {
            IOException suppressed = null;
            try {
                try {
                    channel = XIO.openFileChannelWriting(targetFile, StandardOpenOption.APPEND);
                    for (Path sourceFile : sourceFiles) {
                        if (!selector.test(sourceFile)) continue;
                        Throwable throwable = null;
                        Object var8_11 = null;
                        try (FileChannel sourceChannel = XIO.openFileChannelReading(sourceFile);){
                            sourceChannel.transferTo(0L, sourceChannel.size(), channel);
                        }
                        catch (Throwable throwable2) {
                            if (throwable == null) {
                                throwable = throwable2;
                            } else if (throwable != throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                            throw throwable;
                        }
                    }
                }
                catch (IOException e) {
                    suppressed = e;
                    XIO.close(channel, suppressed);
                }
            }
            finally {
                XIO.close(channel, suppressed);
            }
        }
        catch (IOException e) {
            throw new IORuntimeException(e);
        }
    }

    public static void mergeBinary(Iterable<Path> sourceFiles, Path targetFile) {
        XIO.mergeBinary(sourceFiles, targetFile, XFunc.all());
    }

    public static void move(Path sourceFile, Path targetFile) throws IOException, RuntimeException {
        try {
            Files.move(sourceFile, targetFile, new CopyOption[0]);
        }
        catch (IOException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static ByteBuffer determineLastNonEmpty(ByteBuffer[] byteBuffers) {
        int i = byteBuffers.length - 1;
        while (i >= 0) {
            if (byteBuffers[i].hasRemaining()) {
                return byteBuffers[i];
            }
            --i;
        }
        return null;
    }

    public static ByteBuffer wrapInDirectByteBuffer(byte[] bytes) {
        ByteBuffer dbb = ByteBuffer.allocateDirect(bytes.length);
        dbb.put(bytes);
        dbb.flip();
        return dbb;
    }

    public static long appendAll(FileChannel fileChannel, ByteBuffer[] byteBuffers) throws IOException {
        ByteBuffer lastNonEmpty = XIO.determineLastNonEmpty(byteBuffers);
        if (lastNonEmpty == null) {
            return 0L;
        }
        long oldLength = fileChannel.size();
        long writeCount = 0L;
        fileChannel.position(oldLength);
        while (lastNonEmpty.hasRemaining()) {
            writeCount += fileChannel.write(byteBuffers);
        }
        return writeCount;
    }

    public static long appendAllGuaranteed(FileChannel fileChannel, ByteBuffer[] byteBuffers) throws IOException {
        long oldLength = fileChannel.size();
        long writeCount = XIO.appendAll(fileChannel, byteBuffers);
        fileChannel.force(false);
        long newTotalLength = fileChannel.size();
        if (newTotalLength != oldLength + writeCount) {
            throw new IOException("Inconsistent post-write file length: New total length " + newTotalLength + " is not equal " + oldLength + " + " + writeCount + " (old length and write count)");
        }
        return writeCount;
    }

    public static long writeAppending(FileChannel fileChannel, ByteBuffer buffer) throws IOException {
        return XIO.writePositioned(fileChannel, fileChannel.size(), buffer);
    }

    public static long writePositioned(FileChannel fileChannel, long filePosition, ByteBuffer buffer) throws IOException {
        fileChannel.position(filePosition);
        return XIO.write(fileChannel, buffer);
    }

    public static long write(FileChannel fileChannel, ByteBuffer buffer) throws IOException {
        return XIO.writeToChannel(fileChannel, buffer);
    }

    public static long write(FileChannel fileChannel, Iterable<? extends ByteBuffer> buffers) throws IOException {
        long writeCount = 0L;
        for (ByteBuffer byteBuffer : buffers) {
            writeCount += XIO.writeToChannel(fileChannel, byteBuffer);
        }
        return writeCount;
    }

    public static void truncate(FileChannel fileChannel, long newSize) throws IOException {
        fileChannel.truncate(newSize);
    }

    private static long writeToChannel(FileChannel fileChannel, ByteBuffer buffer) throws IOException {
        long writeCount = 0L;
        while (buffer.hasRemaining()) {
            writeCount += (long)fileChannel.write(buffer);
        }
        return writeCount;
    }

    public static <T> T performClosingOperation(FileChannel fileChannel, IoOperationSR<FileChannel, T> operation) throws IOException {
        try {
            T t = operation.executeSR(fileChannel);
            return t;
        }
        finally {
            fileChannel.close();
        }
    }

    public static ByteBuffer read(FileChannel fileChannel) throws IOException {
        return XIO.read(fileChannel, 0L);
    }

    public static ByteBuffer read(FileChannel fileChannel, long filePosition) throws IOException {
        return XIO.read(fileChannel, filePosition, fileChannel.size());
    }

    public static ByteBuffer read(FileChannel fileChannel, long filePosition, long length) throws IOException {
        ByteBuffer dbb = ByteBuffer.allocateDirect(X.checkArrayRange(length));
        XIO.read(fileChannel, dbb, filePosition, dbb.limit());
        dbb.flip();
        return dbb;
    }

    public static long read(FileChannel fileChannel, ByteBuffer targetBuffer) throws IOException {
        return XIO.read(fileChannel, targetBuffer, 0L, fileChannel.size());
    }

    public static long read(FileChannel fileChannel, ByteBuffer targetBuffer, long filePosition, long length) throws IOException {
        if ((long)targetBuffer.remaining() < length) {
            throw new IllegalArgumentException("Provided target buffer has not enough space remaining to load the file content: " + targetBuffer.remaining() + " < " + length);
        }
        return XIO.internalRead(fileChannel, targetBuffer, filePosition, length);
    }

    public static long read(FileChannel fileChannel, ByteBuffer targetBuffer, long filePosition) throws IOException {
        return XIO.internalRead(fileChannel, targetBuffer, filePosition, targetBuffer.remaining());
    }

    private static long internalRead(FileChannel fileChannel, ByteBuffer targetBuffer, long filePosition, long effectiveLength) throws IOException {
        if (effectiveLength == 0L) {
            return 0L;
        }
        int targetLimit = X.checkArrayRange((long)targetBuffer.position() + effectiveLength);
        long fileLength = fileChannel.size();
        X.validateRange(fileLength, filePosition, effectiveLength);
        long fileOffset = filePosition;
        targetBuffer.limit(targetLimit);
        long readCount = 0L;
        while (targetBuffer.hasRemaining()) {
            fileOffset = filePosition + (readCount += (long)fileChannel.read(targetBuffer, fileOffset));
        }
        return readCount;
    }

    /*
     * Loose catch block
     */
    public static long copyFile(Path sourceFile, Path targetFile, OpenOption ... targetChannelOpenOptions) throws IOException {
        Throwable throwable = null;
        Object var4_5 = null;
        try {
            long l;
            FileChannel targetChannel;
            FileChannel sourceChannel;
            block16: {
                block15: {
                    sourceChannel = XIO.openFileChannelReading(sourceFile);
                    targetChannel = XIO.openFileChannelWriting(targetFile, targetChannelOpenOptions);
                    l = XIO.copyFile(sourceChannel, targetChannel);
                    if (targetChannel == null) break block15;
                    targetChannel.close();
                }
                if (sourceChannel == null) break block16;
                sourceChannel.close();
            }
            return l;
            {
                catch (Throwable throwable2) {
                    try {
                        if (targetChannel != null) {
                            targetChannel.close();
                        }
                        throw throwable2;
                    }
                    catch (Throwable throwable3) {
                        if (throwable == null) {
                            throwable = throwable3;
                        } else if (throwable != throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                        if (sourceChannel != null) {
                            sourceChannel.close();
                        }
                        throw throwable;
                    }
                }
            }
        }
        catch (Throwable throwable4) {
            if (throwable == null) {
                throwable = throwable4;
            } else if (throwable != throwable4) {
                throwable.addSuppressed(throwable4);
            }
            throw throwable;
        }
    }

    public static long copyFile(FileChannel sourceChannel, FileChannel targetChannel) throws IOException {
        return XIO.copyFile(sourceChannel, 0L, targetChannel);
    }

    public static long copyFile(FileChannel sourceChannel, FileChannel targetChannel, long targetPosition) throws IOException {
        return targetChannel.transferFrom(sourceChannel, targetPosition, sourceChannel.size());
    }

    public static long copyFile(FileChannel sourceChannel, long sourcePosition, FileChannel targetChannel) throws IOException {
        return XIO.copyFile(sourceChannel, sourcePosition, sourceChannel.size() - sourcePosition, targetChannel);
    }

    public static long copyFile(FileChannel sourceChannel, long sourcePosition, long length, FileChannel targetChannel) throws IOException {
        return sourceChannel.transferTo(sourcePosition, length, targetChannel);
    }

    public static long copyFile(FileChannel sourceChannel, FileChannel targetChannel, long targetPosition, long length) throws IOException {
        return targetChannel.transferFrom(sourceChannel, targetPosition, length);
    }

    private XIO() {
        throw new UnsupportedOperationException();
    }

    public static final class unchecked {
        public static <C extends Closeable> C close(C closable) throws IORuntimeException {
            if (closable == null) {
                return null;
            }
            try {
                closable.close();
            }
            catch (IOException e) {
                throw new IORuntimeException(e);
            }
            return closable;
        }

        public static <C extends AutoCloseable> C close(C closable) throws RuntimeException {
            if (closable == null) {
                return null;
            }
            try {
                closable.close();
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
            return closable;
        }

        public static <C extends Closeable> C close(C closable, Throwable suppressed) throws IORuntimeException {
            try {
                return XIO.close(closable, suppressed);
            }
            catch (IOException e) {
                throw new IORuntimeException(e);
            }
        }

        public static <C extends AutoCloseable> C close(C closable, Throwable suppressed) throws RuntimeException {
            try {
                return XIO.close(closable, suppressed);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }

        public static long size(FileChannel fileChannel) throws IORuntimeException {
            try {
                return fileChannel.size();
            }
            catch (IOException e) {
                throw new IORuntimeException(e);
            }
        }

        public static boolean isDirectory(Path path) throws IORuntimeException {
            try {
                return XIO.isDirectory(path);
            }
            catch (IOException e) {
                throw new IORuntimeException(e);
            }
        }

        public static boolean exists(Path path) throws IORuntimeException {
            try {
                return XIO.exists(path);
            }
            catch (IOException e) {
                throw new IORuntimeException(e);
            }
        }

        public static long size(Path file) throws IORuntimeException {
            try {
                return XIO.size(file);
            }
            catch (IOException e) {
                throw new IORuntimeException(e);
            }
        }

        public static boolean delete(Path path) throws IORuntimeException {
            try {
                return XIO.delete(path);
            }
            catch (IOException e) {
                throw new IORuntimeException(e);
            }
        }

        public static Path[] listEntries(Path directory) throws IORuntimeException {
            try {
                return XIO.listEntries(directory, XFunc.all());
            }
            catch (IOException e) {
                throw new IORuntimeException(e);
            }
        }

        public static Path[] listEntries(Path directory, Predicate<? super Path> selector) throws IORuntimeException {
            try {
                return XIO.listEntries(directory, selector);
            }
            catch (IOException e) {
                throw new IORuntimeException(e);
            }
        }

        public static <C extends Consumer<? super Path>> C listEntries(Path directory, C target) throws IORuntimeException {
            try {
                return XIO.listEntries(directory, target);
            }
            catch (IOException e) {
                throw new IORuntimeException(e);
            }
        }

        public static <C extends Consumer<? super Path>> C listEntries(Path directory, C target, Predicate<? super Path> selector) throws IORuntimeException {
            try {
                return XIO.listEntries(directory, target, selector);
            }
            catch (IOException e) {
                throw new IORuntimeException(e);
            }
        }

        public static <C extends Consumer<? super Path>> C iterateEntries(Path directory, C logic) throws IORuntimeException {
            try {
                return XIO.iterateEntries(directory, logic);
            }
            catch (IOException e) {
                throw new IORuntimeException(e);
            }
        }

        public static <C extends Consumer<? super Path>> C iterateEntries(Path directory, C logic, Predicate<? super Path> selector) throws IORuntimeException {
            try {
                return XIO.iterateEntries(directory, logic, selector);
            }
            catch (IOException e) {
                throw new IORuntimeException(e);
            }
        }

        public static boolean hasNoFiles(Path directory) throws IORuntimeException {
            try {
                return XIO.hasNoFiles(directory);
            }
            catch (IOException e) {
                throw new IORuntimeException(e);
            }
        }

        public static long lastModified(Path file) throws IORuntimeException {
            try {
                return XIO.lastModified(file);
            }
            catch (IOException e) {
                throw new IORuntimeException(e);
            }
        }

        public static <P extends Path> P ensureDirectory(P directory) throws IORuntimeException {
            try {
                return XIO.ensureDirectory(directory);
            }
            catch (IOException e) {
                throw new IORuntimeException(e);
            }
        }

        public static <P extends Path> P ensureDirectoryAndFile(P file) throws IORuntimeException {
            try {
                return XIO.ensureDirectoryAndFile(file);
            }
            catch (IOException e) {
                throw new IORuntimeException(e);
            }
        }

        public static <P extends Path> P ensureFile(P file) throws IORuntimeException {
            try {
                return XIO.ensureFile(file);
            }
            catch (IOException e) {
                throw new IORuntimeException(e);
            }
        }

        public static <P extends Path> P ensureWriteableFile(P file) throws IORuntimeException {
            try {
                return XIO.ensureWriteableFile(file);
            }
            catch (IOException e) {
                throw new IORuntimeException(e);
            }
        }

        public static void move(Path sourceFile, Path targetFile) throws RuntimeException {
            try {
                XIO.move(sourceFile, targetFile);
            }
            catch (IOException e) {
                throw new IORuntimeException(e);
            }
        }

        private unchecked() {
            throw new UnsupportedOperationException();
        }
    }
}

