/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.serializer.hashing;

import java.util.Objects;
import org.eclipse.serializer.hashing.HashEqualator;
import org.eclipse.serializer.math.XMath;
import org.eclipse.serializer.typing.KeyValue;
import org.eclipse.serializer.typing.XTypes;

public final class XHashing {
    static final SingletonIdentityHashEqualator HASH_EQUALITY_IDENTITY = new SingletonIdentityHashEqualator();
    static final SingletonValueHashEqualator HASH_EQUALITY_VALUE = new SingletonValueHashEqualator();
    static final SingletonKeyValueIdentityHashEqualator HASH_EQUALITY_IDENTITY_KV = new SingletonKeyValueIdentityHashEqualator();

    public static <E> HashEqualator<E> hashEqualityIdentity() {
        return HASH_EQUALITY_IDENTITY;
    }

    public static <E> HashEqualator<E> hashEqualityValue() {
        return HASH_EQUALITY_VALUE;
    }

    public static <KV extends KeyValue<?, ?>> HashEqualator<KV> keyValueHashEqualityKeyIdentity() {
        return HASH_EQUALITY_IDENTITY_KV;
    }

    public static int calculateHashLength(long desiredCapacity, float hashDensity) {
        return XHashing.padHashLength((long)Math.ceil((float)desiredCapacity / hashDensity));
    }

    public static int padHashLength(long desiredHashLength) {
        if (XMath.isGreaterThanOrEqualHighestPowerOf2(desiredHashLength)) {
            return XMath.highestPowerOf2_int();
        }
        int capacity = 1;
        while ((long)capacity < desiredHashLength) {
            capacity <<= 1;
        }
        return capacity;
    }

    public static boolean isValidHashDensity(float hashDensity) {
        return hashDensity > 0.0f && !Float.isNaN(hashDensity);
    }

    public static float validateHashDensity(float hashDensity) {
        if (!XHashing.isValidHashDensity(hashDensity)) {
            throw new IllegalArgumentException("Illegal hash density: " + hashDensity);
        }
        return hashDensity;
    }

    public static <K, V> HashEqualator<KeyValue<K, V>> wrapAsKeyValue(final HashEqualator<? super K> hashEqualator) {
        return new HashEqualator<KeyValue<K, V>>(){

            @Override
            public int hash(KeyValue<K, V> kv) {
                return kv == null ? 0 : hashEqualator.hash(kv.key());
            }

            @Override
            public boolean equal(KeyValue<K, V> kv1, KeyValue<K, V> kv2) {
                return kv1 != null && kv2 != null && hashEqualator.equal(kv1.key(), kv2.key());
            }
        };
    }

    public static <E> HashEqualator<E> deriveHashEquality(Class<E> type) {
        return XTypes.isValueType(type) ? XHashing.hashEqualityValue() : XHashing.hashEqualityIdentity();
    }

    private XHashing() {
        throw new UnsupportedOperationException();
    }

    static final class NonNullSingletonValueHashEqualator
    implements HashEqualator.ValueTypeHashEqualator<Object> {
        NonNullSingletonValueHashEqualator() {
        }

        @Override
        public int hash(Object object) {
            return object.hashCode();
        }

        @Override
        public boolean equal(Object object1, Object object2) {
            return object1.equals(object2);
        }
    }

    static final class SingletonIdentityHashEqualator
    implements HashEqualator.IdentityHashEqualator<Object> {
        SingletonIdentityHashEqualator() {
        }

        @Override
        public int hash(Object object) {
            return System.identityHashCode(object);
        }

        @Override
        public boolean equal(Object object1, Object object2) {
            return object1 == object2;
        }
    }

    static final class SingletonKeyValueIdentityHashEqualator
    implements HashEqualator.IdentityHashEqualator<KeyValue<Object, Object>> {
        SingletonKeyValueIdentityHashEqualator() {
        }

        @Override
        public int hash(KeyValue<Object, Object> kv) {
            return System.identityHashCode(kv.key());
        }

        @Override
        public boolean equal(KeyValue<Object, Object> kv1, KeyValue<Object, Object> kv2) {
            return kv1.key() == kv2.key();
        }
    }

    static final class SingletonValueHashEqualator
    implements HashEqualator.ValueTypeHashEqualator<Object> {
        SingletonValueHashEqualator() {
        }

        @Override
        public int hash(Object object) {
            return object == null ? 0 : object.hashCode();
        }

        @Override
        public boolean equal(Object object1, Object object2) {
            return Objects.equals(object1, object2);
        }
    }
}

