/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.serializer.hashing;

import java.util.function.Consumer;
import org.eclipse.serializer.chars.VarString;
import org.eclipse.serializer.collections.types.XGettingTable;
import org.eclipse.serializer.hashing.HashStatistics;
import org.eclipse.serializer.math.XMath;
import org.eclipse.serializer.typing.KeyValue;
import org.eclipse.serializer.util.X;

public interface HashStatisticsBucketBased
extends HashStatistics {
    default public double averageBucketLength() {
        return (double)this.elementCount() / (double)this.hashLength();
    }

    public float hashDensity();

    public long highestBucketLength();

    public XGettingTable<Long, Long> bucketLengthDistribution();

    public static HashStatisticsBucketBased New(long hashLength, long elementCount, float hashDensity, long highestBucketLength, XGettingTable<Long, Long> bucketLengthDistribution) {
        return new Default(XMath.positive(hashLength), XMath.notNegative(elementCount), hashDensity, XMath.notNegative(highestBucketLength), X.notNull(bucketLengthDistribution));
    }

    public static final class Default
    implements HashStatisticsBucketBased {
        private final long hashLength;
        private final long elementCount;
        private final float hashDensity;
        private final long highestBucketLength;
        private final XGettingTable<Long, Long> bucketLengthDistribution;

        Default(long hashLength, long elementCount, float hashDensity, long highestBucketLength, XGettingTable<Long, Long> bucketLengthDistribution) {
            this.hashLength = hashLength;
            this.elementCount = elementCount;
            this.hashDensity = hashDensity;
            this.highestBucketLength = highestBucketLength;
            this.bucketLengthDistribution = bucketLengthDistribution;
        }

        @Override
        public final long hashLength() {
            return this.hashLength;
        }

        @Override
        public final long elementCount() {
            return this.elementCount;
        }

        @Override
        public final float hashDensity() {
            return this.hashDensity;
        }

        @Override
        public final long highestBucketLength() {
            return this.highestBucketLength;
        }

        @Override
        public final XGettingTable<Long, Long> bucketLengthDistribution() {
            return this.bucketLengthDistribution;
        }

        public final String toString() {
            return VarString.New().add("hashLength = ").add(this.hashLength).lf().add("elementCount = ").add(this.elementCount).lf().add("averageBucketLength = ").add(XMath.round2(this.averageBucketLength())).lf().add("hashDensity = ").add(this.hashDensity).lf().add("highestBucketLength = ").add(this.highestBucketLength).lf().add("bucketLengthDistribution: ").lf().apply(v -> {
                Consumer<KeyValue> consumer = this.bucketLengthDistribution.iterate(e -> {
                    VarString varString2 = v.add(e.key()).add(": ").add(e.value()).lf();
                });
            }).toString();
        }
    }
}

