/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.serializer.functional;

import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import org.eclipse.serializer.equality.Equalator;
import org.eclipse.serializer.functional.AbstractProcedureLimit;
import org.eclipse.serializer.functional.AbstractProcedureSkip;
import org.eclipse.serializer.functional.AbstractProcedureSkipLimit;
import org.eclipse.serializer.util.X;

public final class XFunc {
    public static final <T> Predicate<T> all() {
        return e -> true;
    }

    public static <T> Predicate<T> notNull() {
        return e -> e != null;
    }

    public static final <T, R> Function<T, R> toNull() {
        return t -> null;
    }

    public static final <T> Function<T, T> passThrough() {
        return t -> t;
    }

    public static final <T> Predicate<T> isEqualTo(final T subject) {
        return new Predicate<T>(){

            @Override
            public boolean test(T o) {
                return subject == null ? o == null : subject.equals(o);
            }
        };
    }

    public static final <T, E extends T> Predicate<T> predicate(final E subject, final Equalator<T> equalator) {
        return new Predicate<T>(){

            @Override
            public boolean test(T t) {
                return equalator.equal(subject, t);
            }
        };
    }

    public static <E> Consumer<E> wrapWithSkip(final Consumer<? super E> target, long skip) {
        return new AbstractProcedureSkip<E>(skip){

            @Override
            public void accept(E e) {
                if (--this.skip >= 0L) {
                    return;
                }
                target.accept(e);
            }
        };
    }

    public static <E> Consumer<E> wrapWithLimit(final Consumer<? super E> target, long limit) {
        return new AbstractProcedureLimit<E>(limit){

            @Override
            public void accept(E e) {
                target.accept(e);
                if (--this.limit == 0L) {
                    throw X.BREAK();
                }
            }
        };
    }

    public static <E> Consumer<E> wrapWithSkipLimit(final Consumer<? super E> target, long skip, long limit) {
        return new AbstractProcedureSkipLimit<E>(skip, limit){

            @Override
            public void accept(E e) {
                if (--this.skip >= 0L) {
                    return;
                }
                target.accept(e);
                if (--this.limit == 0L) {
                    throw X.BREAK();
                }
            }
        };
    }

    public static final <E> Consumer<E> wrapWithPredicate(Consumer<? super E> target, Predicate<? super E> predicate) {
        return e -> {
            if (!predicate.test((Object)e)) {
                return;
            }
            target.accept((Object)e);
        };
    }

    public static <E> Consumer<E> wrapWithPredicateSkip(final Consumer<? super E> target, final Predicate<? super E> predicate, long skip) {
        return new AbstractProcedureSkip<E>(skip){

            @Override
            public void accept(E e) {
                if (!predicate.test(e)) {
                    return;
                }
                if (--this.skip >= 0L) {
                    return;
                }
                target.accept(e);
            }
        };
    }

    public static <E> Consumer<E> wrapWithPredicateLimit(final Consumer<? super E> target, final Predicate<? super E> predicate, long limit) {
        return new AbstractProcedureLimit<E>(limit){

            @Override
            public void accept(E e) {
                if (!predicate.test(e)) {
                    return;
                }
                target.accept(e);
                if (--this.limit == 0L) {
                    throw X.BREAK();
                }
            }
        };
    }

    public static <E> Consumer<E> wrapWithPredicateSkipLimit(final Consumer<? super E> target, final Predicate<? super E> predicate, long skip, long limit) {
        return new AbstractProcedureSkipLimit<E>(skip, limit){

            @Override
            public void accept(E e) {
                if (!predicate.test(e)) {
                    return;
                }
                if (--this.skip >= 0L) {
                    return;
                }
                target.accept(e);
                if (--this.limit == 0L) {
                    throw X.BREAK();
                }
            }
        };
    }

    public static final <I, O> Consumer<I> wrapWithFunction(Consumer<? super O> target, Function<? super I, O> function) {
        return e -> target.accept((Object)function.apply((Object)e));
    }

    public static <I, O> Consumer<I> wrapWithFunctionSkip(final Consumer<? super O> target, final Function<? super I, O> function, long skip) {
        return new AbstractProcedureSkip<I>(skip){

            @Override
            public void accept(I e) {
                if (--this.skip >= 0L) {
                    return;
                }
                target.accept(function.apply(e));
            }
        };
    }

    public static <I, O> Consumer<I> wrapWithFunctionLimit(final Consumer<? super O> target, final Function<? super I, O> function, long limit) {
        return new AbstractProcedureLimit<I>(limit){

            @Override
            public void accept(I e) {
                target.accept(function.apply(e));
                if (--this.limit == 0L) {
                    throw X.BREAK();
                }
            }
        };
    }

    public static <I, O> Consumer<I> wrapWithFunctionSkipLimit(final Consumer<? super O> target, final Function<? super I, O> function, long skip, long limit) {
        return new AbstractProcedureSkipLimit<I>(skip, limit){

            @Override
            public void accept(I e) {
                if (--this.skip >= 0L) {
                    return;
                }
                target.accept(function.apply(e));
                if (--this.limit == 0L) {
                    throw X.BREAK();
                }
            }
        };
    }

    public static final <I, O> Consumer<I> wrapWithPredicateFunction(Consumer<? super O> target, Predicate<? super I> predicate, Function<? super I, O> function) {
        return e -> {
            if (!predicate.test((Object)e)) {
                return;
            }
            target.accept((Object)function.apply((Object)e));
        };
    }

    public static <I, O> Consumer<I> wrapWithPredicateFunctionSkip(final Consumer<? super O> target, final Predicate<? super I> predicate, final Function<? super I, O> function, long skip) {
        return new AbstractProcedureSkip<I>(skip){

            @Override
            public void accept(I e) {
                if (!predicate.test(e)) {
                    return;
                }
                if (--this.skip >= 0L) {
                    return;
                }
                target.accept(function.apply(e));
            }
        };
    }

    public static <I, O> Consumer<I> wrapWithPredicateFunctionLimit(final Consumer<? super O> target, final Predicate<? super I> predicate, final Function<? super I, O> function, long limit) {
        return new AbstractProcedureLimit<I>(limit){

            @Override
            public void accept(I e) {
                if (!predicate.test(e)) {
                    return;
                }
                target.accept(function.apply(e));
                if (--this.limit == 0L) {
                    throw X.BREAK();
                }
            }
        };
    }

    public static <I, O> Consumer<I> wrapWithPredicateFunctionSkipLimit(final Consumer<? super O> target, final Predicate<? super I> predicate, final Function<? super I, O> function, long skip, long limit) {
        return new AbstractProcedureSkipLimit<I>(skip, limit){

            @Override
            public void accept(I e) {
                if (!predicate.test(e)) {
                    return;
                }
                if (--this.skip >= 0L) {
                    return;
                }
                target.accept(function.apply(e));
                if (--this.limit == 0L) {
                    throw X.BREAK();
                }
            }
        };
    }

    private XFunc() {
        throw new UnsupportedOperationException();
    }
}

