/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.serializer.functional;

import java.util.function.Consumer;
import java.util.function.Predicate;
import org.eclipse.serializer.util.X;

public final class LimitedOperationWithPredicate<E>
implements Consumer<E> {
    private int skip;
    private int lim;
    private final Predicate<? super E> predicate;
    private final Consumer<? super E> procedure;

    public LimitedOperationWithPredicate(int skip, int limit, Predicate<? super E> predicate, Consumer<? super E> procedure) {
        this.skip = skip;
        this.lim = limit;
        this.predicate = predicate;
        this.procedure = procedure;
    }

    @Override
    public final void accept(E e) {
        if (!this.predicate.test(e)) {
            return;
        }
        if (this.skip > 0) {
            --this.skip;
            return;
        }
        this.procedure.accept(e);
        if (--this.lim == 0) {
            throw X.BREAK();
        }
    }
}

