/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.serializer.entity;

import java.time.Duration;
import java.time.Instant;
import java.util.Comparator;
import org.eclipse.serializer.collections.types.XTable;
import org.eclipse.serializer.entity.Entity;
import org.eclipse.serializer.util.X;

@FunctionalInterface
public interface EntityVersionCleaner<K> {
    public void cleanVersions(XTable<K, Entity> var1);

    public static <K extends Comparable<? super K>> EntityVersionCleaner<K> AmountPreserving(long maxPreservedVersions) {
        return new AmountPreserving(maxPreservedVersions, Comparator.naturalOrder());
    }

    public static <K> EntityVersionCleaner<K> AmountPreserving(long maxPreservedVersions, Comparator<K> comparator) {
        return new AmountPreserving<K>(maxPreservedVersions, comparator);
    }

    public static EntityVersionCleaner<Long> AgePreservingSystemTimeMillis(long preservedAgeMillis) {
        return new AgePreservingSystemTimeMillis(preservedAgeMillis);
    }

    public static EntityVersionCleaner<Long> AgePreservingSystemNanoTime(long preservedAgeNanos) {
        return new AgePreservingSystemNanoTime(preservedAgeNanos);
    }

    public static EntityVersionCleaner<Instant> AgePreservingInstant(Duration preservedAge) {
        return new AgePreservingInstant(preservedAge);
    }

    public static class AgePreservingInstant
    implements EntityVersionCleaner<Instant> {
        private final Duration preservedAge;

        protected AgePreservingInstant(Duration preservedAge) {
            this.preservedAge = preservedAge;
        }

        @Override
        public void cleanVersions(XTable<Instant, Entity> versions) {
            Instant minAge = Instant.now().minus(this.preservedAge);
            versions.removeBy(kv -> ((Instant)kv.key()).isBefore(minAge));
        }
    }

    public static class AgePreservingSystemNanoTime
    implements EntityVersionCleaner<Long> {
        private final long preservedAgeNanos;

        protected AgePreservingSystemNanoTime(long preservedAgeNanos) {
            this.preservedAgeNanos = preservedAgeNanos;
        }

        @Override
        public void cleanVersions(XTable<Long, Entity> versions) {
            long minAge = System.nanoTime() - this.preservedAgeNanos;
            versions.removeBy(kv -> (Long)kv.key() < minAge);
        }
    }

    public static class AgePreservingSystemTimeMillis
    implements EntityVersionCleaner<Long> {
        private final long preservedAgeMillis;

        protected AgePreservingSystemTimeMillis(long preservedAgeMillis) {
            this.preservedAgeMillis = preservedAgeMillis;
        }

        @Override
        public void cleanVersions(XTable<Long, Entity> versions) {
            long minAge = System.currentTimeMillis() - this.preservedAgeMillis;
            versions.removeBy(kv -> (Long)kv.key() < minAge);
        }
    }

    public static class AmountPreserving<K>
    implements EntityVersionCleaner<K> {
        private final long maxPreservedVersions;
        private final Comparator<? super K> comparator;

        protected AmountPreserving(long maxPreservedVersions, Comparator<? super K> comparator) {
            this.maxPreservedVersions = maxPreservedVersions;
            this.comparator = X.notNull(comparator);
        }

        @Override
        public void cleanVersions(XTable<K, Entity> versions) {
            if (versions.size() > this.maxPreservedVersions) {
                versions.sort((kv1, kv2) -> this.comparator.compare(kv1.key(), kv2.key()));
                do {
                    versions.pinch();
                } while (versions.size() > this.maxPreservedVersions);
            }
        }
    }
}

