/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.serializer.entity;

import org.eclipse.serializer.collections.EqHashTable;
import org.eclipse.serializer.collections.types.XGettingTable;
import org.eclipse.serializer.entity.Entity;
import org.eclipse.serializer.entity.EntityExceptionMissingDataForVersion;
import org.eclipse.serializer.entity.EntityLayer;
import org.eclipse.serializer.entity.EntityVersionCleaner;
import org.eclipse.serializer.entity.EntityVersionContext;
import org.eclipse.serializer.util.X;

public final class EntityLayerVersioning<K>
extends EntityLayer {
    EntityVersionContext<K> context;
    EqHashTable<K, Entity> versions;

    protected EntityLayerVersioning(Entity inner, EntityVersionContext<K> context) {
        super(inner);
        this.context = X.notNull(context);
        this.versions = EqHashTable.New(context.equalator());
    }

    synchronized XGettingTable<K, Entity> versions() {
        return this.versions.immure();
    }

    @Override
    protected synchronized Entity entityData() {
        K versionKey = this.context.currentVersion();
        if (versionKey == null) {
            return super.entityData();
        }
        Entity versionedData = this.versions.get(versionKey);
        if (versionedData == null) {
            throw new EntityExceptionMissingDataForVersion(this.entityIdentity(), versionKey);
        }
        return versionedData;
    }

    @Override
    protected synchronized void entityCreated() {
        K versionKey = this.context.versionForUpdate();
        if (versionKey != null) {
            this.versions.put(versionKey, super.entityData());
        }
        super.entityCreated();
    }

    @Override
    protected synchronized boolean updateEntityData(Entity data) {
        K versionKey = this.context.versionForUpdate();
        if (versionKey != null) {
            this.versions.put(versionKey, data);
            EntityVersionCleaner<K> cleaner = this.context.cleaner();
            if (cleaner != null) {
                cleaner.cleanVersions(this.versions);
            }
        }
        return super.updateEntityData(data);
    }
}

