/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.serializer.entity;

import org.eclipse.serializer.entity.Entity;
import org.eclipse.serializer.util.X;

public abstract class EntityLayer
extends Entity.AbstractAccessible {
    private transient Entity inner;

    protected EntityLayer(Entity inner) {
        this.inner = X.mayNull(inner);
    }

    @Override
    protected Entity entityIdentity() {
        return Entity.identity(this.inner);
    }

    @Override
    protected Entity entityData() {
        return Entity.data(this.inner);
    }

    @Override
    protected void entityCreated() {
        Entity.Creator.Static.entityCreated(this.inner);
    }

    @Override
    protected boolean updateEntityData(Entity newData) {
        if (!Entity.updateData(this.inner, newData)) {
            this.updateDataValidating(newData);
        }
        return true;
    }

    protected Entity inner() {
        return this.inner;
    }

    protected void validateNewData(Entity newData) {
        this.validateIdentity(newData);
    }

    protected void updateDataValidating(Entity newData) {
        Entity actualNewData = Entity.data(newData);
        this.validateNewData(actualNewData);
        this.setInner(actualNewData);
    }

    protected void setInner(Entity inner) {
        this.inner = inner;
    }
}

