/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.serializer.com;

import java.io.IOException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.UnknownHostException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.channels.NetworkChannel;
import java.nio.channels.ServerSocketChannel;
import java.nio.channels.SocketChannel;
import org.eclipse.serializer.com.ComException;
import org.eclipse.serializer.com.ComExceptionTimeout;
import org.eclipse.serializer.memory.XMemory;
import org.eclipse.serializer.util.X;
import org.eclipse.serializer.util.logging.Logging;
import org.slf4j.Logger;

public final class XSockets {
    private static final Logger logger = Logging.getLogger(XSockets.class);
    private static final int IO_LOOP_SLEEP_TIME = 10;

    public static ByteOrder byteOrder() {
        return ByteOrder.nativeOrder();
    }

    public static ServerSocketChannel openServerSocketChannel(InetSocketAddress address) throws ComException {
        try {
            logger.debug("creating server socket with address {}", (Object)address);
            ServerSocketChannel serverSocketChannel = ServerSocketChannel.open();
            serverSocketChannel.socket().bind(address);
            logger.debug("bound ServerSocketChannel to {}", (Object)serverSocketChannel);
            return serverSocketChannel;
        }
        catch (IOException e) {
            throw new ComException(e);
        }
    }

    public static SocketChannel acceptSocketChannel(ServerSocketChannel serverSocketChannel) throws ComException {
        try {
            return serverSocketChannel.accept();
        }
        catch (Exception e) {
            throw new ComException(e);
        }
    }

    public static SocketChannel openChannel(InetSocketAddress address) throws ComException {
        X.notNull(address);
        try {
            SocketChannel socketChannel = SocketChannel.open();
            socketChannel.connect(address);
            return socketChannel;
        }
        catch (IOException e) {
            throw new ComException(e);
        }
    }

    public static InetAddress localHostAddress() throws ComException {
        try {
            return InetAddress.getLocalHost();
        }
        catch (UnknownHostException e) {
            throw new ComException(e);
        }
    }

    public static InetSocketAddress localHostSocketAddress() throws ComException {
        return XSockets.localHostSocketAddress(0);
    }

    public static InetSocketAddress localHostSocketAddress(int port) throws ComException {
        return new InetSocketAddress(XSockets.localHostAddress(), port);
    }

    public static SocketChannel openChannelLocalhost() throws ComException {
        return XSockets.openChannel(XSockets.localHostSocketAddress());
    }

    public static SocketChannel openChannelLocalhost(int port) throws ComException {
        return XSockets.openChannel(XSockets.localHostSocketAddress(port));
    }

    public static void closeChannel(NetworkChannel channel) throws ComException {
        try {
            channel.close();
        }
        catch (Exception e) {
            throw new ComException(e);
        }
    }

    public static ByteBuffer writeCompletely(SocketChannel socketChannel, ByteBuffer byteBuffer) throws ComException {
        try {
            socketChannel.write(byteBuffer);
            return byteBuffer;
        }
        catch (IOException e) {
            throw new ComException(e);
        }
    }

    public static ByteBuffer readCompletely(SocketChannel socketChannel, ByteBuffer byteBuffer) throws ComException {
        try {
            socketChannel.read(byteBuffer);
            return byteBuffer;
        }
        catch (IOException e) {
            throw new ComException(e);
        }
    }

    public static ByteBuffer readIntoBufferKnownLength(SocketChannel channel, ByteBuffer buffer, int responseTimeout, int length) throws ComException {
        ByteBuffer checkedBuffer;
        if (length > buffer.capacity()) {
            checkedBuffer = XMemory.allocateDirectNative(length);
        } else {
            checkedBuffer = buffer;
            checkedBuffer.clear().limit(length);
        }
        XSockets.readIntoBuffer(channel, checkedBuffer, responseTimeout);
        return checkedBuffer;
    }

    public static int read(SocketChannel channel, ByteBuffer buffer) throws ComException {
        int numBytesRead;
        try {
            numBytesRead = channel.read(buffer);
        }
        catch (IOException e) {
            throw new ComException("channel read failed", e);
        }
        if (numBytesRead < 0) {
            throw new ComException("channel reached end of stream");
        }
        return numBytesRead;
    }

    public static ByteBuffer read(SocketChannel channel, ByteBuffer buffer, int length) {
        ByteBuffer checkedBuffer;
        if (length > buffer.capacity()) {
            checkedBuffer = XMemory.allocateDirectNative(length);
        } else {
            checkedBuffer = buffer;
            checkedBuffer.clear().limit(length);
        }
        do {
            XSockets.read(channel, checkedBuffer);
            if (!checkedBuffer.hasRemaining()) continue;
            try {
                Thread.sleep(10L);
            }
            catch (InterruptedException e) {
                throw new ComException(e);
            }
        } while (checkedBuffer.hasRemaining());
        XSockets.read(channel, checkedBuffer);
        return checkedBuffer;
    }

    public static void write(SocketChannel channel, ByteBuffer buffer) throws ComException {
        try {
            channel.write(buffer);
        }
        catch (IOException e) {
            throw new ComException(e);
        }
    }

    public static void readIntoBuffer(SocketChannel channel, ByteBuffer buffer, int responseTimeout) throws ComException {
        XSockets.performIoOperation(buffer, XSockets::read, channel, responseTimeout);
    }

    public static void writeFromBuffer(SocketChannel channel, ByteBuffer buffer, int responseTimeout) throws ComException {
        XSockets.performIoOperation(buffer, XSockets::write, channel, responseTimeout);
    }

    private static void performIoOperation(ByteBuffer buffer, IoOperation operation, SocketChannel channel, int responseTimeout) throws ComException {
        long responseTimeoutPoint = System.currentTimeMillis() + (long)responseTimeout;
        long remaining = buffer.remaining();
        while (true) {
            operation.execute(channel, buffer);
            if (!buffer.hasRemaining()) break;
            if ((long)buffer.remaining() < remaining) {
                responseTimeoutPoint = System.currentTimeMillis() + (long)responseTimeout;
                remaining = buffer.remaining();
            } else if (System.currentTimeMillis() >= responseTimeoutPoint) {
                throw new ComExceptionTimeout();
            }
            try {
                Thread.sleep(10L);
            }
            catch (InterruptedException e) {
                return;
            }
        }
    }

    private XSockets() {
        throw new UnsupportedOperationException();
    }

    private static interface IoOperation {
        public void execute(SocketChannel var1, ByteBuffer var2) throws ComException;
    }
}

