/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.serializer.collections.old;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.RandomAccess;
import java.util.function.Predicate;
import org.eclipse.serializer.chars.XChars;
import org.eclipse.serializer.collections.types.XGettingCollection;
import org.eclipse.serializer.collections.types.XGettingMap;
import org.eclipse.serializer.typing.KeyValue;
import org.eclipse.serializer.typing.XTypes;
import org.eclipse.serializer.util.X;

public final class OldCollections {
    public static final <C extends Collection<T>, T> C addBatch(C c, Iterable<T> elements) {
        if (elements != null) {
            for (T t : elements) {
                c.add(t);
            }
        }
        return c;
    }

    @SafeVarargs
    public static final <C extends Collection<? super E>, E> C addArray(C collection, E ... elements) {
        if (elements != null) {
            E[] EArray = elements;
            int n = elements.length;
            int n2 = 0;
            while (n2 < n) {
                E element = EArray[n2];
                collection.add(element);
                ++n2;
            }
        }
        return collection;
    }

    @SafeVarargs
    public static final <E> ArrayList<E> ArrayList(E ... elements) {
        if (elements == null) {
            return new ArrayList();
        }
        ArrayList<E> list = new ArrayList<E>(elements.length);
        int i = 0;
        while (i < elements.length) {
            list.add(elements[i]);
            ++i;
        }
        return list;
    }

    public static final <T> ArrayList<T> ArrayList(int initialCapacity, Iterable<T> elements) {
        return OldCollections.addBatch(new ArrayList(initialCapacity), elements);
    }

    @SafeVarargs
    public static final <E> LinkedList<E> LinkedList(E ... elements) {
        if (elements == null) {
            return new LinkedList();
        }
        LinkedList<E> list = new LinkedList<E>();
        int i = 0;
        while (i < elements.length) {
            list.add(elements[i]);
            ++i;
        }
        return list;
    }

    public static final <E> LinkedList<E> LinkedList(XGettingCollection<? extends E> xCollection) {
        LinkedList list = new LinkedList();
        xCollection.iterate(e -> {
            boolean bl = list.add(e);
        });
        return list;
    }

    @SafeVarargs
    public static <K, V, T extends Map<K, V>, S extends Map<? extends K, ? extends V>> T mergeInto(T target, S ... maps) {
        S[] SArray = maps;
        int n = maps.length;
        int n2 = 0;
        while (n2 < n) {
            S map = SArray[n2];
            target.putAll(map);
            ++n2;
        }
        return target;
    }

    public static final <T, L extends List<T> & RandomAccess> int count(L list, Predicate<? super T> predicate) {
        int count = 0;
        int i = 0;
        int size = list.size();
        while (i < size) {
            T element = list.get(i);
            if (predicate.test(element)) {
                ++count;
            }
            ++i;
        }
        return count;
    }

    public static final <T, L extends List<T> & RandomAccess> T search(L list, Predicate<? super T> predicate) {
        int i = 0;
        int size = list.size();
        while (i < size) {
            T element = list.get(i);
            if (predicate.test(element)) {
                return element;
            }
            ++i;
        }
        return null;
    }

    public static final <T, L extends List<T> & RandomAccess> boolean containsSearched(L list, Predicate<? super T> predicate) {
        int i = 0;
        int size = list.size();
        while (i < size) {
            if (predicate.test(list.get(i))) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public static <C extends Collection<T>, T> C append(C collectionToEnhance, Predicate<? super T> selectionPredicate, T[] arrayToAppend) {
        T[] TArray = arrayToAppend;
        int n = arrayToAppend.length;
        int n2 = 0;
        while (n2 < n) {
            T t = TArray[n2];
            if (selectionPredicate.test(t)) {
                collectionToEnhance.add(t);
            }
            ++n2;
        }
        return collectionToEnhance;
    }

    public static <C extends Collection<T>, T> C append(C collectionToEnhance, Predicate<? super T> selectionPredicate, Iterator<T> iterator) {
        while (iterator.hasNext()) {
            T element = iterator.next();
            if (!selectionPredicate.test(element)) continue;
            collectionToEnhance.add(element);
        }
        return collectionToEnhance;
    }

    public static <C extends Collection<T>, T> C append(C collectionToEnhance, Predicate<? super T> selectionPredicate, Iterable<T> collectionToAppend) {
        for (T t : collectionToAppend) {
            if (!selectionPredicate.test(t)) continue;
            collectionToEnhance.add(t);
        }
        return collectionToEnhance;
    }

    public static <T> ArrayList<T> filter(ArrayList<T> arrayList, Predicate<? super T> selectionPredicate) {
        ArrayList<T> newList = new ArrayList<T>(arrayList.size());
        int i = 0;
        int size = arrayList.size();
        while (i < size) {
            T element = arrayList.get(i);
            if (selectionPredicate.test(element)) {
                newList.add(element);
            }
            ++i;
        }
        return newList;
    }

    public static <T, L extends List<T> & RandomAccess> L filter(L list, Predicate<? super T> selectionPredicate, L targetList) {
        int i = 0;
        int size = list.size();
        while (i < size) {
            T element = list.get(i);
            if (selectionPredicate.test(element)) {
                targetList.add(element);
            }
            ++i;
        }
        return targetList;
    }

    public static <C extends Collection<T>, T> C filter(C sourceCollection, Predicate<? super T> selectionPredicate, C target) {
        for (T t : sourceCollection) {
            if (!selectionPredicate.test(t)) continue;
            target.add(t);
        }
        return target;
    }

    public static <T> ArrayList<T> reduce(ArrayList<T> arrayList, Predicate<? super T> reductionPredicate) {
        int i = 0;
        int size = arrayList.size();
        while (i < size) {
            T element = arrayList.get(i);
            if (reductionPredicate.test(element)) {
                arrayList.remove(element);
            }
            ++i;
        }
        return arrayList;
    }

    public static <C extends Collection<T>, T> C reduce(C collection, Predicate<? super T> reductionPredicate) {
        for (T t : collection) {
            if (!reductionPredicate.test(t)) continue;
            collection.remove(t);
        }
        return collection;
    }

    public static final StringBuilder appendIterableSeperated(StringBuilder sb, String elementSeperator, Iterable<?> iterable) {
        if (elementSeperator == null) {
            return OldCollections.appendArray(sb, iterable);
        }
        boolean notFirst = false;
        for (Object e : iterable) {
            if (notFirst) {
                sb.append(elementSeperator);
            } else {
                notFirst = true;
            }
            sb.append(e);
        }
        return sb;
    }

    public static final StringBuilder appendIterableSeperated(StringBuilder sb, char elementSeperator, Iterable<?> iterable) {
        boolean notFirst = false;
        for (Object e : iterable) {
            if (notFirst) {
                sb.append(elementSeperator);
            } else {
                notFirst = true;
            }
            sb.append(e);
        }
        return sb;
    }

    public static final StringBuilder appendIterable(StringBuilder sb, Iterable<?> iterable) {
        for (Object e : iterable) {
            sb.append(e);
        }
        return sb;
    }

    public static final StringBuilder appendArraySeperated(StringBuilder sb, String elementSeperator, Object ... elements) {
        if (elementSeperator == null) {
            return OldCollections.appendArray(sb, elements);
        }
        if (elements == null) {
            return sb;
        }
        boolean notFirst = false;
        Object[] objectArray = elements;
        int n = elements.length;
        int n2 = 0;
        while (n2 < n) {
            Object e = objectArray[n2];
            if (notFirst) {
                sb.append(elementSeperator);
            } else {
                notFirst = true;
            }
            sb.append(e);
            ++n2;
        }
        return sb;
    }

    public static final StringBuilder appendArraySeperated(StringBuilder sb, char elementSeperator, Object ... elements) {
        if (elements == null) {
            return sb;
        }
        boolean notFirst = false;
        Object[] objectArray = elements;
        int n = elements.length;
        int n2 = 0;
        while (n2 < n) {
            Object e = objectArray[n2];
            if (notFirst) {
                sb.append(elementSeperator);
            } else {
                notFirst = true;
            }
            sb.append(e);
            ++n2;
        }
        return sb;
    }

    public static final StringBuilder appendArray(StringBuilder sb, Object ... elements) {
        if (elements == null) {
            return sb;
        }
        Object[] objectArray = elements;
        int n = elements.length;
        int n2 = 0;
        while (n2 < n) {
            Object e = objectArray[n2];
            sb.append(e);
            ++n2;
        }
        return sb;
    }

    public static final StringBuilder stringBuilderSeperated(String elementSeperator, Object ... elements) {
        return OldCollections.appendArraySeperated(new StringBuilder(), elementSeperator, elements);
    }

    public static final StringBuilder stringBuilderSeperated(char elementSeperator, Object ... elements) {
        return OldCollections.appendArraySeperated(new StringBuilder(), elementSeperator, elements);
    }

    public static final StringBuilder stringBuilder(Object ... elements) {
        return OldCollections.appendArray(new StringBuilder(), elements);
    }

    public static final <T> T[] toArray(Collection<? extends T> collection, Class<T> elementType) {
        return collection.toArray(X.Array(elementType, collection.size()));
    }

    @SafeVarargs
    public static <T> HashSet<T> OldHashSet(T ... elements) {
        if (elements == null || elements.length == 0) {
            return new HashSet();
        }
        return OldCollections.addArray(new HashSet(elements.length), elements);
    }

    @SafeVarargs
    public static <K, V> HashMap<K, V> OldHashMap(KeyValue<? extends K, ? extends V> ... keyValueTuples) {
        if (keyValueTuples == null || keyValueTuples.length == 0) {
            return new HashMap();
        }
        HashMap<K, V> map = new HashMap<K, V>(keyValueTuples.length);
        KeyValue<? extends K, ? extends V>[] keyValueArray = keyValueTuples;
        int n = keyValueTuples.length;
        int n2 = 0;
        while (n2 < n) {
            KeyValue<K, V> kv = keyValueArray[n2];
            map.put(kv.key(), kv.value());
            ++n2;
        }
        return map;
    }

    public static final <K, V> LinkedHashMap<K, V> OldLinkedHashMap(XGettingMap<K, V> map) {
        LinkedHashMap lhm = new LinkedHashMap(XTypes.to_int(map.size()));
        map.iterate(e -> {
            Object v = lhm.put(e.key(), e.value());
        });
        return lhm;
    }

    public static final <E> ArrayList<E> ArrayList(XGettingCollection<? extends E> xCollection) {
        return new ArrayList<E>(xCollection.old());
    }

    public static final void populateMapFromHelperArray(Map<?, ?> instance, Object elementsHelper) {
        if (elementsHelper == null) {
            throw new RuntimeException("Missing collection elements helper instance for " + XChars.systemString(instance));
        }
        if (!(elementsHelper instanceof Object[])) {
            throw new RuntimeException("Invalid collection elements helper instance for " + XChars.systemString(instance));
        }
        Map<Object, Object> castedInstance = instance;
        OldCollections.populateMap(castedInstance, (Object[])elementsHelper);
    }

    public static final void populateMap(Map<Object, Object> instance, Object[] elements) {
        int i = 0;
        while (i < elements.length) {
            if (instance.putIfAbsent(elements[i], elements[i + 1]) != null) {
                throw new RuntimeException("Element hashing inconsistency in " + XChars.systemString(instance));
            }
            i += 2;
        }
    }

    public static final void populateCollectionFromHelperArray(Collection<?> instance, Object elementsHelper) {
        if (elementsHelper == null) {
            throw new RuntimeException("Missing collection elements helper instance for " + XChars.systemString(instance));
        }
        if (!(elementsHelper instanceof Object[])) {
            throw new RuntimeException("Invalid collection elements helper instance for " + XChars.systemString(instance));
        }
        Collection<Object> castedInstance = instance;
        OldCollections.populateCollection(castedInstance, (Object[])elementsHelper);
    }

    public static final void populateCollection(Collection<Object> instance, Object[] elements) {
        int i = 0;
        while (i < elements.length) {
            if (!instance.add(elements[i])) {
                throw new RuntimeException("Error in adding logic (e.g. element hashing inconsistency) in " + XChars.systemString(instance));
            }
            ++i;
        }
    }

    private OldCollections() {
        throw new UnsupportedOperationException();
    }
}

