/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.serializer.collections.old;

import java.util.Collection;
import java.util.Iterator;
import org.eclipse.serializer.collections.XArrays;
import org.eclipse.serializer.collections.old.OldCollection;
import org.eclipse.serializer.collections.types.XCollection;
import org.eclipse.serializer.collections.types.XGettingCollection;
import org.eclipse.serializer.collections.types.XSet;
import org.eclipse.serializer.functional.XFunc;
import org.eclipse.serializer.typing.XTypes;

public class BridgeXCollection<E>
implements OldCollection<E> {
    final XCollection<E> subject;

    protected BridgeXCollection(XCollection<E> collection) {
        this.subject = collection;
    }

    @Override
    public XCollection<E> parent() {
        return this.subject;
    }

    @Override
    public boolean add(E e) {
        return ((XSet)this.subject).add(e);
    }

    @Override
    public boolean addAll(Collection<? extends E> c) {
        if (c instanceof XGettingCollection) {
            ((XSet)this.subject).addAll((XGettingCollection)((Object)c));
            return true;
        }
        XSet list = (XSet)this.subject;
        for (E e : c) {
            list.add(e);
        }
        return true;
    }

    @Override
    public void clear() {
        ((XSet)this.subject).clear();
    }

    @Override
    public boolean contains(Object o) {
        return this.subject.containsSearched(XFunc.isEqualTo(o));
    }

    @Override
    public boolean containsAll(Collection<?> c) {
        for (Object o : c) {
            if (this.subject.containsSearched(XFunc.isEqualTo(o))) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean isEmpty() {
        return this.subject.isEmpty();
    }

    @Override
    public Iterator<E> iterator() {
        return this.subject.iterator();
    }

    @Override
    public boolean remove(Object o) {
        return ((XSet)this.subject).removeBy(XFunc.isEqualTo(o)) > 0L;
    }

    @Override
    public boolean removeAll(Collection<?> c) {
        int removeCount = 0;
        XSet list = (XSet)this.subject;
        for (Object o : c) {
            removeCount = (int)((long)removeCount + list.removeBy(XFunc.isEqualTo(o)));
        }
        return removeCount > 0;
    }

    @Override
    public boolean retainAll(Collection<?> c) {
        int oldSize = XTypes.to_int(this.subject.size());
        ((XSet)this.subject).removeBy(e -> !c.contains(e));
        return oldSize - XTypes.to_int(this.subject.size()) > 0;
    }

    @Override
    public int size() {
        return XTypes.to_int(this.subject.size());
    }

    @Override
    public Object[] toArray() {
        return this.subject.toArray();
    }

    @Override
    public <T> T[] toArray(T[] target) {
        XArrays.copyTo(this.parent(), target);
        return target;
    }
}

