/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.serializer.collections.interfaces;

import java.util.function.Consumer;
import org.eclipse.serializer.chars.VarString;
import org.eclipse.serializer.collections.interfaces.Sized;
import org.eclipse.serializer.collections.types.XGettingList;
import org.eclipse.serializer.hashing.HashEqualator;
import org.eclipse.serializer.typing.KeyValue;

public interface HashCollection<E>
extends Sized {
    public static final float DEFAULT_HASH_FACTOR = 1.0f;
    public static final int DEFAULT_HASH_LENGTH = 1;

    public float hashDensity();

    public void setHashDensity(float var1);

    public HashEqualator<? super E> hashEquality();

    public Analysis<? extends HashCollection<E>> analyze();

    public boolean hasVolatileHashElements();

    public int hashDistributionRange();

    @Override
    public long size();

    public int rehash();

    public static class Analysis<H> {
        private static final int MAX_TO_STRING_ELEMENT_COUNT = 32;
        private final H subject;
        private final int size;
        private final float hashDensity;
        private final int slotCount;
        private final int shortestEntryChainLength;
        private final double averageEntryChainLength;
        private final int longestEntryChainLength;
        private final int distributionRange;
        private final XGettingList<KeyValue<Integer, Integer>> chainLengthDistribution;
        private final double distributionEfficienty;
        private final double storageEfficienty;

        public Analysis(H subject, int size, float hashDensity, int slotCount, int shortestEntryChainLength, int longestEntryChainLength, int distributionRange, XGettingList<KeyValue<Integer, Integer>> chainLengthDistribution) {
            this.subject = subject;
            this.size = size;
            this.hashDensity = hashDensity;
            this.slotCount = slotCount;
            this.shortestEntryChainLength = shortestEntryChainLength;
            this.averageEntryChainLength = (double)size / (double)slotCount;
            this.longestEntryChainLength = longestEntryChainLength;
            this.chainLengthDistribution = chainLengthDistribution;
            this.distributionEfficienty = 1.0 / this.averageEntryChainLength;
            this.storageEfficienty = (double)slotCount / (double)distributionRange;
            this.distributionRange = distributionRange;
        }

        public H getSubject() {
            return this.subject;
        }

        public float getHashDensity() {
            return this.hashDensity;
        }

        public int getSlotCount() {
            return this.slotCount;
        }

        public int getShortestEntryChainLength() {
            return this.shortestEntryChainLength;
        }

        public double getAverageEntryChainLength() {
            return this.averageEntryChainLength;
        }

        public int getLongestEntryChainLength() {
            return this.longestEntryChainLength;
        }

        public XGettingList<KeyValue<Integer, Integer>> getChainLengthDistribution() {
            return this.chainLengthDistribution;
        }

        public int getSize() {
            return this.size;
        }

        public double getDistributionEfficienty() {
            return this.distributionEfficienty;
        }

        public double getStorageEfficienty() {
            return this.storageEfficienty;
        }

        public int getDistributionRange() {
            return this.distributionRange;
        }

        public String toString() {
            final VarString vc = VarString.New().add("subject: ").add(this.subject.getClass() + " @" + System.identityHashCode(this.subject)).lf().add("size: ").add(this.size).lf().add("hashDensity: ").add(this.hashDensity).lf().add("slotCount: ").add(this.slotCount).lf().add("shortestEntryChainLength: ").add(this.shortestEntryChainLength).lf().add("averageEntryChainLength: ").add(this.averageEntryChainLength).lf().add("longestEntryChainLength: ").add(this.longestEntryChainLength).lf().add("distributionRange: ").add(this.distributionRange).lf().add("distributionEfficienty: ").add(this.distributionEfficienty).lf().add("storageEfficienty: ").add(this.storageEfficienty).lf().lf().add("slot occupation: ").lf();
            final int[] a = new int[this.distributionRange + 1];
            this.chainLengthDistribution.iterate(new Consumer<KeyValue<Integer, Integer>>(){

                @Override
                public void accept(KeyValue<Integer, Integer> e) {
                    vc.add(e.key()).add(": ").add(e.value()).append('\t');
                    if (e.value() > 32) {
                        vc.add("[many > 32]");
                    } else {
                        vc.repeat((int)e.value(), '|');
                    }
                    vc.lf();
                    int i = e.key() + 1;
                    while (i-- > 1) {
                        int n = i;
                        a[n] = a[n] + e.value();
                    }
                }
            });
            a[0] = (Integer)((KeyValue)this.chainLengthDistribution.at(0L)).value();
            vc.lf().add("entry distribution: ").lf();
            int i = 0;
            while (i < a.length) {
                vc.add(i == 0 ? "empty" : "rank" + i).add(": ").add(a[i]).append('\t');
                if (a[i] > 32) {
                    vc.add("[many > 32]");
                } else {
                    vc.repeat(a[i], '|');
                }
                vc.lf();
                ++i;
            }
            return vc.toString();
        }
    }
}

