/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.serializer.collections;

import java.util.Comparator;
import java.util.Iterator;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Predicate;
import org.eclipse.serializer.collections.SetView;
import org.eclipse.serializer.collections.old.AbstractBridgeXSet;
import org.eclipse.serializer.collections.types.XGettingCollection;
import org.eclipse.serializer.collections.types.XImmutableSet;
import org.eclipse.serializer.collections.types.XSet;
import org.eclipse.serializer.concurrency.Synchronized;
import org.eclipse.serializer.equality.Equalator;
import org.eclipse.serializer.typing.XTypes;
import org.eclipse.serializer.util.iterables.SynchronizedIterator;

public final class SynchSet<E>
implements XSet<E>,
Synchronized {
    private final XSet<E> subject;

    public SynchSet(XSet<E> set) {
        this.subject = set;
    }

    @Override
    public synchronized E get() {
        return this.subject.get();
    }

    @Override
    public synchronized Equalator<? super E> equality() {
        return this.subject.equality();
    }

    @Override
    public synchronized SynchSet<E> addAll(E ... elements) {
        this.subject.addAll((Object[])elements);
        return this;
    }

    @Override
    public synchronized boolean nullAdd() {
        return this.subject.nullAdd();
    }

    @Override
    public synchronized boolean add(E e) {
        return this.subject.add(e);
    }

    @Override
    public synchronized SynchSet<E> addAll(E[] elements, int offset, int length) {
        this.subject.addAll((Object[])elements, offset, length);
        return this;
    }

    @Override
    public synchronized SynchSet<E> addAll(XGettingCollection<? extends E> elements) {
        this.subject.addAll((XGettingCollection)elements);
        return this;
    }

    @Override
    public synchronized boolean nullPut() {
        return this.subject.nullPut();
    }

    @Override
    public synchronized void accept(E e) {
        this.subject.accept(e);
    }

    @Override
    public synchronized boolean put(E e) {
        return this.subject.put(e);
    }

    @Override
    public synchronized E addGet(E e) {
        return this.subject.addGet(e);
    }

    @Override
    public synchronized E deduplicate(E e) {
        return this.subject.deduplicate(e);
    }

    @Override
    public synchronized E putGet(E e) {
        return this.subject.putGet(e);
    }

    @Override
    public synchronized E replace(E e) {
        return this.subject.replace(e);
    }

    @Override
    public synchronized SynchSet<E> putAll(E ... elements) {
        this.subject.putAll((Object[])elements);
        return this;
    }

    @Override
    public synchronized SynchSet<E> putAll(XGettingCollection<? extends E> elements) {
        this.subject.putAll((XGettingCollection)elements);
        return this;
    }

    @Override
    public synchronized SynchSet<E> putAll(E[] elements, int offset, int length) {
        this.subject.putAll((Object[])elements, offset, length);
        return this;
    }

    @Override
    public synchronized boolean containsSearched(Predicate<? super E> predicate) {
        return this.subject.containsSearched(predicate);
    }

    @Override
    public synchronized boolean applies(Predicate<? super E> predicate) {
        return this.subject.applies(predicate);
    }

    @Override
    public synchronized void clear() {
        this.subject.clear();
    }

    @Override
    public synchronized long consolidate() {
        return this.subject.consolidate();
    }

    @Override
    public synchronized boolean contains(E element) {
        return this.subject.contains(element);
    }

    @Override
    public synchronized boolean containsAll(XGettingCollection<? extends E> elements) {
        return this.subject.containsAll(elements);
    }

    @Override
    public synchronized boolean containsId(E element) {
        return this.subject.containsId(element);
    }

    @Override
    public synchronized boolean nullAllowed() {
        return this.subject.nullAllowed();
    }

    @Override
    public synchronized boolean nullContained() {
        return this.subject.nullContained();
    }

    @Override
    public synchronized <C extends Consumer<? super E>> C filterTo(C target, Predicate<? super E> predicate) {
        return this.subject.filterTo(target, predicate);
    }

    @Override
    public synchronized <C extends Consumer<? super E>> C copyTo(C target) {
        return this.subject.copyTo(target);
    }

    @Override
    public synchronized long count(E element) {
        return this.subject.count(element);
    }

    @Override
    public synchronized long countBy(Predicate<? super E> predicate) {
        return this.subject.countBy(predicate);
    }

    @Override
    public synchronized <C extends Consumer<? super E>> C distinct(C target, Equalator<? super E> equalator) {
        return this.subject.distinct(target, equalator);
    }

    @Override
    public synchronized <C extends Consumer<? super E>> C distinct(C target) {
        return this.subject.distinct(target);
    }

    @Override
    public synchronized SynchSet<E> ensureFreeCapacity(long minimalFreeCapacity) {
        this.subject.ensureFreeCapacity(minimalFreeCapacity);
        return this;
    }

    @Override
    public synchronized SynchSet<E> ensureCapacity(long minimalCapacity) {
        this.subject.ensureCapacity(minimalCapacity);
        return this;
    }

    @Override
    @Deprecated
    public synchronized boolean equals(Object o) {
        return this.subject.equals(o);
    }

    @Override
    public synchronized boolean equals(XGettingCollection<? extends E> samples, Equalator<? super E> equalator) {
        return this.subject.equals(samples, equalator);
    }

    @Override
    public synchronized boolean equalsContent(XGettingCollection<? extends E> samples, Equalator<? super E> equalator) {
        return this.subject.equalsContent(samples, equalator);
    }

    @Override
    public synchronized <C extends Consumer<? super E>> C except(XGettingCollection<? extends E> other, Equalator<? super E> equalator, C target) {
        return this.subject.except(other, equalator, target);
    }

    @Override
    public synchronized <P extends Consumer<? super E>> P iterate(P procedure) {
        this.subject.iterate(procedure);
        return procedure;
    }

    @Override
    public final synchronized <A> A join(BiConsumer<? super E, ? super A> joiner, A aggregate) {
        return this.subject.join(joiner, aggregate);
    }

    @Override
    @Deprecated
    public synchronized int hashCode() {
        return this.subject.hashCode();
    }

    @Override
    public synchronized boolean hasVolatileElements() {
        return this.subject.hasVolatileElements();
    }

    @Override
    public synchronized <C extends Consumer<? super E>> C intersect(XGettingCollection<? extends E> other, Equalator<? super E> equalator, C target) {
        return this.subject.intersect(other, equalator, target);
    }

    @Override
    public synchronized boolean isEmpty() {
        return this.subject.isEmpty();
    }

    @Override
    public synchronized Iterator<E> iterator() {
        return new SynchronizedIterator(this.subject.iterator());
    }

    @Override
    public synchronized E max(Comparator<? super E> comparator) {
        return this.subject.max(comparator);
    }

    @Override
    public synchronized E min(Comparator<? super E> comparator) {
        return this.subject.min(comparator);
    }

    @Override
    public synchronized <C extends Consumer<? super E>> C moveTo(C target, Predicate<? super E> predicate) {
        return this.subject.moveTo(target, predicate);
    }

    @Override
    public final synchronized <P extends Consumer<? super E>> P process(P procedure) {
        return this.subject.process(procedure);
    }

    @Override
    public synchronized E fetch() {
        return this.subject.fetch();
    }

    @Override
    public synchronized E pinch() {
        return this.subject.pinch();
    }

    @Override
    public synchronized long removeBy(Predicate<? super E> predicate) {
        return this.subject.removeBy(predicate);
    }

    @Override
    public synchronized E retrieve(E element) {
        return this.subject.retrieve(element);
    }

    @Override
    public synchronized E retrieveBy(Predicate<? super E> predicate) {
        return this.subject.retrieveBy(predicate);
    }

    @Override
    public synchronized boolean removeOne(E element) {
        return this.subject.removeOne(element);
    }

    @Override
    public synchronized long remove(E element) {
        return this.subject.remove(element);
    }

    @Override
    public synchronized long removeAll(XGettingCollection<? extends E> elements) {
        return this.subject.removeAll(elements);
    }

    @Override
    public synchronized long removeDuplicates(Equalator<? super E> equalator) {
        return this.subject.removeDuplicates(equalator);
    }

    @Override
    public synchronized long removeDuplicates() {
        return this.subject.removeDuplicates();
    }

    @Override
    public synchronized long nullRemove() {
        return this.subject.nullRemove();
    }

    @Override
    public synchronized long retainAll(XGettingCollection<? extends E> elements) {
        return this.subject.retainAll(elements);
    }

    @Override
    public E seek(E sample) {
        return this.subject.seek(sample);
    }

    @Override
    public synchronized E search(Predicate<? super E> predicate) {
        return this.subject.search(predicate);
    }

    @Override
    public synchronized long optimize() {
        return this.subject.optimize();
    }

    @Override
    public synchronized long size() {
        return XTypes.to_int(this.subject.size());
    }

    @Override
    public synchronized Object[] toArray() {
        return this.subject.toArray();
    }

    @Override
    public synchronized E[] toArray(Class<E> type) {
        return this.subject.toArray(type);
    }

    @Override
    public synchronized void truncate() {
        this.subject.truncate();
    }

    @Override
    public synchronized <C extends Consumer<? super E>> C union(XGettingCollection<? extends E> other, Equalator<? super E> equalator, C target) {
        return this.subject.union(other, equalator, target);
    }

    @Override
    public synchronized long currentCapacity() {
        return this.subject.currentCapacity();
    }

    @Override
    public synchronized long maximumCapacity() {
        return this.subject.maximumCapacity();
    }

    @Override
    public synchronized boolean isFull() {
        return this.subject.isFull();
    }

    @Override
    public synchronized long remainingCapacity() {
        return this.subject.remainingCapacity();
    }

    @Override
    public synchronized SynchSet<E> copy() {
        return new SynchSet<E>(this.subject.copy());
    }

    @Override
    public synchronized XImmutableSet<E> immure() {
        return this.subject.immure();
    }

    @Override
    public synchronized SetView<E> view() {
        return new SetView(this);
    }

    @Override
    public OldSynchSet<E> old() {
        return new OldSynchSet(this);
    }

    public static final class OldSynchSet<E>
    extends AbstractBridgeXSet<E> {
        OldSynchSet(SynchSet<E> set) {
            super(set);
        }

        @Override
        public SynchSet<E> parent() {
            return (SynchSet)super.parent();
        }
    }
}

