/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.serializer.collections;

import java.util.Comparator;
import java.util.Iterator;
import java.util.ListIterator;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Predicate;
import org.eclipse.serializer.collections.Constant;
import org.eclipse.serializer.collections.Singleton;
import org.eclipse.serializer.collections.types.XGettingCollection;
import org.eclipse.serializer.collections.types.XReferencing;
import org.eclipse.serializer.equality.Equalator;
import org.eclipse.serializer.functional.IndexedAcceptor;
import org.eclipse.serializer.typing.XTypes;

public class SingletonView<E>
implements XReferencing<E> {
    final Singleton<E> subject;

    public SingletonView(Singleton<E> subject) {
        this.subject = subject;
    }

    @Override
    public int hashCode() {
        return this.subject.hashCode();
    }

    @Override
    public E get() {
        return this.subject.get();
    }

    @Override
    public SingletonView<E> copy() {
        return new SingletonView<E>(this.subject);
    }

    @Override
    public final <P extends Consumer<? super E>> P iterate(P procedure) {
        return this.subject.iterate(procedure);
    }

    @Override
    public final <P extends IndexedAcceptor<? super E>> P iterateIndexed(P procedure) {
        return this.subject.iterateIndexed(procedure);
    }

    @Override
    public final <A> A join(BiConsumer<? super E, ? super A> joiner, A aggregate) {
        return this.subject.join(joiner, aggregate);
    }

    @Override
    public Constant<E> immure() {
        return this.subject.immure();
    }

    @Override
    public ListIterator<E> listIterator() {
        return this.subject.listIterator();
    }

    @Override
    public boolean equals(Object obj) {
        return this.subject.equals(obj);
    }

    @Override
    public ListIterator<E> listIterator(long index) {
        return this.subject.listIterator(index);
    }

    @Override
    public Singleton.OldSingleton old() {
        return this.subject.old();
    }

    @Override
    public SingletonView<E> range(long fromIndex, long toIndex) {
        if (fromIndex != 0L) {
            throw new IndexOutOfBoundsException();
        }
        if (toIndex != 0L) {
            throw new IndexOutOfBoundsException();
        }
        return this;
    }

    @Override
    public SingletonView<E> toReversed() {
        return this;
    }

    @Override
    public <T extends Consumer<? super E>> T copySelection(T target, long ... indices) {
        return this.subject.copySelection(target, indices);
    }

    @Override
    public E first() {
        return this.subject.first();
    }

    @Override
    public E at(long index) {
        return this.subject.at(index);
    }

    @Override
    public long indexOf(E element) {
        return this.subject.indexOf(element);
    }

    @Override
    public long indexBy(Predicate<? super E> predicate) {
        return this.subject.indexBy(predicate);
    }

    @Override
    public boolean isSorted(Comparator<? super E> comparator) {
        return this.subject.isSorted(comparator);
    }

    @Override
    public E last() {
        return this.subject.last();
    }

    @Override
    public long lastIndexOf(E element) {
        return this.subject.lastIndexOf(element);
    }

    @Override
    public long lastIndexBy(Predicate<? super E> predicate) {
        return this.subject.lastIndexBy(predicate);
    }

    @Override
    public long maxIndex(Comparator<? super E> comparator) {
        return this.subject.maxIndex(comparator);
    }

    @Override
    public long minIndex(Comparator<? super E> comparator) {
        return this.subject.minIndex(comparator);
    }

    @Override
    public E peek() {
        return this.subject.peek();
    }

    @Override
    public E poll() {
        return this.subject.poll();
    }

    @Override
    public long scan(Predicate<? super E> predicate) {
        return this.subject.scan(predicate);
    }

    @Override
    public SingletonView<E> view() {
        return this;
    }

    @Override
    public SingletonView<E> view(long lowIndex, long highIndex) {
        if (lowIndex != 0L) {
            throw new IndexOutOfBoundsException();
        }
        if (highIndex != 0L) {
            throw new IndexOutOfBoundsException();
        }
        return this;
    }

    @Override
    public boolean containsSearched(Predicate<? super E> predicate) {
        return this.subject.containsSearched(predicate);
    }

    @Override
    public boolean applies(Predicate<? super E> predicate) {
        return this.subject.applies(predicate);
    }

    @Override
    public boolean contains(E element) {
        return this.subject.contains(element);
    }

    @Override
    public boolean containsAll(XGettingCollection<? extends E> elements) {
        return this.subject.containsAll(elements);
    }

    @Override
    public boolean containsId(E element) {
        return this.subject.containsId(element);
    }

    @Override
    public <T extends Consumer<? super E>> T copyTo(T target) {
        return this.subject.copyTo(target);
    }

    @Override
    public <T extends Consumer<? super E>> T filterTo(T target, Predicate<? super E> predicate) {
        return this.subject.filterTo(target, predicate);
    }

    @Override
    public long count(E element) {
        return this.subject.count(element);
    }

    @Override
    public long countBy(Predicate<? super E> predicate) {
        return this.subject.countBy(predicate);
    }

    @Override
    public <T extends Consumer<? super E>> T distinct(T target) {
        return this.subject.distinct(target);
    }

    @Override
    public <T extends Consumer<? super E>> T distinct(T target, Equalator<? super E> equalator) {
        return this.subject.distinct(target, equalator);
    }

    public String toString() {
        return this.subject.toString();
    }

    @Override
    public Equalator<? super E> equality() {
        return this.subject.equality();
    }

    @Override
    public boolean equals(XGettingCollection<? extends E> samples, Equalator<? super E> equalator) {
        return this.subject.equals(samples, equalator);
    }

    @Override
    public boolean equalsContent(XGettingCollection<? extends E> samples, Equalator<? super E> equalator) {
        return this.subject.equalsContent(samples, equalator);
    }

    @Override
    public <T extends Consumer<? super E>> T except(XGettingCollection<? extends E> other, Equalator<? super E> equalator, T target) {
        return this.subject.except(other, equalator, target);
    }

    @Override
    public boolean hasVolatileElements() {
        return this.subject.hasVolatileElements();
    }

    @Override
    public <T extends Consumer<? super E>> T intersect(XGettingCollection<? extends E> other, Equalator<? super E> equalator, T target) {
        return this.subject.intersect(other, equalator, target);
    }

    @Override
    public boolean isEmpty() {
        return this.subject.isEmpty();
    }

    @Override
    public Iterator<E> iterator() {
        return this.subject.iterator();
    }

    @Override
    public E max(Comparator<? super E> comparator) {
        return this.subject.max(comparator);
    }

    @Override
    public E min(Comparator<? super E> comparator) {
        return this.subject.min(comparator);
    }

    @Override
    public boolean nullContained() {
        return this.subject.nullContained();
    }

    @Override
    public E seek(E sample) {
        return this.subject.seek(sample);
    }

    @Override
    public E search(Predicate<? super E> predicate) {
        return this.subject.search(predicate);
    }

    @Override
    public long size() {
        return XTypes.to_int(this.subject.size());
    }

    @Override
    public Object[] toArray() {
        return this.subject.toArray();
    }

    @Override
    public E[] toArray(Class<E> type) {
        return this.subject.toArray(type);
    }

    @Override
    public <T extends Consumer<? super E>> T union(XGettingCollection<? extends E> other, Equalator<? super E> equalator, T target) {
        return this.subject.union(other, equalator, target);
    }

    @Override
    public boolean nullAllowed() {
        return this.subject.nullAllowed();
    }

    @Override
    public long remainingCapacity() {
        return this.subject.remainingCapacity();
    }

    @Override
    public boolean isFull() {
        return this.subject.isFull();
    }

    @Override
    public long maximumCapacity() {
        return this.subject.maximumCapacity();
    }
}

