/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.serializer.collections;

import java.util.Comparator;
import java.util.Iterator;
import java.util.ListIterator;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Predicate;
import org.eclipse.serializer.chars.VarString;
import org.eclipse.serializer.collections.AbstractExtendedCollection;
import org.eclipse.serializer.collections.SubListView;
import org.eclipse.serializer.collections.XUtilsCollection;
import org.eclipse.serializer.collections.old.AbstractOldGettingList;
import org.eclipse.serializer.collections.types.XGettingCollection;
import org.eclipse.serializer.collections.types.XGettingList;
import org.eclipse.serializer.collections.types.XImmutableList;
import org.eclipse.serializer.equality.Equalator;
import org.eclipse.serializer.functional.IndexedAcceptor;
import org.eclipse.serializer.typing.XTypes;
import org.eclipse.serializer.util.iterables.ReadOnlyListIterator;

public class ListView<E>
implements XGettingList<E> {
    private final XGettingList<E> subject;

    public ListView(XGettingList<E> list) {
        this.subject = list;
    }

    @Override
    public XImmutableList<E> immure() {
        return this.subject.immure();
    }

    @Override
    public Equalator<? super E> equality() {
        return this.subject.equality();
    }

    @Override
    public boolean hasVolatileElements() {
        return this.subject.hasVolatileElements();
    }

    @Override
    public boolean containsSearched(Predicate<? super E> predicate) {
        return this.subject.containsSearched(predicate);
    }

    @Override
    public boolean applies(Predicate<? super E> predicate) {
        return this.subject.applies(predicate);
    }

    @Override
    public boolean nullAllowed() {
        return true;
    }

    @Override
    public boolean nullContained() {
        return this.subject.nullContained();
    }

    @Override
    public boolean containsAll(XGettingCollection<? extends E> elements) {
        return this.subject.containsAll(elements);
    }

    @Override
    public boolean contains(E element) {
        return this.subject.contains(element);
    }

    @Override
    public boolean containsId(E element) {
        return this.subject.containsId(element);
    }

    @Override
    public ListView<E> copy() {
        return new ListView<E>(this.subject);
    }

    @Override
    public <C extends Consumer<? super E>> C filterTo(C target, Predicate<? super E> predicate) {
        return this.subject.filterTo(target, predicate);
    }

    @Override
    public <C extends Consumer<? super E>> C copyTo(C target) {
        return this.subject.copyTo(target);
    }

    @Override
    public long count(E element) {
        return this.subject.count(element);
    }

    @Override
    public long countBy(Predicate<? super E> predicate) {
        return this.subject.countBy(predicate);
    }

    @Override
    public <C extends Consumer<? super E>> C distinct(C target, Equalator<? super E> equalator) {
        return this.subject.distinct(target, equalator);
    }

    @Override
    public <C extends Consumer<? super E>> C distinct(C target) {
        return this.subject.distinct(target);
    }

    @Override
    public boolean equals(XGettingCollection<? extends E> samples, Equalator<? super E> equalator) {
        return this.subject.equals(this.subject, equalator);
    }

    @Override
    public boolean equalsContent(XGettingCollection<? extends E> samples, Equalator<? super E> equalator) {
        return this.subject.equalsContent(this.subject, equalator);
    }

    @Override
    public <C extends Consumer<? super E>> C except(XGettingCollection<? extends E> other, Equalator<? super E> equalator, C target) {
        return this.subject.except(other, equalator, target);
    }

    @Override
    public final <P extends Consumer<? super E>> P iterate(P procedure) {
        return this.subject.iterate(procedure);
    }

    @Override
    public final <A> A join(BiConsumer<? super E, ? super A> joiner, A aggregate) {
        return this.subject.join(joiner, aggregate);
    }

    @Override
    public final <P extends IndexedAcceptor<? super E>> P iterateIndexed(P procedure) {
        this.subject.iterateIndexed(procedure);
        return procedure;
    }

    @Override
    public E get() {
        return this.subject.get();
    }

    @Override
    public E first() {
        return this.subject.first();
    }

    @Override
    public E last() {
        return this.subject.last();
    }

    @Override
    public E poll() {
        return this.subject.poll();
    }

    @Override
    public E peek() {
        return this.subject.peek();
    }

    @Override
    public long indexBy(Predicate<? super E> predicate) {
        return this.subject.indexBy(predicate);
    }

    @Override
    public long indexOf(E element) {
        return this.subject.indexOf(element);
    }

    @Override
    public <C extends Consumer<? super E>> C intersect(XGettingCollection<? extends E> other, Equalator<? super E> equalator, C target) {
        return this.subject.intersect(other, equalator, target);
    }

    @Override
    public boolean isSorted(Comparator<? super E> comparator) {
        return this.subject.isSorted(comparator);
    }

    @Override
    public long lastIndexBy(Predicate<? super E> predicate) {
        return this.subject.lastIndexBy(predicate);
    }

    @Override
    public long lastIndexOf(E element) {
        return this.subject.lastIndexOf(element);
    }

    @Override
    public E max(Comparator<? super E> comparator) {
        return this.subject.max(comparator);
    }

    @Override
    public long maxIndex(Comparator<? super E> comparator) {
        return this.subject.maxIndex(comparator);
    }

    @Override
    public E min(Comparator<? super E> comparator) {
        return this.subject.min(comparator);
    }

    @Override
    public long minIndex(Comparator<? super E> comparator) {
        return this.subject.minIndex(comparator);
    }

    @Override
    public long scan(Predicate<? super E> predicate) {
        return this.subject.scan(predicate);
    }

    @Override
    public E seek(E sample) {
        return this.subject.seek(sample);
    }

    @Override
    public E search(Predicate<? super E> predicate) {
        return this.subject.search(predicate);
    }

    @Override
    public ListView<E> view() {
        return this;
    }

    @Override
    public SubListView<E> view(long lowIndex, long highIndex) {
        return new SubListView(this, lowIndex, highIndex);
    }

    @Override
    public XGettingList<E> range(long fromIndex, long toIndex) {
        return this.subject.range(fromIndex, toIndex);
    }

    @Override
    public E[] toArray(Class<E> type) {
        return this.subject.toArray(type);
    }

    @Override
    public ListView<E> toReversed() {
        return new ListView<E>(this.subject.toReversed());
    }

    @Override
    public <C extends Consumer<? super E>> C union(XGettingCollection<? extends E> other, Equalator<? super E> equalator, C target) {
        return this.subject.union(other, equalator, target);
    }

    @Override
    public <C extends Consumer<? super E>> C copySelection(C target, long ... indices) {
        return this.subject.copySelection(target, indices);
    }

    @Override
    @Deprecated
    public int hashCode() {
        return this.subject.hashCode();
    }

    @Override
    @Deprecated
    public boolean equals(Object o) {
        return this.subject.equals(o);
    }

    @Override
    public boolean isEmpty() {
        return this.subject.isEmpty();
    }

    @Override
    public E at(long index) {
        return this.subject.at(index);
    }

    @Override
    public long size() {
        return XTypes.to_int(this.subject.size());
    }

    @Override
    public long maximumCapacity() {
        return this.subject.maximumCapacity();
    }

    @Override
    public boolean isFull() {
        return this.subject.isFull();
    }

    @Override
    public long remainingCapacity() {
        return this.subject.remainingCapacity();
    }

    @Override
    public Object[] toArray() {
        return this.subject.toArray();
    }

    @Override
    public Iterator<E> iterator() {
        return new ReadOnlyListIterator(this);
    }

    @Override
    public ListIterator<E> listIterator() {
        return new ReadOnlyListIterator(this);
    }

    @Override
    public ListIterator<E> listIterator(long index) {
        AbstractExtendedCollection.validateIndex(this.subject.size(), index);
        return new ReadOnlyListIterator(this, (int)index);
    }

    public String toString() {
        return XUtilsCollection.appendTo(this, VarString.New().add('['), ',').add(']').toString();
    }

    @Override
    public OldListView<E> old() {
        return new OldListView(this);
    }

    public static final class OldListView<E>
    extends AbstractOldGettingList<E> {
        OldListView(ListView<E> list) {
            super(list);
        }

        @Override
        public ListView<E> parent() {
            return (ListView)super.parent();
        }
    }
}

