/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.serializer.collections;

import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import org.eclipse.serializer.collections.AbstractArrayCollection;
import org.eclipse.serializer.collections.AbstractArrayStorage;
import org.eclipse.serializer.collections.AbstractSimpleArrayCollection;
import org.eclipse.serializer.collections.ConstList;
import org.eclipse.serializer.collections.IndexExceededException;
import org.eclipse.serializer.collections.ListView;
import org.eclipse.serializer.collections.SubList;
import org.eclipse.serializer.collections.SubListView;
import org.eclipse.serializer.collections.XArrays;
import org.eclipse.serializer.collections.XSort;
import org.eclipse.serializer.collections.old.AbstractBridgeXList;
import org.eclipse.serializer.collections.types.XGettingCollection;
import org.eclipse.serializer.collections.types.XGettingSequence;
import org.eclipse.serializer.collections.types.XList;
import org.eclipse.serializer.equality.Equalator;
import org.eclipse.serializer.equality.IdentityEqualityLogic;
import org.eclipse.serializer.exceptions.IndexBoundsException;
import org.eclipse.serializer.functional.IndexedAcceptor;
import org.eclipse.serializer.functional.KamikazeArrayAdder;
import org.eclipse.serializer.meta.NotImplementedYetError;
import org.eclipse.serializer.typing.Composition;
import org.eclipse.serializer.typing.XTypes;
import org.eclipse.serializer.util.X;
import org.eclipse.serializer.util.iterables.GenericListIterator;

public final class LimitList<E>
extends AbstractSimpleArrayCollection<E>
implements XList<E>,
Composition,
IdentityEqualityLogic {
    private static final Object MARKER = new Object();
    final E[] data;
    final int limit;
    int size;

    private static String exceptionStringRange(long size, long startIndex, long length) {
        return "Range [" + (length < 0L ? String.valueOf(startIndex + length + 1L) + ";" + startIndex : String.valueOf(startIndex) + ";" + (startIndex + length - 1L)) + "] not in [0;" + (size - 1L) + "]";
    }

    public static final <E> LimitList<E> New(long initialCapacity) {
        return new LimitList<E>(X.checkArrayRange(initialCapacity));
    }

    @SafeVarargs
    public static final <E> LimitList<E> New(E ... initialElements) {
        return new LimitList<E>(initialElements);
    }

    public static final <E> LimitList<E> New(XGettingCollection<E> initialElements) {
        return new LimitList<E>(initialElements);
    }

    public LimitList(int initialCapacity) {
        this.size = 0;
        this.data = LimitList.newArray(initialCapacity);
        this.limit = initialCapacity;
    }

    public LimitList(LimitList<? extends E> original) throws NullPointerException {
        this.size = original.size;
        this.data = (Object[])original.data.clone();
        this.limit = this.data.length;
    }

    public LimitList(Collection<? extends E> elements) throws NullPointerException {
        this.size = elements.size();
        this.data = LimitList.newArray(this.size);
        elements.toArray(this.data);
        this.limit = this.data.length;
    }

    public LimitList(XGettingCollection<? extends E> elements) throws NullPointerException {
        this.size = elements.intSize();
        this.data = LimitList.newArray(this.size);
        XArrays.copyTo(elements, this.data);
        this.limit = this.data.length;
    }

    @SafeVarargs
    public LimitList(E ... elements) throws NullPointerException {
        this.size = elements.length;
        this.data = LimitList.newArray(this.size);
        System.arraycopy(elements, 0, this.data, 0, this.size);
        this.limit = this.data.length;
    }

    public LimitList(int initialCapacity, E[] src, int srcStart, int srcLength) {
        this.data = LimitList.newArray(initialCapacity);
        System.arraycopy(src, srcStart, this.data, 0, srcLength);
        this.size = srcLength;
        this.limit = initialCapacity;
    }

    LimitList(E[] internalData, int size) {
        this.size = size;
        this.data = internalData;
        this.limit = internalData.length;
    }

    private int internalInsertArray(int index, Object[] elements, int elementsSize) {
        if (this.limit - this.size < elementsSize) {
            throw new IndexBoundsException((long)this.limit, elementsSize - 1);
        }
        System.arraycopy(this.data, index, this.data, index + elementsSize, this.size - index);
        System.arraycopy(elements, 0, this.data, index, elementsSize);
        this.size += elementsSize;
        return elementsSize;
    }

    private int internalInsertArray(int index, Object[] elements, int offset, int length) {
        if (length < 0) {
            if (this.limit - this.size < -length) {
                throw new IndexBoundsException((long)this.limit, -length - 1);
            }
            System.arraycopy(this.data, index, this.data, index - length, this.size - index);
            XArrays.reverseArraycopy(elements, offset, elements, index, -length);
            this.size -= length;
            return -length;
        }
        if (this.limit - this.size < length) {
            throw new IndexBoundsException((long)this.limit, length - 1);
        }
        System.arraycopy(this.data, index, this.data, index + length, this.size - index);
        System.arraycopy(elements, 0, this.data, index, length);
        this.size += length;
        return length;
    }

    private int internalInputArray(int index, Object[] elements, int elementsSize) {
        if (this.limit - this.size < elementsSize) {
            throw new IndexBoundsException((long)this.limit, elementsSize - 1);
        }
        System.arraycopy(this.data, index, this.data, index + elementsSize, this.size - index);
        System.arraycopy(elements, 0, this.data, index, elementsSize);
        this.size += elementsSize;
        return elementsSize;
    }

    private int internalInputArray(int index, Object[] elements, int offset, int length) {
        if (length < 0) {
            if (this.limit - this.size < -length) {
                throw new IndexBoundsException((long)this.limit, -length - 1);
            }
            System.arraycopy(this.data, index, this.data, index - length, this.size - index);
            XArrays.reverseArraycopy(elements, offset, elements, index, -length);
            this.size -= length;
            return -length;
        }
        if (this.limit - this.size < length) {
            throw new IndexBoundsException((long)this.limit, length - 1);
        }
        System.arraycopy(this.data, index, this.data, index + length, this.size - index);
        System.arraycopy(elements, 0, this.data, index, length);
        this.size += length;
        return length;
    }

    @Override
    protected final E[] internalGetStorageArray() {
        return this.data;
    }

    @Override
    protected final int internalSize() {
        return this.size;
    }

    @Override
    protected final int[] internalGetSectionIndices() {
        int[] nArray = new int[2];
        nArray[1] = this.size;
        return nArray;
    }

    @Override
    public final Equalator<? super E> equality() {
        return Equalator.identity();
    }

    @Override
    protected final int internalCountingAddAll(E[] elements) throws UnsupportedOperationException {
        if (this.limit - this.size >= elements.length) {
            System.arraycopy(elements, 0, this.data, this.size, elements.length);
            this.size += elements.length;
            return elements.length;
        }
        int partialLength = this.limit - this.size;
        System.arraycopy(elements, 0, this.data, this.size, partialLength);
        this.size = this.limit;
        return partialLength;
    }

    @Override
    protected final int internalCountingAddAll(E[] elements, int offset, int length) throws UnsupportedOperationException {
        throw new NotImplementedYetError();
    }

    @Override
    protected final int internalCountingAddAll(XGettingCollection<? extends E> elements) throws UnsupportedOperationException {
        if (elements instanceof AbstractSimpleArrayCollection) {
            return this.internalCountingAddAll(AbstractSimpleArrayCollection.internalGetStorageArray((AbstractSimpleArrayCollection)((Object)elements)), 0, XTypes.to_int(elements.size()));
        }
        int oldSize = this.size;
        try {
            this.size = elements.iterate(new KamikazeArrayAdder(this.data, oldSize)).yield();
        }
        catch (ArrayIndexOutOfBoundsException e) {
            this.size = this.limit;
        }
        return this.size - oldSize;
    }

    @Override
    protected final int internalCountingPutAll(E[] elements) throws UnsupportedOperationException {
        this.ensureFreeCapacity(elements.length);
        System.arraycopy(elements, 0, this.data, this.size, elements.length);
        this.size += elements.length;
        return elements.length;
    }

    @Override
    protected final int internalCountingPutAll(E[] elements, int offset, int length) throws UnsupportedOperationException {
        throw new NotImplementedYetError();
    }

    @Override
    protected final int internalCountingPutAll(XGettingCollection<? extends E> elements) throws UnsupportedOperationException {
        if (elements instanceof AbstractSimpleArrayCollection) {
            return this.internalCountingAddAll(AbstractSimpleArrayCollection.internalGetStorageArray((AbstractSimpleArrayCollection)((Object)elements)), 0, XTypes.to_int(elements.size()));
        }
        this.ensureFreeCapacity(XTypes.to_int(elements.size()));
        int oldSize = this.size;
        this.size = elements.iterate(new KamikazeArrayAdder(this.data, oldSize)).yield();
        return this.size - oldSize;
    }

    @Override
    public final LimitList<E> copy() {
        return new LimitList<E>(this);
    }

    @Override
    public final ConstList<E> immure() {
        return ConstList.New(this);
    }

    @Override
    public final LimitList<E> toReversed() {
        E[] rData = LimitList.newArray(this.limit);
        E[] data = this.data;
        int i = this.size;
        int r = 0;
        while (i-- > 0) {
            rData[r++] = data[i];
        }
        return new LimitList(rData, this.size);
    }

    @Override
    public final E[] toArray(Class<E> type) {
        E[] array = X.Array(type, this.size);
        System.arraycopy(this.data, 0, array, 0, this.size);
        return array;
    }

    @Override
    public final <P extends Consumer<? super E>> P iterate(P procedure) {
        AbstractArrayStorage.iterate(this.data, this.size, procedure);
        return procedure;
    }

    @Override
    public final <P extends IndexedAcceptor<? super E>> P iterateIndexed(P procedure) {
        AbstractArrayStorage.iterate(this.data, this.size, procedure);
        return procedure;
    }

    @Override
    public final <A> A join(BiConsumer<? super E, ? super A> joiner, A aggregate) {
        AbstractArrayStorage.join(this.data, this.size, joiner, aggregate);
        return aggregate;
    }

    @Override
    public final long count(E element) {
        return AbstractArrayStorage.forwardCount(this.data, 0, this.size, element);
    }

    @Override
    public final long countBy(Predicate<? super E> predicate) {
        return AbstractArrayStorage.forwardConditionalCount(this.data, 0, this.size, predicate);
    }

    @Override
    public final long indexOf(E element) {
        return AbstractArrayStorage.forwardIndexOf(this.data, 0, this.size, element);
    }

    @Override
    public final long indexBy(Predicate<? super E> predicate) {
        return AbstractArrayStorage.forwardConditionalIndexOf(this.data, 0, this.size, predicate);
    }

    @Override
    public final long lastIndexOf(E element) {
        return AbstractArrayStorage.rangedIndexOF(this.data, this.size, this.size - 1, -this.size, element);
    }

    @Override
    public final long lastIndexBy(Predicate<? super E> predicate) {
        return AbstractArrayStorage.lastIndexOf(this.data, this.size, predicate);
    }

    @Override
    public final long maxIndex(Comparator<? super E> comparator) {
        return AbstractArrayStorage.maxIndex(this.data, this.size, comparator);
    }

    @Override
    public final long minIndex(Comparator<? super E> comparator) {
        return AbstractArrayStorage.minIndex(this.data, this.size, comparator);
    }

    @Override
    public final long scan(Predicate<? super E> predicate) {
        return AbstractArrayStorage.forwardScan(this.data, 0, this.size, predicate);
    }

    @Override
    public final E get() {
        return this.data[0];
    }

    @Override
    public final E first() {
        return this.data[0];
    }

    @Override
    public final E last() {
        return this.data[this.size - 1];
    }

    @Override
    public final E poll() {
        return this.size == 0 ? null : (E)this.data[0];
    }

    @Override
    public final E peek() {
        return this.size == 0 ? null : (E)this.data[this.size - 1];
    }

    @Override
    public final E seek(E sample) {
        return (E)(AbstractArrayStorage.forwardContainsSame(this.data, 0, this.limit, sample) ? sample : null);
    }

    @Override
    public final E search(Predicate<? super E> predicate) {
        return AbstractArrayStorage.forwardQueryElement(this.data, 0, this.size, predicate, null);
    }

    @Override
    public final E max(Comparator<? super E> comparator) {
        return AbstractArrayStorage.max(this.data, this.size, comparator);
    }

    @Override
    public final E min(Comparator<? super E> comparator) {
        return AbstractArrayStorage.min(this.data, this.size, comparator);
    }

    @Override
    public final boolean hasVolatileElements() {
        return false;
    }

    @Override
    public final boolean nullAllowed() {
        return true;
    }

    @Override
    public final boolean isSorted(Comparator<? super E> comparator) {
        return AbstractArrayStorage.isSorted(this.data, this.size, comparator);
    }

    @Override
    public final boolean containsSearched(Predicate<? super E> predicate) {
        return AbstractArrayStorage.forwardContains(this.data, 0, this.size, predicate);
    }

    @Override
    public final boolean applies(Predicate<? super E> predicate) {
        return AbstractArrayStorage.forwardApplies(this.data, 0, this.size, predicate);
    }

    @Override
    public final boolean nullContained() {
        return AbstractArrayStorage.forwardNullContained(this.data, 0, this.size);
    }

    @Override
    public final boolean containsId(E element) {
        return AbstractArrayStorage.forwardContainsSame(this.data, 0, this.size, element);
    }

    @Override
    public final boolean contains(E element) {
        return AbstractArrayStorage.forwardContainsSame(this.data, 0, this.size, element);
    }

    @Override
    public final boolean containsAll(XGettingCollection<? extends E> elements) {
        return AbstractArrayStorage.containsAll(this.data, this.size, elements);
    }

    @Override
    public final boolean equals(XGettingCollection<? extends E> samples, Equalator<? super E> equalator) {
        if (samples == null || !(samples instanceof LimitList) || XTypes.to_int(samples.size()) != this.size) {
            return false;
        }
        if (samples == this) {
            return true;
        }
        return XArrays.equals(this.data, 0, ((LimitList)samples).data, 0, this.size, equalator);
    }

    @Override
    public final boolean equalsContent(XGettingCollection<? extends E> samples, Equalator<? super E> equalator) {
        if (samples == null || XTypes.to_int(samples.size()) != this.size) {
            return false;
        }
        if (samples == this) {
            return true;
        }
        return AbstractArrayStorage.equalsContent(this.data, this.size, samples, equalator);
    }

    @Override
    public final <C extends Consumer<? super E>> C intersect(XGettingCollection<? extends E> samples, Equalator<? super E> equalator, C target) {
        return AbstractArrayStorage.intersect(this.data, this.size, samples, equalator, target);
    }

    @Override
    public final <C extends Consumer<? super E>> C except(XGettingCollection<? extends E> samples, Equalator<? super E> equalator, C target) {
        return AbstractArrayStorage.except(this.data, this.size, samples, equalator, target);
    }

    @Override
    public final <C extends Consumer<? super E>> C union(XGettingCollection<? extends E> samples, Equalator<? super E> equalator, C target) {
        return AbstractArrayStorage.union(this.data, this.size, samples, equalator, target);
    }

    @Override
    public final <C extends Consumer<? super E>> C copyTo(C target) {
        return AbstractArrayStorage.forwardCopyTo(this.data, 0, this.size, target);
    }

    @Override
    public final <C extends Consumer<? super E>> C filterTo(C target, Predicate<? super E> predicate) {
        return AbstractArrayStorage.forwardCopyTo(this.data, 0, this.size, target, predicate);
    }

    @Override
    public final <C extends Consumer<? super E>> C distinct(C target) {
        return AbstractArrayStorage.distinct(this.data, this.size, target);
    }

    @Override
    public final <C extends Consumer<? super E>> C distinct(C target, Equalator<? super E> equalator) {
        return AbstractArrayStorage.distinct(this.data, this.size, target, equalator);
    }

    @Override
    public final <C extends Consumer<? super E>> C copySelection(C target, long ... indices) {
        return AbstractArrayStorage.copySelection(this.data, this.size, indices, target);
    }

    @Override
    public final ListView<E> view() {
        return new ListView(this);
    }

    @Override
    public final SubListView<E> view(long fromIndex, long toIndex) {
        return new SubListView(this, fromIndex, toIndex);
    }

    @Override
    public final LimitList<E> shiftTo(long sourceIndex, long targetIndex) {
        if (sourceIndex >= (long)this.size) {
            throw new IndexExceededException(this.size, sourceIndex);
        }
        if (targetIndex >= (long)this.size) {
            throw new IndexExceededException(this.size, targetIndex);
        }
        if (sourceIndex == targetIndex) {
            if (sourceIndex < 0L) {
                throw new IndexExceededException(this.size, sourceIndex);
            }
            return this;
        }
        E shiftling = this.data[(int)sourceIndex];
        if (sourceIndex < targetIndex) {
            System.arraycopy(this.data, (int)sourceIndex + 1, this.data, (int)sourceIndex, (int)targetIndex - (int)sourceIndex);
        } else {
            System.arraycopy(this.data, (int)targetIndex, this.data, (int)targetIndex + 1, (int)sourceIndex - (int)targetIndex);
        }
        this.data[(int)targetIndex] = shiftling;
        return this;
    }

    @Override
    public final LimitList<E> shiftTo(long sourceIndex, long targetIndex, long length) {
        if (sourceIndex + length >= (long)this.size) {
            throw new IndexExceededException(this.size, sourceIndex);
        }
        if (targetIndex + length >= (long)this.size) {
            throw new IndexExceededException(this.size, targetIndex);
        }
        if (sourceIndex == targetIndex) {
            if (sourceIndex < 0L) {
                throw new IndexExceededException(this.size, sourceIndex);
            }
            return this;
        }
        E[] shiftlings = LimitList.newArray((int)length);
        System.arraycopy(this.data, (int)sourceIndex, shiftlings, 0, (int)length);
        if (sourceIndex < targetIndex) {
            System.arraycopy(this.data, (int)(sourceIndex + length), this.data, (int)sourceIndex, (int)(targetIndex - sourceIndex));
        } else {
            System.arraycopy(this.data, (int)targetIndex, this.data, (int)(targetIndex + length), (int)(sourceIndex - targetIndex));
        }
        System.arraycopy(shiftlings, 0, this.data, (int)targetIndex, (int)length);
        return this;
    }

    @Override
    public final LimitList<E> shiftBy(long sourceIndex, long distance) {
        return this.shiftTo(sourceIndex, sourceIndex + distance);
    }

    @Override
    public final LimitList<E> shiftBy(long sourceIndex, long distance, long length) {
        return this.shiftTo(sourceIndex, sourceIndex + distance, length);
    }

    @Override
    public final LimitList<E> swap(long indexA, long indexB) throws IndexOutOfBoundsException, ArrayIndexOutOfBoundsException {
        if (indexA >= (long)this.size) {
            throw new IndexBoundsException((long)this.size, indexA);
        }
        if (indexB >= (long)this.size) {
            throw new IndexBoundsException((long)this.size, indexB);
        }
        E t = this.data[(int)indexA];
        this.data[(int)indexA] = this.data[(int)indexB];
        this.data[(int)indexB] = t;
        return this;
    }

    @Override
    public final LimitList<E> swap(long indexA, long indexB, long length) {
        AbstractArrayStorage.swap(this.data, this.size, X.checkArrayRange(indexA), X.checkArrayRange(indexB), X.checkArrayRange(length));
        return this;
    }

    @Override
    public final LimitList<E> reverse() {
        AbstractArrayStorage.reverse(this.data, this.size);
        return this;
    }

    @Override
    public final void setFirst(E element) {
        this.data[0] = element;
    }

    @Override
    public final void setLast(E element) {
        this.data[this.size - 1] = element;
    }

    @Override
    @SafeVarargs
    public final LimitList<E> setAll(long offset, E ... elements) {
        if (offset < 0L || offset + (long)elements.length > (long)this.size) {
            throw new IndexOutOfBoundsException(LimitList.exceptionStringRange(this.size, offset, offset + (long)elements.length - 1L));
        }
        System.arraycopy(elements, 0, this.data, X.checkArrayRange(offset), elements.length);
        return this;
    }

    @Override
    public final LimitList<E> set(long offset, E[] src, int srcIndex, int srcLength) {
        AbstractArrayStorage.set(this.data, this.size, X.checkArrayRange(offset), src, srcIndex, srcLength);
        return this;
    }

    @Override
    public final LimitList<E> set(long offset, XGettingSequence<? extends E> elements, long elementsOffset, long elementsLength) {
        AbstractArrayStorage.set(this.data, this.size, X.checkArrayRange(offset), elements, elementsOffset, elementsLength);
        return this;
    }

    @Override
    public final LimitList<E> fill(long offset, long length, E element) {
        AbstractArrayStorage.fill(this.data, this.size, X.checkArrayRange(offset), X.checkArrayRange(length), element);
        return this;
    }

    @Override
    public final LimitList<E> sort(Comparator<? super E> comparator) {
        XSort.mergesort(this.data, 0, this.size, comparator);
        return this;
    }

    @Override
    public final boolean replaceOne(E element, E replacement) {
        return AbstractArrayStorage.replaceOne(this.data, this.size, element, replacement);
    }

    @Override
    public final boolean replaceOne(Predicate<? super E> predicate, E substitute) {
        return AbstractArrayStorage.substituteOne(this.data, this.size, predicate, substitute);
    }

    @Override
    public final long replace(E element, E replacement) {
        return AbstractArrayStorage.replace(this.data, this.size, element, replacement);
    }

    @Override
    public final long replace(Predicate<? super E> predicate, E substitute) {
        return AbstractArrayStorage.substitute(this.data, this.size, predicate, substitute);
    }

    @Override
    public final long replaceAll(XGettingCollection<? extends E> elements, E replacement) {
        return AbstractArrayStorage.replaceAll(this.data, this.size, elements, replacement, MARKER);
    }

    @Override
    public final long substitute(Function<? super E, ? extends E> mapper) {
        return AbstractArrayStorage.substitute(this.data, this.size, mapper);
    }

    @Override
    public final long substitute(Predicate<? super E> predicate, Function<E, E> mapper) {
        return AbstractArrayStorage.substitute(this.data, this.size, predicate, mapper);
    }

    @Override
    public final long currentCapacity() {
        return this.limit;
    }

    @Override
    public final long maximumCapacity() {
        return this.limit;
    }

    @Override
    public final boolean isFull() {
        return this.size >= this.limit;
    }

    @Override
    public final long remainingCapacity() {
        return this.limit - this.size;
    }

    @Override
    public final long optimize() {
        return this.limit;
    }

    @Override
    public final LimitList<E> ensureFreeCapacity(long requiredFreeCapacity) {
        if ((long)(this.limit - this.size) >= requiredFreeCapacity) {
            throw new IndexBoundsException((long)this.limit, requiredFreeCapacity - 1L);
        }
        return this;
    }

    @Override
    public final LimitList<E> ensureCapacity(long minCapacity) {
        if (minCapacity > (long)this.limit) {
            throw new IndexBoundsException((long)this.limit, minCapacity - 1L);
        }
        return this;
    }

    @Override
    public final boolean add(E element) {
        if (this.size >= this.limit) {
            throw new IndexOutOfBoundsException();
        }
        this.data[this.size++] = element;
        return true;
    }

    @Override
    public final boolean nullAdd() {
        if (this.size >= this.limit) {
            throw new IndexOutOfBoundsException();
        }
        ++this.size;
        return true;
    }

    @Override
    @SafeVarargs
    public final LimitList<E> addAll(E ... elements) {
        System.arraycopy(elements, 0, this.data, this.size, elements.length);
        this.size += elements.length;
        return this;
    }

    @Override
    public final LimitList<E> addAll(E[] elements, int offset, int length) {
        if (length == 0) {
            return this;
        }
        if (length > 0) {
            this.ensureFreeCapacity(length);
            System.arraycopy(elements, offset, this.data, this.size, length);
            this.size += length;
        } else {
            int bound = offset + length;
            if (bound < -1) {
                throw new ArrayIndexOutOfBoundsException(bound + 1);
            }
            this.ensureFreeCapacity(-length);
            E[] data = this.data;
            int size = this.size;
            int i = offset;
            while (i > bound) {
                data[size++] = elements[i];
                --i;
            }
            this.size = size;
        }
        return this;
    }

    @Override
    public final LimitList<E> addAll(XGettingCollection<? extends E> elements) {
        return elements.iterate(this);
    }

    @Override
    public final boolean nullPut() {
        return this.nullAdd();
    }

    @Override
    public final void accept(E element) {
        if (this.size >= this.limit) {
            throw new IndexOutOfBoundsException();
        }
        this.data[this.size++] = element;
    }

    @Override
    public final boolean put(E element) {
        if (this.size >= this.limit) {
            throw new IndexOutOfBoundsException();
        }
        this.data[this.size++] = element;
        return true;
    }

    @Override
    @SafeVarargs
    public final LimitList<E> putAll(E ... elements) {
        return this.addAll((Object[])elements);
    }

    @Override
    public final LimitList<E> putAll(E[] elements, int offset, int length) {
        return this.addAll((Object[])elements, offset, length);
    }

    @Override
    public final LimitList<E> putAll(XGettingCollection<? extends E> elements) {
        return elements.iterate(this);
    }

    @Override
    public final boolean prepend(E element) {
        if (this.size >= this.limit) {
            throw new IndexBoundsException((long)this.limit);
        }
        System.arraycopy(this.data, 0, this.data, 1, this.size);
        this.data[0] = element;
        ++this.size;
        return true;
    }

    @Override
    public final boolean insert(long index, E element) {
        if (this.size >= this.limit) {
            throw new IndexBoundsException((long)this.limit);
        }
        if (index >= (long)this.size || index < 0L) {
            if (index == (long)this.size) {
                this.data[this.size++] = element;
                return true;
            }
            throw new IndexBoundsException((long)this.size, index);
        }
        System.arraycopy(this.data, (int)index, this.data, (int)index + 1, this.size - (int)index);
        this.data[(int)index] = element;
        ++this.size;
        return true;
    }

    @Override
    @SafeVarargs
    public final long insertAll(long index, E ... elements) throws IndexOutOfBoundsException {
        if (index >= (long)this.size || index < 0L) {
            if (index == (long)this.size) {
                return this.internalCountingAddAll(elements);
            }
            throw new IndexBoundsException((long)this.size, index);
        }
        return this.internalInsertArray((int)index, elements, elements.length);
    }

    @Override
    public final long insertAll(long index, E[] elements, int offset, int length) {
        if (index >= (long)this.size || index < 0L) {
            if (index == (long)this.size) {
                return this.internalCountingAddAll(elements, offset, length);
            }
            throw new IndexBoundsException((long)this.size, index);
        }
        return this.internalInsertArray((int)index, elements, offset, length);
    }

    @Override
    public final long insertAll(long index, XGettingCollection<? extends E> elements) {
        if (index >= (long)this.size || index < 0L) {
            if (index == (long)this.size) {
                return this.internalCountingAddAll(elements);
            }
            throw new IndexBoundsException((long)this.size, index);
        }
        Object[] elementsToAdd = elements instanceof AbstractSimpleArrayCollection ? AbstractSimpleArrayCollection.internalGetStorageArray((AbstractSimpleArrayCollection)((Object)elements)) : elements.toArray();
        return this.internalInsertArray((int)index, elementsToAdd, elementsToAdd.length);
    }

    @Override
    public final boolean preput(E element) {
        if (this.size >= this.limit) {
            throw new IndexBoundsException((long)this.limit);
        }
        System.arraycopy(this.data, 0, this.data, 1, this.size);
        this.data[0] = element;
        ++this.size;
        return true;
    }

    @Override
    public final boolean input(long index, E element) {
        if (this.size >= this.limit) {
            throw new IndexBoundsException((long)this.limit);
        }
        if (index >= (long)this.size || index < 0L) {
            if (index == (long)this.size) {
                this.data[this.size++] = element;
                return true;
            }
            throw new IndexBoundsException((long)this.size, (int)index);
        }
        System.arraycopy(this.data, (int)index, this.data, (int)index + 1, this.size - (int)index);
        this.data[(int)index] = element;
        ++this.size;
        return true;
    }

    @Override
    @SafeVarargs
    public final long inputAll(long index, E ... elements) throws IndexOutOfBoundsException {
        if (index >= (long)this.size || index < 0L) {
            if (index == (long)this.size) {
                return this.internalCountingPutAll(elements);
            }
            throw new IndexBoundsException((long)this.size, index);
        }
        return this.internalInputArray((int)index, elements, elements.length);
    }

    @Override
    public final long inputAll(long index, E[] elements, int offset, int length) {
        if (index >= (long)this.size || index < 0L) {
            if (index == (long)this.size) {
                return this.internalCountingPutAll(elements, offset, length);
            }
            throw new IndexBoundsException((long)this.size, index);
        }
        return this.internalInputArray((int)index, elements, offset, length);
    }

    @Override
    public final long inputAll(long index, XGettingCollection<? extends E> elements) {
        if (index >= (long)this.size || index < 0L) {
            if (index == (long)this.size) {
                return this.internalCountingPutAll(elements);
            }
            throw new IndexBoundsException((long)this.size, index);
        }
        Object[] elementsToAdd = elements instanceof AbstractSimpleArrayCollection ? AbstractSimpleArrayCollection.internalGetStorageArray((AbstractSimpleArrayCollection)((Object)elements)) : elements.toArray();
        return this.internalInputArray((int)index, elementsToAdd, elementsToAdd.length);
    }

    @Override
    public final void truncate() {
        E[] data = this.data;
        int i = this.size;
        while (i-- > 0) {
            data[i] = null;
        }
        this.size = 0;
    }

    @Override
    public final long consolidate() {
        return 0L;
    }

    @Override
    public final E retrieve(E element) {
        Object removedElement = AbstractArrayStorage.retrieve(this.data, this.size, element, MARKER);
        if (removedElement != MARKER) {
            --this.size;
            return (E)removedElement;
        }
        return null;
    }

    @Override
    public final E retrieveBy(Predicate<? super E> predicate) {
        Object e = AbstractArrayStorage.retrieve(this.data, this.size, predicate, MARKER);
        if (e != MARKER) {
            --this.size;
            return (E)e;
        }
        return null;
    }

    @Override
    public final boolean removeOne(E element) {
        if (AbstractArrayStorage.removeOne(this.data, this.size, element)) {
            --this.size;
            return true;
        }
        return false;
    }

    @Override
    public final long remove(E element) {
        int removeCount = XArrays.removeAllFromArray(this.data, 0, this.size, element);
        this.size -= removeCount;
        return removeCount;
    }

    @Override
    public final long nullRemove() {
        int removeCount = XArrays.removeAllFromArray(this.data, 0, this.size, null);
        this.size -= removeCount;
        return removeCount;
    }

    @Override
    public final long removeBy(Predicate<? super E> predicate) {
        int removeCount = AbstractArrayStorage.reduce(this.data, this.size, predicate, MARKER);
        this.size -= removeCount;
        return removeCount;
    }

    @Override
    public final long retainAll(XGettingCollection<? extends E> elements) {
        int removeCount = AbstractArrayStorage.retainAll(this.data, this.size, elements, MARKER);
        this.size -= removeCount;
        return removeCount;
    }

    @Override
    public final <P extends Consumer<? super E>> P process(P procedure) {
        this.size -= AbstractArrayStorage.process(this.data, this.size, procedure, MARKER);
        return procedure;
    }

    @Override
    public final <C extends Consumer<? super E>> C moveTo(C target, Predicate<? super E> predicate) {
        this.size -= AbstractArrayStorage.moveTo(this.data, this.size, target, predicate, MARKER);
        return target;
    }

    @Override
    public final <C extends Consumer<? super E>> C moveSelection(C target, long ... indices) {
        this.size -= AbstractArrayStorage.moveSelection(this.data, this.size, indices, target, MARKER);
        return target;
    }

    @Override
    public final long removeAll(XGettingCollection<? extends E> elements) {
        int removed = XArrays.removeAllFromArray(elements, this.data, 0, this.size);
        this.size -= removed;
        return removed;
    }

    @Override
    public final long removeDuplicates(Equalator<? super E> equalator) {
        int removeCount = AbstractArrayStorage.removeDuplicates(this.data, this.size, equalator, MARKER);
        this.size -= removeCount;
        return removeCount;
    }

    @Override
    public final long removeDuplicates() {
        int removeCount = AbstractArrayStorage.removeDuplicates(this.data, this.size, MARKER);
        this.size -= removeCount;
        return removeCount;
    }

    @Override
    public final E fetch() {
        E element = this.data[0];
        System.arraycopy(this.data, 1, this.data, 0, --this.size);
        this.data[this.size] = null;
        return element;
    }

    @Override
    public final E pop() {
        E element = this.data[this.size - 1];
        this.data[--this.size] = null;
        return element;
    }

    @Override
    public final E pinch() {
        if (this.size == 0) {
            return null;
        }
        E element = this.data[0];
        System.arraycopy(this.data, 1, this.data, 0, --this.size);
        this.data[this.size] = null;
        return element;
    }

    @Override
    public final E pick() {
        if (this.size == 0) {
            return null;
        }
        E element = this.data[--this.size];
        this.data[this.size] = null;
        return element;
    }

    @Override
    public final long removeSelection(long[] indices) {
        int removeCount = AbstractArrayStorage.removeSelection(this.data, this.size, indices, MARKER);
        this.size -= removeCount;
        return removeCount;
    }

    @Override
    public final LimitList<E> removeRange(long offset, long length) {
        this.size -= AbstractArrayStorage.removeRange(this.data, this.size, X.checkArrayRange(offset), X.checkArrayRange(length));
        return this;
    }

    @Override
    public final LimitList<E> retainRange(long offset, long length) {
        AbstractArrayStorage.retainRange(this.data, this.size, X.checkArrayRange(offset), X.checkArrayRange(length));
        this.size = (int)length;
        return this;
    }

    @Override
    public final boolean isEmpty() {
        return this.size == 0;
    }

    @Override
    public final Iterator<E> iterator() {
        return new GenericListIterator(this);
    }

    @Override
    public final ListIterator<E> listIterator() {
        return new GenericListIterator(this);
    }

    @Override
    public final ListIterator<E> listIterator(long index) {
        LimitList.validateIndex(this.size, index);
        return new GenericListIterator(this, (int)index);
    }

    @Override
    public final boolean set(long index, E element) throws IndexOutOfBoundsException, ArrayIndexOutOfBoundsException {
        if (index >= (long)this.size) {
            throw new IndexBoundsException((long)this.size, index);
        }
        this.data[(int)index] = element;
        return false;
    }

    @Override
    public final E setGet(long index, E element) throws IndexOutOfBoundsException, ArrayIndexOutOfBoundsException {
        if (index >= (long)this.size) {
            throw new IndexBoundsException((long)this.size, index);
        }
        E old = this.data[(int)index];
        this.data[(int)index] = element;
        return old;
    }

    @Override
    public final long size() {
        return this.size;
    }

    @Override
    public final SubList<E> range(long fromIndex, long toIndex) {
        return new SubList(this, fromIndex, toIndex);
    }

    public final String toString() {
        return AbstractArrayStorage.toString(this.data, this.size);
    }

    @Override
    public final Object[] toArray() {
        Object[] array = new Object[this.size];
        System.arraycopy(this.data, 0, array, 0, this.size);
        return array;
    }

    @Override
    public final E at(long index) throws ArrayIndexOutOfBoundsException {
        if (index >= (long)this.size) {
            throw new IndexBoundsException((long)this.size, index);
        }
        return this.data[(int)index];
    }

    @Override
    public final void clear() {
        E[] data = this.data;
        int i = this.size;
        while (i-- > 0) {
            data[i] = null;
        }
        this.size = 0;
    }

    @Override
    public final E removeAt(long index) throws IndexOutOfBoundsException, ArrayIndexOutOfBoundsException {
        if (index >= (long)this.size) {
            throw new IndexBoundsException((long)this.size, index);
        }
        E oldValue = this.data[(int)index];
        int moveCount = this.size - 1 - (int)index;
        if (moveCount > 0) {
            System.arraycopy(this.data, (int)index + 1, this.data, (int)index, moveCount);
        }
        this.data[--this.size] = null;
        return oldValue;
    }

    @Override
    @Deprecated
    public final boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o == null || !(o instanceof List)) {
            return false;
        }
        List list = (List)o;
        if (this.size != list.size()) {
            return false;
        }
        E[] data = this.data;
        int i = 0;
        for (Object e2 : list) {
            E e1;
            if (!((e1 = data[i++]) == null ? e2 != null : !e1.equals(e2))) continue;
            return false;
        }
        return true;
    }

    @Override
    @Deprecated
    public final int hashCode() {
        return XArrays.arrayHashCode(this.data, this.size);
    }

    @Override
    public final OldLimitList<E> old() {
        return new OldLimitList(this);
    }

    @Override
    public final boolean nullInput(long index) {
        throw new NotImplementedYetError();
    }

    @Override
    public final boolean nullInsert(long index) {
        throw new NotImplementedYetError();
    }

    @Override
    public final boolean nullPrepend() {
        throw new NotImplementedYetError();
    }

    @Override
    @SafeVarargs
    public final LimitList<E> prependAll(E ... elements) {
        throw new NotImplementedYetError();
    }

    @Override
    public final LimitList<E> prependAll(E[] elements, int srcStartIndex, int srcLength) {
        throw new NotImplementedYetError();
    }

    @Override
    public final LimitList<E> prependAll(XGettingCollection<? extends E> elements) {
        throw new NotImplementedYetError();
    }

    @Override
    public final boolean nullPreput() {
        throw new NotImplementedYetError();
    }

    @Override
    @SafeVarargs
    public final LimitList<E> preputAll(E ... elements) {
        throw new NotImplementedYetError();
    }

    @Override
    public final LimitList<E> preputAll(E[] elements, int offset, int length) {
        throw new NotImplementedYetError();
    }

    @Override
    public final LimitList<E> preputAll(XGettingCollection<? extends E> elements) {
        throw new NotImplementedYetError();
    }

    public static final class Creator<E>
    implements XList.Creator<E> {
        private final int initialCapacity;

        public Creator(int initialCapacity) {
            if (initialCapacity < 0) {
                throw new IllegalArgumentException("initial capacity may not be negative.");
            }
            this.initialCapacity = initialCapacity;
        }

        public final int getInitialCapacity() {
            return this.initialCapacity;
        }

        @Override
        public final LimitList<E> newInstance() {
            return new LimitList(AbstractArrayCollection.newArray(this.initialCapacity), this.initialCapacity);
        }
    }

    public static final class OldLimitList<E>
    extends AbstractBridgeXList<E> {
        OldLimitList(LimitList<E> list) {
            super(list);
        }

        @Override
        public final LimitList<E> parent() {
            return (LimitList)super.parent();
        }
    }
}

