/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.serializer.collections;

public class InvalidCapacityException
extends RuntimeException {
    private final long maximumCapacity;
    private final long desiredCapacity;

    public InvalidCapacityException() {
        this(null, null);
    }

    public InvalidCapacityException(Throwable cause) {
        this(null, cause);
    }

    public InvalidCapacityException(String message) {
        this(message, null);
    }

    public InvalidCapacityException(String message, Throwable cause) {
        super(message, cause);
        this.maximumCapacity = -1L;
        this.desiredCapacity = -1L;
    }

    public InvalidCapacityException(String message, Throwable cause, boolean enableSuppression, boolean writableStackTrace) {
        super(message, cause, enableSuppression, writableStackTrace);
        this.maximumCapacity = -1L;
        this.desiredCapacity = -1L;
    }

    public InvalidCapacityException(long maximumCapacity, long desiredCapacity) {
        this(maximumCapacity, desiredCapacity, null, null);
    }

    public InvalidCapacityException(long maximumCapacity, long desiredCapacity, Throwable cause) {
        this(maximumCapacity, desiredCapacity, null, cause);
    }

    public InvalidCapacityException(long maximumCapacity, long desiredCapacity, String message) {
        this(maximumCapacity, desiredCapacity, message, null);
    }

    public InvalidCapacityException(long maximumCapacity, long desiredCapacity, String message, Throwable cause) {
        super(message, cause);
        this.maximumCapacity = maximumCapacity;
        this.desiredCapacity = desiredCapacity;
    }

    public InvalidCapacityException(long maximumCapacity, long desiredCapacity, String message, Throwable cause, boolean enableSuppression, boolean writableStackTrace) {
        super(message, cause, enableSuppression, writableStackTrace);
        this.maximumCapacity = maximumCapacity;
        this.desiredCapacity = desiredCapacity;
    }

    public long getMaximumCapacity() {
        return this.maximumCapacity;
    }

    public long getDesiredCapacity() {
        return this.desiredCapacity;
    }

    @Override
    public String getMessage() {
        return "maximum capacity: " + this.maximumCapacity + ", desired capacity: " + this.desiredCapacity + ", message: " + super.getMessage();
    }
}

