/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.serializer.collections;

import java.util.function.Predicate;
import org.eclipse.serializer.collections.XSort;
import org.eclipse.serializer.functional.IndexedAcceptor;
import org.eclipse.serializer.util.X;

final class Indexer<E>
implements IndexedAcceptor<E> {
    private static final int INITIAL_INDEX_LENGTH = 32;
    private int size = 0;
    private int[] index = new int[32];
    private final Predicate<? super E> predicate;

    Indexer(Predicate<? super E> predicate) {
        this.predicate = predicate;
    }

    @Override
    public final void accept(E e, long index) {
        if (!this.predicate.test(e)) {
            return;
        }
        if (this.size >= this.index.length) {
            this.index = new int[(int)((float)this.index.length * 2.0f)];
            System.arraycopy(this.index, 0, this.index, 0, this.size);
        }
        this.index[this.size++] = X.checkArrayRange(index);
    }

    public final int[] yield() {
        if (this.size >= this.index.length) {
            return this.index;
        }
        int[] index = new int[this.size];
        System.arraycopy(this.index, 0, index, 0, this.size);
        return index;
    }

    public final int[] sortAndYield() {
        XSort.sort(this.index, 0, this.size);
        return this.yield();
    }
}

