/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.serializer.collections;

import java.util.function.Consumer;
import org.eclipse.serializer.collections.BulkList;
import org.eclipse.serializer.collections.interfaces.OptimizableCollection;
import org.eclipse.serializer.collections.types.XList;
import org.eclipse.serializer.functional._longProcedure;
import org.eclipse.serializer.math.XMath;
import org.eclipse.serializer.typing.Composition;
import org.eclipse.serializer.typing.KeyValue;

public final class HashMapIdId
implements OptimizableCollection,
Composition {
    private Entry[] hashSlots;
    private int hashRange;
    private int size;

    public HashMapIdId() {
        this.hashSlots = new Entry[1];
        this.hashRange = 0;
    }

    public HashMapIdId(int slotSize) {
        this.hashRange = XMath.pow2BoundCapped(slotSize) - 1;
        this.hashSlots = new Entry[this.hashRange + 1];
    }

    @Override
    public final long size() {
        return this.size;
    }

    @Override
    public final boolean isEmpty() {
        return this.size == 0;
    }

    private void rebuild(int newLength) {
        if (this.hashSlots.length >= newLength || newLength <= 0) {
            return;
        }
        int newRange = newLength - 1;
        Entry[] oldSlots = this.hashSlots;
        Entry[] newSlots = new Entry[newLength];
        int i = 0;
        while (i < oldSlots.length) {
            if (oldSlots[i] != null) {
                Entry entry = oldSlots[i];
                while (entry != null) {
                    Entry next = entry.link;
                    entry.link = newSlots[System.identityHashCode(entry.value) & newRange];
                    newSlots[System.identityHashCode((Object)Long.valueOf((long)entry.value)) & newRange] = entry;
                    entry = next;
                }
            }
            ++i;
        }
        this.hashSlots = newSlots;
        this.hashRange = newRange;
    }

    public boolean add(long key, long value) {
        int index = (int)(key & (long)(this.hashSlots.length - 1));
        Entry entry = this.hashSlots[index];
        if (entry == null) {
            this.putEntry(index, new Entry(key, value));
            return true;
        }
        do {
            if (entry.key != key) continue;
            return false;
        } while ((entry = entry.link) != null);
        this.putEntry(index, new Entry(key, value, this.hashSlots[index]));
        return true;
    }

    public boolean put(long key, long value) {
        int index = (int)(key & (long)(this.hashSlots.length - 1));
        Entry entry = this.hashSlots[index];
        if (entry == null) {
            this.putEntry(index, new Entry(key, value));
            return true;
        }
        do {
            if (entry.key != key) continue;
            entry.value = value;
            return false;
        } while ((entry = entry.link) != null);
        this.putEntry(index, new Entry(key, value, this.hashSlots[index]));
        return true;
    }

    public long putGet(long key, long value) {
        int index = (int)(key & (long)(this.hashSlots.length - 1));
        Entry entry = this.hashSlots[index];
        if (entry == null) {
            this.putEntry(index, new Entry(key, value));
            return value;
        }
        do {
            if (entry.key != key) continue;
            long oldValue = entry.value;
            entry.value = value;
            return oldValue;
        } while ((entry = entry.link) != null);
        this.putEntry(index, new Entry(key, value, this.hashSlots[index]));
        return value;
    }

    public long addGet(long key, long value) {
        int index = (int)(key & (long)(this.hashSlots.length - 1));
        Entry entry = this.hashSlots[index];
        if (entry == null) {
            this.putEntry(index, new Entry(key, value));
            return value;
        }
        do {
            if (entry.key != key) continue;
            return entry.value;
        } while ((entry = entry.link) != null);
        this.putEntry(index, new Entry(key, value, this.hashSlots[index]));
        return value;
    }

    private void putEntry(int index, Entry entry) {
        this.hashSlots[index] = entry;
        if (++this.size >= this.hashRange) {
            this.rebuild((int)((float)this.hashSlots.length * 2.0f));
        }
    }

    public long get(long key) {
        Entry entry = this.hashSlots[(int)(key & (long)this.hashRange)];
        while (entry != null) {
            if (entry.key == key) {
                return entry.value;
            }
            entry = entry.link;
        }
        return 0L;
    }

    public XList<Long> getIds() {
        BulkList<Long> list = new BulkList<Long>(this.size);
        Entry[] entryArray = this.hashSlots;
        int n = this.hashSlots.length;
        int n2 = 0;
        while (n2 < n) {
            Entry entry = entryArray[n2];
            while (entry != null) {
                list.add(entry.key);
                entry = entry.link;
            }
            ++n2;
        }
        return list;
    }

    public int iterateObjects(_longProcedure procedure) {
        Entry[] entryArray = this.hashSlots;
        int n = this.hashSlots.length;
        int n2 = 0;
        while (n2 < n) {
            Entry entry = entryArray[n2];
            while (entry != null) {
                procedure.accept(entry.value);
                entry = entry.link;
            }
            ++n2;
        }
        return this.size;
    }

    @Override
    public long optimize() {
        this.rebuild(XMath.pow2BoundCapped(this.size));
        return this.size;
    }

    public int iterateIds(Consumer<? super Long> procedure) {
        Entry[] entryArray = this.hashSlots;
        int n = this.hashSlots.length;
        int n2 = 0;
        while (n2 < n) {
            Entry entry = entryArray[n2];
            while (entry != null) {
                procedure.accept((Long)entry.key);
                entry = entry.link;
            }
            ++n2;
        }
        return this.size;
    }

    public int iterateIds(_longProcedure procedure) {
        Entry[] entryArray = this.hashSlots;
        int n = this.hashSlots.length;
        int n2 = 0;
        while (n2 < n) {
            Entry entry = entryArray[n2];
            while (entry != null) {
                procedure.accept(entry.key);
                entry = entry.link;
            }
            ++n2;
        }
        return this.size;
    }

    public void clear() {
        Entry[] slots = this.hashSlots;
        int i = 0;
        int len = slots.length;
        while (i < len) {
            slots[i] = null;
            ++i;
        }
        this.size = 0;
    }

    static final class Entry
    implements KeyValue<Long, Long>,
    Composition {
        final long key;
        long value;
        Entry link;

        Entry(long key, long ref, Entry next) {
            this.key = key;
            this.value = ref;
            this.link = next;
        }

        Entry(long key, long value) {
            this.key = key;
            this.value = value;
            this.link = null;
        }

        @Override
        public Long key() {
            return this.key;
        }

        @Override
        public Long value() {
            return this.value;
        }
    }
}

