/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.serializer.collections;

import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.ListIterator;
import java.util.Map;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import org.eclipse.serializer.chars.VarString;
import org.eclipse.serializer.collections.AbstractChainEntryLinked;
import org.eclipse.serializer.collections.AbstractChainKeyValueCollection;
import org.eclipse.serializer.collections.AbstractChainKeyValueStorage;
import org.eclipse.serializer.collections.ArrayView;
import org.eclipse.serializer.collections.BulkList;
import org.eclipse.serializer.collections.ChainMapEntryLinkedHashedStrongStrong;
import org.eclipse.serializer.collections.ChainStrongStrongStorage;
import org.eclipse.serializer.collections.ConstList;
import org.eclipse.serializer.collections.EnumView;
import org.eclipse.serializer.collections.EqConstHashEnum;
import org.eclipse.serializer.collections.EqConstHashTable;
import org.eclipse.serializer.collections.EqHashEnum;
import org.eclipse.serializer.collections.EqHashTable;
import org.eclipse.serializer.collections.ListView;
import org.eclipse.serializer.collections.SubListProcessor;
import org.eclipse.serializer.collections.SubListView;
import org.eclipse.serializer.collections.TableView;
import org.eclipse.serializer.collections.XArrays;
import org.eclipse.serializer.collections.interfaces.CapacityExtendable;
import org.eclipse.serializer.collections.interfaces.HashCollection;
import org.eclipse.serializer.collections.old.AbstractBridgeXSet;
import org.eclipse.serializer.collections.old.AbstractOldSettingList;
import org.eclipse.serializer.collections.types.XEnum;
import org.eclipse.serializer.collections.types.XGettingCollection;
import org.eclipse.serializer.collections.types.XGettingEnum;
import org.eclipse.serializer.collections.types.XGettingMap;
import org.eclipse.serializer.collections.types.XGettingSequence;
import org.eclipse.serializer.collections.types.XGettingTable;
import org.eclipse.serializer.collections.types.XImmutableList;
import org.eclipse.serializer.collections.types.XIterable;
import org.eclipse.serializer.collections.types.XList;
import org.eclipse.serializer.collections.types.XTable;
import org.eclipse.serializer.equality.Equalator;
import org.eclipse.serializer.exceptions.ArrayCapacityException;
import org.eclipse.serializer.functional.IndexedAcceptor;
import org.eclipse.serializer.hashing.HashEqualator;
import org.eclipse.serializer.hashing.XHashing;
import org.eclipse.serializer.math.XMath;
import org.eclipse.serializer.meta.NotImplementedYetError;
import org.eclipse.serializer.typing.Composition;
import org.eclipse.serializer.typing.Copyable;
import org.eclipse.serializer.typing.KeyValue;
import org.eclipse.serializer.typing.XTypes;
import org.eclipse.serializer.util.X;

public final class EqHashTable<K, V>
extends AbstractChainKeyValueCollection<K, V, ChainMapEntryLinkedHashedStrongStrong<K, V>>
implements XTable<K, V>,
HashCollection<K>,
Composition {
    final AbstractChainKeyValueStorage<K, V, ChainMapEntryLinkedHashedStrongStrong<K, V>> chain;
    ChainMapEntryLinkedHashedStrongStrong<K, V>[] slots;
    final HashEqualator<? super K> hashEqualator;
    float hashDensity;
    int capacity;
    int range;
    int size;
    final Values values = new Values();
    final Keys keys = new Keys();

    public static final <K, V> EqHashTable<K, V> New() {
        return new EqHashTable(1, 1.0f, XHashing.hashEqualityValue());
    }

    public static final <K, V> EqHashTable<K, V> NewCustom(int initialHashLength) {
        return new EqHashTable(XHashing.padHashLength(initialHashLength), 1.0f, XHashing.hashEqualityValue());
    }

    public static final <K, V> EqHashTable<K, V> NewCustom(float hashDensity) {
        return new EqHashTable(1, XHashing.validateHashDensity(hashDensity), XHashing.hashEqualityValue());
    }

    public static final <K, V> EqHashTable<K, V> NewCustom(int initialHashLength, float hashDensity) {
        return new EqHashTable(XHashing.padHashLength(initialHashLength), XHashing.validateHashDensity(hashDensity), XHashing.hashEqualityValue());
    }

    public static final <K, V> EqHashTable<K, V> New(XGettingCollection<? extends KeyValue<? extends K, ? extends V>> entries) {
        return EqHashTable.New().internalAddEntries(entries);
    }

    public static final <K, V> EqHashTable<K, V> NewCustom(int initialHashLength, float hashDensity, XGettingCollection<? extends KeyValue<? extends K, ? extends V>> entries) {
        return new EqHashTable(XHashing.padHashLength(initialHashLength), XHashing.validateHashDensity(hashDensity), XHashing.hashEqualityValue()).internalAddEntries(entries);
    }

    public static final <K, V> EqHashTable<K, V> NewSingle(K key, V value) {
        EqHashTable<K, V> instance = EqHashTable.New();
        instance.internalAdd(key, value);
        return instance;
    }

    @SafeVarargs
    public static final <K, V> EqHashTable<K, V> New(KeyValue<? extends K, ? extends V> ... entries) {
        return EqHashTable.New().internalAddEntries(new ArrayView<KeyValue<? extends K, ? extends V>>(entries));
    }

    @SafeVarargs
    public static final <K, V> EqHashTable<K, V> NewCustom(int initialHashLength, float hashDensity, KeyValue<? extends K, ? extends V> ... entries) {
        return new EqHashTable(XHashing.padHashLength(initialHashLength), XHashing.validateHashDensity(hashDensity), XHashing.hashEqualityValue()).internalAddEntries(new ArrayView<KeyValue<? extends K, ? extends V>>(entries));
    }

    public static final <K, V> EqHashTable<K, V> New(HashEqualator<? super K> hashEqualator) {
        return new EqHashTable<K, V>(1, 1.0f, X.notNull(hashEqualator));
    }

    public static final <K, V> EqHashTable<K, V> NewCustom(HashEqualator<? super K> hashEqualator, int initialHashLength) {
        return new EqHashTable<K, V>(XHashing.padHashLength(initialHashLength), 1.0f, X.notNull(hashEqualator));
    }

    public static final <K, V> EqHashTable<K, V> NewCustom(HashEqualator<? super K> hashEqualator, float hashDensity) {
        return new EqHashTable<K, V>(1, XHashing.validateHashDensity(hashDensity), X.notNull(hashEqualator));
    }

    public static final <K, V> EqHashTable<K, V> NewCustom(HashEqualator<? super K> hashEqualator, int initialHashLength, float hashDensity) {
        return new EqHashTable<K, V>(XHashing.padHashLength(initialHashLength), XHashing.validateHashDensity(hashDensity), X.notNull(hashEqualator));
    }

    public static final <K, V> EqHashTable<K, V> New(HashEqualator<? super K> hashEqualator, XGettingCollection<? extends KeyValue<? extends K, ? extends V>> entries) {
        return new EqHashTable<K, V>(1, 1.0f, X.notNull(hashEqualator)).internalAddEntries(entries);
    }

    public static final <K, V> EqHashTable<K, V> NewCustom(HashEqualator<? super K> hashEqualator, int initialHashLength, float hashDensity, XGettingCollection<? extends KeyValue<? extends K, ? extends V>> entries) {
        return new EqHashTable<K, V>(XHashing.padHashLength(initialHashLength), XHashing.validateHashDensity(hashDensity), X.notNull(hashEqualator)).internalAddEntries(entries);
    }

    @SafeVarargs
    public static final <K, V> EqHashTable<K, V> New(HashEqualator<? super K> hashEqualator, KeyValue<? extends K, ? extends V> ... entries) {
        return new EqHashTable<K, V>(1, 1.0f, X.notNull(hashEqualator)).internalAddEntries(new ArrayView<KeyValue<? extends K, ? extends V>>(entries));
    }

    @SafeVarargs
    public static final <K, V> EqHashTable<K, V> NewCustom(HashEqualator<? super K> hashEqualator, int initialHashLength, float hashDensity, KeyValue<? extends K, ? extends V> ... entries) {
        return new EqHashTable<K, V>(XHashing.padHashLength(initialHashLength), XHashing.validateHashDensity(hashDensity), X.notNull(hashEqualator)).internalAddEntries(new ArrayView<KeyValue<? extends K, ? extends V>>(entries));
    }

    private EqHashTable(EqHashTable<K, V> original) {
        this.hashDensity = original.hashDensity;
        this.hashEqualator = original.hashEqualator;
        this.range = original.range;
        this.slots = ChainMapEntryLinkedHashedStrongStrong.array(original.slots.length);
        this.chain = new ChainStrongStrongStorage(this, new ChainMapEntryLinkedHashedStrongStrong<Object, Object>(-1, null, null, null));
        this.capacity = original.capacity;
    }

    private EqHashTable(int pow2InitialHashLength, float positiveHashDensity, HashEqualator<? super K> hashEqualator) {
        this.hashDensity = positiveHashDensity;
        this.hashEqualator = hashEqualator;
        this.range = pow2InitialHashLength - 1;
        this.slots = ChainMapEntryLinkedHashedStrongStrong.array(pow2InitialHashLength);
        this.chain = new ChainStrongStrongStorage(this, new ChainMapEntryLinkedHashedStrongStrong<Object, Object>(-1, null, null, null));
        this.capacity = (int)((float)pow2InitialHashLength * positiveHashDensity);
    }

    private ChainMapEntryLinkedHashedStrongStrong<K, V> createNewEntry(int hash, K key, V value) {
        if (this.size >= this.capacity) {
            EqHashTable.ensureFreeArrayCapacity(this.size);
            this.increaseStorage();
        }
        ChainMapEntryLinkedHashedStrongStrong<K, V> e = new ChainMapEntryLinkedHashedStrongStrong<K, V>(hash, key, value, this.slots[hash & this.range]);
        this.slots[hash & this.range] = e;
        ++this.size;
        return e;
    }

    private void increaseStorage() {
        this.rebuildStorage((int)((float)this.slots.length * 2.0f));
    }

    private void rebuildStorage(int newSlotLength) {
        ChainMapEntryLinkedHashedStrongStrong<K, V>[] newSlots = ChainMapEntryLinkedHashedStrongStrong.array(newSlotLength);
        int modulo = newSlotLength >= Integer.MAX_VALUE ? Integer.MAX_VALUE : newSlotLength - 1;
        ChainMapEntryLinkedHashedStrongStrong entry = (ChainMapEntryLinkedHashedStrongStrong)this.chain.head();
        while ((entry = (ChainMapEntryLinkedHashedStrongStrong)entry.next) != null) {
            entry.link = newSlots[entry.hash & modulo];
            newSlots[entry.hash & modulo] = entry;
        }
        this.capacity = newSlotLength >= Integer.MAX_VALUE ? Integer.MAX_VALUE : (int)((float)newSlotLength * this.hashDensity);
        this.slots = newSlots;
        this.range = modulo;
    }

    final boolean internalAddOnlyKey(K key) {
        int hash = this.hashEqualator.hash(key);
        ChainMapEntryLinkedHashedStrongStrong e = this.slots[hash & this.range];
        while (e != null) {
            if (e.hash == hash && this.hashEqualator.equal(e.key(), key)) {
                return false;
            }
            e = (ChainMapEntryLinkedHashedStrongStrong)e.link;
        }
        this.chain.appendEntry(this.createNewEntry(hash, key, null));
        return true;
    }

    final boolean internalPutOnlyKey(K key) {
        int hash = this.hashEqualator.hash(key);
        ChainMapEntryLinkedHashedStrongStrong e = this.slots[hash & this.range];
        while (e != null) {
            if (e.hash == hash && this.hashEqualator.equal(e.key(), key)) {
                e.setKey(key);
                return false;
            }
            e = (ChainMapEntryLinkedHashedStrongStrong)e.link;
        }
        this.chain.appendEntry(this.createNewEntry(hash, key, null));
        return true;
    }

    final K internalPutGetKey(K key) {
        int hash = this.hashEqualator.hash(key);
        ChainMapEntryLinkedHashedStrongStrong e = this.slots[hash & this.range];
        while (e != null) {
            if (e.hash == hash && this.hashEqualator.equal(e.key(), key)) {
                return e.setKey(key);
            }
            e = (ChainMapEntryLinkedHashedStrongStrong)e.link;
        }
        this.chain.appendEntry(this.createNewEntry(hash, key, null));
        return null;
    }

    final K internalAddGetKey(K key) {
        int hash = this.hashEqualator.hash(key);
        ChainMapEntryLinkedHashedStrongStrong e = this.slots[hash & this.range];
        while (e != null) {
            if (e.hash == hash && this.hashEqualator.equal(e.key(), key)) {
                return e.key();
            }
            e = (ChainMapEntryLinkedHashedStrongStrong)e.link;
        }
        this.chain.appendEntry(this.createNewEntry(hash, key, null));
        return null;
    }

    final K internalReplaceKey(K key) {
        int hash = this.hashEqualator.hash(key);
        ChainMapEntryLinkedHashedStrongStrong e = this.slots[hash & this.range];
        while (e != null) {
            if (e.hash == hash && this.hashEqualator.equal(e.key(), key)) {
                return e.setKey(key);
            }
            e = (ChainMapEntryLinkedHashedStrongStrong)e.link;
        }
        return null;
    }

    final K internalSubstituteKey(K key) {
        int hash = this.hashEqualator.hash(key);
        ChainMapEntryLinkedHashedStrongStrong e = this.slots[hash & this.range];
        while (e != null) {
            if (e.hash == hash && this.hashEqualator.equal(e.key(), key)) {
                e.key = key;
                return e.key;
            }
            e = (ChainMapEntryLinkedHashedStrongStrong)e.link;
        }
        this.chain.appendEntry(this.createNewEntry(hash, key, null));
        return null;
    }

    final void internalAdd(K key, V value) {
        int hash = this.hashEqualator.hash(key);
        ChainMapEntryLinkedHashedStrongStrong e = this.slots[hash & this.range];
        while (e != null) {
            if (e.hash == hash && this.hashEqualator.equal(e.key(), key)) {
                return;
            }
            e = (ChainMapEntryLinkedHashedStrongStrong)e.link;
        }
        this.chain.appendEntry(this.createNewEntry(hash, key, value));
    }

    final EqHashTable<K, V> internalAddEntries(XGettingCollection<? extends KeyValue<? extends K, ? extends V>> entries) {
        entries.iterate(new Consumer<KeyValue<? extends K, ? extends V>>(){

            @Override
            public void accept(KeyValue<? extends K, ? extends V> e) {
                EqHashTable.this.internalAdd(e.key(), e.value());
            }
        });
        return this;
    }

    final V oldPutGet(K key, V value) {
        int hash = this.hashEqualator.hash(key);
        ChainMapEntryLinkedHashedStrongStrong e = this.slots[hash & this.range];
        while (e != null) {
            if (e.hash == hash && this.hashEqualator.equal(e.key(), key)) {
                return e.setValue(value);
            }
            e = (ChainMapEntryLinkedHashedStrongStrong)e.link;
        }
        this.chain.appendEntry(this.createNewEntry(hash, key, value));
        return null;
    }

    @Override
    public final KeyValue<K, V> lookup(K key) {
        int hash = this.hashEqualator.hash(key);
        ChainMapEntryLinkedHashedStrongStrong e = this.slots[hash & this.range];
        while (e != null) {
            if (e.hash == hash && this.hashEqualator.equal(e.key(), key)) {
                return e;
            }
            e = (ChainMapEntryLinkedHashedStrongStrong)e.link;
        }
        return null;
    }

    final boolean containsKey(K key) {
        int hash = this.hashEqualator.hash(key);
        ChainMapEntryLinkedHashedStrongStrong e = this.slots[hash & this.range];
        while (e != null) {
            if (e.hash == hash && this.hashEqualator.equal(e.key(), key)) {
                return true;
            }
            e = (ChainMapEntryLinkedHashedStrongStrong)e.link;
        }
        return false;
    }

    final int removeKey(K key) {
        int hash = this.hashEqualator.hash(key);
        ChainMapEntryLinkedHashedStrongStrong e = this.slots[hash & this.range];
        if (e == null) {
            return 0;
        }
        if (e.hash == hash && this.hashEqualator.equal(e.key(), key)) {
            this.slots[hash & this.range] = (ChainMapEntryLinkedHashedStrongStrong)e.link;
            this.chain.disjoinEntry(e);
            --this.size;
            return 1;
        }
        ChainMapEntryLinkedHashedStrongStrong last = e;
        e = (ChainMapEntryLinkedHashedStrongStrong)last.link;
        while (e != null) {
            if (e.hash == hash && this.hashEqualator.equal(e.key(), key)) {
                last.link = (ChainMapEntryLinkedHashedStrongStrong)e.link;
                this.chain.disjoinEntry(e);
                --this.size;
                return 1;
            }
            last = e;
            e = (ChainMapEntryLinkedHashedStrongStrong)last.link;
        }
        return 0;
    }

    final void removeNullEntry() {
        this.removeFor(null);
    }

    boolean nullKeyPut() {
        return this.internalPutOnlyKey(null);
    }

    boolean nullKeyAdd() {
        return this.internalAddOnlyKey(null);
    }

    final void internalCollectUnhashed(K key, V value) {
        this.chain.appendEntry(new ChainMapEntryLinkedHashedStrongStrong<K, V>(0, key, value, null));
    }

    final void replace(ChainMapEntryLinkedHashedStrongStrong<K, V> oldEntry, K newElement) {
        int newHash = this.hashEqualator.hash(newElement);
        ChainMapEntryLinkedHashedStrongStrong e = this.slots[newHash & this.range];
        while (e != null) {
            if (e.hash == newHash && this.hashEqualator.equal(e.key, newElement) && e == oldEntry) {
                e.setKey0(newElement);
                return;
            }
            e = (ChainMapEntryLinkedHashedStrongStrong)e.link;
        }
        throw new UnsupportedOperationException("Hash-changing replacement not supported, yet.");
    }

    protected int internalCountingAddAll(KeyValue<K, V>[] elements) throws UnsupportedOperationException {
        return this.internalCountingAddAll(elements, 0, elements.length);
    }

    protected int internalCountingAddAll(KeyValue<K, V>[] elements, int offset, int length) throws UnsupportedOperationException {
        int bound = offset + length;
        int count = 0;
        int i = offset;
        while (i < bound) {
            if (this.add(elements[i])) {
                ++count;
            }
            ++i;
        }
        return count;
    }

    @Override
    protected int internalCountingAddAll(XGettingCollection<? extends KeyValue<K, V>> elements) throws UnsupportedOperationException {
        return elements.iterate(new Consumer<KeyValue<K, V>>(){
            int count;

            @Override
            public void accept(KeyValue<K, V> e) {
                if (EqHashTable.this.add(e)) {
                    ++this.count;
                }
            }
        }).count;
    }

    protected int internalCountingPutAll(KeyValue<K, V>[] elements) throws UnsupportedOperationException {
        return this.internalCountingAddAll(elements, 0, elements.length);
    }

    protected int internalCountingPutAll(KeyValue<K, V>[] elements, int offset, int length) throws UnsupportedOperationException {
        int bound = offset + length;
        int count = 0;
        int i = offset;
        while (i < bound) {
            if (this.put(elements[i])) {
                ++count;
            }
            ++i;
        }
        return count;
    }

    @Override
    protected int internalCountingPutAll(XGettingCollection<? extends KeyValue<K, V>> elements) throws UnsupportedOperationException {
        return elements.iterate(new Consumer<KeyValue<K, V>>(){
            int count;

            @Override
            public void accept(KeyValue<K, V> e) {
                if (EqHashTable.this.put(e)) {
                    ++this.count;
                }
            }
        }).count;
    }

    @Override
    protected int internalRemoveNullEntries() {
        return this.removeKey(null);
    }

    /*
     * Unable to fully structure code
     */
    @Override
    protected void internalRemoveEntry(ChainMapEntryLinkedHashedStrongStrong<K, V> entry) {
        block3: {
            e = this.slots[setEntry.hash & this.range];
            setEntry = entry;
            if (e != setEntry) ** GOTO lbl9
            this.slots[setEntry.hash & this.range] = (ChainMapEntryLinkedHashedStrongStrong)setEntry.link;
            break block3;
lbl-1000:
            // 1 sources

            {
                if (e == setEntry) {
                    last.link = (ChainMapEntryLinkedHashedStrongStrong)setEntry.link;
                    break;
                }
lbl9:
                // 3 sources

                last = e;
                ** while ((e = (ChainMapEntryLinkedHashedStrongStrong)last.link) != null)
            }
lbl11:
            // 2 sources

            if (e == null) {
                throw new IllegalArgumentException("Entry inconsistency detected");
            }
        }
        --this.size;
        this.chain.disjoinEntry(setEntry);
    }

    @Override
    protected int internalClear() {
        int size = this.size;
        this.clear();
        return size;
    }

    protected AbstractChainKeyValueStorage<K, V, ChainMapEntryLinkedHashedStrongStrong<K, V>> getInternalStorageChain() {
        return this.chain;
    }

    @Override
    public final long size() {
        return this.size;
    }

    @Override
    public final boolean isEmpty() {
        return this.size == 0;
    }

    @Override
    public final void clear() {
        this.chain.clear();
        ChainMapEntryLinkedHashedStrongStrong<K, V>[] slots = this.slots;
        int i = 0;
        int length = slots.length;
        while (i < length) {
            slots[i] = null;
            ++i;
        }
        this.size = 0;
    }

    @Override
    public final void truncate() {
        this.chain.clear();
        this.slots = ChainMapEntryLinkedHashedStrongStrong.array(1);
        this.size = 0;
        this.capacity = (int)(1.0f * this.hashDensity);
    }

    @Override
    public final long consolidate() {
        return this.chain.consolidate();
    }

    @Override
    public final CapacityExtendable ensureCapacity(long minimalCapacity) {
        if ((long)this.capacity >= minimalCapacity) {
            return this;
        }
        int requiredSlotLength = (int)((float)minimalCapacity / this.hashDensity);
        if (XMath.isGreaterThanHighestPowerOf2(requiredSlotLength)) {
            this.rebuildStorage(Integer.MAX_VALUE);
            return this;
        }
        int newSlotsLength = this.slots.length;
        while (newSlotsLength < requiredSlotLength) {
            newSlotsLength <<= 1;
        }
        this.rebuildStorage(newSlotsLength);
        return this;
    }

    @Override
    public final CapacityExtendable ensureFreeCapacity(long requiredFreeCapacity) {
        if ((long)(this.capacity - this.size) >= requiredFreeCapacity) {
            return this;
        }
        if ((long)(Integer.MAX_VALUE - this.size) < requiredFreeCapacity) {
            throw new ArrayCapacityException(requiredFreeCapacity + (long)this.size);
        }
        int requiredSlotLength = (int)((float)((long)this.size + requiredFreeCapacity) / this.hashDensity);
        if (XMath.isGreaterThanHighestPowerOf2(requiredSlotLength)) {
            this.rebuildStorage(Integer.MAX_VALUE);
            return this;
        }
        int newSlotsLength = this.slots.length;
        while (newSlotsLength < requiredSlotLength) {
            newSlotsLength <<= 1;
        }
        this.rebuildStorage(newSlotsLength);
        return this;
    }

    @Override
    public final long optimize() {
        int requiredCapacity = (int)((float)this.size / this.hashDensity);
        if (XMath.isGreaterThanHighestPowerOf2(requiredCapacity)) {
            if (this.slots.length != Integer.MAX_VALUE) {
                this.rebuildStorage(Integer.MAX_VALUE);
            }
            return this.capacity;
        }
        int newCapacity = XHashing.padHashLength(requiredCapacity);
        if (this.slots.length != newCapacity) {
            this.rebuildStorage(newCapacity);
        }
        return this.capacity;
    }

    @Override
    public final int rehash() {
        int reqCapacity = XHashing.padHashLength((int)((float)this.size / this.hashDensity));
        ChainMapEntryLinkedHashedStrongStrong<K, V>[] slots = ChainMapEntryLinkedHashedStrongStrong.array(reqCapacity);
        int range = reqCapacity >= Integer.MAX_VALUE ? Integer.MAX_VALUE : reqCapacity - 1;
        HashEqualator<K> hashEqualator = this.hashEqualator;
        AbstractChainKeyValueStorage<K, V, ChainMapEntryLinkedHashedStrongStrong<K, V>> chain = this.chain;
        ChainMapEntryLinkedHashedStrongStrong entry = (ChainMapEntryLinkedHashedStrongStrong)((ChainMapEntryLinkedHashedStrongStrong)chain.head()).next;
        chain.clear();
        int size = 0;
        while (entry != null) {
            block3: {
                int hash = hashEqualator.hash(entry.key);
                ChainMapEntryLinkedHashedStrongStrong e = slots[hash & range];
                while (e != null) {
                    if (e.hash != hash || !hashEqualator.equal(e.key, entry.key)) {
                        e = (ChainMapEntryLinkedHashedStrongStrong)e.link;
                        continue;
                    }
                    break block3;
                }
                ChainMapEntryLinkedHashedStrongStrong chainMapEntryLinkedHashedStrongStrong = new ChainMapEntryLinkedHashedStrongStrong(hash, entry.key, entry.value, slots[hash & range]);
                slots[hash & range] = chainMapEntryLinkedHashedStrongStrong;
                chain.appendEntry(chainMapEntryLinkedHashedStrongStrong);
                ++size;
            }
            entry = (ChainMapEntryLinkedHashedStrongStrong)entry.next;
        }
        this.slots = slots;
        this.range = range;
        this.size = size;
        return size;
    }

    @Override
    public final EqHashTable<K, V> copy() {
        final EqHashTable<K, V> newVarMap = new EqHashTable<K, V>(this);
        this.chain.iterate(new Consumer<KeyValue<K, V>>(){

            @Override
            public void accept(KeyValue<K, V> entry) {
                newVarMap.put(entry.key(), entry.value());
            }
        });
        return newVarMap;
    }

    @Override
    public final EqConstHashTable<K, V> immure() {
        this.consolidate();
        return EqConstHashTable.NewCustom(this.hashEqualator, this.size, this.hashDensity, this);
    }

    @Override
    public final XGettingTable<K, V> view() {
        return new TableView(this);
    }

    @Override
    public final void setHashDensity(float hashDensity) {
        this.hashDensity = XHashing.validateHashDensity(hashDensity);
        this.capacity = (int)((float)this.slots.length * this.hashDensity);
        this.optimize();
    }

    @Override
    public final boolean hasVolatileElements() {
        return false;
    }

    @Override
    public final boolean nullAllowed() {
        return true;
    }

    @Override
    public final boolean nullKeyAllowed() {
        return true;
    }

    @Override
    public final boolean nullValuesAllowed() {
        return true;
    }

    @Override
    public final V get(K key) {
        int hash = this.hashEqualator.hash(key);
        ChainMapEntryLinkedHashedStrongStrong e = this.slots[hash & this.range];
        while (e != null) {
            if (e.hash == hash && this.hashEqualator.equal(e.key(), key)) {
                return e.value();
            }
            e = (ChainMapEntryLinkedHashedStrongStrong)e.link;
        }
        return null;
    }

    @Override
    public final V ensure(K key, Function<? super K, V> valueProvider) {
        V value = this.get(key);
        if (value == null) {
            value = valueProvider.apply(key);
            this.add(key, value);
        }
        return value;
    }

    @Override
    public final Keys keys() {
        return this.keys;
    }

    @Override
    public final XTable.EntriesBridge<K, V> old() {
        throw new NotImplementedYetError();
    }

    @Override
    public XTable.Bridge<K, V> oldMap() {
        return new OldVarMap();
    }

    @Override
    public final V searchValue(final Predicate<? super K> keyPredicate) {
        KeyValue foundEntry = (KeyValue)this.chain.search(new Predicate<KeyValue<K, V>>(){

            @Override
            public boolean test(KeyValue<K, V> entry) {
                return keyPredicate.test(entry.key());
            }
        });
        return foundEntry != null ? (V)foundEntry.value() : null;
    }

    @Override
    public final <C extends Consumer<? super V>> C query(XIterable<? extends K> keys, final C collector) {
        keys.iterate(new Consumer<K>(){

            @Override
            public void accept(K key) {
                collector.accept(EqHashTable.this.get(key));
            }
        });
        return collector;
    }

    @Override
    public final Values values() {
        return this.values;
    }

    @Override
    public final long currentCapacity() {
        return this.capacity;
    }

    @Override
    public final long maximumCapacity() {
        return Integer.MAX_VALUE;
    }

    @Override
    public final boolean isFull() {
        return this.size >= Integer.MAX_VALUE;
    }

    @Override
    public final boolean hasVolatileValues() {
        return this.chain.hasVolatileValues();
    }

    @Override
    public final KeyValue<K, V> addGet(K key, V value) {
        int hash = this.hashEqualator.hash(key);
        ChainMapEntryLinkedHashedStrongStrong e = this.slots[hash & this.range];
        while (e != null) {
            if (e.hash == hash && this.hashEqualator.equal(e.key(), key)) {
                return e;
            }
            e = (ChainMapEntryLinkedHashedStrongStrong)e.link;
        }
        this.chain.appendEntry(this.createNewEntry(hash, key, value));
        return null;
    }

    @Override
    public KeyValue<K, V> substitute(K key, V value) {
        int hash = this.hashEqualator.hash(key);
        ChainMapEntryLinkedHashedStrongStrong e = this.slots[hash & this.range];
        while (e != null) {
            if (e.hash == hash && this.hashEqualator.equal(e.key(), key)) {
                return e;
            }
            e = (ChainMapEntryLinkedHashedStrongStrong)e.link;
        }
        this.chain.appendEntry(this.createNewEntry(hash, key, value));
        return X.KeyValue(key, value);
    }

    @Override
    public KeyValue<K, V> deduplicate(KeyValue<K, V> entry) {
        int hash = this.hashEqualator.hash(entry.key());
        ChainMapEntryLinkedHashedStrongStrong e = this.slots[hash & this.range];
        while (e != null) {
            if (e.hash == hash && this.hashEqualator.equal(e.key(), entry.key())) {
                return e;
            }
            e = (ChainMapEntryLinkedHashedStrongStrong)e.link;
        }
        this.chain.appendEntry(this.createNewEntry(hash, entry.key(), entry.value()));
        return entry;
    }

    @Override
    public final KeyValue<K, V> putGet(K key, V value) {
        int hash = this.hashEqualator.hash(key);
        ChainMapEntryLinkedHashedStrongStrong e = this.slots[hash & this.range];
        while (e != null) {
            if (e.hash == hash && this.hashEqualator.equal(e.key(), key)) {
                return X.KeyValue(e.setKey(key), e.setValue(value));
            }
            e = (ChainMapEntryLinkedHashedStrongStrong)e.link;
        }
        this.chain.appendEntry(this.createNewEntry(hash, key, value));
        return null;
    }

    @Override
    public KeyValue<K, V> replace(K key, V value) {
        int hash = this.hashEqualator.hash(key);
        ChainMapEntryLinkedHashedStrongStrong e = this.slots[hash & this.range];
        while (e != null) {
            if (e.hash == hash && this.hashEqualator.equal(e.key(), key)) {
                return X.KeyValue(e.setKey(key), e.setValue(value));
            }
            e = (ChainMapEntryLinkedHashedStrongStrong)e.link;
        }
        return null;
    }

    @Override
    public final KeyValue<K, V> replace(KeyValue<K, V> entry) {
        return this.replace(entry.key(), entry.value());
    }

    @Override
    public final KeyValue<K, V> setGet(K key, V value) {
        int hash = this.hashEqualator.hash(key);
        ChainMapEntryLinkedHashedStrongStrong e = this.slots[hash & this.range];
        while (e != null) {
            if (e.hash == hash && this.hashEqualator.equal(e.key(), key)) {
                return X.KeyValue(e.setKey(key), e.setValue(value));
            }
            e = (ChainMapEntryLinkedHashedStrongStrong)e.link;
        }
        return null;
    }

    @Override
    public final boolean add(K key, V value) {
        int hash = this.hashEqualator.hash(key);
        ChainMapEntryLinkedHashedStrongStrong e = this.slots[hash & this.range];
        while (e != null) {
            if (e.hash == hash && this.hashEqualator.equal(e.key(), key)) {
                return false;
            }
            e = (ChainMapEntryLinkedHashedStrongStrong)e.link;
        }
        this.chain.appendEntry(this.createNewEntry(hash, key, value));
        return true;
    }

    @Override
    public final boolean put(K key, V value) {
        int hash = this.hashEqualator.hash(key);
        ChainMapEntryLinkedHashedStrongStrong e = this.slots[hash & this.range];
        while (e != null) {
            if (e.hash == hash && this.hashEqualator.equal(e.key(), key)) {
                e.set0(key, value);
                return false;
            }
            e = (ChainMapEntryLinkedHashedStrongStrong)e.link;
        }
        this.chain.appendEntry(this.createNewEntry(hash, key, value));
        return true;
    }

    @Override
    public final boolean set(K key, V value) {
        int hash = this.hashEqualator.hash(key);
        ChainMapEntryLinkedHashedStrongStrong e = this.slots[hash & this.range];
        while (e != null) {
            if (e.hash == hash && this.hashEqualator.equal(e.key(), key)) {
                e.set0(key, value);
                return true;
            }
            e = (ChainMapEntryLinkedHashedStrongStrong)e.link;
        }
        return false;
    }

    @Override
    public final boolean valuePut(K key, V value) {
        int hash = this.hashEqualator.hash(key);
        ChainMapEntryLinkedHashedStrongStrong e = this.slots[hash & this.range];
        while (e != null) {
            if (e.hash == hash && this.hashEqualator.equal(e.key(), key)) {
                e.setValue0(value);
                return false;
            }
            e = (ChainMapEntryLinkedHashedStrongStrong)e.link;
        }
        this.chain.appendEntry(this.createNewEntry(hash, key, value));
        return true;
    }

    @Override
    public final boolean valueSet(K key, V value) {
        int hash = this.hashEqualator.hash(key);
        ChainMapEntryLinkedHashedStrongStrong e = this.slots[hash & this.range];
        while (e != null) {
            if (e.hash == hash && this.hashEqualator.equal(e.key(), key)) {
                e.setValue0(value);
                return true;
            }
            e = (ChainMapEntryLinkedHashedStrongStrong)e.link;
        }
        return false;
    }

    @Override
    public final V valuePutGet(K key, V value) {
        int hash = this.hashEqualator.hash(key);
        ChainMapEntryLinkedHashedStrongStrong e = this.slots[hash & this.range];
        while (e != null) {
            if (e.hash == hash && this.hashEqualator.equal(e.key(), key)) {
                return e.setValue(value);
            }
            e = (ChainMapEntryLinkedHashedStrongStrong)e.link;
        }
        this.chain.appendEntry(this.createNewEntry(hash, key, value));
        return null;
    }

    @Override
    public final V valueSetGet(K key, V value) {
        int hash = this.hashEqualator.hash(key);
        ChainMapEntryLinkedHashedStrongStrong e = this.slots[hash & this.range];
        while (e != null) {
            if (e.hash == hash && this.hashEqualator.equal(e.key(), key)) {
                return e.setValue(value);
            }
            e = (ChainMapEntryLinkedHashedStrongStrong)e.link;
        }
        return null;
    }

    @Override
    public final V removeFor(K key) {
        int hash = this.hashEqualator.hash(key);
        ChainMapEntryLinkedHashedStrongStrong e = this.slots[hash & this.range];
        if (e == null) {
            return null;
        }
        if (e.hash == hash && this.hashEqualator.equal(e.key(), key)) {
            this.slots[hash & this.range] = (ChainMapEntryLinkedHashedStrongStrong)e.link;
            this.chain.disjoinEntry(e);
            --this.size;
            return e.value();
        }
        ChainMapEntryLinkedHashedStrongStrong last = e;
        e = (ChainMapEntryLinkedHashedStrongStrong)last.link;
        while (e != null) {
            if (e.hash == hash && this.hashEqualator.equal(e.key(), key)) {
                last.link = (ChainMapEntryLinkedHashedStrongStrong)e.link;
                this.chain.disjoinEntry(e);
                --this.size;
                return e.value();
            }
            last = e;
            e = (ChainMapEntryLinkedHashedStrongStrong)last.link;
        }
        return null;
    }

    @Override
    public final HashCollection.Analysis<EqHashTable<K, V>> analyze() {
        return AbstractChainEntryLinked.analyzeSlots((HashCollection)this, (AbstractChainEntryLinked[])this.slots);
    }

    @Override
    public final int hashDistributionRange() {
        return this.slots.length;
    }

    @Override
    public final HashEqualator<? super K> hashEquality() {
        return this.hashEqualator;
    }

    @Override
    public final float hashDensity() {
        return this.hashDensity;
    }

    @Override
    public final boolean hasVolatileHashElements() {
        return this.chain.hasVolatileElements();
    }

    public final String toString() {
        return this.chain.appendTo(VarString.New(this.slots.length).append('{'), ",").append('}').toString();
    }

    public final Consumer<KeyValue<K, V>> procedureRemoveEntry() {
        return entry -> this.removeKey(entry.key());
    }

    public final Predicate<KeyValue<K, V>> predicateContainsEntry() {
        return entry -> {
            KeyValue kv = this.lookup(entry.key());
            if (kv == null) {
                return false;
            }
            return this.hashEqualator.equal(kv.key(), entry.key()) && kv.value() == entry.value();
        };
    }

    @Override
    public final EqHashTable<K, V> sort(Comparator<? super KeyValue<K, V>> comparator) {
        this.chain.sort(comparator);
        return this;
    }

    @Override
    public long substitute(Function<? super KeyValue<K, V>, ? extends KeyValue<K, V>> mapper) {
        throw new NotImplementedYetError();
    }

    @Override
    public final XEnum<KeyValue<K, V>> range(long lowIndex, long highIndex) {
        throw new NotImplementedYetError();
    }

    @Override
    public final XGettingEnum<KeyValue<K, V>> view(long lowIndex, long highIndex) {
        throw new NotImplementedYetError();
    }

    public final KeyValue<K, V>[] toArray(Class<KeyValue<K, V>> type) {
        return this.chain.toArray(type);
    }

    @Override
    public final <P extends Consumer<? super KeyValue<K, V>>> P iterate(P procedure) {
        this.chain.iterate(procedure);
        return procedure;
    }

    @Override
    public final <A> A join(BiConsumer<? super KeyValue<K, V>, ? super A> joiner, A aggregate) {
        this.chain.join(joiner, aggregate);
        return aggregate;
    }

    @Override
    public final long count(KeyValue<K, V> entry) {
        return this.chain.count(entry, this.equality());
    }

    @Override
    public final long countBy(Predicate<? super KeyValue<K, V>> predicate) {
        return this.chain.count(predicate);
    }

    @Override
    public final KeyValue<K, V> search(Predicate<? super KeyValue<K, V>> predicate) {
        return this.chain.search(predicate);
    }

    @Override
    public final KeyValue<K, V> max(Comparator<? super KeyValue<K, V>> comparator) {
        return this.chain.max(comparator);
    }

    @Override
    public final KeyValue<K, V> min(Comparator<? super KeyValue<K, V>> comparator) {
        return this.chain.min(comparator);
    }

    @Override
    public final boolean containsSearched(Predicate<? super KeyValue<K, V>> predicate) {
        return this.chain.containsSearched(predicate);
    }

    @Override
    public final boolean applies(Predicate<? super KeyValue<K, V>> predicate) {
        return this.chain.appliesAll(predicate);
    }

    @Override
    public final boolean nullContained() {
        return false;
    }

    @Override
    public final boolean containsId(KeyValue<K, V> entry) {
        int hash = this.hashEqualator.hash(entry.key());
        ChainMapEntryLinkedHashedStrongStrong e = this.slots[hash & this.range];
        while (e != null) {
            if (hash == e.hash && entry == e.key()) {
                return true;
            }
            e = (ChainMapEntryLinkedHashedStrongStrong)e.link;
        }
        return false;
    }

    @Override
    public final boolean contains(KeyValue<K, V> entry) {
        int hash = this.hashEqualator.hash(entry.key());
        ChainMapEntryLinkedHashedStrongStrong e = this.slots[hash & this.range];
        while (e != null) {
            if (e.hash == hash && this.hashEqualator.equal(e.key(), entry.key())) {
                return true;
            }
            e = (ChainMapEntryLinkedHashedStrongStrong)e.link;
        }
        return false;
    }

    @Override
    public final KeyValue<K, V> seek(KeyValue<K, V> sample) {
        if (sample == null) {
            return null;
        }
        int hash = this.hashEqualator.hash(sample.key());
        ChainMapEntryLinkedHashedStrongStrong e = this.slots[hash & this.range];
        while (e != null) {
            if (e.hash == hash && this.hashEqualator.equal(e.key(), sample.key())) {
                return e;
            }
            e = (ChainMapEntryLinkedHashedStrongStrong)e.link;
        }
        return null;
    }

    @Override
    public final boolean containsAll(XGettingCollection<? extends KeyValue<K, V>> elements) {
        return elements.applies(this.predicateContainsEntry());
    }

    @Override
    public final boolean equals(XGettingCollection<? extends KeyValue<K, V>> samples, Equalator<? super KeyValue<K, V>> equalator) {
        if (samples == null || !(samples instanceof Keys)) {
            return false;
        }
        if (samples == this) {
            return true;
        }
        return this.equalsContent(samples, equalator);
    }

    @Override
    public final boolean equalsContent(XGettingCollection<? extends KeyValue<K, V>> samples, Equalator<? super KeyValue<K, V>> equalator) {
        this.consolidate();
        if (this.size != XTypes.to_int(samples.size())) {
            return false;
        }
        return this.chain.equalsContent(samples, equalator);
    }

    @Override
    public final <C extends Consumer<? super KeyValue<K, V>>> C intersect(XGettingCollection<? extends KeyValue<K, V>> other, Equalator<? super KeyValue<K, V>> equalator, C target) {
        return this.chain.intersect(other, equalator, target);
    }

    @Override
    public final <C extends Consumer<? super KeyValue<K, V>>> C except(XGettingCollection<? extends KeyValue<K, V>> other, Equalator<? super KeyValue<K, V>> equalator, C target) {
        return this.chain.except(other, equalator, target);
    }

    @Override
    public final <C extends Consumer<? super KeyValue<K, V>>> C union(XGettingCollection<? extends KeyValue<K, V>> other, Equalator<? super KeyValue<K, V>> equalator, C target) {
        return this.chain.union(other, equalator, target);
    }

    @Override
    public final <C extends Consumer<? super KeyValue<K, V>>> C copyTo(C target) {
        if (target == this) {
            return target;
        }
        return this.chain.copyTo(target);
    }

    @Override
    public final <C extends Consumer<? super KeyValue<K, V>>> C filterTo(C target, Predicate<? super KeyValue<K, V>> predicate) {
        return this.chain.copyTo(target, predicate);
    }

    @Override
    public final <C extends Consumer<? super KeyValue<K, V>>> C distinct(C target) {
        return this.distinct(target, this.equality());
    }

    @Override
    public final <C extends Consumer<? super KeyValue<K, V>>> C distinct(C target, Equalator<? super KeyValue<K, V>> equalator) {
        return this.chain.distinct(target, equalator);
    }

    @Override
    public final boolean nullAdd() {
        return this.nullKeyAdd();
    }

    @Override
    public final boolean add(KeyValue<K, V> entry) {
        return this.add(entry.key(), entry.value());
    }

    @Override
    @SafeVarargs
    public final EqHashTable<K, V> addAll(KeyValue<K, V> ... elements) {
        EqHashTable parent = this;
        int i = 0;
        int len = elements.length;
        while (i < len) {
            parent.add(elements[i].key(), elements[i].value());
            ++i;
        }
        return this;
    }

    @Override
    public final EqHashTable<K, V> addAll(KeyValue<K, V>[] elements, int srcIndex, int srcLength) {
        int d = XArrays.validateArrayRange(elements, srcIndex, srcLength);
        if (d == 0) {
            return this;
        }
        int bound = srcIndex + srcLength;
        EqHashTable parent = this;
        int i = srcIndex;
        while (i != bound) {
            parent.add(elements[i].key(), elements[i].value());
            i += d;
        }
        return this;
    }

    @Override
    public final EqHashTable<K, V> addAll(XGettingCollection<? extends KeyValue<K, V>> elements) {
        elements.iterate(this::add);
        return this;
    }

    @Override
    public final boolean nullPut() {
        return this.nullKeyPut();
    }

    @Override
    public final void accept(KeyValue<K, V> entry) {
        this.put(entry.key(), entry.value());
    }

    @Override
    public final boolean put(KeyValue<K, V> entry) {
        return this.put(entry.key(), entry.value());
    }

    @Override
    public final KeyValue<K, V> putGet(KeyValue<K, V> entry) {
        return this.putGet(entry.key(), entry.value());
    }

    @Override
    public final KeyValue<K, V> addGet(KeyValue<K, V> entry) {
        return this.addGet(entry.key(), entry.value());
    }

    @Override
    @SafeVarargs
    public final EqHashTable<K, V> putAll(KeyValue<K, V> ... elements) {
        EqHashTable parent = this;
        int i = 0;
        int len = elements.length;
        while (i < len) {
            parent.put(elements[i].key(), elements[i].value());
            ++i;
        }
        return this;
    }

    @Override
    public final EqHashTable<K, V> putAll(KeyValue<K, V>[] elements, int srcIndex, int srcLength) {
        int d = XArrays.validateArrayRange(elements, srcIndex, srcLength);
        if (d == 0) {
            return this;
        }
        int bound = srcIndex + srcLength;
        EqHashTable parent = this;
        int i = srcIndex;
        while (i != bound) {
            parent.put(elements[i].key(), elements[i].value());
            i += d;
        }
        return this;
    }

    @Override
    public final EqHashTable<K, V> putAll(XGettingCollection<? extends KeyValue<K, V>> elements) {
        return elements.iterate(this);
    }

    @Override
    public final long remove(KeyValue<K, V> entry) {
        return this.chain.remove(entry, this.equality());
    }

    @Override
    public final long nullRemove() {
        return 0L;
    }

    @Override
    public final long removeBy(Predicate<? super KeyValue<K, V>> predicate) {
        return this.chain.reduce(predicate);
    }

    @Override
    public final long retainAll(XGettingCollection<? extends KeyValue<K, V>> elements) {
        return this.chain.retainAll(elements, this.equality());
    }

    @Override
    public final <P extends Consumer<? super KeyValue<K, V>>> P process(P procedure) {
        this.chain.process(procedure);
        return procedure;
    }

    @Override
    public final <C extends Consumer<? super KeyValue<K, V>>> C moveTo(C target, Predicate<? super KeyValue<K, V>> predicate) {
        this.chain.moveTo(target, predicate);
        return target;
    }

    @Override
    public final long removeAll(XGettingCollection<? extends KeyValue<K, V>> elements) {
        int oldSize = this.size;
        elements.iterate(this.procedureRemoveEntry());
        return oldSize - this.size;
    }

    @Override
    public final long removeDuplicates() {
        return 0L;
    }

    @Override
    public final long removeDuplicates(Equalator<? super KeyValue<K, V>> equalator) {
        return this.chain.removeDuplicates(equalator);
    }

    @Override
    public final EqHashTable<K, V> toReversed() {
        Copyable reversedVarSet = this.copy();
        ((EqHashTable)reversedVarSet).chain.reverse();
        return reversedVarSet;
    }

    @Override
    public final <T extends Consumer<? super KeyValue<K, V>>> T copySelection(T target, long ... indices) {
        this.chain.copySelection(target, indices);
        return target;
    }

    @Override
    public final <P extends IndexedAcceptor<? super KeyValue<K, V>>> P iterateIndexed(P procedure) {
        this.chain.iterateIndexed(procedure);
        return procedure;
    }

    @Override
    public final KeyValue<K, V> at(long index) {
        return (KeyValue)this.chain.get(index);
    }

    @Override
    public final KeyValue<K, V> get() {
        return (KeyValue)this.chain.first();
    }

    @Override
    public final KeyValue<K, V> first() {
        return (KeyValue)this.chain.first();
    }

    @Override
    public final KeyValue<K, V> last() {
        return (KeyValue)this.chain.last();
    }

    @Override
    public final KeyValue<K, V> poll() {
        return this.size == 0 ? null : (KeyValue)this.chain.first();
    }

    @Override
    public final KeyValue<K, V> peek() {
        return this.size == 0 ? null : (KeyValue)this.chain.last();
    }

    @Override
    public final long indexOf(KeyValue<K, V> entry) {
        return this.chain.indexOf(entry);
    }

    @Override
    public final long indexBy(Predicate<? super KeyValue<K, V>> predicate) {
        return this.chain.indexOf(predicate);
    }

    @Override
    public final boolean isSorted(Comparator<? super KeyValue<K, V>> comparator) {
        return this.chain.isSorted(comparator);
    }

    @Override
    public final long lastIndexOf(KeyValue<K, V> entry) {
        return this.chain.lastIndexBy((? super E kv) -> this.hashEqualator.equal(kv.key(), entry.key()));
    }

    @Override
    public final long lastIndexBy(Predicate<? super KeyValue<K, V>> predicate) {
        return this.chain.lastIndexBy(predicate);
    }

    @Override
    public final long maxIndex(Comparator<? super KeyValue<K, V>> comparator) {
        return this.chain.maxIndex(comparator);
    }

    @Override
    public final long minIndex(Comparator<? super KeyValue<K, V>> comparator) {
        return this.chain.minIndex(comparator);
    }

    @Override
    public final long scan(Predicate<? super KeyValue<K, V>> predicate) {
        return this.chain.scan(predicate);
    }

    @Override
    public final <C extends Consumer<? super KeyValue<K, V>>> C moveSelection(C target, long ... indices) {
        this.chain.moveSelection(target, indices);
        return target;
    }

    @Override
    public final KeyValue<K, V> removeAt(long index) {
        return (KeyValue)this.chain.remove(index);
    }

    @Override
    public final KeyValue<K, V> fetch() {
        return (KeyValue)this.chain.remove(0L);
    }

    @Override
    public final KeyValue<K, V> pop() {
        return (KeyValue)this.chain.remove(this.size - 1);
    }

    @Override
    public final KeyValue<K, V> pinch() {
        return this.size == 0 ? null : (KeyValue)this.chain.remove(0L);
    }

    @Override
    public final KeyValue<K, V> pick() {
        return this.size == 0 ? null : (KeyValue)this.chain.remove(this.size - 1);
    }

    @Override
    public final KeyValue<K, V> retrieve(KeyValue<K, V> entry) {
        return this.chain.retrieve(entry);
    }

    @Override
    public final KeyValue<K, V> retrieveBy(Predicate<? super KeyValue<K, V>> predicate) {
        return this.chain.retrieve(predicate);
    }

    @Override
    public final boolean removeOne(KeyValue<K, V> entry) {
        return this.chain.removeOne(entry);
    }

    public final EqHashTable<K, V> removeRange(long startIndex, long length) {
        this.chain.removeRange(startIndex, length);
        return this;
    }

    public final EqHashTable<K, V> retainRange(long startIndex, long length) {
        this.chain.retainRange(startIndex, length);
        return this;
    }

    @Override
    public final long removeSelection(long[] indices) {
        return this.chain.removeSelection(indices);
    }

    @Override
    public final Iterator<KeyValue<K, V>> iterator() {
        return this.chain.iterator();
    }

    @Override
    public final Object[] toArray() {
        return this.chain.toArray();
    }

    @Override
    public final EqHashTable<K, V> reverse() {
        this.chain.reverse();
        return this;
    }

    @Override
    public final EqHashTable<K, V> shiftTo(long sourceIndex, long targetIndex) {
        this.chain.shiftTo(sourceIndex, targetIndex);
        return this;
    }

    @Override
    public final EqHashTable<K, V> shiftTo(long sourceIndex, long targetIndex, long length) {
        this.chain.shiftTo(sourceIndex, targetIndex, length);
        return this;
    }

    @Override
    public final EqHashTable<K, V> shiftBy(long sourceIndex, long distance) {
        this.chain.shiftTo(sourceIndex, distance);
        return this;
    }

    @Override
    public final EqHashTable<K, V> shiftBy(long sourceIndex, long distance, long length) {
        this.chain.shiftTo(sourceIndex, distance, length);
        return this;
    }

    @Override
    public final EqHashTable<K, V> swap(long indexA, long indexB) {
        this.chain.swap(indexA, indexB);
        return this;
    }

    @Override
    public final EqHashTable<K, V> swap(long indexA, long indexB, long length) {
        this.chain.swap(indexA, indexB, length);
        return this;
    }

    @Override
    public final HashEqualator<KeyValue<K, V>> equality() {
        return XHashing.wrapAsKeyValue(this.hashEqualator);
    }

    @Override
    public final boolean input(long index, KeyValue<K, V> element) {
        throw new NotImplementedYetError();
    }

    @SafeVarargs
    public final long inputAll(long index, KeyValue<K, V> ... elements) {
        throw new NotImplementedYetError();
    }

    public final long inputAll(long index, KeyValue<K, V>[] elements, int offset, int length) {
        throw new NotImplementedYetError();
    }

    @Override
    public final long inputAll(long index, XGettingCollection<? extends KeyValue<K, V>> elements) {
        throw new NotImplementedYetError();
    }

    @Override
    public final boolean insert(long index, KeyValue<K, V> element) {
        throw new NotImplementedYetError();
    }

    @SafeVarargs
    public final long insertAll(long index, KeyValue<K, V> ... elements) {
        throw new NotImplementedYetError();
    }

    public final long insertAll(long index, KeyValue<K, V>[] elements, int offset, int length) {
        throw new NotImplementedYetError();
    }

    @Override
    public final long insertAll(long index, XGettingCollection<? extends KeyValue<K, V>> elements) {
        throw new NotImplementedYetError();
    }

    @Override
    public final boolean prepend(KeyValue<K, V> element) {
        throw new NotImplementedYetError();
    }

    @Override
    public final boolean preput(KeyValue<K, V> element) {
        throw new NotImplementedYetError();
    }

    @Override
    public final boolean nullInput(long index) {
        throw new NotImplementedYetError();
    }

    @Override
    public final boolean nullInsert(long index) {
        throw new NotImplementedYetError();
    }

    @Override
    public final boolean nullPrepend() {
        throw new NotImplementedYetError();
    }

    @SafeVarargs
    public final EqHashTable<K, V> prependAll(KeyValue<K, V> ... elements) {
        throw new NotImplementedYetError();
    }

    public final EqHashTable<K, V> prependAll(KeyValue<K, V>[] elements, int srcStartIndex, int srcLength) {
        throw new NotImplementedYetError();
    }

    public final EqHashTable<K, V> prependAll(XGettingCollection<? extends KeyValue<K, V>> elements) {
        throw new NotImplementedYetError();
    }

    @Override
    public final boolean nullPreput() {
        throw new NotImplementedYetError();
    }

    @SafeVarargs
    public final EqHashTable<K, V> preputAll(KeyValue<K, V> ... elements) {
        throw new NotImplementedYetError();
    }

    public final EqHashTable<K, V> preputAll(KeyValue<K, V>[] elements, int offset, int length) {
        throw new NotImplementedYetError();
    }

    public final EqHashTable<K, V> preputAll(XGettingCollection<? extends KeyValue<K, V>> elements) {
        throw new NotImplementedYetError();
    }

    @Override
    public final boolean set(long index, KeyValue<K, V> element) {
        throw new NotImplementedYetError();
    }

    @Override
    public final KeyValue<K, V> setGet(long index, KeyValue<K, V> element) {
        throw new NotImplementedYetError();
    }

    @Override
    public final void setFirst(KeyValue<K, V> element) {
        throw new NotImplementedYetError();
    }

    @Override
    public final void setLast(KeyValue<K, V> element) {
        throw new NotImplementedYetError();
    }

    @SafeVarargs
    public final EqHashTable<K, V> setAll(long index, KeyValue<K, V> ... elements) {
        throw new NotImplementedYetError();
    }

    public final EqHashTable<K, V> set(long index, KeyValue<K, V>[] elements, int offset, int length) {
        throw new NotImplementedYetError();
    }

    public final EqHashTable<K, V> set(long index, XGettingSequence<? extends KeyValue<K, V>> elements, long offset, long length) {
        throw new NotImplementedYetError();
    }

    public static final <K, VK, VV> Function<K, EqHashTable<VK, VV>> supplier(final HashEqualator<VK> hashEqualator) {
        return new Function<K, EqHashTable<VK, VV>>(){

            @Override
            public final EqHashTable<VK, VV> apply(K key) {
                return EqHashTable.New(hashEqualator);
            }
        };
    }

    public static final <K, VK, VV> Function<K, EqHashTable<VK, VV>> supplier() {
        return new Function<K, EqHashTable<VK, VV>>(){

            @Override
            public final EqHashTable<VK, VV> apply(K key) {
                return EqHashTable.New();
            }
        };
    }

    public static interface Creator<K, V> {
        public EqHashTable<K, V> newInstance();
    }

    public final class Keys
    implements XTable.Keys<K, V>,
    HashCollection<K> {
        @Override
        public final int hashDistributionRange() {
            return EqHashTable.this.slots.length;
        }

        @Override
        public final boolean hasVolatileHashElements() {
            return EqHashTable.this.chain.hasVolatileElements();
        }

        @Override
        public final void setHashDensity(float hashDensity) {
            EqHashTable.this.setHashDensity(hashDensity);
        }

        @Override
        public final HashCollection.Analysis<Keys> analyze() {
            return AbstractChainEntryLinked.analyzeSlots((HashCollection)this, (AbstractChainEntryLinked[])EqHashTable.this.slots);
        }

        @Override
        public final Equalator<? super K> equality() {
            return EqHashTable.this.hashEquality();
        }

        @Override
        public final Keys copy() {
            return ((EqHashTable)EqHashTable.this.copy()).keys();
        }

        @Override
        public final EqConstHashEnum<K> immure() {
            this.consolidate();
            return EqConstHashEnum.New(EqHashTable.this.hashEquality(), EqHashTable.this.hashDensity, this);
        }

        @Override
        public final XGettingEnum<K> view() {
            return new EnumView(this);
        }

        @Override
        public final XEnum<K> range(long lowIndex, long highIndex) {
            throw new NotImplementedYetError();
        }

        @Override
        public final XGettingEnum<K> view(long lowIndex, long highIndex) {
            throw new NotImplementedYetError();
        }

        @Override
        public final K[] toArray(Class<K> type) {
            return EqHashTable.this.chain.keyToArray(type);
        }

        @Override
        public final <P extends Consumer<? super K>> P iterate(P procedure) {
            EqHashTable.this.chain.keyIterate(procedure);
            return procedure;
        }

        @Override
        public final <A> A join(BiConsumer<? super K, ? super A> joiner, A aggregate) {
            EqHashTable.this.chain.keyJoin(joiner, aggregate);
            return aggregate;
        }

        @Override
        public final long count(K element) {
            return this.contains((K)element) ? 1 : 0;
        }

        @Override
        public final long countBy(Predicate<? super K> predicate) {
            return EqHashTable.this.chain.keyCount(predicate);
        }

        @Override
        public final K seek(K sample) {
            return EqHashTable.this.chain.keySeek(sample, EqHashTable.this.hashEqualator);
        }

        @Override
        public final K search(Predicate<? super K> predicate) {
            return EqHashTable.this.chain.keySearch(predicate);
        }

        @Override
        public final K max(Comparator<? super K> comparator) {
            return EqHashTable.this.chain.keyMax(comparator);
        }

        @Override
        public final K min(Comparator<? super K> comparator) {
            return EqHashTable.this.chain.keyMin(comparator);
        }

        @Override
        public final boolean hasVolatileElements() {
            return EqHashTable.this.chain.hasVolatileElements();
        }

        @Override
        public final boolean nullAllowed() {
            return true;
        }

        @Override
        public final boolean containsSearched(Predicate<? super K> predicate) {
            return EqHashTable.this.chain.keyApplies(predicate);
        }

        @Override
        public final boolean applies(Predicate<? super K> predicate) {
            return EqHashTable.this.chain.keyAppliesAll(predicate);
        }

        @Override
        public final boolean nullContained() {
            return this.contains((K)null);
        }

        @Override
        public final boolean containsId(K element) {
            int hash = EqHashTable.this.hashEqualator.hash(element);
            ChainMapEntryLinkedHashedStrongStrong e = EqHashTable.this.slots[hash & EqHashTable.this.range];
            while (e != null) {
                if (hash == e.hash && element == e.key()) {
                    return true;
                }
                e = (ChainMapEntryLinkedHashedStrongStrong)e.link;
            }
            return false;
        }

        @Override
        public final boolean contains(K element) {
            int hash = EqHashTable.this.hashEqualator.hash(element);
            ChainMapEntryLinkedHashedStrongStrong e = EqHashTable.this.slots[hash & EqHashTable.this.range];
            while (e != null) {
                if (e.hash == hash && EqHashTable.this.hashEqualator.equal(e.key(), element)) {
                    return true;
                }
                e = (ChainMapEntryLinkedHashedStrongStrong)e.link;
            }
            return false;
        }

        @Override
        public final boolean containsAll(XGettingCollection<? extends K> elements) {
            return elements.applies(this::contains);
        }

        @Override
        public final boolean equals(XGettingCollection<? extends K> samples, Equalator<? super K> equalator) {
            if (samples == null || !(samples instanceof Keys)) {
                return false;
            }
            if (samples == this) {
                return true;
            }
            return this.equalsContent(samples, equalator);
        }

        @Override
        public final boolean equalsContent(XGettingCollection<? extends K> samples, Equalator<? super K> equalator) {
            this.consolidate();
            if (EqHashTable.this.size != XTypes.to_int(samples.size())) {
                return false;
            }
            return EqHashTable.this.chain.keyEqualsContent(samples, equalator);
        }

        @Override
        public final <C extends Consumer<? super K>> C intersect(XGettingCollection<? extends K> other, Equalator<? super K> equalator, C target) {
            return EqHashTable.this.chain.keyIntersect(other, equalator, target);
        }

        @Override
        public final <C extends Consumer<? super K>> C except(XGettingCollection<? extends K> other, Equalator<? super K> equalator, C target) {
            return EqHashTable.this.chain.keyExcept(other, equalator, target);
        }

        @Override
        public final <C extends Consumer<? super K>> C union(XGettingCollection<? extends K> other, Equalator<? super K> equalator, C target) {
            return EqHashTable.this.chain.keyUnion(other, equalator, target);
        }

        @Override
        public final <C extends Consumer<? super K>> C copyTo(C target) {
            if (target == this) {
                return target;
            }
            return EqHashTable.this.chain.keyCopyTo(target);
        }

        @Override
        public final <C extends Consumer<? super K>> C filterTo(C target, Predicate<? super K> predicate) {
            return EqHashTable.this.chain.keyCopyTo(target, predicate);
        }

        @Override
        public final <C extends Consumer<? super K>> C distinct(C target) {
            return this.distinct(target, EqHashTable.this.hashEqualator);
        }

        @Override
        public final <C extends Consumer<? super K>> C distinct(C target, Equalator<? super K> equalator) {
            if (EqHashTable.this.hashEqualator == equalator) {
                return this.copyTo(target);
            }
            return EqHashTable.this.chain.keyDistinct(target, equalator);
        }

        @Override
        public final long currentCapacity() {
            return EqHashTable.this.currentCapacity();
        }

        @Override
        public final long maximumCapacity() {
            return EqHashTable.this.maximumCapacity();
        }

        @Override
        public final boolean isFull() {
            return EqHashTable.this.isFull();
        }

        @Override
        public final long optimize() {
            return EqHashTable.this.optimize();
        }

        @Override
        public final int rehash() {
            return EqHashTable.this.rehash();
        }

        @Override
        public final Keys ensureFreeCapacity(long requiredFreeCapacity) {
            EqHashTable.this.ensureFreeCapacity(requiredFreeCapacity);
            return this;
        }

        @Override
        public final Keys ensureCapacity(long minimalCapacity) {
            EqHashTable.this.ensureCapacity(minimalCapacity);
            return this;
        }

        @Override
        public final boolean nullAdd() {
            return EqHashTable.this.nullKeyAdd();
        }

        @Override
        public final boolean add(K element) {
            return EqHashTable.this.internalAddOnlyKey(element);
        }

        @SafeVarargs
        public final Keys addAll(K ... elements) {
            EqHashTable parent = EqHashTable.this;
            int i = 0;
            int len = elements.length;
            while (i < len) {
                parent.internalAddOnlyKey(elements[i]);
                ++i;
            }
            return this;
        }

        public final Keys addAll(K[] elements, int srcIndex, int srcLength) {
            int d = XArrays.validateArrayRange(elements, srcIndex, srcLength);
            if (d == 0) {
                return this;
            }
            int bound = srcIndex + srcLength;
            EqHashTable parent = EqHashTable.this;
            int i = srcIndex;
            while (i != bound) {
                parent.internalAddOnlyKey(elements[i]);
                i += d;
            }
            return this;
        }

        public final Keys addAll(XGettingCollection<? extends K> elements) {
            elements.iterate(EqHashTable.this::internalAddOnlyKey);
            return this;
        }

        @Override
        public final boolean nullPut() {
            return EqHashTable.this.nullKeyPut();
        }

        @Override
        public final void accept(K element) {
            EqHashTable.this.internalPutOnlyKey(element);
        }

        @Override
        public final boolean put(K element) {
            return EqHashTable.this.internalPutOnlyKey(element);
        }

        @Override
        public final K addGet(K element) {
            return EqHashTable.this.internalAddGetKey(element);
        }

        @Override
        public K deduplicate(K element) {
            return EqHashTable.this.internalAddGetKey(element);
        }

        @Override
        public final K putGet(K element) {
            return EqHashTable.this.internalPutGetKey(element);
        }

        @Override
        public final K replace(K element) {
            return EqHashTable.this.internalReplaceKey(element);
        }

        @SafeVarargs
        public final Keys putAll(K ... elements) {
            EqHashTable parent = EqHashTable.this;
            int i = 0;
            int len = elements.length;
            while (i < len) {
                parent.internalPutOnlyKey(elements[i]);
                ++i;
            }
            return this;
        }

        public final Keys putAll(K[] elements, int srcIndex, int srcLength) {
            int d = XArrays.validateArrayRange(elements, srcIndex, srcLength);
            if (d == 0) {
                return this;
            }
            int bound = srcIndex + srcLength;
            EqHashTable parent = EqHashTable.this;
            int i = srcIndex;
            while (i != bound) {
                parent.internalPutOnlyKey(elements[i]);
                i += d;
            }
            return this;
        }

        public final Keys putAll(XGettingCollection<? extends K> elements) {
            elements.iterate(k -> {
                boolean bl = EqHashTable.this.put(k, null);
            });
            return this;
        }

        @Override
        public final void truncate() {
            EqHashTable.this.truncate();
        }

        @Override
        public final long consolidate() {
            return EqHashTable.this.consolidate();
        }

        @Override
        public final long remove(K element) {
            return EqHashTable.this.removeKey(element);
        }

        @Override
        public final long nullRemove() {
            return EqHashTable.this.removeKey(null);
        }

        @Override
        public final long removeBy(Predicate<? super K> predicate) {
            return EqHashTable.this.chain.keyReduce(predicate);
        }

        @Override
        public final long retainAll(XGettingCollection<? extends K> elements) {
            return EqHashTable.this.chain.keyRetainAll(elements);
        }

        @Override
        public final <P extends Consumer<? super K>> P process(P procedure) {
            EqHashTable.this.chain.keyProcess(procedure);
            return procedure;
        }

        @Override
        public final <C extends Consumer<? super K>> C moveTo(C target, Predicate<? super K> predicate) {
            EqHashTable.this.chain.keyMoveTo(target, predicate);
            return target;
        }

        @Override
        public final long removeAll(XGettingCollection<? extends K> elements) {
            int oldSize = EqHashTable.this.size;
            elements.iterate(EqHashTable.this::removeFor);
            return oldSize - EqHashTable.this.size;
        }

        @Override
        public final long removeDuplicates() {
            return 0L;
        }

        @Override
        public final long removeDuplicates(Equalator<? super K> equalator) {
            if (EqHashTable.this.hashEqualator == equalator) {
                return 0L;
            }
            return EqHashTable.this.chain.keyRemoveDuplicates(equalator);
        }

        @Override
        public final Keys toReversed() {
            Copyable reversedVarSet = EqHashTable.this.copy();
            ((EqHashTable)reversedVarSet).chain.reverse();
            return ((EqHashTable)reversedVarSet).keys;
        }

        @Override
        public final <T extends Consumer<? super K>> T copySelection(T target, long ... indices) {
            EqHashTable.this.chain.keyCopySelection(target, indices);
            return target;
        }

        @Override
        public final <P extends IndexedAcceptor<? super K>> P iterateIndexed(P procedure) {
            EqHashTable.this.chain.keyIterateIndexed(procedure);
            return procedure;
        }

        @Override
        public final K at(long index) {
            return EqHashTable.this.chain.keyGet(index);
        }

        @Override
        public final K get() {
            return EqHashTable.this.chain.keyFirst();
        }

        @Override
        public final K first() {
            return EqHashTable.this.chain.keyFirst();
        }

        @Override
        public final K last() {
            return EqHashTable.this.chain.keyLast();
        }

        @Override
        public final K poll() {
            return EqHashTable.this.size == 0 ? null : (Object)EqHashTable.this.chain.keyFirst();
        }

        @Override
        public final K peek() {
            return EqHashTable.this.size == 0 ? null : (Object)EqHashTable.this.chain.keyLast();
        }

        @Override
        public final long indexOf(K element) {
            return EqHashTable.this.chain.keyIndexOf((Object)element, this.hashEquality());
        }

        @Override
        public final long indexBy(Predicate<? super K> predicate) {
            return EqHashTable.this.chain.keyIndexBy(predicate);
        }

        @Override
        public final boolean isSorted(Comparator<? super K> comparator) {
            return EqHashTable.this.chain.keyIsSorted(comparator);
        }

        @Override
        public final long lastIndexOf(K element) {
            return EqHashTable.this.chain.keyLastIndexOf((Object)element, this.hashEquality());
        }

        @Override
        public final long lastIndexBy(Predicate<? super K> predicate) {
            return EqHashTable.this.chain.keyLastIndexBy(predicate);
        }

        @Override
        public final long maxIndex(Comparator<? super K> comparator) {
            return EqHashTable.this.chain.keyMaxIndex(comparator);
        }

        @Override
        public final long minIndex(Comparator<? super K> comparator) {
            return EqHashTable.this.chain.keyMinIndex(comparator);
        }

        @Override
        public final long scan(Predicate<? super K> predicate) {
            return EqHashTable.this.chain.keyScan(predicate);
        }

        @Override
        public final <C extends Consumer<? super K>> C moveSelection(C target, long ... indices) {
            EqHashTable.this.chain.keyMoveSelection(target, indices);
            return target;
        }

        @Override
        public final K removeAt(long index) {
            return EqHashTable.this.chain.keyRemove(index);
        }

        @Override
        public final K fetch() {
            return EqHashTable.this.chain.keyRemove(0L);
        }

        @Override
        public final K pop() {
            return EqHashTable.this.chain.keyRemove(EqHashTable.this.size - 1);
        }

        @Override
        public final K pinch() {
            return EqHashTable.this.size == 0 ? null : (Object)EqHashTable.this.chain.keyRemove(0L);
        }

        @Override
        public final K pick() {
            return EqHashTable.this.size == 0 ? null : (Object)EqHashTable.this.chain.keyRemove(EqHashTable.this.size - 1);
        }

        @Override
        public final K retrieve(K element) {
            return EqHashTable.this.chain.keyRetrieve((Object)element, this.hashEquality());
        }

        @Override
        public final K retrieveBy(Predicate<? super K> predicate) {
            return EqHashTable.this.chain.keyRetrieve(predicate);
        }

        @Override
        public final boolean removeOne(K element) {
            return EqHashTable.this.chain.keyRemoveOne((Object)element, this.hashEquality());
        }

        public final Keys removeRange(long startIndex, long length) {
            EqHashTable.this.chain.removeRange(startIndex, length);
            return this;
        }

        public final Keys retainRange(long startIndex, long length) {
            EqHashTable.this.chain.retainRange(startIndex, length);
            return this;
        }

        @Override
        public final long removeSelection(long[] indices) {
            return EqHashTable.this.chain.removeSelection(indices);
        }

        @Override
        public final boolean isEmpty() {
            return EqHashTable.this.isEmpty();
        }

        @Override
        public final Iterator<K> iterator() {
            return EqHashTable.this.chain.keyIterator();
        }

        @Override
        public final long size() {
            return EqHashTable.this.size;
        }

        public final String toString() {
            if (EqHashTable.this.size == 0) {
                return "[]";
            }
            VarString vc = VarString.New(EqHashTable.this.slots.length).append('[');
            EqHashTable.this.chain.keyAppendTo(vc, ',').append(']');
            return vc.toString();
        }

        @Override
        public final Object[] toArray() {
            return EqHashTable.this.chain.keyToArray();
        }

        @Override
        public final void clear() {
            EqHashTable.this.clear();
        }

        @Override
        public final Keys reverse() {
            EqHashTable.this.chain.reverse();
            return this;
        }

        public final Keys sort(Comparator<? super K> comparator) {
            EqHashTable.this.chain.keySort(comparator);
            return this;
        }

        @Override
        public final Keys shiftTo(long sourceIndex, long targetIndex) {
            EqHashTable.this.chain.shiftTo(sourceIndex, targetIndex);
            return this;
        }

        @Override
        public final Keys shiftTo(long sourceIndex, long targetIndex, long length) {
            EqHashTable.this.chain.shiftTo(sourceIndex, targetIndex, length);
            return this;
        }

        @Override
        public final Keys shiftBy(long sourceIndex, long distance) {
            EqHashTable.this.chain.shiftTo(sourceIndex, distance);
            return this;
        }

        @Override
        public final Keys shiftBy(long sourceIndex, long distance, long length) {
            EqHashTable.this.chain.shiftTo(sourceIndex, distance, length);
            return this;
        }

        @Override
        public final Keys swap(long indexA, long indexB) {
            EqHashTable.this.chain.swap(indexA, indexB);
            return this;
        }

        @Override
        public final Keys swap(long indexA, long indexB, long length) {
            EqHashTable.this.chain.swap(indexA, indexB, length);
            return this;
        }

        public final org.eclipse.serializer.collections.EqHashTable$Keys.OldKeys old() {
            return new OldKeys();
        }

        @Override
        public final EqHashTable<K, V> parent() {
            return EqHashTable.this;
        }

        @Override
        public final HashEqualator<? super K> hashEquality() {
            return EqHashTable.this.hashEquality();
        }

        @Override
        public final float hashDensity() {
            return EqHashTable.this.hashDensity();
        }

        @Override
        public final boolean input(long index, K element) {
            throw new NotImplementedYetError();
        }

        @Override
        @SafeVarargs
        public final long inputAll(long index, K ... elements) {
            throw new NotImplementedYetError();
        }

        @Override
        public final long inputAll(long index, K[] elements, int offset, int length) {
            throw new NotImplementedYetError();
        }

        @Override
        public final long inputAll(long index, XGettingCollection<? extends K> elements) {
            throw new NotImplementedYetError();
        }

        @Override
        public final boolean insert(long index, K element) {
            throw new NotImplementedYetError();
        }

        @Override
        @SafeVarargs
        public final long insertAll(long index, K ... elements) {
            throw new NotImplementedYetError();
        }

        @Override
        public final long insertAll(long index, K[] elements, int offset, int length) {
            throw new NotImplementedYetError();
        }

        @Override
        public final long insertAll(long index, XGettingCollection<? extends K> elements) {
            throw new NotImplementedYetError();
        }

        @Override
        public final boolean prepend(K element) {
            throw new NotImplementedYetError();
        }

        @Override
        public final boolean preput(K element) {
            throw new NotImplementedYetError();
        }

        @Override
        public final boolean nullInput(long index) {
            throw new NotImplementedYetError();
        }

        @Override
        public final boolean nullInsert(long index) {
            throw new NotImplementedYetError();
        }

        @Override
        public final boolean nullPrepend() {
            throw new NotImplementedYetError();
        }

        public final Keys prependAll(K ... elements) {
            throw new NotImplementedYetError();
        }

        public final Keys prependAll(K[] elements, int srcStartIndex, int srcLength) {
            throw new NotImplementedYetError();
        }

        public final Keys prependAll(XGettingCollection<? extends K> elements) {
            throw new NotImplementedYetError();
        }

        @Override
        public final boolean nullPreput() {
            throw new NotImplementedYetError();
        }

        @SafeVarargs
        public final Keys preputAll(K ... elements) {
            throw new NotImplementedYetError();
        }

        public final Keys preputAll(K[] elements, int offset, int length) {
            throw new NotImplementedYetError();
        }

        public final Keys preputAll(XGettingCollection<? extends K> elements) {
            throw new NotImplementedYetError();
        }

        @Override
        public final boolean set(long index, K element) {
            throw new NotImplementedYetError();
        }

        @Override
        public final K setGet(long index, K element) {
            throw new NotImplementedYetError();
        }

        @Override
        public final void setFirst(K element) {
            throw new NotImplementedYetError();
        }

        @Override
        public final void setLast(K element) {
            throw new NotImplementedYetError();
        }

        @SafeVarargs
        public final Keys setAll(long index, K ... elements) {
            throw new NotImplementedYetError();
        }

        public final Keys set(long index, K[] elements, int offset, int length) {
            throw new NotImplementedYetError();
        }

        public final Keys set(long index, XGettingSequence<? extends K> elements, long offset, long length) {
            throw new NotImplementedYetError();
        }

        @Override
        public long substitute(Function<? super K, ? extends K> mapper) {
            return EqHashTable.this.chain.keySubstitute(mapper, EqHashTable.this::replace);
        }

        public final class OldKeys
        extends AbstractBridgeXSet<K> {
            protected OldKeys() {
                super(Keys.this);
            }

            @Override
            public final Keys parent() {
                return (Keys)super.parent();
            }
        }
    }

    public final class OldVarMap
    implements XTable.Bridge<K, V> {
        @Override
        public final void clear() {
            EqHashTable.this.clear();
        }

        @Override
        public final boolean containsKey(Object key) {
            try {
                return EqHashTable.this.containsKey(key);
            }
            catch (Exception e) {
                return false;
            }
        }

        @Override
        public final boolean containsValue(Object value) {
            try {
                return EqHashTable.this.chain.valuesContains(value);
            }
            catch (Exception e) {
                return false;
            }
        }

        @Override
        public final Set<Map.Entry<K, V>> entrySet() {
            return (Set)((Object)EqHashTable.this.old());
        }

        @Override
        public final V get(Object key) {
            try {
                return EqHashTable.this.get(key);
            }
            catch (Exception e) {
                return null;
            }
        }

        @Override
        public final boolean isEmpty() {
            return EqHashTable.this.isEmpty();
        }

        @Override
        public final Set<K> keySet() {
            return EqHashTable.this.keys().old();
        }

        @Override
        public final V put(K key, V value) {
            return EqHashTable.this.oldPutGet(key, value);
        }

        @Override
        public final void putAll(Map<? extends K, ? extends V> m) {
            if (m instanceof XGettingMap.Bridge) {
                EqHashTable.this.addAll((XGettingCollection)((XGettingMap.Bridge)m).parent());
                return;
            }
            EqHashTable parent = EqHashTable.this;
            for (Map.Entry entry : m.entrySet()) {
                parent.put(entry.getKey(), entry.getValue());
            }
        }

        @Override
        public final V remove(Object key) {
            try {
                return EqHashTable.this.removeFor(key);
            }
            catch (Exception e) {
                return null;
            }
        }

        @Override
        public final int size() {
            return XTypes.to_int(EqHashTable.this.size());
        }

        @Override
        public final Collection<V> values() {
            return EqHashTable.this.values.old();
        }

        @Override
        public final EqHashTable<K, V> parent() {
            return EqHashTable.this;
        }
    }

    public final class Values
    implements XTable.Values<K, V> {
        @Override
        public final Equalator<? super V> equality() {
            return Equalator.identity();
        }

        @Override
        public final XList<V> copy() {
            return new BulkList(XTypes.to_int(EqHashTable.this.size())).addAll((XGettingCollection)this);
        }

        @Override
        public final <P extends Consumer<? super V>> P iterate(P procedure) {
            EqHashTable.this.chain.valuesIterate(procedure);
            return procedure;
        }

        @Override
        public final <A> A join(BiConsumer<? super V, ? super A> joiner, A aggregate) {
            EqHashTable.this.chain.valuesJoin(joiner, aggregate);
            return aggregate;
        }

        @Override
        public final <P extends IndexedAcceptor<? super V>> P iterateIndexed(P procedure) {
            EqHashTable.this.chain.valuesIterateIndexed(procedure);
            return procedure;
        }

        @Override
        public final Values toReversed() {
            Copyable reversedVarSet = EqHashTable.this.copy();
            ((EqHashTable)reversedVarSet).chain.reverse();
            return ((EqHashTable)reversedVarSet).values;
        }

        @Override
        public final boolean containsSearched(Predicate<? super V> predicate) {
            return EqHashTable.this.chain.valuesApplies(predicate);
        }

        @Override
        public final boolean applies(Predicate<? super V> predicate) {
            return EqHashTable.this.chain.valuesAppliesAll(predicate);
        }

        @Override
        public final boolean contains(V value) {
            return EqHashTable.this.chain.valuesContains(value);
        }

        @Override
        public final boolean containsAll(XGettingCollection<? extends V> values) {
            return EqHashTable.this.chain.valuesContainsAll(values);
        }

        @Override
        public final boolean containsId(V value) {
            return EqHashTable.this.chain.valuesContainsId(value);
        }

        @Override
        public final <T extends Consumer<? super V>> T copyTo(T target) {
            EqHashTable.this.chain.valuesCopyTo(target);
            return target;
        }

        @Override
        public final <T extends Consumer<? super V>> T filterTo(T target, Predicate<? super V> predicate) {
            EqHashTable.this.chain.valuesCopyTo(target, predicate);
            return target;
        }

        @Override
        public final long count(V value) {
            return EqHashTable.this.chain.valuesCount(value);
        }

        @Override
        public final long countBy(Predicate<? super V> predicate) {
            return EqHashTable.this.chain.valuesCount(predicate);
        }

        @Override
        public final <T extends Consumer<? super V>> T distinct(T target) {
            EqHashTable.this.chain.valuesDistinct(target);
            return target;
        }

        @Override
        public final <T extends Consumer<? super V>> T distinct(T target, Equalator<? super V> equalator) {
            EqHashTable.this.chain.valuesDistinct(target, equalator);
            return target;
        }

        @Override
        public final boolean equals(XGettingCollection<? extends V> samples, Equalator<? super V> equalator) {
            if (samples == null || !(samples instanceof EqHashEnum)) {
                return false;
            }
            if (samples == this) {
                return true;
            }
            return this.equalsContent(samples, equalator);
        }

        @Override
        public final boolean equalsContent(XGettingCollection<? extends V> samples, Equalator<? super V> equalator) {
            return EqHashTable.this.chain.valuesEqualsContent(samples, equalator);
        }

        @Override
        public final <T extends Consumer<? super V>> T except(XGettingCollection<? extends V> other, Equalator<? super V> equalator, T target) {
            EqHashTable.this.chain.valuesExcept(other, equalator, target);
            return target;
        }

        @Override
        public final boolean hasVolatileElements() {
            return EqHashTable.this.hasVolatileValues();
        }

        @Override
        public final <T extends Consumer<? super V>> T intersect(XGettingCollection<? extends V> other, Equalator<? super V> equalator, T target) {
            EqHashTable.this.chain.valuesIntersect(other, equalator, target);
            return target;
        }

        @Override
        public final boolean isEmpty() {
            return EqHashTable.this.isEmpty();
        }

        @Override
        public final Iterator<V> iterator() {
            return EqHashTable.this.chain.valuesIterator();
        }

        @Override
        public final V max(Comparator<? super V> comparator) {
            return EqHashTable.this.chain.valuesMax(comparator);
        }

        @Override
        public final V min(Comparator<? super V> comparator) {
            return EqHashTable.this.chain.valuesMin(comparator);
        }

        @Override
        public final boolean nullAllowed() {
            return EqHashTable.this.nullAllowed();
        }

        @Override
        public final boolean nullContained() {
            return EqHashTable.this.chain.valuesContains(null);
        }

        public final org.eclipse.serializer.collections.EqHashTable$Values.OldValues old() {
            return new OldValues();
        }

        @Override
        public final V seek(V sample) {
            return EqHashTable.this.chain.valuesSeek(sample);
        }

        @Override
        public final V search(Predicate<? super V> predicate) {
            return EqHashTable.this.chain.valuesSearch(predicate);
        }

        @Override
        public final long size() {
            return XTypes.to_int(EqHashTable.this.size());
        }

        @Override
        public final long maximumCapacity() {
            return XTypes.to_int(EqHashTable.this.size());
        }

        @Override
        public final boolean isFull() {
            return EqHashTable.this.isFull();
        }

        @Override
        public final long remainingCapacity() {
            return EqHashTable.this.remainingCapacity();
        }

        public final String toString() {
            if (EqHashTable.this.size == 0) {
                return "[]";
            }
            VarString vc = VarString.New(EqHashTable.this.slots.length).append('[');
            EqHashTable.this.chain.valuesAppendTo(vc, ',').append(']');
            return vc.toString();
        }

        @Override
        public final Object[] toArray() {
            return EqHashTable.this.chain.valuesToArray();
        }

        @Override
        public final V[] toArray(Class<V> type) {
            return EqHashTable.this.chain.valuesToArray(type);
        }

        @Override
        public final <T extends Consumer<? super V>> T union(XGettingCollection<? extends V> other, Equalator<? super V> equalator, T target) {
            EqHashTable.this.chain.valuesUnion(other, equalator, target);
            return target;
        }

        @Override
        public final EqHashTable<K, V> parent() {
            return EqHashTable.this;
        }

        @Override
        public final SubListView<V> view(long fromIndex, long toIndex) {
            return new SubListView(this, fromIndex, toIndex);
        }

        @Override
        public final ListIterator<V> listIterator() {
            return EqHashTable.this.chain.valuesListIterator(0L);
        }

        @Override
        public final ListIterator<V> listIterator(long index) {
            return EqHashTable.this.chain.valuesListIterator(index);
        }

        @Override
        public final SubListProcessor<V> range(long fromIndex, long toIndex) {
            return new SubListProcessor(this, fromIndex, toIndex);
        }

        @Override
        public final XImmutableList<V> immure() {
            return ConstList.New(this);
        }

        @Override
        public final ListView<V> view() {
            return new ListView(this);
        }

        @Override
        public final <T extends Consumer<? super V>> T copySelection(T target, long ... indices) {
            EqHashTable.this.chain.valuesCopySelection(target, indices);
            return target;
        }

        @Override
        public final V at(long index) {
            return EqHashTable.this.chain.valuesGet(index);
        }

        @Override
        public final V get() {
            return EqHashTable.this.chain.valuesFirst();
        }

        @Override
        public final V first() {
            return EqHashTable.this.chain.valuesFirst();
        }

        @Override
        public final V last() {
            return EqHashTable.this.chain.valuesLast();
        }

        @Override
        public final V poll() {
            return EqHashTable.this.size == 0 ? null : (Object)EqHashTable.this.chain.valuesFirst();
        }

        @Override
        public final V peek() {
            return EqHashTable.this.size == 0 ? null : (Object)EqHashTable.this.chain.valuesLast();
        }

        @Override
        public final long indexOf(V value) {
            return EqHashTable.this.chain.valuesIndexOf(value);
        }

        @Override
        public final long indexBy(Predicate<? super V> predicate) {
            return EqHashTable.this.chain.valuesIndexBy(predicate);
        }

        @Override
        public final boolean isSorted(Comparator<? super V> comparator) {
            return EqHashTable.this.chain.valuesIsSorted(comparator);
        }

        @Override
        public final long lastIndexOf(V value) {
            return EqHashTable.this.chain.valuesLastIndexOf(value);
        }

        @Override
        public final long lastIndexBy(Predicate<? super V> predicate) {
            return EqHashTable.this.chain.valuesLastIndexBy(predicate);
        }

        @Override
        public final long maxIndex(Comparator<? super V> comparator) {
            return EqHashTable.this.chain.valuesMaxIndex(comparator);
        }

        @Override
        public final long minIndex(Comparator<? super V> comparator) {
            return EqHashTable.this.chain.valuesMinIndex(comparator);
        }

        @Override
        public final long scan(Predicate<? super V> predicate) {
            return EqHashTable.this.chain.valuesScan(predicate);
        }

        @Override
        public final <C extends Consumer<? super V>> C moveSelection(C target, long ... indices) {
            EqHashTable.this.chain.valuesMoveSelection(target, indices);
            return target;
        }

        @Override
        public final V removeAt(long index) {
            return EqHashTable.this.chain.valuesRemove(index);
        }

        @Override
        public final V fetch() {
            return EqHashTable.this.chain.valuesRemove(0L);
        }

        @Override
        public final V pop() {
            return EqHashTable.this.chain.valuesRemove(EqHashTable.this.size - 1);
        }

        @Override
        public final V pinch() {
            return EqHashTable.this.size == 0 ? null : (Object)EqHashTable.this.chain.valuesRemove(0L);
        }

        @Override
        public final V pick() {
            return EqHashTable.this.size == 0 ? null : (Object)EqHashTable.this.chain.valuesRemove(EqHashTable.this.size - 1);
        }

        @Override
        public final V retrieve(V value) {
            return EqHashTable.this.chain.valuesRetrieve(value);
        }

        @Override
        public final V retrieveBy(Predicate<? super V> predicate) {
            return EqHashTable.this.chain.valuesRetrieve(predicate);
        }

        @Override
        public final boolean removeOne(V element) {
            return EqHashTable.this.chain.valuesRemoveOne(element);
        }

        public final Values removeRange(long startIndex, long length) {
            EqHashTable.this.chain.removeRange(startIndex, length);
            return this;
        }

        public final Values retainRange(long startIndex, long length) {
            EqHashTable.this.chain.retainRange(startIndex, length);
            return this;
        }

        @Override
        public final long removeSelection(long[] indices) {
            return EqHashTable.this.chain.removeSelection(indices);
        }

        @Override
        public final void clear() {
            EqHashTable.this.clear();
        }

        @Override
        public final long consolidate() {
            return EqHashTable.this.consolidate();
        }

        @Override
        public final <C extends Consumer<? super V>> C moveTo(C target, Predicate<? super V> predicate) {
            EqHashTable.this.chain.valuesMoveTo(target, predicate);
            return target;
        }

        @Override
        public final long nullRemove() {
            return EqHashTable.this.chain.valuesRemove(null);
        }

        @Override
        public final long optimize() {
            return EqHashTable.this.optimize();
        }

        @Override
        public final <P extends Consumer<? super V>> P process(P procedure) {
            EqHashTable.this.chain.valuesProcess(procedure);
            return procedure;
        }

        @Override
        public final long removeBy(Predicate<? super V> predicate) {
            return EqHashTable.this.chain.valuesReduce(predicate);
        }

        @Override
        public final long remove(V value) {
            return EqHashTable.this.chain.valuesRemove(value);
        }

        @Override
        public final long removeAll(XGettingCollection<? extends V> values) {
            return EqHashTable.this.chain.valuesRemoveAll(values);
        }

        @Override
        public final long removeDuplicates() {
            return EqHashTable.this.chain.valuesRemoveDuplicates();
        }

        @Override
        public final long removeDuplicates(Equalator<? super V> equalator) {
            return EqHashTable.this.chain.valuesRemoveDuplicates(equalator);
        }

        @Override
        public final long retainAll(XGettingCollection<? extends V> values) {
            return EqHashTable.this.chain.valuesRetainAll(values);
        }

        @Override
        public final void truncate() {
            EqHashTable.this.truncate();
        }

        public final Values fill(long offset, long length, V value) {
            EqHashTable.this.chain.valuesFill(offset, length, value);
            return this;
        }

        @Override
        public final long replace(V value, V replacement) {
            return EqHashTable.this.chain.valuesReplace(value, replacement);
        }

        @Override
        public final long replaceAll(XGettingCollection<? extends V> values, V replacement) {
            return EqHashTable.this.chain.valuesReplaceAll(values, (Object)replacement);
        }

        @Override
        public final long substitute(Function<? super V, ? extends V> mapper) {
            return EqHashTable.this.chain.valuesSubstitute(mapper);
        }

        @Override
        public final long substitute(Predicate<? super V> predicate, Function<V, V> mapper) {
            return EqHashTable.this.chain.valuesSubstitute((Predicate)predicate, mapper);
        }

        @Override
        public final boolean replaceOne(V value, V replacement) {
            return EqHashTable.this.chain.valuesReplaceOne(value, replacement);
        }

        @Override
        public final Values reverse() {
            EqHashTable.this.chain.reverse();
            return this;
        }

        @Override
        public final boolean set(long index, V value) {
            return EqHashTable.this.chain.valuesSet(index, value) == value;
        }

        @Override
        public final V setGet(long index, V value) {
            return EqHashTable.this.chain.valuesSet(index, value);
        }

        public final Values setAll(long offset, V ... values) {
            EqHashTable.this.chain.valuesSet(offset, values);
            return this;
        }

        public final Values set(long offset, V[] src, int srcIndex, int srcLength) {
            EqHashTable.this.chain.valuesSet(offset, src, srcIndex, srcLength);
            return this;
        }

        public final Values set(long offset, XGettingSequence<? extends V> values, long valuesOffset, long valuesLength) {
            throw new NotImplementedYetError();
        }

        @Override
        public final void setFirst(V value) {
            EqHashTable.this.chain.valuesSet(0L, value);
        }

        @Override
        public final void setLast(V value) {
            EqHashTable.this.chain.valuesSet((long)(EqHashTable.this.size - 1), value);
        }

        public final Values sort(Comparator<? super V> comparator) {
            EqHashTable.this.chain.valuesSort(comparator);
            return this;
        }

        @Override
        public final long replace(Predicate<? super V> predicate, V substitute) {
            return EqHashTable.this.chain.valuesSubstitute(predicate, (Object)substitute);
        }

        @Override
        public final boolean replaceOne(Predicate<? super V> predicate, V substitute) {
            return EqHashTable.this.chain.valuesSubstituteOne(predicate, (Object)substitute);
        }

        @Override
        public final Values shiftTo(long sourceIndex, long targetIndex) {
            EqHashTable.this.chain.shiftTo(sourceIndex, targetIndex);
            return this;
        }

        @Override
        public final Values shiftTo(long sourceIndex, long targetIndex, long length) {
            EqHashTable.this.chain.shiftTo(sourceIndex, targetIndex, length);
            return this;
        }

        @Override
        public final Values shiftBy(long sourceIndex, long distance) {
            EqHashTable.this.chain.shiftTo(sourceIndex, distance);
            return this;
        }

        @Override
        public final Values shiftBy(long sourceIndex, long distance, long length) {
            EqHashTable.this.chain.shiftTo(sourceIndex, distance, length);
            return this;
        }

        @Override
        public final Values swap(long indexA, long indexB) {
            EqHashTable.this.chain.swap(indexA, indexB);
            return this;
        }

        @Override
        public final Values swap(long indexA, long indexB, long length) {
            EqHashTable.this.chain.swap(indexA, indexB, length);
            return this;
        }

        public final class OldValues
        extends AbstractOldSettingList<V> {
            protected OldValues() {
                super(Values.this);
            }

            @Override
            public final Values parent() {
                return (Values)super.parent();
            }
        }
    }
}

