/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.serializer.collections;

import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.ListIterator;
import java.util.Map;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import org.eclipse.serializer.chars.VarString;
import org.eclipse.serializer.collections.AbstractChainEntryLinked;
import org.eclipse.serializer.collections.AbstractChainKeyValueCollection;
import org.eclipse.serializer.collections.AbstractChainKeyValueStorage;
import org.eclipse.serializer.collections.ArrayView;
import org.eclipse.serializer.collections.ChainMapEntryLinkedHashedStrongStrong;
import org.eclipse.serializer.collections.ChainStrongStrongStorage;
import org.eclipse.serializer.collections.ConstList;
import org.eclipse.serializer.collections.EnumView;
import org.eclipse.serializer.collections.EqHashEnum;
import org.eclipse.serializer.collections.TableView;
import org.eclipse.serializer.collections.interfaces.HashCollection;
import org.eclipse.serializer.collections.old.OldCollection;
import org.eclipse.serializer.collections.old.OldList;
import org.eclipse.serializer.collections.types.XEnum;
import org.eclipse.serializer.collections.types.XGettingCollection;
import org.eclipse.serializer.collections.types.XGettingEnum;
import org.eclipse.serializer.collections.types.XGettingTable;
import org.eclipse.serializer.collections.types.XImmutableList;
import org.eclipse.serializer.collections.types.XImmutableTable;
import org.eclipse.serializer.collections.types.XIterable;
import org.eclipse.serializer.equality.Equalator;
import org.eclipse.serializer.functional.IndexedAcceptor;
import org.eclipse.serializer.hashing.HashEqualator;
import org.eclipse.serializer.hashing.XHashing;
import org.eclipse.serializer.meta.NotImplementedYetError;
import org.eclipse.serializer.typing.Composition;
import org.eclipse.serializer.typing.Copyable;
import org.eclipse.serializer.typing.KeyValue;
import org.eclipse.serializer.typing.XTypes;
import org.eclipse.serializer.util.X;

public final class EqConstHashTable<K, V>
extends AbstractChainKeyValueCollection<K, V, ChainMapEntryLinkedHashedStrongStrong<K, V>>
implements XImmutableTable<K, V>,
HashCollection<K>,
Composition {
    final AbstractChainKeyValueStorage<K, V, ChainMapEntryLinkedHashedStrongStrong<K, V>> chain;
    ChainMapEntryLinkedHashedStrongStrong<K, V>[] slots;
    final HashEqualator<? super K> hashEqualator;
    float hashDensity;
    int capacity;
    int range;
    int size;
    final Values values = new Values();
    final Keys keys = new Keys();

    public static final <K, V> EqConstHashTable<K, V> New() {
        return new EqConstHashTable(1, 1.0f, XHashing.hashEqualityValue());
    }

    public static final <K, V> EqConstHashTable<K, V> NewCustom(int initialHashLength) {
        return new EqConstHashTable(XHashing.padHashLength(initialHashLength), 1.0f, XHashing.hashEqualityValue());
    }

    public static final <K, V> EqConstHashTable<K, V> NewCustom(float hashDensity) {
        return new EqConstHashTable(1, XHashing.validateHashDensity(hashDensity), XHashing.hashEqualityValue());
    }

    public static final <K, V> EqConstHashTable<K, V> NewCustom(int initialHashLength, float hashDensity) {
        return new EqConstHashTable(XHashing.padHashLength(initialHashLength), XHashing.validateHashDensity(hashDensity), XHashing.hashEqualityValue());
    }

    public static final <K, V> EqConstHashTable<K, V> New(XGettingCollection<? extends KeyValue<? extends K, ? extends V>> entries) {
        return new EqConstHashTable(1, 1.0f, XHashing.hashEqualityValue()).internalAddEntries(entries);
    }

    public static final <V0, K, V> EqConstHashTable<K, V> New(XGettingCollection<? extends KeyValue<? extends K, ? extends V0>> entries, Function<? super V0, V> mapper) {
        return new EqConstHashTable(1, 1.0f, XHashing.hashEqualityValue()).internalAddEntries(entries, mapper);
    }

    public static final <K, V> EqConstHashTable<K, V> NewCustom(int initialHashLength, float hashDensity, XGettingCollection<? extends KeyValue<? extends K, ? extends V>> entries) {
        return new EqConstHashTable(XHashing.padHashLength(initialHashLength), XHashing.validateHashDensity(hashDensity), XHashing.hashEqualityValue()).internalAddEntries(entries);
    }

    public static final <K, V> EqConstHashTable<K, V> NewSingle(K key, V value) {
        EqConstHashTable<K, V> instance = EqConstHashTable.New();
        instance.internalAdd(key, value);
        return instance;
    }

    @SafeVarargs
    public static final <K, V> EqConstHashTable<K, V> New(KeyValue<? extends K, ? extends V> ... entries) {
        return new EqConstHashTable(1, 1.0f, XHashing.hashEqualityValue()).internalAddEntries(new ArrayView<KeyValue<? extends K, ? extends V>>(entries));
    }

    @SafeVarargs
    public static final <K, V> EqConstHashTable<K, V> NewCustom(int initialHashLength, float hashDensity, KeyValue<? extends K, ? extends V> ... entries) {
        return new EqConstHashTable(XHashing.padHashLength(initialHashLength), XHashing.validateHashDensity(hashDensity), XHashing.hashEqualityValue()).internalAddEntries(new ArrayView<KeyValue<? extends K, ? extends V>>(entries));
    }

    public static final <K, V> EqConstHashTable<K, V> New(HashEqualator<? super K> hashEqualator) {
        return new EqConstHashTable<K, V>(1, 1.0f, X.notNull(hashEqualator));
    }

    public static final <K, V> EqConstHashTable<K, V> NewCustom(HashEqualator<? super K> hashEqualator, int initialHashLength) {
        return new EqConstHashTable<K, V>(XHashing.padHashLength(initialHashLength), 1.0f, X.notNull(hashEqualator));
    }

    public static final <K, V> EqConstHashTable<K, V> NewCustom(HashEqualator<? super K> hashEqualator, float hashDensity) {
        return new EqConstHashTable<K, V>(1, XHashing.validateHashDensity(hashDensity), X.notNull(hashEqualator));
    }

    public static final <K, V> EqConstHashTable<K, V> NewCustom(HashEqualator<? super K> hashEqualator, int initialHashLength, float hashDensity) {
        return new EqConstHashTable<K, V>(XHashing.padHashLength(initialHashLength), XHashing.validateHashDensity(hashDensity), X.notNull(hashEqualator));
    }

    public static final <K, V> EqConstHashTable<K, V> New(HashEqualator<? super K> hashEqualator, XGettingCollection<? extends KeyValue<? extends K, ? extends V>> entries) {
        return new EqConstHashTable<K, V>(1, 1.0f, X.notNull(hashEqualator)).internalAddEntries(entries);
    }

    public static final <K, V> EqConstHashTable<K, V> NewCustom(HashEqualator<? super K> hashEqualator, int initialHashLength, float hashDensity, XGettingCollection<? extends KeyValue<? extends K, ? extends V>> entries) {
        return new EqConstHashTable<K, V>(XHashing.padHashLength(initialHashLength), XHashing.validateHashDensity(hashDensity), X.notNull(hashEqualator)).internalAddEntries(entries);
    }

    @SafeVarargs
    public static final <K, V> EqConstHashTable<K, V> New(HashEqualator<? super K> hashEqualator, KeyValue<? extends K, ? extends V> ... entries) {
        return new EqConstHashTable<K, V>(1, 1.0f, X.notNull(hashEqualator)).internalAddEntries(new ArrayView<KeyValue<? extends K, ? extends V>>(entries));
    }

    @SafeVarargs
    public static final <K, V> EqConstHashTable<K, V> NewCustom(HashEqualator<? super K> hashEqualator, int initialHashLength, float hashDensity, KeyValue<? extends K, ? extends V> ... entries) {
        return new EqConstHashTable<K, V>(XHashing.padHashLength(initialHashLength), XHashing.validateHashDensity(hashDensity), X.notNull(hashEqualator)).internalAddEntries(new ArrayView<KeyValue<? extends K, ? extends V>>(entries));
    }

    public static final <K, V, K1, V1> EqConstHashTable<K1, V1> NewProjected(float hashDensity, XGettingCollection<? extends KeyValue<K, V>> entries, final Function<? super K, K1> keyProjector, final Function<? super V, V1> valueProjector) {
        final EqConstHashTable newMap = new EqConstHashTable(1, XHashing.validateHashDensity(hashDensity), XHashing.hashEqualityValue());
        entries.iterate(new Consumer<KeyValue<K, V>>(){

            @Override
            public void accept(KeyValue<K, V> e) {
                newMap.internalAdd(keyProjector.apply(e.key()), valueProjector.apply(e.value()));
            }
        });
        return newMap;
    }

    public static final <K, V, K1, V1> EqConstHashTable<K1, V1> NewProjected(XGettingCollection<? extends KeyValue<K, V>> entries, Function<? super K, K1> keyProjector, Function<? super V, V1> valueProjector) {
        return EqConstHashTable.NewProjected(entries instanceof HashCollection ? ((HashCollection)((Object)entries)).hashDensity() : 1.0f, entries, keyProjector, valueProjector);
    }

    private EqConstHashTable(EqConstHashTable<K, V> original) {
        this.hashDensity = original.hashDensity;
        this.hashEqualator = original.hashEqualator;
        this.range = original.range;
        this.slots = ChainMapEntryLinkedHashedStrongStrong.array(original.slots.length);
        this.chain = new ChainStrongStrongStorage(this, new ChainMapEntryLinkedHashedStrongStrong<Object, Object>(-1, null, null, null));
        this.capacity = original.capacity;
    }

    private EqConstHashTable(int pow2InitialHashLength, float positiveHashDensity, HashEqualator<? super K> hashEqualator) {
        this.hashDensity = positiveHashDensity;
        this.hashEqualator = hashEqualator;
        this.range = pow2InitialHashLength - 1;
        this.slots = ChainMapEntryLinkedHashedStrongStrong.array(pow2InitialHashLength);
        this.chain = new ChainStrongStrongStorage(this, new ChainMapEntryLinkedHashedStrongStrong<Object, Object>(-1, null, null, null));
        this.capacity = (int)((float)pow2InitialHashLength * positiveHashDensity);
    }

    private ChainMapEntryLinkedHashedStrongStrong<K, V> createNewEntry(int hash, K key, V value) {
        if (this.size >= this.capacity) {
            EqConstHashTable.ensureFreeArrayCapacity(this.size);
            this.increaseStorage();
        }
        ChainMapEntryLinkedHashedStrongStrong<K, V> e = new ChainMapEntryLinkedHashedStrongStrong<K, V>(hash, key, value, this.slots[hash & this.range]);
        this.slots[hash & this.range] = e;
        ++this.size;
        return e;
    }

    private void increaseStorage() {
        this.rebuildStorage((int)((float)this.slots.length * 2.0f));
    }

    private void rebuildStorage(int newSlotLength) {
        ChainMapEntryLinkedHashedStrongStrong<K, V>[] newSlots = ChainMapEntryLinkedHashedStrongStrong.array(newSlotLength);
        int modulo = newSlotLength >= Integer.MAX_VALUE ? Integer.MAX_VALUE : newSlotLength - 1;
        ChainMapEntryLinkedHashedStrongStrong entry = (ChainMapEntryLinkedHashedStrongStrong)this.chain.head();
        while ((entry = (ChainMapEntryLinkedHashedStrongStrong)entry.next) != null) {
            entry.link = newSlots[entry.hash & modulo];
            newSlots[entry.hash & modulo] = entry;
        }
        this.capacity = newSlotLength >= Integer.MAX_VALUE ? Integer.MAX_VALUE : (int)((float)newSlotLength * this.hashDensity);
        this.slots = newSlots;
        this.range = modulo;
    }

    @Override
    public final KeyValue<K, V> lookup(K key) {
        int hash = this.hashEqualator.hash(key);
        ChainMapEntryLinkedHashedStrongStrong e = this.slots[hash & this.range];
        while (e != null) {
            if (e.hash == hash && this.hashEqualator.equal(e.key(), key)) {
                return e;
            }
            e = (ChainMapEntryLinkedHashedStrongStrong)e.link;
        }
        return null;
    }

    final boolean containsKey(K key) {
        int hash = this.hashEqualator.hash(key);
        ChainMapEntryLinkedHashedStrongStrong e = this.slots[hash & this.range];
        while (e != null) {
            if (e.hash == hash && this.hashEqualator.equal(e.key(), key)) {
                return true;
            }
            e = (ChainMapEntryLinkedHashedStrongStrong)e.link;
        }
        return false;
    }

    final void internalAdd(K key, V value) {
        int hash = this.hashEqualator.hash(key);
        ChainMapEntryLinkedHashedStrongStrong e = this.slots[hash & this.range];
        while (e != null) {
            if (e.hash == hash && this.hashEqualator.equal(e.key(), key)) {
                return;
            }
            e = (ChainMapEntryLinkedHashedStrongStrong)e.link;
        }
        this.chain.appendEntry(this.createNewEntry(hash, key, value));
    }

    final EqConstHashTable<K, V> internalAddEntries(XGettingCollection<? extends KeyValue<? extends K, ? extends V>> entries) {
        entries.iterate(kv -> this.internalAdd(kv.key(), kv.value()));
        return this;
    }

    final <V0> EqConstHashTable<K, V> internalAddEntries(XGettingCollection<? extends KeyValue<? extends K, ? extends V0>> entries, Function<? super V0, V> mapper) {
        entries.iterate(kv -> this.internalAdd(kv.key(), mapper.apply((Object)kv.value())));
        return this;
    }

    final void internalCollectUnhashed(K key, V value) {
        this.chain.appendEntry(new ChainMapEntryLinkedHashedStrongStrong<K, V>(0, key, value, null));
    }

    final int internalRehash() {
        int reqCapacity = XHashing.padHashLength((int)((float)this.size / this.hashDensity));
        ChainMapEntryLinkedHashedStrongStrong<K, V>[] slots = ChainMapEntryLinkedHashedStrongStrong.array(reqCapacity);
        int range = reqCapacity >= Integer.MAX_VALUE ? Integer.MAX_VALUE : reqCapacity - 1;
        HashEqualator<K> hashEqualator = this.hashEqualator;
        AbstractChainKeyValueStorage<K, V, ChainMapEntryLinkedHashedStrongStrong<K, V>> chain = this.chain;
        ChainMapEntryLinkedHashedStrongStrong entry = (ChainMapEntryLinkedHashedStrongStrong)((ChainMapEntryLinkedHashedStrongStrong)chain.head()).next;
        chain.clear();
        int size = 0;
        while (entry != null) {
            block3: {
                int hash = hashEqualator.hash(entry.key);
                ChainMapEntryLinkedHashedStrongStrong e = slots[hash & range];
                while (e != null) {
                    if (e.hash != hash || !hashEqualator.equal(e.key, entry.key)) {
                        e = (ChainMapEntryLinkedHashedStrongStrong)e.link;
                        continue;
                    }
                    break block3;
                }
                ChainMapEntryLinkedHashedStrongStrong chainMapEntryLinkedHashedStrongStrong = new ChainMapEntryLinkedHashedStrongStrong(hash, entry.key, entry.value, slots[hash & range]);
                slots[hash & range] = chainMapEntryLinkedHashedStrongStrong;
                chain.appendEntry(chainMapEntryLinkedHashedStrongStrong);
                ++size;
            }
            entry = (ChainMapEntryLinkedHashedStrongStrong)entry.next;
        }
        this.slots = slots;
        this.range = range;
        this.size = size;
        return size;
    }

    @Override
    public final int rehash() {
        throw new UnsupportedOperationException();
    }

    protected int internalCountingAddAll(KeyValue<K, V>[] elements) throws UnsupportedOperationException {
        return this.internalCountingAddAll(elements, 0, elements.length);
    }

    protected int internalCountingAddAll(KeyValue<K, V>[] elements, int offset, int length) throws UnsupportedOperationException {
        throw new UnsupportedOperationException();
    }

    @Override
    protected int internalCountingAddAll(XGettingCollection<? extends KeyValue<K, V>> elements) throws UnsupportedOperationException {
        throw new UnsupportedOperationException();
    }

    protected int internalCountingPutAll(KeyValue<K, V>[] elements) throws UnsupportedOperationException {
        throw new UnsupportedOperationException();
    }

    protected int internalCountingPutAll(KeyValue<K, V>[] elements, int offset, int length) throws UnsupportedOperationException {
        throw new UnsupportedOperationException();
    }

    @Override
    protected int internalCountingPutAll(XGettingCollection<? extends KeyValue<K, V>> elements) throws UnsupportedOperationException {
        throw new UnsupportedOperationException();
    }

    @Override
    protected int internalRemoveNullEntries() {
        throw new UnsupportedOperationException();
    }

    @Override
    protected void internalRemoveEntry(ChainMapEntryLinkedHashedStrongStrong<K, V> entry) {
        throw new UnsupportedOperationException();
    }

    @Override
    protected int internalClear() {
        throw new UnsupportedOperationException();
    }

    protected AbstractChainKeyValueStorage<K, V, ChainMapEntryLinkedHashedStrongStrong<K, V>> getInternalStorageChain() {
        return this.chain;
    }

    @Override
    public final long size() {
        return this.size;
    }

    @Override
    public final boolean isEmpty() {
        return this.size == 0;
    }

    @Override
    public final EqConstHashTable<K, V> copy() {
        final EqConstHashTable<K, V> newVarMap = new EqConstHashTable<K, V>(this);
        this.chain.iterate(new Consumer<KeyValue<K, V>>(){

            @Override
            public void accept(KeyValue<K, V> entry) {
                newVarMap.internalAdd(entry.key(), entry.value());
            }
        });
        return newVarMap;
    }

    @Override
    public final EqConstHashTable<K, V> immure() {
        return this;
    }

    @Override
    public final XGettingTable<K, V> view() {
        return new TableView(this);
    }

    @Override
    public final void setHashDensity(float hashDensity) {
    }

    @Override
    public final boolean hasVolatileElements() {
        return false;
    }

    @Override
    public final boolean nullAllowed() {
        return true;
    }

    @Override
    public final boolean nullKeyAllowed() {
        return true;
    }

    @Override
    public final boolean nullValuesAllowed() {
        return true;
    }

    @Override
    public final V get(K key) {
        int hash = this.hashEqualator.hash(key);
        ChainMapEntryLinkedHashedStrongStrong e = this.slots[hash & this.range];
        while (e != null) {
            if (e.hash == hash && this.hashEqualator.equal(e.key(), key)) {
                return e.value();
            }
            e = (ChainMapEntryLinkedHashedStrongStrong)e.link;
        }
        return null;
    }

    @Override
    public final Keys keys() {
        return this.keys;
    }

    @Override
    public final XImmutableTable.EntriesBridge<K, V> old() {
        throw new NotImplementedYetError();
    }

    @Override
    public XImmutableTable.Bridge<K, V> oldMap() {
        return new OldVarMap();
    }

    @Override
    public final V searchValue(final Predicate<? super K> keyPredicate) {
        KeyValue foundEntry = (KeyValue)this.chain.search(new Predicate<KeyValue<K, V>>(){

            @Override
            public boolean test(KeyValue<K, V> entry) {
                return keyPredicate.test(entry.key());
            }
        });
        return foundEntry != null ? (V)foundEntry.value() : null;
    }

    @Override
    public final <C extends Consumer<? super V>> C query(XIterable<? extends K> keys, final C collector) {
        keys.iterate(new Consumer<K>(){

            @Override
            public void accept(K key) {
                collector.accept(EqConstHashTable.this.get(key));
            }
        });
        return collector;
    }

    @Override
    public final Values values() {
        return this.values;
    }

    @Override
    public final long maximumCapacity() {
        return Integer.MAX_VALUE;
    }

    @Override
    public final boolean isFull() {
        return this.size >= Integer.MAX_VALUE;
    }

    @Override
    public final long remainingCapacity() {
        return Integer.MAX_VALUE - this.size;
    }

    @Override
    public final HashCollection.Analysis<EqConstHashTable<K, V>> analyze() {
        return AbstractChainEntryLinked.analyzeSlots((HashCollection)this, (AbstractChainEntryLinked[])this.slots);
    }

    @Override
    public final int hashDistributionRange() {
        return this.slots.length;
    }

    @Override
    public final HashEqualator<? super K> hashEquality() {
        return this.hashEqualator;
    }

    @Override
    public final float hashDensity() {
        return this.hashDensity;
    }

    @Override
    public final boolean hasVolatileHashElements() {
        return this.chain.hasVolatileElements();
    }

    public final String toString() {
        return this.chain.appendTo(VarString.New(this.slots.length).append('{'), ",").append('}').toString();
    }

    public final Predicate<K> predicateContainsKey() {
        return key -> this.containsKey(key);
    }

    public final Predicate<KeyValue<K, V>> predicateContainsEntry() {
        return entry -> {
            KeyValue kv = this.lookup(entry.key());
            if (kv == null) {
                return false;
            }
            return this.hashEqualator.equal(kv.key(), entry.key()) && kv.value() == entry.value();
        };
    }

    @Override
    public final XEnum<KeyValue<K, V>> range(long lowIndex, long highIndex) {
        throw new NotImplementedYetError();
    }

    @Override
    public final XGettingEnum<KeyValue<K, V>> view(long lowIndex, long highIndex) {
        throw new NotImplementedYetError();
    }

    public final KeyValue<K, V>[] toArray(Class<KeyValue<K, V>> type) {
        return this.chain.toArray(type);
    }

    @Override
    public final <P extends Consumer<? super KeyValue<K, V>>> P iterate(P procedure) {
        this.chain.iterate(procedure);
        return procedure;
    }

    @Override
    public final <A> A join(BiConsumer<? super KeyValue<K, V>, ? super A> joiner, A aggregate) {
        this.chain.join(joiner, aggregate);
        return aggregate;
    }

    @Override
    public final long count(KeyValue<K, V> entry) {
        return this.chain.count(entry, this.equality());
    }

    @Override
    public final long countBy(Predicate<? super KeyValue<K, V>> predicate) {
        return this.chain.count(predicate);
    }

    @Override
    public final KeyValue<K, V> search(Predicate<? super KeyValue<K, V>> predicate) {
        return this.chain.search(predicate);
    }

    @Override
    public final KeyValue<K, V> max(Comparator<? super KeyValue<K, V>> comparator) {
        return this.chain.max(comparator);
    }

    @Override
    public final KeyValue<K, V> min(Comparator<? super KeyValue<K, V>> comparator) {
        return this.chain.min(comparator);
    }

    @Override
    public final boolean containsSearched(Predicate<? super KeyValue<K, V>> predicate) {
        return this.chain.containsSearched(predicate);
    }

    @Override
    public final boolean applies(Predicate<? super KeyValue<K, V>> predicate) {
        return this.chain.appliesAll(predicate);
    }

    @Override
    public final boolean nullContained() {
        return false;
    }

    @Override
    public final boolean containsId(KeyValue<K, V> entry) {
        int hash = this.hashEqualator.hash(entry.key());
        ChainMapEntryLinkedHashedStrongStrong e = this.slots[hash & this.range];
        while (e != null) {
            if (hash == e.hash && entry == e.key()) {
                return true;
            }
            e = (ChainMapEntryLinkedHashedStrongStrong)e.link;
        }
        return false;
    }

    @Override
    public final boolean contains(KeyValue<K, V> entry) {
        int hash = this.hashEqualator.hash(entry.key());
        ChainMapEntryLinkedHashedStrongStrong e = this.slots[hash & this.range];
        while (e != null) {
            if (e.hash == hash && this.hashEqualator.equal(e.key(), entry.key())) {
                return true;
            }
            e = (ChainMapEntryLinkedHashedStrongStrong)e.link;
        }
        return false;
    }

    @Override
    public final KeyValue<K, V> seek(KeyValue<K, V> sample) {
        if (sample == null) {
            return null;
        }
        int hash = this.hashEqualator.hash(sample.key());
        ChainMapEntryLinkedHashedStrongStrong e = this.slots[hash & this.range];
        while (e != null) {
            if (e.hash == hash && this.hashEqualator.equal(e.key(), sample.key())) {
                return e;
            }
            e = (ChainMapEntryLinkedHashedStrongStrong)e.link;
        }
        return null;
    }

    @Override
    public final boolean containsAll(XGettingCollection<? extends KeyValue<K, V>> elements) {
        return elements.applies(this.predicateContainsEntry());
    }

    @Override
    public final boolean equals(XGettingCollection<? extends KeyValue<K, V>> samples, Equalator<? super KeyValue<K, V>> equalator) {
        if (samples == null || !(samples instanceof Keys)) {
            return false;
        }
        if (samples == this) {
            return true;
        }
        return this.equalsContent(samples, equalator);
    }

    @Override
    public final boolean equalsContent(XGettingCollection<? extends KeyValue<K, V>> samples, Equalator<? super KeyValue<K, V>> equalator) {
        if (this.size != XTypes.to_int(samples.size())) {
            return false;
        }
        return this.chain.equalsContent(samples, equalator);
    }

    @Override
    public final <C extends Consumer<? super KeyValue<K, V>>> C intersect(XGettingCollection<? extends KeyValue<K, V>> other, Equalator<? super KeyValue<K, V>> equalator, C target) {
        return this.chain.intersect(other, equalator, target);
    }

    @Override
    public final <C extends Consumer<? super KeyValue<K, V>>> C except(XGettingCollection<? extends KeyValue<K, V>> other, Equalator<? super KeyValue<K, V>> equalator, C target) {
        return this.chain.except(other, equalator, target);
    }

    @Override
    public final <C extends Consumer<? super KeyValue<K, V>>> C union(XGettingCollection<? extends KeyValue<K, V>> other, Equalator<? super KeyValue<K, V>> equalator, C target) {
        return this.chain.union(other, equalator, target);
    }

    @Override
    public final <C extends Consumer<? super KeyValue<K, V>>> C copyTo(C target) {
        return this.chain.copyTo(target);
    }

    @Override
    public final <C extends Consumer<? super KeyValue<K, V>>> C filterTo(C target, Predicate<? super KeyValue<K, V>> predicate) {
        return this.chain.copyTo(target, predicate);
    }

    @Override
    public final <C extends Consumer<? super KeyValue<K, V>>> C distinct(C target) {
        return this.distinct(target, this.equality());
    }

    @Override
    public final <C extends Consumer<? super KeyValue<K, V>>> C distinct(C target, Equalator<? super KeyValue<K, V>> equalator) {
        return this.chain.distinct(target, equalator);
    }

    @Override
    public final EqConstHashTable<K, V> toReversed() {
        Copyable reversedVarSet = this.copy();
        ((EqConstHashTable)reversedVarSet).chain.reverse();
        return reversedVarSet;
    }

    @Override
    public final <T extends Consumer<? super KeyValue<K, V>>> T copySelection(T target, long ... indices) {
        this.chain.copySelection(target, indices);
        return target;
    }

    @Override
    public final <P extends IndexedAcceptor<? super KeyValue<K, V>>> P iterateIndexed(P procedure) {
        this.chain.iterateIndexed(procedure);
        return procedure;
    }

    @Override
    public final KeyValue<K, V> at(long index) {
        return (KeyValue)this.chain.get(index);
    }

    @Override
    public final KeyValue<K, V> get() {
        return (KeyValue)this.chain.first();
    }

    @Override
    public final KeyValue<K, V> first() {
        return (KeyValue)this.chain.first();
    }

    @Override
    public final KeyValue<K, V> last() {
        return (KeyValue)this.chain.last();
    }

    @Override
    public final KeyValue<K, V> poll() {
        return this.size == 0 ? null : (KeyValue)this.chain.first();
    }

    @Override
    public final KeyValue<K, V> peek() {
        return this.size == 0 ? null : (KeyValue)this.chain.last();
    }

    @Override
    public final long indexOf(KeyValue<K, V> entry) {
        return this.chain.indexOf(entry);
    }

    @Override
    public final long indexBy(Predicate<? super KeyValue<K, V>> predicate) {
        return this.chain.indexOf(predicate);
    }

    @Override
    public final boolean isSorted(Comparator<? super KeyValue<K, V>> comparator) {
        return this.chain.isSorted(comparator);
    }

    @Override
    public final long lastIndexOf(KeyValue<K, V> entry) {
        return this.chain.lastIndexBy((? super E kv) -> this.hashEqualator.equal(kv.key(), entry.key()));
    }

    @Override
    public final long lastIndexBy(Predicate<? super KeyValue<K, V>> predicate) {
        return this.chain.lastIndexBy(predicate);
    }

    @Override
    public final long maxIndex(Comparator<? super KeyValue<K, V>> comparator) {
        return this.chain.maxIndex(comparator);
    }

    @Override
    public final long minIndex(Comparator<? super KeyValue<K, V>> comparator) {
        return this.chain.minIndex(comparator);
    }

    @Override
    public final long scan(Predicate<? super KeyValue<K, V>> predicate) {
        return this.chain.scan(predicate);
    }

    @Override
    public final Iterator<KeyValue<K, V>> iterator() {
        return this.chain.iterator();
    }

    @Override
    public final Object[] toArray() {
        return this.chain.toArray();
    }

    @Override
    public final HashEqualator<KeyValue<K, V>> equality() {
        return XHashing.wrapAsKeyValue(this.hashEqualator);
    }

    public static interface Creator<K, V> {
        public EqConstHashTable<K, V> newInstance();
    }

    public final class Keys
    implements XImmutableTable.Keys<K, V>,
    HashCollection<K> {
        @Override
        public final int hashDistributionRange() {
            return EqConstHashTable.this.slots.length;
        }

        @Override
        public final boolean hasVolatileHashElements() {
            return EqConstHashTable.this.chain.hasVolatileElements();
        }

        @Override
        public final void setHashDensity(float hashDensity) {
            EqConstHashTable.this.setHashDensity(hashDensity);
        }

        @Override
        public final HashCollection.Analysis<Keys> analyze() {
            return AbstractChainEntryLinked.analyzeSlots((HashCollection)this, (AbstractChainEntryLinked[])EqConstHashTable.this.slots);
        }

        @Override
        public final int rehash() {
            return EqConstHashTable.this.rehash();
        }

        @Override
        public final Equalator<? super K> equality() {
            return EqConstHashTable.this.hashEquality();
        }

        @Override
        public final Keys copy() {
            return ((EqConstHashTable)EqConstHashTable.this.copy()).keys();
        }

        @Override
        public final Keys immure() {
            return this;
        }

        @Override
        public final XGettingEnum<K> view() {
            return new EnumView(this);
        }

        @Override
        public final XEnum<K> range(long lowIndex, long highIndex) {
            throw new NotImplementedYetError();
        }

        @Override
        public final XGettingEnum<K> view(long lowIndex, long highIndex) {
            throw new NotImplementedYetError();
        }

        @Override
        public final K[] toArray(Class<K> type) {
            return EqConstHashTable.this.chain.keyToArray(type);
        }

        @Override
        public final <P extends Consumer<? super K>> P iterate(P procedure) {
            EqConstHashTable.this.chain.keyIterate(procedure);
            return procedure;
        }

        @Override
        public final <A> A join(BiConsumer<? super K, ? super A> joiner, A aggregate) {
            EqConstHashTable.this.chain.keyJoin(joiner, aggregate);
            return aggregate;
        }

        @Override
        public final long count(K element) {
            return this.contains((K)element) ? 1 : 0;
        }

        @Override
        public final long countBy(Predicate<? super K> predicate) {
            return EqConstHashTable.this.chain.keyCount(predicate);
        }

        @Override
        public final K seek(K sample) {
            return EqConstHashTable.this.chain.keySeek(sample, EqConstHashTable.this.hashEqualator);
        }

        @Override
        public final K search(Predicate<? super K> predicate) {
            return EqConstHashTable.this.chain.keySearch(predicate);
        }

        @Override
        public final K max(Comparator<? super K> comparator) {
            return EqConstHashTable.this.chain.keyMax(comparator);
        }

        @Override
        public final K min(Comparator<? super K> comparator) {
            return EqConstHashTable.this.chain.keyMin(comparator);
        }

        @Override
        public final boolean hasVolatileElements() {
            return EqConstHashTable.this.chain.hasVolatileElements();
        }

        @Override
        public final boolean nullAllowed() {
            return true;
        }

        @Override
        public final boolean containsSearched(Predicate<? super K> predicate) {
            return EqConstHashTable.this.chain.keyApplies(predicate);
        }

        @Override
        public final boolean applies(Predicate<? super K> predicate) {
            return EqConstHashTable.this.chain.keyAppliesAll(predicate);
        }

        @Override
        public final boolean nullContained() {
            return this.contains((K)null);
        }

        @Override
        public final boolean containsId(K element) {
            int hash = EqConstHashTable.this.hashEqualator.hash(element);
            ChainMapEntryLinkedHashedStrongStrong e = EqConstHashTable.this.slots[hash & EqConstHashTable.this.range];
            while (e != null) {
                if (hash == e.hash && element == e.key()) {
                    return true;
                }
                e = (ChainMapEntryLinkedHashedStrongStrong)e.link;
            }
            return false;
        }

        @Override
        public final boolean contains(K element) {
            int hash = EqConstHashTable.this.hashEqualator.hash(element);
            ChainMapEntryLinkedHashedStrongStrong e = EqConstHashTable.this.slots[hash & EqConstHashTable.this.range];
            while (e != null) {
                if (e.hash == hash && EqConstHashTable.this.hashEqualator.equal(e.key(), element)) {
                    return true;
                }
                e = (ChainMapEntryLinkedHashedStrongStrong)e.link;
            }
            return false;
        }

        @Override
        public final boolean containsAll(XGettingCollection<? extends K> elements) {
            return elements.applies(EqConstHashTable.this.predicateContainsKey());
        }

        @Override
        public final boolean equals(XGettingCollection<? extends K> samples, Equalator<? super K> equalator) {
            if (samples == null || !(samples instanceof Keys)) {
                return false;
            }
            if (samples == this) {
                return true;
            }
            return this.equalsContent(samples, equalator);
        }

        @Override
        public final boolean equalsContent(XGettingCollection<? extends K> samples, Equalator<? super K> equalator) {
            if (EqConstHashTable.this.size != XTypes.to_int(samples.size())) {
                return false;
            }
            return EqConstHashTable.this.chain.keyEqualsContent(samples, equalator);
        }

        @Override
        public final <C extends Consumer<? super K>> C intersect(XGettingCollection<? extends K> other, Equalator<? super K> equalator, C target) {
            return EqConstHashTable.this.chain.keyIntersect(other, equalator, target);
        }

        @Override
        public final <C extends Consumer<? super K>> C except(XGettingCollection<? extends K> other, Equalator<? super K> equalator, C target) {
            return EqConstHashTable.this.chain.keyExcept(other, equalator, target);
        }

        @Override
        public final <C extends Consumer<? super K>> C union(XGettingCollection<? extends K> other, Equalator<? super K> equalator, C target) {
            return EqConstHashTable.this.chain.keyUnion(other, equalator, target);
        }

        @Override
        public final <C extends Consumer<? super K>> C copyTo(C target) {
            return EqConstHashTable.this.chain.keyCopyTo(target);
        }

        @Override
        public final <C extends Consumer<? super K>> C filterTo(C target, Predicate<? super K> predicate) {
            return EqConstHashTable.this.chain.keyCopyTo(target, predicate);
        }

        @Override
        public final <C extends Consumer<? super K>> C distinct(C target) {
            return this.distinct(target, EqConstHashTable.this.hashEqualator);
        }

        @Override
        public final <C extends Consumer<? super K>> C distinct(C target, Equalator<? super K> equalator) {
            if (EqConstHashTable.this.hashEqualator == equalator) {
                return this.copyTo(target);
            }
            return EqConstHashTable.this.chain.keyDistinct(target, equalator);
        }

        @Override
        public final long maximumCapacity() {
            return EqConstHashTable.this.maximumCapacity();
        }

        @Override
        public final boolean isFull() {
            return EqConstHashTable.this.isFull();
        }

        @Override
        public final long remainingCapacity() {
            return EqConstHashTable.this.remainingCapacity();
        }

        @Override
        public final Keys toReversed() {
            Copyable reversedVarSet = EqConstHashTable.this.copy();
            ((EqConstHashTable)reversedVarSet).chain.reverse();
            return ((EqConstHashTable)reversedVarSet).keys;
        }

        @Override
        public final <T extends Consumer<? super K>> T copySelection(T target, long ... indices) {
            EqConstHashTable.this.chain.keyCopySelection(target, indices);
            return target;
        }

        @Override
        public final <P extends IndexedAcceptor<? super K>> P iterateIndexed(P procedure) {
            EqConstHashTable.this.chain.keyIterateIndexed(procedure);
            return procedure;
        }

        @Override
        public final K at(long index) {
            return EqConstHashTable.this.chain.keyGet(index);
        }

        @Override
        public final K get() {
            return EqConstHashTable.this.chain.keyFirst();
        }

        @Override
        public final K first() {
            return EqConstHashTable.this.chain.keyFirst();
        }

        @Override
        public final K last() {
            return EqConstHashTable.this.chain.keyLast();
        }

        @Override
        public final K poll() {
            return EqConstHashTable.this.size == 0 ? null : (Object)EqConstHashTable.this.chain.keyFirst();
        }

        @Override
        public final K peek() {
            return EqConstHashTable.this.size == 0 ? null : (Object)EqConstHashTable.this.chain.keyLast();
        }

        @Override
        public final long indexOf(K element) {
            return EqConstHashTable.this.chain.keyIndexOf(element);
        }

        @Override
        public final long indexBy(Predicate<? super K> predicate) {
            return EqConstHashTable.this.chain.keyIndexBy(predicate);
        }

        @Override
        public final boolean isSorted(Comparator<? super K> comparator) {
            return EqConstHashTable.this.chain.keyIsSorted(comparator);
        }

        @Override
        public final long lastIndexOf(K element) {
            return EqConstHashTable.this.chain.keyLastIndexOf(element);
        }

        @Override
        public final long lastIndexBy(Predicate<? super K> predicate) {
            return EqConstHashTable.this.chain.keyLastIndexBy(predicate);
        }

        @Override
        public final long maxIndex(Comparator<? super K> comparator) {
            return EqConstHashTable.this.chain.keyMaxIndex(comparator);
        }

        @Override
        public final long minIndex(Comparator<? super K> comparator) {
            return EqConstHashTable.this.chain.keyMinIndex(comparator);
        }

        @Override
        public final long scan(Predicate<? super K> predicate) {
            return EqConstHashTable.this.chain.keyScan(predicate);
        }

        @Override
        public final boolean isEmpty() {
            return EqConstHashTable.this.isEmpty();
        }

        @Override
        public final Iterator<K> iterator() {
            return EqConstHashTable.this.chain.keyIterator();
        }

        @Override
        public final long size() {
            return EqConstHashTable.this.size;
        }

        public final String toString() {
            if (EqConstHashTable.this.size == 0) {
                return "[]";
            }
            VarString vc = VarString.New(EqConstHashTable.this.slots.length).append('[');
            EqConstHashTable.this.chain.keyAppendTo(vc, ',').append(']');
            return vc.toString();
        }

        @Override
        public final Object[] toArray() {
            return EqConstHashTable.this.chain.keyToArray();
        }

        @Override
        public final OldCollection<K> old() {
            throw new NotImplementedYetError();
        }

        @Override
        public final EqConstHashTable<K, V> parent() {
            return EqConstHashTable.this;
        }

        @Override
        public final HashEqualator<? super K> hashEquality() {
            return EqConstHashTable.this.hashEquality();
        }

        @Override
        public final float hashDensity() {
            return EqConstHashTable.this.hashDensity();
        }
    }

    public final class OldVarMap
    implements XImmutableTable.Bridge<K, V> {
        @Override
        public final void clear() {
            throw new UnsupportedOperationException();
        }

        @Override
        public final boolean containsKey(Object key) {
            try {
                return EqConstHashTable.this.containsKey(key);
            }
            catch (Exception e) {
                return false;
            }
        }

        @Override
        public final boolean containsValue(Object value) {
            try {
                return EqConstHashTable.this.chain.valuesContains(value);
            }
            catch (Exception e) {
                return false;
            }
        }

        @Override
        public final Set<Map.Entry<K, V>> entrySet() {
            return (Set)((Object)EqConstHashTable.this.old());
        }

        @Override
        public final V get(Object key) {
            try {
                return EqConstHashTable.this.get(key);
            }
            catch (Exception e) {
                return null;
            }
        }

        @Override
        public final boolean isEmpty() {
            return EqConstHashTable.this.isEmpty();
        }

        @Override
        public final Set<K> keySet() {
            throw new NotImplementedYetError();
        }

        @Override
        public final V put(K key, V value) {
            throw new UnsupportedOperationException();
        }

        @Override
        public final void putAll(Map<? extends K, ? extends V> m) {
            throw new UnsupportedOperationException();
        }

        @Override
        public final V remove(Object key) {
            throw new UnsupportedOperationException();
        }

        @Override
        public final int size() {
            return XTypes.to_int(EqConstHashTable.this.size());
        }

        @Override
        public final Collection<V> values() {
            return EqConstHashTable.this.values.old();
        }

        @Override
        public final EqConstHashTable<K, V> parent() {
            return EqConstHashTable.this;
        }
    }

    public final class Values
    implements XImmutableTable.Values<K, V> {
        @Override
        public final Equalator<? super V> equality() {
            return Equalator.identity();
        }

        @Override
        public final XImmutableList<V> copy() {
            return ConstList.New(this);
        }

        @Override
        public final <P extends Consumer<? super V>> P iterate(P procedure) {
            EqConstHashTable.this.chain.valuesIterate(procedure);
            return procedure;
        }

        @Override
        public final <A> A join(BiConsumer<? super V, ? super A> joiner, A aggregate) {
            EqConstHashTable.this.chain.valuesJoin(joiner, aggregate);
            return aggregate;
        }

        @Override
        public final <P extends IndexedAcceptor<? super V>> P iterateIndexed(P procedure) {
            EqConstHashTable.this.chain.valuesIterateIndexed(procedure);
            return procedure;
        }

        @Override
        public final Values toReversed() {
            Copyable reversedVarSet = EqConstHashTable.this.copy();
            ((EqConstHashTable)reversedVarSet).chain.reverse();
            return ((EqConstHashTable)reversedVarSet).values;
        }

        @Override
        public final boolean containsSearched(Predicate<? super V> predicate) {
            return EqConstHashTable.this.chain.valuesApplies(predicate);
        }

        @Override
        public final boolean applies(Predicate<? super V> predicate) {
            return EqConstHashTable.this.chain.valuesAppliesAll(predicate);
        }

        @Override
        public final boolean contains(V value) {
            return EqConstHashTable.this.chain.valuesContains(value);
        }

        @Override
        public final boolean containsAll(XGettingCollection<? extends V> values) {
            return EqConstHashTable.this.chain.valuesContainsAll(values);
        }

        @Override
        public final boolean containsId(V value) {
            return EqConstHashTable.this.chain.valuesContainsId(value);
        }

        @Override
        public final <T extends Consumer<? super V>> T copyTo(T target) {
            EqConstHashTable.this.chain.valuesCopyTo(target);
            return target;
        }

        @Override
        public final <T extends Consumer<? super V>> T filterTo(T target, Predicate<? super V> predicate) {
            EqConstHashTable.this.chain.valuesCopyTo(target, predicate);
            return target;
        }

        @Override
        public final long count(V value) {
            return EqConstHashTable.this.chain.valuesCount(value);
        }

        @Override
        public final long countBy(Predicate<? super V> predicate) {
            return EqConstHashTable.this.chain.valuesCount(predicate);
        }

        @Override
        public final <T extends Consumer<? super V>> T distinct(T target) {
            EqConstHashTable.this.chain.valuesDistinct(target);
            return target;
        }

        @Override
        public final <T extends Consumer<? super V>> T distinct(T target, Equalator<? super V> equalator) {
            EqConstHashTable.this.chain.valuesDistinct(target, equalator);
            return target;
        }

        @Override
        public final boolean equals(XGettingCollection<? extends V> samples, Equalator<? super V> equalator) {
            if (samples == null || !(samples instanceof EqHashEnum)) {
                return false;
            }
            if (samples == this) {
                return true;
            }
            return this.equalsContent(samples, equalator);
        }

        @Override
        public final boolean equalsContent(XGettingCollection<? extends V> samples, Equalator<? super V> equalator) {
            return EqConstHashTable.this.chain.valuesEqualsContent(samples, equalator);
        }

        @Override
        public final <T extends Consumer<? super V>> T except(XGettingCollection<? extends V> other, Equalator<? super V> equalator, T target) {
            EqConstHashTable.this.chain.valuesExcept(other, equalator, target);
            return target;
        }

        @Override
        public final boolean hasVolatileElements() {
            return false;
        }

        @Override
        public final <T extends Consumer<? super V>> T intersect(XGettingCollection<? extends V> other, Equalator<? super V> equalator, T target) {
            EqConstHashTable.this.chain.valuesIntersect(other, equalator, target);
            return target;
        }

        @Override
        public final boolean isEmpty() {
            return EqConstHashTable.this.isEmpty();
        }

        @Override
        public final Iterator<V> iterator() {
            return EqConstHashTable.this.chain.valuesIterator();
        }

        @Override
        public final V max(Comparator<? super V> comparator) {
            return EqConstHashTable.this.chain.valuesMax(comparator);
        }

        @Override
        public final V min(Comparator<? super V> comparator) {
            return EqConstHashTable.this.chain.valuesMin(comparator);
        }

        @Override
        public final boolean nullAllowed() {
            return EqConstHashTable.this.nullAllowed();
        }

        @Override
        public final boolean nullContained() {
            return EqConstHashTable.this.chain.valuesContains(null);
        }

        @Override
        public final OldList<V> old() {
            throw new NotImplementedYetError();
        }

        @Override
        public final V seek(V sample) {
            return EqConstHashTable.this.chain.valuesSeek(sample);
        }

        @Override
        public final V search(Predicate<? super V> predicate) {
            return EqConstHashTable.this.chain.valuesSearch(predicate);
        }

        @Override
        public final long size() {
            return XTypes.to_int(EqConstHashTable.this.size());
        }

        @Override
        public final long maximumCapacity() {
            return XTypes.to_int(EqConstHashTable.this.size());
        }

        @Override
        public final boolean isFull() {
            return EqConstHashTable.this.isFull();
        }

        @Override
        public final long remainingCapacity() {
            return EqConstHashTable.this.remainingCapacity();
        }

        public final String toString() {
            if (EqConstHashTable.this.size == 0) {
                return "[]";
            }
            VarString vc = VarString.New(EqConstHashTable.this.slots.length).append('[');
            EqConstHashTable.this.chain.valuesAppendTo(vc, ',').append(']');
            return vc.toString();
        }

        @Override
        public final Object[] toArray() {
            return EqConstHashTable.this.chain.valuesToArray();
        }

        @Override
        public final V[] toArray(Class<V> type) {
            return EqConstHashTable.this.chain.valuesToArray(type);
        }

        @Override
        public final <T extends Consumer<? super V>> T union(XGettingCollection<? extends V> other, Equalator<? super V> equalator, T target) {
            EqConstHashTable.this.chain.valuesUnion(other, equalator, target);
            return target;
        }

        @Override
        public final EqConstHashTable<K, V> parent() {
            return EqConstHashTable.this;
        }

        @Override
        public final XImmutableList<V> view(long fromIndex, long toIndex) {
            throw new NotImplementedYetError();
        }

        @Override
        public final ListIterator<V> listIterator() {
            return EqConstHashTable.this.chain.valuesListIterator(0L);
        }

        @Override
        public final ListIterator<V> listIterator(long index) {
            return EqConstHashTable.this.chain.valuesListIterator(index);
        }

        @Override
        public final XImmutableList<V> range(long fromIndex, long toIndex) {
            throw new NotImplementedYetError();
        }

        @Override
        public final XImmutableList<V> immure() {
            return ConstList.New(this);
        }

        @Override
        public final XImmutableList<V> view() {
            throw new NotImplementedYetError();
        }

        @Override
        public final <T extends Consumer<? super V>> T copySelection(T target, long ... indices) {
            EqConstHashTable.this.chain.valuesCopySelection(target, indices);
            return target;
        }

        @Override
        public final V at(long index) {
            return EqConstHashTable.this.chain.valuesGet(index);
        }

        @Override
        public final V get() {
            return EqConstHashTable.this.chain.valuesFirst();
        }

        @Override
        public final V first() {
            return EqConstHashTable.this.chain.valuesFirst();
        }

        @Override
        public final V last() {
            return EqConstHashTable.this.chain.valuesLast();
        }

        @Override
        public final V poll() {
            return EqConstHashTable.this.size == 0 ? null : (Object)EqConstHashTable.this.chain.valuesFirst();
        }

        @Override
        public final V peek() {
            return EqConstHashTable.this.size == 0 ? null : (Object)EqConstHashTable.this.chain.valuesLast();
        }

        @Override
        public final long indexOf(V value) {
            return EqConstHashTable.this.chain.valuesIndexOf(value);
        }

        @Override
        public final long indexBy(Predicate<? super V> predicate) {
            return EqConstHashTable.this.chain.valuesIndexBy(predicate);
        }

        @Override
        public final boolean isSorted(Comparator<? super V> comparator) {
            return EqConstHashTable.this.chain.valuesIsSorted(comparator);
        }

        @Override
        public final long lastIndexOf(V value) {
            return EqConstHashTable.this.chain.valuesLastIndexOf(value);
        }

        @Override
        public final long lastIndexBy(Predicate<? super V> predicate) {
            return EqConstHashTable.this.chain.valuesLastIndexBy(predicate);
        }

        @Override
        public final long maxIndex(Comparator<? super V> comparator) {
            return EqConstHashTable.this.chain.valuesMaxIndex(comparator);
        }

        @Override
        public final long minIndex(Comparator<? super V> comparator) {
            return EqConstHashTable.this.chain.valuesMinIndex(comparator);
        }

        @Override
        public final long scan(Predicate<? super V> predicate) {
            return EqConstHashTable.this.chain.valuesScan(predicate);
        }
    }
}

