/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.serializer.collections;

import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import org.eclipse.serializer.collections.AbstractArrayCollection;
import org.eclipse.serializer.collections.AbstractArrayStorage;
import org.eclipse.serializer.collections.AbstractSimpleArrayCollection;
import org.eclipse.serializer.collections.EqConstList;
import org.eclipse.serializer.collections.ListView;
import org.eclipse.serializer.collections.SubList;
import org.eclipse.serializer.collections.SubListView;
import org.eclipse.serializer.collections.XArrays;
import org.eclipse.serializer.collections.XSort;
import org.eclipse.serializer.collections.old.AbstractBridgeXList;
import org.eclipse.serializer.collections.types.XGettingCollection;
import org.eclipse.serializer.collections.types.XGettingSequence;
import org.eclipse.serializer.collections.types.XList;
import org.eclipse.serializer.equality.Equalator;
import org.eclipse.serializer.exceptions.ArrayCapacityException;
import org.eclipse.serializer.exceptions.IndexBoundsException;
import org.eclipse.serializer.functional.IndexedAcceptor;
import org.eclipse.serializer.functional.IsCustomEqual;
import org.eclipse.serializer.math.XMath;
import org.eclipse.serializer.typing.Composition;
import org.eclipse.serializer.typing.XTypes;
import org.eclipse.serializer.util.X;
import org.eclipse.serializer.util.iterables.GenericListIterator;

public final class EqBulkList<E>
extends AbstractSimpleArrayCollection<E>
implements XList<E>,
Composition {
    E[] data;
    int size;
    final Equalator<? super E> equalator;

    private static String exceptionStringRange(long size, long startIndex, long length) {
        return "Range [" + (length < 0L ? String.valueOf(startIndex + length + 1L) + ";" + startIndex : String.valueOf(startIndex) + ";" + (startIndex + length - 1L)) + "] not in [0;" + (size - 1L) + "]";
    }

    public EqBulkList(Equalator<? super E> equalator) {
        this.size = 0;
        this.data = EqBulkList.newArray(1);
        this.equalator = equalator;
    }

    public EqBulkList(Equalator<? super E> equalator, int initialCapacity) {
        this.size = 0;
        this.data = EqBulkList.newArray(XMath.pow2BoundMaxed(initialCapacity));
        this.equalator = equalator;
    }

    public EqBulkList(EqBulkList<E> original) throws NullPointerException {
        this.size = original.size;
        this.data = (Object[])original.data.clone();
        this.equalator = original.equalator;
    }

    @SafeVarargs
    public EqBulkList(Equalator<? super E> equalator, E ... elements) throws NullPointerException {
        this.size = elements.length;
        this.data = EqBulkList.newArray(XMath.pow2BoundMaxed(this.size));
        System.arraycopy(elements, 0, this.data, 0, this.size);
        this.equalator = equalator;
    }

    public EqBulkList(Equalator<? super E> equalator, int initialCapacity, E[] src, int srcStart, int srcLength) {
        this.data = EqBulkList.newArray(XMath.pow2BoundMaxed(initialCapacity >= srcLength ? initialCapacity : srcLength));
        this.size = srcLength;
        System.arraycopy(src, srcStart, this.data, 0, this.size);
        this.equalator = equalator;
    }

    EqBulkList(Equalator<? super E> equalator, E[] storageArray, int size) {
        this.size = size;
        this.data = storageArray;
        this.equalator = equalator;
    }

    void internalAdd(E element) {
        if (this.size >= this.data.length) {
            if (this.size >= Integer.MAX_VALUE) {
                throw new IndexOutOfBoundsException();
            }
            this.data = EqBulkList.newArray((int)((float)this.data.length * 2.0f));
            System.arraycopy(this.data, 0, this.data, 0, this.size);
        }
        this.data[this.size++] = element;
    }

    private int internalInputArray(int index, Object[] elements, int elementsSize) {
        int newCapacity;
        if (this.data.length - this.size >= elementsSize) {
            System.arraycopy(this.data, index, this.data, index + elementsSize, elementsSize);
            System.arraycopy(elements, 0, this.data, index, elementsSize);
            this.size += elementsSize;
            return elementsSize;
        }
        if (Integer.MAX_VALUE - this.size < elementsSize) {
            throw new ArrayCapacityException((long)elementsSize + (long)this.size);
        }
        int newSize = this.size + elementsSize;
        if (XMath.isGreaterThanHighestPowerOf2(newSize)) {
            newCapacity = Integer.MAX_VALUE;
        } else {
            newCapacity = this.data.length;
            while (newCapacity < newSize) {
                newCapacity <<= 1;
            }
        }
        E[] data = EqBulkList.newArray(newCapacity);
        System.arraycopy(this.data, 0, data, 0, index);
        System.arraycopy(this.data, index, data, index + elementsSize, elementsSize);
        this.data = data;
        System.arraycopy(elements, 0, data, index, elementsSize);
        this.size = newSize;
        return elementsSize;
    }

    private int internalInputArray(int index, E[] elements, int offset, int length) {
        int newCapacity;
        if (length < 0) {
            return this.internalReverseInputArray(index, elements, offset, -length);
        }
        if (this.data.length - this.size >= length) {
            System.arraycopy(this.data, index, this.data, index + length, length);
            System.arraycopy(elements, offset, this.data, index, length);
            this.size += length;
            return length;
        }
        if (Integer.MAX_VALUE - this.size < length) {
            throw new ArrayCapacityException((long)length + (long)this.size);
        }
        int newSize = this.size + length;
        if (XMath.isGreaterThanHighestPowerOf2(newSize)) {
            newCapacity = Integer.MAX_VALUE;
        } else {
            newCapacity = this.data.length;
            while (newCapacity < newSize) {
                newCapacity <<= 1;
            }
        }
        E[] data = EqBulkList.newArray(newCapacity);
        System.arraycopy(this.data, 0, data, 0, index);
        System.arraycopy(this.data, index, data, index + length, length);
        this.data = data;
        System.arraycopy(elements, offset, data, index, length);
        this.size = newSize;
        return length;
    }

    private int internalReverseInputArray(int index, E[] elements, int offset, int length) {
        int newCapacity;
        if (this.data.length - this.size >= length) {
            System.arraycopy(this.data, index, this.data, index + length, length);
            XArrays.reverseArraycopy(elements, offset, this.data, index, length);
            this.size += length;
            return length;
        }
        if (Integer.MAX_VALUE - this.size < length) {
            throw new ArrayCapacityException((long)length + (long)this.size);
        }
        int newSize = this.size + length;
        if (XMath.isGreaterThanHighestPowerOf2(newSize)) {
            newCapacity = Integer.MAX_VALUE;
        } else {
            newCapacity = this.data.length;
            while (newCapacity < newSize) {
                newCapacity <<= 1;
            }
        }
        E[] data = EqBulkList.newArray(newCapacity);
        System.arraycopy(this.data, 0, data, 0, index);
        System.arraycopy(this.data, index, data, index + length, length);
        XArrays.reverseArraycopy(elements, 0, this.data, index, -length);
        this.size = newSize;
        return length;
    }

    @Override
    protected E[] internalGetStorageArray() {
        return this.data;
    }

    @Override
    protected int internalSize() {
        return this.size;
    }

    @Override
    protected int[] internalGetSectionIndices() {
        int[] nArray = new int[2];
        nArray[1] = this.size;
        return nArray;
    }

    @Override
    protected int internalCountingAddAll(E[] elements) throws UnsupportedOperationException {
        this.ensureFreeCapacity(elements.length);
        System.arraycopy(elements, 0, this.data, this.size, elements.length);
        this.size += elements.length;
        return elements.length;
    }

    @Override
    protected int internalCountingAddAll(E[] elements, int offset, int length) throws UnsupportedOperationException {
        if (length >= 0) {
            this.ensureFreeCapacity(length);
            System.arraycopy(elements, offset, this.data, this.size, length);
            this.size += length;
            return length;
        }
        int bound = offset + length;
        if (bound < -1) {
            throw new ArrayIndexOutOfBoundsException(bound + 1);
        }
        this.ensureFreeCapacity(-length);
        E[] data = this.data;
        int size = this.size;
        int i = offset;
        while (i > bound) {
            data[size++] = elements[i];
            --i;
        }
        this.size = size;
        return -length;
    }

    @Override
    protected int internalCountingAddAll(XGettingCollection<? extends E> elements) throws UnsupportedOperationException {
        if (elements instanceof AbstractSimpleArrayCollection) {
            return this.internalCountingAddAll(AbstractSimpleArrayCollection.internalGetStorageArray((AbstractSimpleArrayCollection)((Object)elements)), 0, XTypes.to_int(elements.size()));
        }
        int oldSize = this.size;
        elements.iterate(this);
        return this.size - oldSize;
    }

    @Override
    protected int internalCountingPutAll(E[] elements) throws UnsupportedOperationException {
        this.ensureFreeCapacity(elements.length);
        System.arraycopy(elements, 0, this.data, this.size, elements.length);
        this.size += elements.length;
        return elements.length;
    }

    @Override
    protected int internalCountingPutAll(E[] elements, int offset, int length) throws UnsupportedOperationException {
        if (length >= 0) {
            this.ensureFreeCapacity(length);
            System.arraycopy(elements, offset, this.data, this.size, length);
            this.size += length;
            return length;
        }
        int bound = offset + length;
        if (bound < -1) {
            throw new ArrayIndexOutOfBoundsException(bound + 1);
        }
        this.ensureFreeCapacity(-length);
        E[] data = this.data;
        int size = this.size;
        int i = offset;
        while (i > bound) {
            data[size++] = elements[i];
            --i;
        }
        this.size = size;
        return -length;
    }

    @Override
    protected int internalCountingPutAll(XGettingCollection<? extends E> elements) throws UnsupportedOperationException {
        if (elements instanceof AbstractSimpleArrayCollection) {
            return this.internalCountingAddAll(AbstractSimpleArrayCollection.internalGetStorageArray((AbstractSimpleArrayCollection)((Object)elements)), 0, XTypes.to_int(elements.size()));
        }
        int oldSize = this.size;
        elements.iterate(this);
        return this.size - oldSize;
    }

    @Override
    public Equalator<? super E> equality() {
        return this.equalator;
    }

    @Override
    public EqBulkList<E> copy() {
        return new EqBulkList<E>(this);
    }

    @Override
    public EqConstList<E> immure() {
        return new EqConstList<E>(this.equalator, this);
    }

    @Override
    public EqBulkList<E> toReversed() {
        E[] data = this.data;
        E[] reversedData = EqBulkList.newArray(this.data.length);
        int i = this.size;
        int r = 0;
        while (i-- > 0) {
            reversedData[r++] = data[i];
        }
        return new EqBulkList<E>(this.equalator, reversedData, this.size);
    }

    @Override
    public E[] toArray(Class<E> type) {
        E[] array = X.Array(type, this.size);
        System.arraycopy(this.data, 0, array, 0, this.size);
        return array;
    }

    @Override
    public final <P extends Consumer<? super E>> P iterate(P procedure) {
        AbstractArrayStorage.iterate(this.data, this.size, procedure);
        return procedure;
    }

    @Override
    public final <P extends IndexedAcceptor<? super E>> P iterateIndexed(P procedure) {
        AbstractArrayStorage.iterate(this.data, this.size, procedure);
        return procedure;
    }

    @Override
    public final <A> A join(BiConsumer<? super E, ? super A> joiner, A aggregate) {
        AbstractArrayStorage.join(this.data, this.size, joiner, aggregate);
        return aggregate;
    }

    @Override
    public long count(E element) {
        return AbstractArrayStorage.forwardConditionalCount(this.data, 0, this.size, new IsCustomEqual<E>(this.equalator, element));
    }

    @Override
    public long countBy(Predicate<? super E> predicate) {
        return AbstractArrayStorage.forwardConditionalCount(this.data, 0, this.size, predicate);
    }

    @Override
    public long indexOf(E element) {
        return AbstractArrayStorage.forwardConditionalIndexOf(this.data, 0, this.size, new IsCustomEqual<E>(this.equalator, element));
    }

    @Override
    public long indexBy(Predicate<? super E> predicate) {
        return AbstractArrayStorage.forwardConditionalIndexOf(this.data, 0, this.size, predicate);
    }

    @Override
    public long lastIndexOf(E element) {
        return AbstractArrayStorage.reverseConditionalIndexOf(this.data, this.size - 1, 0, new IsCustomEqual<E>(this.equalator, element));
    }

    @Override
    public long lastIndexBy(Predicate<? super E> predicate) {
        return AbstractArrayStorage.lastIndexOf(this.data, this.size, predicate);
    }

    @Override
    public long maxIndex(Comparator<? super E> comparator) {
        return AbstractArrayStorage.maxIndex(this.data, this.size, comparator);
    }

    @Override
    public long minIndex(Comparator<? super E> comparator) {
        return AbstractArrayStorage.minIndex(this.data, this.size, comparator);
    }

    @Override
    public long scan(Predicate<? super E> predicate) {
        return AbstractArrayStorage.forwardScan(this.data, 0, this.size, predicate);
    }

    @Override
    public E get() {
        return this.data[0];
    }

    @Override
    public E first() {
        return this.data[0];
    }

    @Override
    public E last() {
        return this.data[this.size - 1];
    }

    @Override
    public E poll() {
        return this.size == 0 ? null : (E)this.data[0];
    }

    @Override
    public E peek() {
        return this.size == 0 ? null : (E)this.data[this.size - 1];
    }

    @Override
    public E seek(E sample) {
        return AbstractArrayStorage.forwardQueryElement(this.data, 0, this.size, new IsCustomEqual<E>(this.equalator, sample), null);
    }

    @Override
    public E search(Predicate<? super E> predicate) {
        return AbstractArrayStorage.forwardQueryElement(this.data, 0, this.size, predicate, null);
    }

    @Override
    public E max(Comparator<? super E> comparator) {
        return AbstractArrayStorage.max(this.data, this.size, comparator);
    }

    @Override
    public E min(Comparator<? super E> comparator) {
        return AbstractArrayStorage.min(this.data, this.size, comparator);
    }

    @Override
    public boolean hasVolatileElements() {
        return false;
    }

    @Override
    public boolean nullAllowed() {
        return true;
    }

    @Override
    public boolean isSorted(Comparator<? super E> comparator) {
        return AbstractArrayStorage.isSorted(this.data, this.size, comparator);
    }

    @Override
    public boolean containsSearched(Predicate<? super E> predicate) {
        return AbstractArrayStorage.forwardContains(this.data, 0, this.size, predicate);
    }

    @Override
    public boolean applies(Predicate<? super E> predicate) {
        return AbstractArrayStorage.forwardApplies(this.data, 0, this.size, predicate);
    }

    @Override
    public boolean nullContained() {
        return AbstractArrayStorage.forwardNullContained(this.data, 0, this.size);
    }

    @Override
    public boolean containsId(E element) {
        return AbstractArrayStorage.forwardContainsSame(this.data, 0, this.size, element);
    }

    @Override
    public boolean contains(E element) {
        return AbstractArrayStorage.forwardContains(this.data, 0, this.size, new IsCustomEqual<E>(this.equalator, element));
    }

    @Override
    public boolean containsAll(XGettingCollection<? extends E> elements) {
        return AbstractArrayStorage.containsAll(this.data, this.size, elements, this.equalator);
    }

    @Override
    public boolean equals(XGettingCollection<? extends E> samples, Equalator<? super E> equalator) {
        if (samples == null || !(samples instanceof EqBulkList) || XTypes.to_int(samples.size()) != this.size) {
            return false;
        }
        if (samples == this) {
            return true;
        }
        return XArrays.equals(this.data, 0, ((EqBulkList)samples).data, 0, this.size, equalator);
    }

    @Override
    public boolean equalsContent(XGettingCollection<? extends E> samples, Equalator<? super E> equalator) {
        if (samples == null || XTypes.to_int(samples.size()) != this.size) {
            return false;
        }
        if (samples == this) {
            return true;
        }
        return AbstractArrayStorage.equalsContent(this.data, this.size, samples, equalator);
    }

    @Override
    public <C extends Consumer<? super E>> C intersect(XGettingCollection<? extends E> samples, Equalator<? super E> equalator, C target) {
        return AbstractArrayStorage.intersect(this.data, this.size, samples, equalator, target);
    }

    @Override
    public <C extends Consumer<? super E>> C except(XGettingCollection<? extends E> samples, Equalator<? super E> equalator, C target) {
        return AbstractArrayStorage.except(this.data, this.size, samples, equalator, target);
    }

    @Override
    public <C extends Consumer<? super E>> C union(XGettingCollection<? extends E> samples, Equalator<? super E> equalator, C target) {
        return AbstractArrayStorage.union(this.data, this.size, samples, equalator, target);
    }

    @Override
    public <C extends Consumer<? super E>> C copyTo(C target) {
        return AbstractArrayStorage.forwardCopyTo(this.data, 0, this.size, target);
    }

    @Override
    public <C extends Consumer<? super E>> C filterTo(C target, Predicate<? super E> predicate) {
        return AbstractArrayStorage.forwardCopyTo(this.data, 0, this.size, target, predicate);
    }

    @Override
    public <C extends Consumer<? super E>> C distinct(C target) {
        return AbstractArrayStorage.distinct(this.data, this.size, target);
    }

    @Override
    public <C extends Consumer<? super E>> C distinct(C target, Equalator<? super E> equalator) {
        return AbstractArrayStorage.distinct(this.data, this.size, target, equalator);
    }

    @Override
    public <C extends Consumer<? super E>> C copySelection(C target, long ... indices) {
        return AbstractArrayStorage.copySelection(this.data, this.size, indices, target);
    }

    @Override
    public ListView<E> view() {
        return new ListView(this);
    }

    @Override
    public SubListView<E> view(long fromIndex, long toIndex) {
        return new SubListView(this, fromIndex, toIndex);
    }

    @Override
    public EqBulkList<E> shiftTo(long sourceIndex, long targetIndex) {
        if (sourceIndex >= (long)this.size) {
            throw new IndexBoundsException((long)this.size, sourceIndex);
        }
        if (targetIndex >= (long)this.size) {
            throw new IndexBoundsException((long)this.size, targetIndex);
        }
        if (sourceIndex == targetIndex) {
            if (sourceIndex < 0L) {
                throw new IndexBoundsException((long)this.size, sourceIndex);
            }
            return this;
        }
        E shiftling = this.data[(int)sourceIndex];
        if (sourceIndex < targetIndex) {
            System.arraycopy(this.data, (int)sourceIndex + 1, this.data, (int)sourceIndex, X.checkArrayRange(targetIndex - sourceIndex));
        } else {
            System.arraycopy(this.data, (int)targetIndex, this.data, (int)targetIndex + 1, X.checkArrayRange(sourceIndex - targetIndex));
        }
        this.data[(int)targetIndex] = shiftling;
        return this;
    }

    @Override
    public EqBulkList<E> shiftTo(long sourceIndex, long targetIndex, long length) {
        if (sourceIndex + length >= (long)this.size) {
            throw new IndexBoundsException((long)this.size, sourceIndex);
        }
        if (targetIndex + length >= (long)this.size) {
            throw new IndexBoundsException((long)this.size, targetIndex);
        }
        if (sourceIndex == targetIndex) {
            if (sourceIndex < 0L) {
                throw new IndexBoundsException((long)this.size, sourceIndex);
            }
            return this;
        }
        E[] shiftlings = EqBulkList.newArray(X.checkArrayRange(length));
        System.arraycopy(this.data, (int)sourceIndex, shiftlings, 0, (int)length);
        if (sourceIndex < targetIndex) {
            System.arraycopy(this.data, X.checkArrayRange(sourceIndex + length), this.data, (int)sourceIndex, X.checkArrayRange(targetIndex - sourceIndex));
        } else {
            System.arraycopy(this.data, (int)targetIndex, this.data, X.checkArrayRange(targetIndex + length), X.checkArrayRange(sourceIndex - targetIndex));
        }
        System.arraycopy(shiftlings, 0, this.data, (int)targetIndex, (int)length);
        return this;
    }

    @Override
    public EqBulkList<E> shiftBy(long sourceIndex, long distance) {
        return this.shiftTo(sourceIndex, sourceIndex + distance);
    }

    @Override
    public EqBulkList<E> shiftBy(long sourceIndex, long distance, long length) {
        return this.shiftTo(sourceIndex, sourceIndex + distance, length);
    }

    @Override
    public EqBulkList<E> swap(long indexA, long indexB) throws IndexOutOfBoundsException, ArrayIndexOutOfBoundsException {
        if (indexA >= (long)this.size) {
            throw new IndexBoundsException((long)this.size, indexA);
        }
        if (indexB >= (long)this.size) {
            throw new IndexBoundsException((long)this.size, indexB);
        }
        E e = this.data[(int)indexA];
        this.data[(int)indexA] = this.data[(int)indexB];
        this.data[(int)indexB] = e;
        return this;
    }

    @Override
    public EqBulkList<E> swap(long indexA, long indexB, long length) {
        AbstractArrayStorage.swap(this.data, this.size, X.checkArrayRange(indexA), X.checkArrayRange(indexB), X.checkArrayRange(length));
        return this;
    }

    @Override
    public EqBulkList<E> reverse() {
        AbstractArrayStorage.reverse(this.data, this.size);
        return this;
    }

    @Override
    public void setFirst(E element) {
        this.data[0] = element;
    }

    @Override
    public void setLast(E element) {
        this.data[this.size - 1] = element;
    }

    @Override
    @SafeVarargs
    public final EqBulkList<E> setAll(long offset, E ... elements) {
        if (offset < 0L || offset + (long)elements.length > (long)this.size) {
            throw new IndexOutOfBoundsException(EqBulkList.exceptionStringRange(this.size, offset, offset + (long)elements.length - 1L));
        }
        System.arraycopy(elements, 0, this.data, X.checkArrayRange(offset), elements.length);
        return this;
    }

    @Override
    public EqBulkList<E> set(long offset, E[] src, int srcIndex, int srcLength) {
        AbstractArrayStorage.set(this.data, this.size, X.checkArrayRange(offset), src, srcIndex, srcLength);
        return this;
    }

    @Override
    public EqBulkList<E> set(long offset, XGettingSequence<? extends E> elements, long elementsOffset, long elementsLength) {
        AbstractArrayStorage.set(this.data, this.size, X.checkArrayRange(offset), elements, elementsOffset, elementsLength);
        return this;
    }

    @Override
    public EqBulkList<E> fill(long offset, long length, E element) {
        AbstractArrayStorage.fill(this.data, this.size, X.checkArrayRange(offset), X.checkArrayRange(length), element);
        return this;
    }

    @Override
    public EqBulkList<E> sort(Comparator<? super E> comparator) {
        XSort.mergesort(this.data, 0, this.size, comparator);
        return this;
    }

    @Override
    public boolean replaceOne(E element, E replacement) {
        return AbstractArrayStorage.replaceOne(this.data, this.size, element, replacement, this.equalator);
    }

    @Override
    public boolean replaceOne(Predicate<? super E> predicate, E substitute) {
        return AbstractArrayStorage.substituteOne(this.data, this.size, predicate, substitute);
    }

    @Override
    public long replace(E element, E replacement) {
        return AbstractArrayStorage.replace(this.data, this.size, element, replacement, this.equalator);
    }

    @Override
    public long replace(Predicate<? super E> predicate, E substitute) {
        return AbstractArrayStorage.substitute(this.data, this.size, predicate, substitute);
    }

    @Override
    public long replaceAll(XGettingCollection<? extends E> elements, E replacement) {
        return AbstractArrayStorage.replaceAll(this.data, this.size, elements, replacement, this.equalator, AbstractArrayCollection.marker());
    }

    @Override
    public long substitute(Function<? super E, ? extends E> mapper) {
        return AbstractArrayStorage.substitute(this.data, this.size, mapper);
    }

    @Override
    public long substitute(Predicate<? super E> predicate, Function<E, E> mapper) {
        return AbstractArrayStorage.substitute(this.data, this.size, predicate, mapper);
    }

    @Override
    public long currentCapacity() {
        return this.data.length;
    }

    @Override
    public long maximumCapacity() {
        return Integer.MAX_VALUE;
    }

    @Override
    public boolean isFull() {
        return this.size >= Integer.MAX_VALUE;
    }

    @Override
    public long remainingCapacity() {
        return Integer.MAX_VALUE - this.size;
    }

    @Override
    public long optimize() {
        int requiredCapacity = XMath.pow2BoundMaxed(this.size);
        if (requiredCapacity != this.data.length) {
            this.data = EqBulkList.newArray(requiredCapacity);
            System.arraycopy(this.data, 0, this.data, 0, this.size);
        }
        return this.data.length;
    }

    @Override
    public EqBulkList<E> ensureFreeCapacity(long requiredFreeCapacity) {
        int newCapacity;
        if ((long)(this.data.length - this.size) >= requiredFreeCapacity) {
            return this;
        }
        int newSize = XTypes.to_int((long)this.size + requiredFreeCapacity);
        if (XMath.isGreaterThanHighestPowerOf2(newSize)) {
            newCapacity = Integer.MAX_VALUE;
        } else {
            newCapacity = this.data.length;
            while (newCapacity < newSize) {
                newCapacity <<= 1;
            }
        }
        E[] data = EqBulkList.newArray(newCapacity);
        System.arraycopy(this.data, 0, data, 0, this.size);
        this.data = data;
        return this;
    }

    @Override
    public EqBulkList<E> ensureCapacity(long minCapacity) {
        if (minCapacity > (long)this.data.length) {
            this.data = EqBulkList.newArray(EqBulkList.pow2BoundMaxed(minCapacity), this.data, this.size);
        }
        return this;
    }

    @Override
    public void accept(E element) {
        this.internalAdd(element);
    }

    @Override
    public boolean add(E element) {
        this.internalAdd(element);
        return true;
    }

    @Override
    @SafeVarargs
    public final EqBulkList<E> addAll(E ... elements) {
        this.ensureFreeCapacity(elements.length);
        System.arraycopy(elements, 0, this.data, this.size, elements.length);
        this.size += elements.length;
        return this;
    }

    @Override
    public EqBulkList<E> addAll(E[] elements, int offset, int length) {
        if (length >= 0) {
            this.ensureFreeCapacity(length);
            System.arraycopy(elements, offset, this.data, this.size, length);
            this.size += length;
        } else {
            int bound = length + length;
            if (bound < -1) {
                throw new ArrayIndexOutOfBoundsException(bound + 1);
            }
            this.ensureFreeCapacity(-length);
            E[] data = this.data;
            int size = this.size;
            int i = length;
            while (i > bound) {
                data[size++] = elements[i];
                --i;
            }
            this.size = size;
        }
        return this;
    }

    @Override
    public EqBulkList<E> addAll(XGettingCollection<? extends E> elements) {
        if (elements instanceof AbstractSimpleArrayCollection) {
            return this.addAll((Object[])AbstractSimpleArrayCollection.internalGetStorageArray((AbstractSimpleArrayCollection)((Object)elements)), 0, XTypes.to_int(elements.size()));
        }
        return elements.iterate(this);
    }

    @Override
    public boolean nullAdd() {
        if (this.size >= this.data.length) {
            if (this.size >= Integer.MAX_VALUE) {
                throw new IndexOutOfBoundsException();
            }
            this.data = EqBulkList.newArray((int)((float)this.data.length * 2.0f));
            System.arraycopy(this.data, 0, this.data, 0, this.size);
        }
        ++this.size;
        return true;
    }

    @Override
    public boolean nullPut() {
        return this.nullAdd();
    }

    @Override
    public boolean put(E element) {
        this.internalAdd(element);
        return true;
    }

    @Override
    @SafeVarargs
    public final EqBulkList<E> putAll(E ... elements) {
        return this.addAll((Object[])elements);
    }

    @Override
    public EqBulkList<E> putAll(E[] elements, int offset, int length) {
        return this.addAll((Object[])elements, offset, length);
    }

    @Override
    public EqBulkList<E> putAll(XGettingCollection<? extends E> elements) {
        return elements.iterate(this);
    }

    @Override
    public boolean prepend(E element) {
        if (this.size >= this.data.length) {
            if (this.size >= Integer.MAX_VALUE) {
                throw new IndexOutOfBoundsException();
            }
            this.data = EqBulkList.newArray((int)((float)this.data.length * 2.0f));
            System.arraycopy(this.data, 0, this.data, 1, this.size);
        } else {
            System.arraycopy(this.data, 0, this.data, 1, this.size);
        }
        this.data[0] = element;
        ++this.size;
        return true;
    }

    @Override
    @SafeVarargs
    public final EqBulkList<E> prependAll(E ... elements) {
        this.internalInputArray(0, elements, elements.length);
        return this;
    }

    @Override
    public EqBulkList<E> prependAll(E[] elements, int offset, int length) {
        this.internalInputArray(0, elements, offset, length);
        return this;
    }

    @Override
    public EqBulkList<E> prependAll(XGettingCollection<? extends E> elements) {
        this.insertAll(0L, elements);
        return this;
    }

    @Override
    public boolean nullPrepend() {
        if (this.size >= this.data.length) {
            if (this.size >= Integer.MAX_VALUE) {
                throw new IndexOutOfBoundsException();
            }
            this.data = EqBulkList.newArray((int)((float)this.data.length * 2.0f));
            System.arraycopy(this.data, 0, this.data, 0, this.size);
        } else {
            System.arraycopy(this.data, 0, this.data, 1, this.size);
        }
        this.data[0] = null;
        ++this.size;
        return true;
    }

    @Override
    public boolean preput(E element) {
        if (this.size >= this.data.length) {
            if (this.size >= Integer.MAX_VALUE) {
                throw new IndexOutOfBoundsException();
            }
            this.data = EqBulkList.newArray((int)((float)this.data.length * 2.0f));
            System.arraycopy(this.data, 0, this.data, 0, this.size);
        } else {
            System.arraycopy(this.data, 0, this.data, 1, this.size);
        }
        this.data[0] = element;
        ++this.size;
        return true;
    }

    @Override
    @SafeVarargs
    public final EqBulkList<E> preputAll(E ... elements) {
        this.internalInputArray(0, elements, elements.length);
        return this;
    }

    @Override
    public EqBulkList<E> preputAll(E[] elements, int offset, int length) {
        this.internalInputArray(0, elements, offset, length);
        return this;
    }

    @Override
    public EqBulkList<E> preputAll(XGettingCollection<? extends E> elements) {
        this.inputAll(0L, elements);
        return this;
    }

    @Override
    public boolean nullPreput() {
        if (this.size >= this.data.length) {
            if (this.size >= Integer.MAX_VALUE) {
                throw new IndexOutOfBoundsException();
            }
            this.data = EqBulkList.newArray((int)((float)this.data.length * 2.0f));
            System.arraycopy(this.data, 0, this.data, 0, this.size);
        } else {
            System.arraycopy(this.data, 0, this.data, 1, this.size);
        }
        this.data[0] = null;
        ++this.size;
        return true;
    }

    @Override
    public boolean insert(long index, E element) {
        if (this.size >= Integer.MAX_VALUE) {
            throw new ArrayCapacityException();
        }
        if (index >= (long)this.size || index < 0L) {
            if (index == (long)this.size) {
                if (this.size >= this.data.length) {
                    if (this.size >= Integer.MAX_VALUE) {
                        throw new IndexOutOfBoundsException();
                    }
                    this.data = EqBulkList.newArray((int)((float)this.data.length * 2.0f));
                    System.arraycopy(this.data, 0, this.data, 0, this.size);
                }
                this.data[this.size++] = element;
                return true;
            }
            throw new IndexBoundsException((long)this.size, index);
        }
        if (this.size >= this.data.length) {
            if (this.size >= Integer.MAX_VALUE) {
                throw new IndexOutOfBoundsException();
            }
            E[] oldData = this.data;
            this.data = EqBulkList.newArray((int)((float)this.data.length * 2.0f));
            System.arraycopy(this.data, 0, this.data, 0, (int)index);
            System.arraycopy(oldData, (int)index, this.data, (int)index + 1, this.size - (int)index);
        } else {
            System.arraycopy(this.data, (int)index, this.data, (int)index + 1, this.size - (int)index);
        }
        this.data[(int)index] = element;
        ++this.size;
        return true;
    }

    @Override
    @SafeVarargs
    public final long insertAll(long index, E ... elements) throws IndexOutOfBoundsException {
        if (index >= (long)this.size || index < 0L) {
            if (index == (long)this.size) {
                return this.internalCountingAddAll(elements);
            }
            throw new IndexBoundsException((long)this.size, index);
        }
        return this.internalInputArray((int)index, elements, elements.length);
    }

    @Override
    public long insertAll(long index, E[] elements, int offset, int length) {
        if (index >= (long)this.size || index < 0L) {
            if (index == (long)this.size) {
                return this.internalCountingAddAll(elements, offset, length);
            }
            throw new IndexBoundsException((long)this.size, index);
        }
        return this.internalInputArray((int)index, elements, offset, length);
    }

    @Override
    public long insertAll(long index, XGettingCollection<? extends E> elements) {
        if (index >= (long)this.size || index < 0L) {
            if (index == (long)this.size) {
                return this.internalCountingAddAll(elements);
            }
            throw new IndexBoundsException((long)this.size, index);
        }
        Object[] elementsToAdd = elements instanceof AbstractSimpleArrayCollection ? AbstractSimpleArrayCollection.internalGetStorageArray((AbstractSimpleArrayCollection)((Object)elements)) : elements.toArray();
        return this.internalInputArray((int)index, elementsToAdd, elementsToAdd.length);
    }

    @Override
    public boolean nullInsert(long index) {
        return this.insert(0L, null);
    }

    @Override
    public boolean input(long index, E element) {
        if (this.size >= Integer.MAX_VALUE) {
            throw new ArrayCapacityException();
        }
        if (index >= (long)this.size || index < 0L) {
            if (index == (long)this.size) {
                if (this.size >= this.data.length) {
                    if (this.size >= Integer.MAX_VALUE) {
                        throw new IndexOutOfBoundsException();
                    }
                    this.data = EqBulkList.newArray((int)((float)this.data.length * 2.0f));
                    System.arraycopy(this.data, 0, this.data, 0, this.size);
                }
                this.data[this.size++] = element;
                return true;
            }
            throw new IndexBoundsException((long)this.size, index);
        }
        if (this.size >= this.data.length) {
            if (this.size >= Integer.MAX_VALUE) {
                throw new IndexOutOfBoundsException();
            }
            E[] oldData = this.data;
            this.data = EqBulkList.newArray((int)((float)this.data.length * 2.0f));
            System.arraycopy(this.data, 0, this.data, 0, (int)index);
            System.arraycopy(oldData, (int)index, this.data, (int)index + 1, this.size - (int)index);
        } else {
            System.arraycopy(this.data, (int)index, this.data, (int)index + 1, this.size - (int)index);
        }
        this.data[(int)index] = element;
        ++this.size;
        return true;
    }

    @Override
    @SafeVarargs
    public final long inputAll(long index, E ... elements) throws IndexOutOfBoundsException {
        if (index >= (long)this.size || index < 0L) {
            if (index == (long)this.size) {
                return this.internalCountingPutAll(elements);
            }
            throw new IndexBoundsException((long)this.size, index);
        }
        return this.internalInputArray((int)index, elements, elements.length);
    }

    @Override
    public long inputAll(long index, E[] elements, int offset, int length) {
        if (index >= (long)this.size || index < 0L) {
            if (index == (long)this.size) {
                return this.internalCountingPutAll(elements, offset, length);
            }
            throw new IndexBoundsException((long)this.size, index);
        }
        return this.internalInputArray((int)index, elements, offset, length);
    }

    @Override
    public long inputAll(long index, XGettingCollection<? extends E> elements) {
        if (index >= (long)this.size || index < 0L) {
            if (index == (long)this.size) {
                return this.internalCountingPutAll(elements);
            }
            throw new IndexBoundsException((long)this.size, index);
        }
        Object[] elementsToAdd = elements instanceof AbstractSimpleArrayCollection ? AbstractSimpleArrayCollection.internalGetStorageArray((AbstractSimpleArrayCollection)((Object)elements)) : elements.toArray();
        return this.internalInputArray((int)index, elementsToAdd, elementsToAdd.length);
    }

    @Override
    public boolean nullInput(long index) {
        return this.input(0L, null);
    }

    @Override
    public void truncate() {
        this.size = 0;
        this.data = EqBulkList.newArray(1);
    }

    @Override
    public long consolidate() {
        return 0L;
    }

    @Override
    public boolean removeOne(E element) {
        if (AbstractArrayStorage.removeOne(this.data, this.size, element, this.equalator)) {
            --this.size;
            return true;
        }
        return false;
    }

    @Override
    public E retrieve(E element) {
        E removedElement = AbstractArrayStorage.retrieve(this.data, this.size, element, this.equalator, AbstractArrayCollection.marker());
        if (removedElement != AbstractArrayCollection.marker()) {
            --this.size;
            return removedElement;
        }
        return null;
    }

    @Override
    public E retrieveBy(Predicate<? super E> predicate) {
        E e = AbstractArrayStorage.retrieve(this.data, this.size, predicate, AbstractArrayCollection.marker());
        if (e != AbstractArrayCollection.marker()) {
            --this.size;
            return e;
        }
        return null;
    }

    @Override
    public long remove(E element) {
        int removeCount = XArrays.removeAllFromArray(this.data, 0, this.size, element, this.equalator);
        this.size -= removeCount;
        return removeCount;
    }

    @Override
    public long nullRemove() {
        int removeCount = XArrays.removeAllFromArray(this.data, 0, this.size, null);
        this.size -= removeCount;
        return removeCount;
    }

    @Override
    public E removeAt(long index) throws IndexOutOfBoundsException, ArrayIndexOutOfBoundsException {
        if (index >= (long)this.size) {
            throw new IndexBoundsException((long)this.size, index);
        }
        E oldValue = this.data[(int)index];
        int moveCount = this.size - 1 - (int)index;
        if (moveCount > 0) {
            System.arraycopy(this.data, (int)index + 1, this.data, (int)index, moveCount);
        }
        this.data[--this.size] = null;
        return oldValue;
    }

    @Override
    public long removeBy(Predicate<? super E> predicate) {
        int removeCount = AbstractArrayStorage.reduce(this.data, this.size, predicate, AbstractArrayCollection.marker());
        this.size -= removeCount;
        return removeCount;
    }

    @Override
    public long retainAll(XGettingCollection<? extends E> elements) {
        int removeCount = AbstractArrayStorage.retainAll(this.data, this.size, elements, this.equalator, AbstractArrayCollection.marker());
        this.size -= removeCount;
        return removeCount;
    }

    @Override
    public final <P extends Consumer<? super E>> P process(P procedure) {
        this.size -= AbstractArrayStorage.process(this.data, this.size, procedure, AbstractArrayCollection.marker());
        return procedure;
    }

    @Override
    public <C extends Consumer<? super E>> C moveTo(C target, Predicate<? super E> predicate) {
        this.size -= AbstractArrayStorage.moveTo(this.data, this.size, target, predicate, AbstractArrayCollection.marker());
        return target;
    }

    @Override
    public <C extends Consumer<? super E>> C moveSelection(C target, long ... indices) {
        this.size -= AbstractArrayStorage.moveSelection(this.data, this.size, indices, target, AbstractArrayCollection.marker());
        return target;
    }

    @Override
    public long removeAll(XGettingCollection<? extends E> elements) {
        int removed = XArrays.removeAllFromArray(this.data, 0, this.size, elements, this.equalator);
        this.size -= removed;
        return removed;
    }

    @Override
    public long removeDuplicates(Equalator<? super E> equalator) {
        int removeCount = AbstractArrayStorage.removeDuplicates(this.data, this.size, equalator, AbstractArrayCollection.marker());
        this.size -= removeCount;
        return removeCount;
    }

    @Override
    public long removeDuplicates() {
        int removeCount = AbstractArrayStorage.removeDuplicates(this.data, this.size, this.equalator, AbstractArrayCollection.marker());
        this.size -= removeCount;
        return removeCount;
    }

    @Override
    public E fetch() {
        E element = this.data[0];
        System.arraycopy(this.data, 1, this.data, 0, --this.size);
        this.data[this.size] = null;
        return element;
    }

    @Override
    public E pop() {
        E element = this.data[this.size - 1];
        this.data[--this.size] = null;
        return element;
    }

    @Override
    public E pinch() {
        if (this.size == 0) {
            return null;
        }
        E element = this.data[0];
        System.arraycopy(this.data, 1, this.data, 0, --this.size);
        this.data[this.size] = null;
        return element;
    }

    @Override
    public E pick() {
        if (this.size == 0) {
            return null;
        }
        E element = this.data[--this.size];
        this.data[this.size] = null;
        return element;
    }

    @Override
    public long removeSelection(long[] indices) {
        int removeCount = AbstractArrayStorage.removeSelection(this.data, this.size, indices, AbstractArrayCollection.marker());
        this.size -= removeCount;
        return removeCount;
    }

    @Override
    public EqBulkList<E> removeRange(long startIndex, long length) {
        this.size -= AbstractArrayStorage.removeRange(this.data, this.size, X.checkArrayRange(startIndex), X.checkArrayRange(length));
        return this;
    }

    @Override
    public EqBulkList<E> retainRange(long startIndex, long length) {
        AbstractArrayStorage.retainRange(this.data, this.size, X.checkArrayRange(startIndex), X.checkArrayRange(length));
        this.size = (int)length;
        return this;
    }

    @Override
    public boolean isEmpty() {
        return this.size == 0;
    }

    @Override
    public Iterator<E> iterator() {
        return new GenericListIterator(this);
    }

    @Override
    public ListIterator<E> listIterator() {
        return new GenericListIterator(this);
    }

    @Override
    public ListIterator<E> listIterator(long index) {
        EqBulkList.validateIndex(this.size, index);
        return new GenericListIterator(this, (int)index);
    }

    @Override
    public boolean set(long index, E element) throws IndexOutOfBoundsException, ArrayIndexOutOfBoundsException {
        if (index >= (long)this.size) {
            throw new IndexBoundsException((long)this.size, index);
        }
        this.data[(int)index] = element;
        return false;
    }

    @Override
    public E setGet(long index, E element) throws IndexOutOfBoundsException, ArrayIndexOutOfBoundsException {
        if (index >= (long)this.size) {
            throw new IndexBoundsException((long)this.size, index);
        }
        E old = this.data[(int)index];
        this.data[(int)index] = element;
        return old;
    }

    @Override
    public long size() {
        return this.size;
    }

    @Override
    public SubList<E> range(long fromIndex, long toIndex) {
        return new SubList(this, fromIndex, toIndex);
    }

    public String toString() {
        return AbstractArrayStorage.toString(this.data, this.size);
    }

    @Override
    public Object[] toArray() {
        Object[] array = EqBulkList.newArray(this.size);
        System.arraycopy(this.data, 0, array, 0, this.size);
        return array;
    }

    @Override
    public E at(long index) throws ArrayIndexOutOfBoundsException {
        if (index >= (long)this.size) {
            throw new IndexBoundsException((long)this.size, index);
        }
        return this.data[(int)index];
    }

    @Override
    public void clear() {
        E[] data = this.data;
        int i = this.size;
        while (i-- > 0) {
            data[i] = null;
        }
        this.size = 0;
    }

    @Override
    @Deprecated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o == null || !(o instanceof List)) {
            return false;
        }
        List list = (List)o;
        if (this.size != list.size()) {
            return false;
        }
        E[] data = this.data;
        int i = 0;
        for (Object e2 : list) {
            E e1;
            if (!((e1 = data[i++]) == null ? e2 != null : !e1.equals(e2))) continue;
            return false;
        }
        return true;
    }

    @Override
    @Deprecated
    public int hashCode() {
        return XArrays.arrayHashCode(this.data, this.size);
    }

    @Override
    public OldBulkList<E> old() {
        return new OldBulkList(this);
    }

    public static class Creator<E>
    implements XList.Creator<E> {
        private final int initialCapacity;
        private final Equalator<? super E> equalator;

        public Creator(Equalator<? super E> equalator, int initialCapacity) {
            this.initialCapacity = XMath.pow2BoundMaxed(initialCapacity);
            this.equalator = equalator;
        }

        public int getInitialCapacity() {
            return this.initialCapacity;
        }

        public Equalator<? super E> getEqualator() {
            return this.equalator;
        }

        @Override
        public EqBulkList<E> newInstance() {
            return new EqBulkList<E>(this.equalator, AbstractArrayCollection.newArray(this.initialCapacity), this.initialCapacity);
        }
    }

    public static final class OldBulkList<E>
    extends AbstractBridgeXList<E> {
        OldBulkList(EqBulkList<E> list) {
            super(list);
        }

        @Override
        public EqBulkList<E> parent() {
            return (EqBulkList)super.parent();
        }
    }
}

