/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.serializer.collections;

import java.util.Comparator;
import java.util.Iterator;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Predicate;
import org.eclipse.serializer.chars.VarString;
import org.eclipse.serializer.collections.AbstractChainCollection;
import org.eclipse.serializer.collections.AbstractChainEntryLinked;
import org.eclipse.serializer.collections.AbstractChainStorage;
import org.eclipse.serializer.collections.ChainEntryLinkedStrong;
import org.eclipse.serializer.collections.ChainStorageStrong;
import org.eclipse.serializer.collections.EnumView;
import org.eclipse.serializer.collections.interfaces.ChainStorage;
import org.eclipse.serializer.collections.interfaces.HashCollection;
import org.eclipse.serializer.collections.old.OldSet;
import org.eclipse.serializer.collections.types.XGettingCollection;
import org.eclipse.serializer.collections.types.XGettingEnum;
import org.eclipse.serializer.collections.types.XImmutableEnum;
import org.eclipse.serializer.equality.Equalator;
import org.eclipse.serializer.equality.IdentityEqualityLogic;
import org.eclipse.serializer.functional.IndexedAcceptor;
import org.eclipse.serializer.hashing.HashEqualator;
import org.eclipse.serializer.hashing.XHashing;
import org.eclipse.serializer.meta.NotImplementedYetError;
import org.eclipse.serializer.typing.Composition;
import org.eclipse.serializer.typing.Copyable;
import org.eclipse.serializer.typing.XTypes;

public final class ConstHashEnum<E>
extends AbstractChainCollection<E, E, E, ChainEntryLinkedStrong<E>>
implements XImmutableEnum<E>,
HashCollection<E>,
Composition,
IdentityEqualityLogic {
    private final AbstractChainStorage<E, E, E, ChainEntryLinkedStrong<E>> chain;
    ChainEntryLinkedStrong<E>[] slots;
    float hashDensity;
    transient int capacity;
    transient int range;
    int size;

    public static final <E> ConstHashEnum<E> New() {
        return new ConstHashEnum<E>(1, 1.0f);
    }

    public static final <E> ConstHashEnum<E> NewCustom(int initialCapacity) {
        return new ConstHashEnum<E>(XHashing.padHashLength(initialCapacity), 1.0f);
    }

    public static final <E> ConstHashEnum<E> NewCustom(int initialCapacity, float hashDensity) {
        return new ConstHashEnum<E>(XHashing.padHashLength(initialCapacity), XHashing.validateHashDensity(hashDensity));
    }

    public static final <E> ConstHashEnum<E> NewCustom(float hashDensity, XGettingCollection<? extends E> entries) {
        ConstHashEnum<E> newEnum = new ConstHashEnum<E>(XHashing.padHashLength(entries.size()), XHashing.validateHashDensity(hashDensity));
        newEnum.internalAddAll(entries);
        return newEnum;
    }

    @SafeVarargs
    public static final <E> ConstHashEnum<E> NewCustom(float hashDensity, E ... entries) {
        ConstHashEnum<E> newEnum = new ConstHashEnum<E>(XHashing.calculateHashLength(entries.length, hashDensity), XHashing.validateHashDensity(hashDensity));
        E[] EArray = entries;
        int n = entries.length;
        int n2 = 0;
        while (n2 < n) {
            E e = EArray[n2];
            newEnum.internalAdd(e);
            ++n2;
        }
        return newEnum;
    }

    public static final <E> ConstHashEnum<E> New(XGettingCollection<? extends E> entries) {
        return ConstHashEnum.NewCustom(1.0f, entries);
    }

    @SafeVarargs
    public static final <E> ConstHashEnum<E> New(E ... entries) {
        return ConstHashEnum.NewCustom(1.0f, entries);
    }

    private ConstHashEnum(ConstHashEnum<E> original) {
        this.hashDensity = original.hashDensity;
        this.range = original.range;
        this.slots = ChainEntryLinkedStrong.array(original.slots.length);
        this.chain = new ChainStorageStrong<E, E, E, ChainEntryLinkedStrong<Object>>(this, new ChainEntryLinkedStrong<Object>(null, null));
        this.capacity = original.capacity;
    }

    private ConstHashEnum(int pow2InitialHashLength, float positiveHashDensity) {
        this.hashDensity = positiveHashDensity;
        this.range = pow2InitialHashLength - 1;
        this.slots = ChainEntryLinkedStrong.array(pow2InitialHashLength);
        this.chain = new ChainStorageStrong<E, E, E, ChainEntryLinkedStrong<Object>>(this, new ChainEntryLinkedStrong<Object>(null, null));
        this.capacity = (int)((float)pow2InitialHashLength * positiveHashDensity);
    }

    final boolean internalAdd(E element) {
        ChainEntryLinkedStrong e = this.slots[System.identityHashCode(element) & this.range];
        while (e != null) {
            if (e.element == element) {
                return false;
            }
            e = (ChainEntryLinkedStrong)e.link;
        }
        this.chain.appendEntry(this.createNewEntry(element));
        return true;
    }

    final void internalAddAll(XGettingCollection<? extends E> elements) {
        elements.iterate(e -> this.internalAdd(e));
    }

    private ChainEntryLinkedStrong<E> createNewEntry(E element) {
        if (this.size >= this.capacity) {
            ConstHashEnum.ensureFreeArrayCapacity(this.size);
            this.increaseStorage();
        }
        ChainEntryLinkedStrong<E> e = new ChainEntryLinkedStrong<E>(element, this.slots[System.identityHashCode(element) & this.range]);
        this.slots[System.identityHashCode(element) & this.range] = e;
        ++this.size;
        return e;
    }

    private void increaseStorage() {
        this.rebuildStorage((int)((float)this.slots.length * 2.0f));
    }

    private void rebuildStorage(int newSlotLength) {
        ChainEntryLinkedStrong<E>[] newSlots = ChainEntryLinkedStrong.array(newSlotLength);
        int modulo = newSlotLength >= Integer.MAX_VALUE ? Integer.MAX_VALUE : newSlotLength - 1;
        ChainEntryLinkedStrong entry = this.chain.head();
        while ((entry = (ChainEntryLinkedStrong)entry.next) != null) {
            entry.link = newSlots[System.identityHashCode(entry.element) & modulo];
            newSlots[System.identityHashCode(entry.element) & modulo] = entry;
        }
        this.capacity = newSlotLength >= Integer.MAX_VALUE ? Integer.MAX_VALUE : (int)((float)newSlotLength * this.hashDensity);
        this.slots = newSlots;
        this.range = modulo;
    }

    @Override
    public boolean nullAllowed() {
        throw new UnsupportedOperationException();
    }

    @Override
    protected ChainStorage<E, E, E, ChainEntryLinkedStrong<E>> getInternalStorageChain() {
        return this.chain;
    }

    @Override
    protected int internalRemoveNullEntries() {
        throw new UnsupportedOperationException();
    }

    @Override
    protected int internalCountingAddAll(E[] elements) throws UnsupportedOperationException {
        throw new UnsupportedOperationException();
    }

    @Override
    protected int internalCountingAddAll(E[] elements, int offset, int length) throws UnsupportedOperationException {
        throw new UnsupportedOperationException();
    }

    @Override
    protected int internalCountingAddAll(XGettingCollection<? extends E> elements) throws UnsupportedOperationException {
        throw new UnsupportedOperationException();
    }

    @Override
    protected int internalCountingPutAll(E[] elements) throws UnsupportedOperationException {
        throw new UnsupportedOperationException();
    }

    @Override
    protected int internalCountingPutAll(E[] elements, int offset, int length) throws UnsupportedOperationException {
        throw new UnsupportedOperationException();
    }

    @Override
    protected int internalCountingPutAll(XGettingCollection<? extends E> elements) throws UnsupportedOperationException {
        throw new UnsupportedOperationException();
    }

    @Override
    protected void internalRemoveEntry(ChainEntryLinkedStrong<E> entry) {
        throw new UnsupportedOperationException();
    }

    @Override
    protected int internalClear() {
        throw new UnsupportedOperationException();
    }

    @Override
    public final long size() {
        return this.size;
    }

    @Override
    public final int rehash() {
        return XTypes.to_int(this.size());
    }

    @Override
    public final boolean isEmpty() {
        return this.size == 0;
    }

    @Override
    public final ConstHashEnum<E> copy() {
        final ConstHashEnum<E> newVarMap = new ConstHashEnum<E>(this);
        this.chain.iterate(new Consumer<E>(){

            @Override
            public void accept(E entry) {
                newVarMap.internalAdd(entry);
            }
        });
        return newVarMap;
    }

    @Override
    public final ConstHashEnum<E> immure() {
        return this;
    }

    @Override
    public final XGettingEnum<E> view() {
        return new EnumView(this);
    }

    @Override
    public final void setHashDensity(float hashDensity) {
    }

    @Override
    public final boolean hasVolatileElements() {
        return false;
    }

    @Override
    public final OldSet<E> old() {
        throw new NotImplementedYetError();
    }

    @Override
    public final long maximumCapacity() {
        return Integer.MAX_VALUE;
    }

    @Override
    public final boolean isFull() {
        return this.size >= Integer.MAX_VALUE;
    }

    @Override
    public final long remainingCapacity() {
        return Integer.MAX_VALUE - this.size;
    }

    @Override
    public final HashCollection.Analysis<ConstHashEnum<E>> analyze() {
        return AbstractChainEntryLinked.analyzeSlots((HashCollection)this, (AbstractChainEntryLinked[])this.slots);
    }

    @Override
    public final int hashDistributionRange() {
        return this.slots.length;
    }

    @Override
    public final HashEqualator<E> hashEquality() {
        return XHashing.hashEqualityIdentity();
    }

    @Override
    public final float hashDensity() {
        return this.hashDensity;
    }

    @Override
    public final boolean hasVolatileHashElements() {
        return this.chain.hasVolatileElements();
    }

    public final String toString() {
        return this.chain.appendTo(VarString.New(this.slots.length).append('['), ",").append(']').toString();
    }

    @Override
    public final XImmutableEnum<E> range(long lowIndex, long highIndex) {
        throw new NotImplementedYetError();
    }

    @Override
    public final XGettingEnum<E> view(long lowIndex, long highIndex) {
        throw new NotImplementedYetError();
    }

    @Override
    public final E[] toArray(Class<E> type) {
        return this.chain.toArray(type);
    }

    @Override
    public final <P extends Consumer<? super E>> P iterate(P procedure) {
        this.chain.iterate(procedure);
        return procedure;
    }

    @Override
    public final <A> A join(BiConsumer<? super E, ? super A> joiner, A aggregate) {
        this.chain.join(joiner, aggregate);
        return aggregate;
    }

    @Override
    public final long count(E entry) {
        return this.chain.count(entry);
    }

    @Override
    public final long countBy(Predicate<? super E> predicate) {
        return this.chain.count(predicate);
    }

    @Override
    public final E search(Predicate<? super E> predicate) {
        return this.chain.search(predicate);
    }

    @Override
    public final E max(Comparator<? super E> comparator) {
        return this.chain.max(comparator);
    }

    @Override
    public final E min(Comparator<? super E> comparator) {
        return this.chain.min(comparator);
    }

    @Override
    public final boolean containsSearched(Predicate<? super E> predicate) {
        return this.chain.containsSearched(predicate);
    }

    @Override
    public final boolean applies(Predicate<? super E> predicate) {
        return this.chain.appliesAll(predicate);
    }

    @Override
    public final boolean nullContained() {
        return false;
    }

    @Override
    public final boolean containsId(E element) {
        ChainEntryLinkedStrong e = this.slots[System.identityHashCode(element) & this.range];
        while (e != null) {
            if (element == e.element) {
                return true;
            }
            e = (ChainEntryLinkedStrong)e.link;
        }
        return false;
    }

    @Override
    public final boolean contains(E element) {
        ChainEntryLinkedStrong e = this.slots[System.identityHashCode(element) & this.range];
        while (e != null) {
            if (e.element == element) {
                return true;
            }
            e = (ChainEntryLinkedStrong)e.link;
        }
        return false;
    }

    @Override
    public final E seek(E sample) {
        if (sample == null) {
            return null;
        }
        ChainEntryLinkedStrong e = this.slots[System.identityHashCode(sample) & this.range];
        while (e != null) {
            if (e.element == sample) {
                return e.element;
            }
            e = (ChainEntryLinkedStrong)e.link;
        }
        return null;
    }

    @Override
    public final boolean equals(XGettingCollection<? extends E> samples, Equalator<? super E> equalator) {
        if (samples == null || !(samples instanceof ConstHashEnum)) {
            return false;
        }
        if (samples == this) {
            return true;
        }
        return this.equalsContent(samples, equalator);
    }

    @Override
    public final boolean equalsContent(XGettingCollection<? extends E> samples, Equalator<? super E> equalator) {
        if (this.size != XTypes.to_int(samples.size())) {
            return false;
        }
        return this.chain.equalsContent(samples, equalator);
    }

    @Override
    public final <C extends Consumer<? super E>> C intersect(XGettingCollection<? extends E> other, Equalator<? super E> equalator, C target) {
        return this.chain.intersect(other, equalator, target);
    }

    @Override
    public final <C extends Consumer<? super E>> C except(XGettingCollection<? extends E> other, Equalator<? super E> equalator, C target) {
        return this.chain.except(other, equalator, target);
    }

    @Override
    public final <C extends Consumer<? super E>> C union(XGettingCollection<? extends E> other, Equalator<? super E> equalator, C target) {
        return this.chain.union(other, equalator, target);
    }

    @Override
    public final <C extends Consumer<? super E>> C copyTo(C target) {
        return this.chain.copyTo(target);
    }

    @Override
    public final <C extends Consumer<? super E>> C filterTo(C target, Predicate<? super E> predicate) {
        return this.chain.copyTo(target, predicate);
    }

    @Override
    public final <C extends Consumer<? super E>> C distinct(C target) {
        return this.chain.distinct(target);
    }

    @Override
    public final <C extends Consumer<? super E>> C distinct(C target, Equalator<? super E> equalator) {
        return this.chain.distinct(target, equalator);
    }

    @Override
    public final ConstHashEnum<E> toReversed() {
        Copyable reversedVarSet = this.copy();
        ((ConstHashEnum)reversedVarSet).chain.reverse();
        return reversedVarSet;
    }

    @Override
    public final <T extends Consumer<? super E>> T copySelection(T target, long ... indices) {
        this.chain.copySelection(target, indices);
        return target;
    }

    @Override
    public final <P extends IndexedAcceptor<? super E>> P iterateIndexed(P procedure) {
        this.chain.iterateIndexed(procedure);
        return procedure;
    }

    @Override
    public final E at(long index) {
        return this.chain.get(index);
    }

    @Override
    public final E get() {
        return this.chain.first();
    }

    @Override
    public final E first() {
        return this.chain.first();
    }

    @Override
    public final E last() {
        return this.chain.last();
    }

    @Override
    public final E poll() {
        return this.size == 0 ? null : (E)this.chain.first();
    }

    @Override
    public final E peek() {
        return this.size == 0 ? null : (E)this.chain.last();
    }

    @Override
    public final long indexOf(E entry) {
        return this.chain.indexOf(entry);
    }

    @Override
    public final long indexBy(Predicate<? super E> predicate) {
        return this.chain.indexOf(predicate);
    }

    @Override
    public final boolean isSorted(Comparator<? super E> comparator) {
        return this.chain.isSorted(comparator);
    }

    @Override
    public final long lastIndexOf(E entry) {
        return this.chain.lastIndexOf(entry);
    }

    @Override
    public final long lastIndexBy(Predicate<? super E> predicate) {
        return this.chain.lastIndexBy(predicate);
    }

    @Override
    public final long maxIndex(Comparator<? super E> comparator) {
        return this.chain.maxIndex(comparator);
    }

    @Override
    public final long minIndex(Comparator<? super E> comparator) {
        return this.chain.minIndex(comparator);
    }

    @Override
    public final long scan(Predicate<? super E> predicate) {
        return this.chain.scan(predicate);
    }

    @Override
    public final Iterator<E> iterator() {
        return this.chain.iterator();
    }

    @Override
    public final Object[] toArray() {
        return this.chain.toArray();
    }

    @Override
    public final HashEqualator<E> equality() {
        return XHashing.hashEqualityIdentity();
    }
}

