/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.serializer.collections;

import java.util.Comparator;
import java.util.Iterator;
import java.util.ListIterator;
import java.util.NoSuchElementException;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import org.eclipse.serializer.branching.ThrowBreak;
import org.eclipse.serializer.chars.VarString;
import org.eclipse.serializer.chars.XChars;
import org.eclipse.serializer.collections.AbstractChainCollection;
import org.eclipse.serializer.collections.AbstractChainEntry;
import org.eclipse.serializer.collections.AbstractChainKeyValueStorage;
import org.eclipse.serializer.collections.AbstractSimpleArrayCollection;
import org.eclipse.serializer.collections.CachedSampleEquality;
import org.eclipse.serializer.collections.ChainStorageStrong;
import org.eclipse.serializer.collections.ElementIsContained;
import org.eclipse.serializer.collections.XArrays;
import org.eclipse.serializer.collections.interfaces.ChainStorage;
import org.eclipse.serializer.collections.types.XGettingCollection;
import org.eclipse.serializer.equality.Equalator;
import org.eclipse.serializer.functional.Aggregator;
import org.eclipse.serializer.functional.IndexedAcceptor;
import org.eclipse.serializer.meta.NotImplementedYetError;
import org.eclipse.serializer.reference.ReferenceType;
import org.eclipse.serializer.typing.KeyValue;
import org.eclipse.serializer.typing.XTypes;
import org.eclipse.serializer.util.X;

public final class ChainStrongStrongStorage<K, V, EN extends AbstractChainEntry<KeyValue<K, V>, K, V, EN>>
extends AbstractChainKeyValueStorage<K, V, EN> {
    public ChainStrongStrongStorage(AbstractChainCollection<KeyValue<K, V>, K, V, EN> parent, EN head) {
        super(parent, head);
    }

    /*
     * Unable to fully structure code
     */
    static <K, V, EN extends AbstractChainEntry<KeyValue<K, V>, K, V, EN>> void entriesMergesortHead(EN head, Comparator<? super K> comparator) {
        block4: {
            try {
                entry = ChainStrongStrongStorage.entriesMergesort0(head.next, comparator);
                break block4;
            }
            catch (Throwable e) {
                entry = head.prev;
                if (true) ** GOTO lbl9
            }
            do {
                entry.next = last;
lbl9:
                // 2 sources

                last = entry;
            } while ((entry = last.prev) != head);
            throw e;
        }
        head.next = entry;
        entry.prev = head;
        if (true) ** GOTO lbl18
        do {
            entry.prev = last;
lbl18:
            // 2 sources

            last = entry;
        } while ((entry = last.next) != null);
        head.prev = last;
    }

    /*
     * Handled impossible loop by duplicating code
     * Enabled aggressive block sorting
     */
    private static <K, V, EN extends AbstractChainEntry<KeyValue<K, V>, K, V, EN>> EN entriesMergesort0(EN chain, Comparator<? super K> comparator) {
        Object chain2;
        if (chain == null || chain.next == null) {
            return chain;
        }
        EN t1 = chain;
        Object t2 = chain2 = t1.next;
        if (true) {
            return ChainStrongStrongStorage.entriesMerge1(ChainStrongStrongStorage.entriesMergesort0(chain, comparator), ChainStrongStrongStorage.entriesMergesort0(chain2, comparator), comparator);
        }
        do {
            t2 = ((AbstractChainEntry)t2).next = t1.next;
            if (t2 == null) return ChainStrongStrongStorage.entriesMerge1(ChainStrongStrongStorage.entriesMergesort0(chain, comparator), ChainStrongStrongStorage.entriesMergesort0(chain2, comparator), comparator);
            t1.next = ((AbstractChainEntry)t2).next;
            t1 = t1.next;
        } while (t1.next != null);
        return ChainStrongStrongStorage.entriesMerge1(ChainStrongStrongStorage.entriesMergesort0(chain, comparator), ChainStrongStrongStorage.entriesMergesort0(chain2, comparator), comparator);
    }

    private static <K, V, EN extends AbstractChainEntry<KeyValue<K, V>, K, V, EN>> EN entriesMerge1(EN c1, EN c2, Comparator<? super K> cmp) {
        EN c;
        if (c1 == null) {
            return c2;
        }
        if (c2 == null) {
            return c1;
        }
        if (cmp.compare(c1.key(), c2.key()) < 0) {
            c = c1;
            c1 = c.next;
        } else {
            c = c2;
            c2 = c.next;
        }
        EN t = c;
        while (true) {
            if (c1 == null) {
                t.next = c2;
                break;
            }
            if (c2 == null) {
                t.next = c1;
                break;
            }
            if (cmp.compare(c1.key(), c2.key()) < 0) {
                t.next = c1;
                t = t.next;
                c1 = ((AbstractChainEntry)t.next).next;
                continue;
            }
            t.next = c2;
            t = t.next;
            c2 = ((AbstractChainEntry)t.next).next;
        }
        return c;
    }

    /*
     * Unable to fully structure code
     */
    private static <K, V, EN extends AbstractChainEntry<KeyValue<K, V>, K, V, EN>> void keyMergesortHead(EN head, Comparator<? super K> comparator) {
        block4: {
            try {
                entry = ChainStrongStrongStorage.mergesort0(head.next, comparator);
                break block4;
            }
            catch (Throwable e) {
                entry = head.prev;
                if (true) ** GOTO lbl9
            }
            do {
                entry.next = last;
lbl9:
                // 2 sources

                last = entry;
            } while ((entry = last.prev) != head);
            throw e;
        }
        head.next = entry;
        entry.prev = head;
        if (true) ** GOTO lbl18
        do {
            entry.prev = last;
lbl18:
            // 2 sources

            last = entry;
        } while ((entry = last.next) != null);
        head.prev = last;
    }

    /*
     * Handled impossible loop by duplicating code
     * Enabled aggressive block sorting
     */
    private static <K, V, EN extends AbstractChainEntry<KeyValue<K, V>, K, V, EN>> EN mergesort0(EN chain, Comparator<? super K> comparator) {
        Object chain2;
        if (chain == null || chain.next == null) {
            return chain;
        }
        EN t1 = chain;
        Object t2 = chain2 = t1.next;
        if (true) {
            return ChainStrongStrongStorage.merge1(ChainStrongStrongStorage.mergesort0(chain, comparator), ChainStrongStrongStorage.mergesort0(chain2, comparator), comparator);
        }
        do {
            t2 = ((AbstractChainEntry)t2).next = t1.next;
            if (t2 == null) return ChainStrongStrongStorage.merge1(ChainStrongStrongStorage.mergesort0(chain, comparator), ChainStrongStrongStorage.mergesort0(chain2, comparator), comparator);
            t1.next = ((AbstractChainEntry)t2).next;
            t1 = t1.next;
        } while (t1.next != null);
        return ChainStrongStrongStorage.merge1(ChainStrongStrongStorage.mergesort0(chain, comparator), ChainStrongStrongStorage.mergesort0(chain2, comparator), comparator);
    }

    private static <K, V, EN extends AbstractChainEntry<KeyValue<K, V>, K, V, EN>> EN merge1(EN c1, EN c2, Comparator<? super K> cmp) {
        EN c;
        if (c1 == null) {
            return c2;
        }
        if (c2 == null) {
            return c1;
        }
        if (cmp.compare(c1.key(), c2.key()) < 0) {
            c = c1;
            c1 = c.next;
        } else {
            c = c2;
            c2 = c.next;
        }
        EN t = c;
        while (true) {
            if (c1 == null) {
                t.next = c2;
                break;
            }
            if (c2 == null) {
                t.next = c1;
                break;
            }
            if (cmp.compare(c1.key(), c2.key()) < 0) {
                t.next = c1;
                t = t.next;
                c1 = ((AbstractChainEntry)t.next).next;
                continue;
            }
            t.next = c2;
            t = t.next;
            c2 = ((AbstractChainEntry)t.next).next;
        }
        return c;
    }

    @Override
    public final Iterator<K> keyIterator() {
        return new KeyItr();
    }

    @Override
    public final boolean keyEqualsContent(XGettingCollection<? extends K> other, final Equalator<? super K> equalator) {
        if (XTypes.to_int(this.parent.size()) != XTypes.to_int(other.size())) {
            return false;
        }
        if (other instanceof AbstractSimpleArrayCollection) {
            int otherSize = XTypes.to_int(other.size());
            E[] otherData = AbstractSimpleArrayCollection.internalGetStorageArray((AbstractSimpleArrayCollection)((Object)other));
            Object entry = this.head.next;
            int i = 0;
            while (i < otherSize) {
                if (!equalator.equal(((AbstractChainEntry)entry).key(), otherData[i])) {
                    return false;
                }
                ++i;
                entry = ((AbstractChainEntry)entry).next;
            }
            return true;
        }
        Aggregator agg = new Aggregator<K, Boolean>(){
            private EN entry;
            private boolean notEqual;
            {
                this.entry = ChainStrongStrongStorage.this.head;
            }

            @Override
            public final void accept(K element) {
                this.entry = ((AbstractChainEntry)this.entry).next;
                if (this.entry == null) {
                    this.notEqual = true;
                    throw X.BREAK();
                }
                if (!equalator.equal(element, ((AbstractChainEntry)this.entry).key())) {
                    this.notEqual = true;
                    throw X.BREAK();
                }
            }

            @Override
            public final Boolean yield() {
                return this.notEqual || this.entry == null || (this.entry = ((AbstractChainEntry)this.entry).next) != null ? Boolean.FALSE : Boolean.TRUE;
            }
        };
        other.iterate(agg);
        return (Boolean)agg.yield();
    }

    @Override
    public final V searchValue(K key, Equalator<? super K> equalator) {
        Object e = this.head.next;
        while (e != null) {
            if (equalator.equal(((AbstractChainEntry)e).key(), key)) {
                return ((AbstractChainEntry)e).value();
            }
            e = ((AbstractChainEntry)e).next;
        }
        return null;
    }

    @Override
    public final boolean keyContainsNull() {
        Object e = this.head.next;
        while (e != null) {
            if (((AbstractChainEntry)e).hasNullKey()) {
                return true;
            }
            e = ((AbstractChainEntry)e).next;
        }
        return false;
    }

    @Override
    public final boolean keyContainsId(K element) {
        Object e = this.head.next;
        while (e != null) {
            if (((AbstractChainEntry)e).key() == element) {
                return true;
            }
            e = ((AbstractChainEntry)e).next;
        }
        return false;
    }

    @Override
    public final boolean keyContains(K element) {
        Object e = this.head.next;
        while (e != null) {
            if (((AbstractChainEntry)e).key() == element) {
                return true;
            }
            e = ((AbstractChainEntry)e).next;
        }
        return false;
    }

    @Override
    public final boolean keyContains(K sample, Equalator<? super K> equalator) {
        Object e = this.head.next;
        while (e != null) {
            if (equalator.equal(((AbstractChainEntry)e).key(), sample)) {
                return true;
            }
            e = ((AbstractChainEntry)e).next;
        }
        return false;
    }

    @Override
    public final boolean keyContainsAll(K[] elements, int elementsOffset, int elementsLength) {
        Object first = this.head.next;
        if (first == null) {
            return false;
        }
        int d = ChainStorageStrong.validateArrayIteration(elements, elementsOffset, elementsLength);
        if (d == 0) {
            return true;
        }
        int elementsBound = elementsOffset + elementsLength;
        int ei = elementsOffset;
        while (ei != elementsBound) {
            block5: {
                K element = elements[ei];
                Object e = first;
                while (e != null) {
                    if (((AbstractChainEntry)e).key() != element) {
                        e = ((AbstractChainEntry)e).next;
                        continue;
                    }
                    break block5;
                }
                return false;
            }
            ei += d;
        }
        return true;
    }

    @Override
    public final boolean keyContainsAll(XGettingCollection<? extends K> elements) {
        if (elements instanceof AbstractSimpleArrayCollection) {
            return this.keyContainsAll(AbstractSimpleArrayCollection.internalGetStorageArray((AbstractSimpleArrayCollection)((Object)elements)), 0, XTypes.to_int(elements.size()));
        }
        return elements.applies(e -> this.keyContains(e));
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public final boolean keyApplies(Predicate<? super K> predicate) {
        try {
            Object e = this.head.next;
            while (true) {
                if (e == null) {
                    return false;
                }
                if (predicate.test(((AbstractChainEntry)e).key())) {
                    return true;
                }
                e = ((AbstractChainEntry)e).next;
            }
        }
        catch (ThrowBreak throwBreak) {
            // empty catch block
        }
        return false;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public final boolean keyAppliesAll(Predicate<? super K> predicate) {
        try {
            AbstractChainEntry e = this.head;
            if (e.next == null) {
                return false;
            }
            do {
                if ((e = e.next) != null) continue;
                return true;
            } while (predicate.test(e.key()));
            return false;
        }
        catch (ThrowBreak throwBreak) {
            // empty catch block
        }
        return true;
    }

    @Override
    public final int keyCount(K element) {
        int count = 0;
        Object e = this.head.next;
        while (e != null) {
            if (((AbstractChainEntry)e).key() == element) {
                ++count;
            }
            e = ((AbstractChainEntry)e).next;
        }
        return count;
    }

    @Override
    public final int keyCount(K sample, Equalator<? super K> equalator) {
        int count = 0;
        Object e = this.head.next;
        while (e != null) {
            if (equalator.equal(((AbstractChainEntry)e).key(), sample)) {
                ++count;
            }
            e = ((AbstractChainEntry)e).next;
        }
        return count;
    }

    @Override
    public final int keyCount(Predicate<? super K> predicate) {
        int count = 0;
        try {
            Object e = this.head.next;
            while (e != null) {
                if (predicate.test(((AbstractChainEntry)e).key())) {
                    ++count;
                }
                e = ((AbstractChainEntry)e).next;
            }
        }
        catch (ThrowBreak throwBreak) {
            // empty catch block
        }
        return count;
    }

    @Override
    public final <C extends Consumer<? super K>> C keyIntersect(XGettingCollection<? extends K> samples, Equalator<? super K> equalator, C target) {
        if (samples instanceof AbstractSimpleArrayCollection) {
            E[] array = AbstractSimpleArrayCollection.internalGetStorageArray((AbstractSimpleArrayCollection)((Object)samples));
            int size = XTypes.to_int(samples.size());
            Object entry = this.head.next;
            while (entry != null) {
                Object element = ((AbstractChainEntry)entry).key();
                int i = 0;
                while (i < size) {
                    if (equalator.equal(element, array[i])) {
                        target.accept(element);
                        break;
                    }
                    ++i;
                }
                entry = ((AbstractChainEntry)entry).next;
            }
            return target;
        }
        CachedSampleEquality<? super K> equalCurrentElement = new CachedSampleEquality<K>(equalator);
        Object entry = this.head.next;
        while (entry != null) {
            equalCurrentElement.sample = ((AbstractChainEntry)entry).key();
            if (samples.containsSearched(equalCurrentElement)) {
                target.accept(equalCurrentElement.sample);
            }
            entry = ((AbstractChainEntry)entry).next;
        }
        return target;
    }

    @Override
    public final <C extends Consumer<? super K>> C keyExcept(XGettingCollection<? extends K> samples, Equalator<? super K> equalator, C target) {
        if (samples instanceof AbstractSimpleArrayCollection) {
            E[] array = AbstractSimpleArrayCollection.internalGetStorageArray((AbstractSimpleArrayCollection)((Object)samples));
            int size = XTypes.to_int(samples.size());
            Object entry = this.head.next;
            while (entry != null) {
                block6: {
                    Object element = ((AbstractChainEntry)entry).key();
                    int i = 0;
                    while (i < size) {
                        if (!equalator.equal(element, array[i])) {
                            ++i;
                            continue;
                        }
                        break block6;
                    }
                    target.accept(element);
                }
                entry = ((AbstractChainEntry)entry).next;
            }
            return target;
        }
        CachedSampleEquality<? super K> equalCurrentElement = new CachedSampleEquality<K>(equalator);
        Object entry = this.head.next;
        while (entry != null) {
            equalCurrentElement.sample = ((AbstractChainEntry)entry).key();
            if (!samples.containsSearched(equalCurrentElement)) {
                target.accept(equalCurrentElement.sample);
            }
            entry = ((AbstractChainEntry)entry).next;
        }
        return target;
    }

    @Override
    public final <C extends Consumer<? super K>> C keyUnion(XGettingCollection<? extends K> samples, Equalator<? super K> equalator, C target) {
        this.keyCopyTo(target);
        if (samples instanceof AbstractSimpleArrayCollection) {
            E[] array = AbstractSimpleArrayCollection.internalGetStorageArray((AbstractSimpleArrayCollection)((Object)samples));
            int size = XTypes.to_int(samples.size());
            int i = 0;
            while (i < size) {
                block4: {
                    Object sample = array[i];
                    Object entry = this.head.next;
                    while (entry != null) {
                        if (!equalator.equal(((AbstractChainEntry)entry).key(), sample)) {
                            entry = ((AbstractChainEntry)entry).next;
                            continue;
                        }
                        break block4;
                    }
                    target.accept(sample);
                }
                ++i;
            }
            return target;
        }
        samples.iterate(e -> {
            Equalator equalator2 = equalator;
            Object entry = this.head.next;
            while (entry != null) {
                if (equalator2.equal(e, ((AbstractChainEntry)entry).key())) {
                    return;
                }
                entry = ((AbstractChainEntry)entry).next;
            }
            target.accept(e);
        });
        return target;
    }

    @Override
    public final <C extends Consumer<? super K>> C keyCopyTo(C target) {
        Object e = this.head.next;
        while (e != null) {
            target.accept(((AbstractChainEntry)e).key());
            e = ((AbstractChainEntry)e).next;
        }
        return target;
    }

    @Override
    public final <C extends Consumer<? super K>> C keyCopySelection(C target, long ... indices) {
        int length = indices.length;
        int size = XTypes.to_int(this.parent.size());
        int i = 0;
        while (i < length) {
            if (indices[i] < 0L || indices[i] >= (long)size) {
                throw new IndexOutOfBoundsException(ChainStrongStrongStorage.exceptionIndexOutOfBounds(size, indices[i]));
            }
            ++i;
        }
        i = 0;
        while (i < length) {
            target.accept(((AbstractChainEntry)this.getChainEntry(indices[i])).key());
            ++i;
        }
        return target;
    }

    @Override
    public final <C extends Consumer<? super K>> C keyCopyTo(C target, Predicate<? super K> predicate) {
        try {
            Object entry = this.head.next;
            while (entry != null) {
                if (predicate.test(((AbstractChainEntry)entry).key())) {
                    target.accept(((AbstractChainEntry)entry).key());
                }
                entry = ((AbstractChainEntry)entry).next;
            }
        }
        catch (ThrowBreak throwBreak) {
            // empty catch block
        }
        return target;
    }

    @Override
    public final Object[] keyToArray() {
        Object[] array = new Object[XTypes.to_int(this.parent.size())];
        this.keyCopyToArray(0, XTypes.to_int(this.parent.size()), array, 0);
        return array;
    }

    @Override
    public final K[] keyToArray(Class<K> type) {
        Object[] array = X.Array(type, XTypes.to_int(this.parent.size()));
        this.keyCopyToArray(0, XTypes.to_int(this.parent.size()), array, 0);
        return array;
    }

    @Override
    public final K keyFirst() {
        return this.head.next == null ? null : (K)((AbstractChainEntry)this.head.next).key();
    }

    @Override
    public final K keyLast() {
        return this.head.prev == this.head ? null : (K)((AbstractChainEntry)this.head.prev).key();
    }

    @Override
    public final K keyGet(long index) {
        return ((AbstractChainEntry)this.getChainEntry(index)).key();
    }

    @Override
    public final K keySeek(K sample, Equalator<? super K> equalator) {
        Object e = this.head.next;
        while (e != null) {
            if (equalator.equal(((AbstractChainEntry)e).key(), sample)) {
                return ((AbstractChainEntry)e).key();
            }
            e = ((AbstractChainEntry)e).next;
        }
        return null;
    }

    @Override
    public final K keySeek(K sample) {
        Object e = this.head.next;
        while (e != null) {
            if (sample == ((AbstractChainEntry)e).key()) {
                return ((AbstractChainEntry)e).key();
            }
            e = ((AbstractChainEntry)e).next;
        }
        return null;
    }

    @Override
    public final K keySearch(Predicate<? super K> predicate) {
        try {
            Object e = this.head.next;
            while (e != null) {
                if (predicate.test(((AbstractChainEntry)e).key())) {
                    return ((AbstractChainEntry)e).key();
                }
                e = ((AbstractChainEntry)e).next;
            }
        }
        catch (ThrowBreak throwBreak) {
            // empty catch block
        }
        return null;
    }

    @Override
    public final K keyMin(Comparator<? super K> comparator) {
        Object e = this.head.next;
        if (e == null) {
            return null;
        }
        Object loopMinElement = ((AbstractChainEntry)e).key();
        e = ((AbstractChainEntry)e).next;
        while (e != null) {
            Object element = ((AbstractChainEntry)e).key();
            if (comparator.compare(loopMinElement, element) > 0) {
                loopMinElement = element;
            }
            e = ((AbstractChainEntry)e).next;
        }
        return loopMinElement;
    }

    @Override
    public final K keyMax(Comparator<? super K> comparator) {
        Object e = this.head.next;
        if (e == null) {
            return null;
        }
        Object loopMaxElement = ((AbstractChainEntry)e).key();
        e = ((AbstractChainEntry)e).next;
        while (e != null) {
            Object element = ((AbstractChainEntry)e).key();
            if (comparator.compare(loopMaxElement, element) < 0) {
                loopMaxElement = element;
            }
            e = ((AbstractChainEntry)e).next;
        }
        return loopMaxElement;
    }

    @Override
    public final void keyIterate(Consumer<? super K> procedure) {
        try {
            AbstractChainEntry entry = this.head;
            while ((entry = entry.next) != null) {
                procedure.accept(entry.key());
            }
        }
        catch (ThrowBreak throwBreak) {
            // empty catch block
        }
    }

    @Override
    public final <A> void keyJoin(BiConsumer<? super K, A> joiner, A aggregate) {
        try {
            AbstractChainEntry entry = this.head;
            while ((entry = entry.next) != null) {
                joiner.accept(entry.key(), aggregate);
            }
        }
        catch (ThrowBreak throwBreak) {
            // empty catch block
        }
    }

    @Override
    public final void keyIterateIndexed(IndexedAcceptor<? super K> procedure) {
        try {
            int i = -1;
            AbstractChainEntry entry = this.head;
            while ((entry = entry.next) != null) {
                procedure.accept(entry.key(), ++i);
            }
        }
        catch (ThrowBreak throwBreak) {
            // empty catch block
        }
    }

    @Override
    public final void keyIterate(Predicate<? super K> predicate, Consumer<? super K> procedure) {
        try {
            Object e = this.head.next;
            while (e != null) {
                if (predicate.test(((AbstractChainEntry)e).key())) {
                    procedure.accept(((AbstractChainEntry)e).key());
                }
                e = ((AbstractChainEntry)e).next;
            }
        }
        catch (ThrowBreak throwBreak) {
            // empty catch block
        }
    }

    @Override
    public final int keyIndexOf(K element) {
        int i = 0;
        Object e = this.head.next;
        while (e != null) {
            if (((AbstractChainEntry)e).key() == element) {
                return i;
            }
            e = ((AbstractChainEntry)e).next;
            ++i;
        }
        return -1;
    }

    @Override
    public final int keyIndexOf(K sample, Equalator<? super K> equalator) {
        int i = 0;
        Object e = this.head.next;
        while (e != null) {
            if (equalator.equal(((AbstractChainEntry)e).key(), sample)) {
                return i;
            }
            e = ((AbstractChainEntry)e).next;
            ++i;
        }
        return -1;
    }

    @Override
    public final int keyIndexBy(Predicate<? super K> predicate) {
        int i = 0;
        try {
            Object e = this.head.next;
            while (e != null) {
                if (predicate.test(((AbstractChainEntry)e).key())) {
                    return i;
                }
                e = ((AbstractChainEntry)e).next;
                ++i;
            }
        }
        catch (ThrowBreak throwBreak) {
            // empty catch block
        }
        return -1;
    }

    @Override
    public final int keyLastIndexOf(K element) {
        int i = 0;
        Object e = this.head.prev;
        while (e != this.head) {
            if (((AbstractChainEntry)e).key() == element) {
                return i;
            }
            e = ((AbstractChainEntry)e).prev;
            ++i;
        }
        return -1;
    }

    @Override
    public final int keyLastIndexOf(K sample, Equalator<? super K> equalator) {
        int i = 0;
        Object e = this.head.prev;
        while (e != this.head) {
            if (equalator.equal(((AbstractChainEntry)e).key(), sample)) {
                return i;
            }
            e = ((AbstractChainEntry)e).prev;
            ++i;
        }
        return -1;
    }

    @Override
    public final int keyLastIndexBy(Predicate<? super K> predicate) {
        int i = 0;
        try {
            Object e = this.head.prev;
            while (e != this.head) {
                if (predicate.test(((AbstractChainEntry)e).key())) {
                    return i;
                }
                e = ((AbstractChainEntry)e).prev;
                ++i;
            }
        }
        catch (ThrowBreak throwBreak) {
            // empty catch block
        }
        return -1;
    }

    @Override
    public final int keyMinIndex(Comparator<? super K> comparator) {
        Object e = this.head.next;
        if (e == null) {
            return -1;
        }
        Object loopMinElement = ((AbstractChainEntry)e).key();
        int loopMinIndex = 0;
        int i = 1;
        e = ((AbstractChainEntry)e).next;
        while (e != null) {
            Object element = ((AbstractChainEntry)e).key();
            if (comparator.compare(loopMinElement, element) > 0) {
                loopMinElement = element;
                loopMinIndex = i;
            }
            e = ((AbstractChainEntry)e).next;
            ++i;
        }
        return loopMinIndex;
    }

    @Override
    public final int keyMaxIndex(Comparator<? super K> comparator) {
        Object e = this.head.next;
        if (e == null) {
            return -1;
        }
        Object loopMaxElement = ((AbstractChainEntry)e).key();
        int loopMaxIndex = 0;
        int i = 1;
        e = ((AbstractChainEntry)e).next;
        while (e != null) {
            Object element = ((AbstractChainEntry)e).key();
            if (comparator.compare(loopMaxElement, element) < 0) {
                loopMaxElement = element;
                loopMaxIndex = i;
            }
            e = ((AbstractChainEntry)e).next;
            ++i;
        }
        return loopMaxIndex;
    }

    @Override
    public final int keyScan(Predicate<? super K> predicate) {
        int i = 0;
        int foundIndex = -1;
        Object e = this.head.next;
        while (e != null) {
            if (predicate.test(((AbstractChainEntry)e).key())) {
                foundIndex = i;
            }
            e = ((AbstractChainEntry)e).next;
            ++i;
        }
        return foundIndex;
    }

    @Override
    public final boolean keyHasDistinctValues() {
        Object e = this.head.next;
        while (e != null) {
            Object element = ((AbstractChainEntry)e).key();
            Object lookAhead = ((AbstractChainEntry)e).next;
            while (lookAhead != null) {
                if (element == ((AbstractChainEntry)lookAhead).key()) {
                    return false;
                }
                lookAhead = ((AbstractChainEntry)lookAhead).next;
            }
            e = ((AbstractChainEntry)e).next;
        }
        return true;
    }

    @Override
    public final boolean keyHasDistinctValues(Equalator<? super K> equalator) {
        Object e = this.head.next;
        while (e != null) {
            Object element = ((AbstractChainEntry)e).key();
            Object lookAhead = ((AbstractChainEntry)e).next;
            while (lookAhead != null) {
                if (equalator.equal(element, ((AbstractChainEntry)lookAhead).key())) {
                    return false;
                }
                lookAhead = ((AbstractChainEntry)lookAhead).next;
            }
            e = ((AbstractChainEntry)e).next;
        }
        return true;
    }

    @Override
    public final <C extends Consumer<? super K>> C keyDistinct(C target) {
        Object e = this.head.next;
        while (e != null) {
            block3: {
                Object element = ((AbstractChainEntry)e).key();
                Object lookAhead = ((AbstractChainEntry)e).next;
                while (lookAhead != null) {
                    if (element != ((AbstractChainEntry)lookAhead).key()) {
                        lookAhead = ((AbstractChainEntry)lookAhead).next;
                        continue;
                    }
                    break block3;
                }
                target.accept(element);
            }
            e = ((AbstractChainEntry)e).next;
        }
        return target;
    }

    @Override
    public final <C extends Consumer<? super K>> C keyDistinct(C target, Equalator<? super K> equalator) {
        Object e = this.head.next;
        while (e != null) {
            block3: {
                Object element = ((AbstractChainEntry)e).key();
                Object lookAhead = ((AbstractChainEntry)e).next;
                while (lookAhead != null) {
                    if (!equalator.equal(element, ((AbstractChainEntry)lookAhead).key())) {
                        lookAhead = ((AbstractChainEntry)lookAhead).next;
                        continue;
                    }
                    break block3;
                }
                target.accept(element);
            }
            e = ((AbstractChainEntry)e).next;
        }
        return target;
    }

    @Override
    public final K keyRemove(long index) {
        ChainStorage.Entry e = this.getChainEntry(index);
        ((AbstractChainEntry)e).removeFrom(this.parent);
        return ((AbstractChainEntry)e).key();
    }

    @Override
    public final int keyRemoveNull() {
        AbstractChainCollection parent = this.parent;
        int removeCount = 0;
        Object e = this.head.next;
        while (e != null) {
            if (((AbstractChainEntry)e).hasNullKey()) {
                ((AbstractChainEntry)e).removeFrom(parent);
                ++removeCount;
            }
            e = ((AbstractChainEntry)e).next;
        }
        return removeCount;
    }

    @Override
    public final K keyRetrieve(K element) {
        AbstractChainCollection parent = this.parent;
        Object e = this.head.next;
        while (e != null) {
            if (((AbstractChainEntry)e).key() == element) {
                ((AbstractChainEntry)e).removeFrom(parent);
                return ((AbstractChainEntry)e).key();
            }
            e = ((AbstractChainEntry)e).next;
        }
        return null;
    }

    @Override
    public final K keyRetrieve(K sample, Equalator<? super K> equalator) {
        AbstractChainCollection parent = this.parent;
        Object e = this.head.next;
        while (e != null) {
            if (equalator.equal(((AbstractChainEntry)e).key(), sample)) {
                ((AbstractChainEntry)e).removeFrom(parent);
                return ((AbstractChainEntry)e).key();
            }
            e = ((AbstractChainEntry)e).next;
        }
        return null;
    }

    @Override
    public final K keyRetrieve(Predicate<? super K> predicate) {
        AbstractChainCollection parent = this.parent;
        Object e = this.head.next;
        while (e != null) {
            if (predicate.test(((AbstractChainEntry)e).key())) {
                ((AbstractChainEntry)e).removeFrom(parent);
                return ((AbstractChainEntry)e).key();
            }
            e = ((AbstractChainEntry)e).next;
        }
        return null;
    }

    @Override
    public final boolean keyRemoveOne(K element) {
        AbstractChainCollection parent = this.parent;
        Object e = this.head.next;
        while (e != null) {
            if (((AbstractChainEntry)e).key() == element) {
                ((AbstractChainEntry)e).removeFrom(parent);
                return true;
            }
            e = ((AbstractChainEntry)e).next;
        }
        return false;
    }

    @Override
    public final boolean keyRemoveOne(K sample, Equalator<? super K> equalator) {
        AbstractChainCollection parent = this.parent;
        Object e = this.head.next;
        while (e != null) {
            if (equalator.equal(((AbstractChainEntry)e).key(), sample)) {
                ((AbstractChainEntry)e).removeFrom(parent);
                return true;
            }
            e = ((AbstractChainEntry)e).next;
        }
        return false;
    }

    @Override
    public final int keyRemove(K element) {
        int oldSize = XTypes.to_int(this.parent.size());
        AbstractChainCollection parent = this.parent;
        Object e = this.head.next;
        while (e != null) {
            if (((AbstractChainEntry)e).key() == element) {
                ((AbstractChainEntry)e).removeFrom(parent);
            }
            e = ((AbstractChainEntry)e).next;
        }
        return oldSize - XTypes.to_int(this.parent.size());
    }

    @Override
    public final int keyRemove(K sample, Equalator<? super K> equalator) {
        int oldSize = XTypes.to_int(this.parent.size());
        AbstractChainCollection parent = this.parent;
        Object e = this.head.next;
        while (e != null) {
            if (equalator.equal(((AbstractChainEntry)e).key(), sample)) {
                ((AbstractChainEntry)e).removeFrom(parent);
            }
            e = ((AbstractChainEntry)e).next;
        }
        return oldSize - XTypes.to_int(this.parent.size());
    }

    @Override
    public final int keyRemoveAll(K[] elements, int elementsOffset, int elementsLength) {
        int d = ChainStorageStrong.validateArrayIteration(elements, elementsOffset, elementsLength);
        if (d == 0) {
            return 0;
        }
        int elementsBound = elementsOffset + elementsLength;
        AbstractChainCollection parent = this.parent;
        int removeCount = 0;
        Object e = this.head.next;
        while (e != null) {
            Object element = ((AbstractChainEntry)e).key();
            int i = elementsOffset;
            while (i != elementsBound) {
                if (element == elements[i]) {
                    ((AbstractChainEntry)e).removeFrom(parent);
                    ++removeCount;
                    break;
                }
                i += d;
            }
            e = ((AbstractChainEntry)e).next;
        }
        return removeCount;
    }

    @Override
    public final int keyRemoveAll(XGettingCollection<? extends K> elements) {
        if (elements instanceof AbstractSimpleArrayCollection) {
            return this.keyRemoveAll(AbstractSimpleArrayCollection.internalGetStorageArray((AbstractSimpleArrayCollection)((Object)elements)), 0, XTypes.to_int(elements.size()));
        }
        return elements.iterate(new Consumer<K>(){
            int removeCount;

            @Override
            public void accept(K e) {
                this.removeCount += ChainStrongStrongStorage.this.keyRemove(e);
            }
        }).removeCount;
    }

    @Override
    public final int keyRemoveDuplicates() {
        AbstractChainCollection parent = this.parent;
        int removeCount = 0;
        Object e = this.head.next;
        while (e != null) {
            Object element = ((AbstractChainEntry)e).key();
            Object lookAhead = ((AbstractChainEntry)e).next;
            while (lookAhead != null) {
                if (element == ((AbstractChainEntry)lookAhead).key()) {
                    ((AbstractChainEntry)lookAhead).removeFrom(parent);
                    ++removeCount;
                }
                lookAhead = ((AbstractChainEntry)lookAhead).next;
            }
            e = ((AbstractChainEntry)e).next;
        }
        return removeCount;
    }

    @Override
    public final int keyRemoveDuplicates(Equalator<? super K> equalator) {
        AbstractChainCollection parent = this.parent;
        int removeCount = 0;
        Object e = this.head.next;
        while (e != null) {
            Object element = ((AbstractChainEntry)e).key();
            Object lookAhead = ((AbstractChainEntry)e).next;
            while (lookAhead != null) {
                if (equalator.equal(element, ((AbstractChainEntry)lookAhead).key())) {
                    ((AbstractChainEntry)lookAhead).removeFrom(parent);
                    ++removeCount;
                }
                lookAhead = ((AbstractChainEntry)lookAhead).next;
            }
            e = ((AbstractChainEntry)e).next;
        }
        return removeCount;
    }

    @Override
    public final int keyReduce(Predicate<? super K> predicate) {
        int removeCount = 0;
        AbstractChainCollection parent = this.parent;
        Object e = this.head.next;
        while (e != null) {
            if (predicate.test(((AbstractChainEntry)e).key())) {
                ((AbstractChainEntry)e).removeFrom(parent);
                ++removeCount;
            }
            e = ((AbstractChainEntry)e).next;
        }
        return removeCount;
    }

    @Override
    public final int keyRetainAll(K[] elements, int elementsOffset, int elementsLength) {
        int d = ChainStorageStrong.validateArrayIteration(elements, elementsOffset, elementsLength);
        if (d == 0) {
            return 0;
        }
        int elementsBound = elementsOffset + elementsLength;
        AbstractChainCollection parent = this.parent;
        int removeCount = 0;
        Object e = this.head.next;
        while (e != null) {
            block4: {
                Object element = ((AbstractChainEntry)e).key();
                int i = elementsOffset;
                while (i != elementsBound) {
                    if (element != elements[i]) {
                        i += d;
                        continue;
                    }
                    break block4;
                }
                ((AbstractChainEntry)e).removeFrom(parent);
                ++removeCount;
            }
            e = ((AbstractChainEntry)e).next;
        }
        return removeCount;
    }

    public final int keyRetainAll(K[] samples, int samplesOffset, int samplesLength, Equalator<? super K> equalator) {
        int d = ChainStorageStrong.validateArrayIteration(samples, samplesOffset, samplesLength);
        if (d == 0) {
            return 0;
        }
        int samplesBound = samplesOffset + samplesLength;
        AbstractChainCollection parent = this.parent;
        int removeCount = 0;
        Object e = this.head.next;
        while (e != null) {
            block4: {
                Object element = ((AbstractChainEntry)e).key();
                int i = samplesOffset;
                while (i != samplesBound) {
                    if (!equalator.equal(element, samples[i])) {
                        i += d;
                        continue;
                    }
                    break block4;
                }
                ((AbstractChainEntry)e).removeFrom(parent);
                ++removeCount;
            }
            e = ((AbstractChainEntry)e).next;
        }
        return removeCount;
    }

    @Override
    public final int keyRetainAll(XGettingCollection<? extends K> elements) {
        if (elements instanceof AbstractSimpleArrayCollection) {
            return this.keyRetainAll(AbstractSimpleArrayCollection.internalGetStorageArray((AbstractSimpleArrayCollection)((Object)elements)), 0, XTypes.to_int(elements.size()));
        }
        ElementIsContained currentElement = new ElementIsContained();
        AbstractChainCollection parent = this.parent;
        int removeCount = 0;
        Object e = this.head.next;
        while (e != null) {
            currentElement.element = ((AbstractChainEntry)e).key();
            if (!elements.containsSearched(currentElement)) {
                ((AbstractChainEntry)e).removeFrom(parent);
                ++removeCount;
            }
            e = ((AbstractChainEntry)e).next;
        }
        return removeCount;
    }

    @Override
    public final int keyRetainAll(XGettingCollection<? extends K> samples, Equalator<? super K> equalator) {
        if (samples instanceof AbstractSimpleArrayCollection) {
            return this.keyRetainAll(AbstractSimpleArrayCollection.internalGetStorageArray((AbstractSimpleArrayCollection)((Object)samples)), 0, XTypes.to_int(samples.size()), equalator);
        }
        CachedSampleEquality<? super K> equalCurrentElement = new CachedSampleEquality<K>(equalator);
        AbstractChainCollection parent = this.parent;
        int removeCount = 0;
        Object e = this.head.next;
        while (e != null) {
            equalCurrentElement.sample = ((AbstractChainEntry)e).key();
            if (!samples.containsSearched(equalCurrentElement)) {
                ((AbstractChainEntry)e).removeFrom(parent);
                ++removeCount;
            }
            e = ((AbstractChainEntry)e).next;
        }
        return removeCount;
    }

    @Override
    public final int keyProcess(Consumer<? super K> procedure) {
        AbstractChainCollection parent = this.parent;
        int removeCount = 0;
        try {
            Object e = this.head.next;
            while (e != null) {
                procedure.accept(((AbstractChainEntry)e).key());
                ((AbstractChainEntry)e).removeFrom(parent);
                ++removeCount;
                e = ((AbstractChainEntry)e).next;
            }
        }
        catch (ThrowBreak b) {
            removeCount += parent.internalClear();
        }
        return removeCount;
    }

    /*
     * Unable to fully structure code
     * Could not resolve type clashes
     */
    @Override
    public final int keyMoveRange(int offset, int length, Consumer<? super K> target) {
        block3: {
            e /* !! */  = this.getRangeChainEntry(offset, length);
            if (e /* !! */  == null) {
                return 0;
            }
            parent = this.parent;
            bound = offset + length;
            if (length <= 0) ** GOTO lbl18
            while (offset != bound) {
                target.accept(e /* !! */ .key());
                e /* !! */ .removeFrom(parent);
                e /* !! */  = e /* !! */ .next;
                ++offset;
            }
            break block3;
lbl-1000:
            // 1 sources

            {
                target.accept(e /* !! */ .key());
                e /* !! */ .removeFrom(parent);
                e /* !! */  = e /* !! */ .prev;
                --offset;
lbl18:
                // 2 sources

                ** while (offset != bound)
            }
        }
        return length < 0 ? -length : length;
    }

    @Override
    public final int keyMoveSelection(Consumer<? super K> target, long ... indices) {
        int indicesLength = indices.length;
        int size = XTypes.to_int(this.parent.size());
        int i = 0;
        while (i < indicesLength) {
            if (indices[i] < 0L || indices[i] >= (long)size) {
                throw new IndexOutOfBoundsException(ChainStrongStrongStorage.exceptionIndexOutOfBounds(size, indices[i]));
            }
            ++i;
        }
        AbstractChainCollection parent = this.parent;
        int i2 = 0;
        while (i2 < indicesLength) {
            ChainStorage.Entry e = this.getChainEntry(indices[i2]);
            target.accept(((AbstractChainEntry)e).key());
            ((AbstractChainEntry)e).removeFrom(parent);
            ++i2;
        }
        return indicesLength;
    }

    @Override
    public final int keyMoveTo(Consumer<? super K> target, Predicate<? super K> predicate) {
        int removeCount = 0;
        AbstractChainCollection parent = this.parent;
        Object e = this.head.next;
        while (e != null) {
            Object element = ((AbstractChainEntry)e).key();
            if (predicate.test(element)) {
                target.accept(element);
                ((AbstractChainEntry)e).removeFrom(parent);
                ++removeCount;
            }
            e = ((AbstractChainEntry)e).next;
        }
        return removeCount;
    }

    @Override
    public final void keySort(Comparator<? super K> comparator) {
        if (comparator == null) {
            throw new NullPointerException();
        }
        if (XTypes.to_int(this.parent.size()) <= 1) {
            return;
        }
        ChainStrongStrongStorage.keyMergesortHead(this.head, comparator);
    }

    @Override
    public final boolean keyIsSorted(Comparator<? super K> comparator) {
        Object e = this.head.next;
        if (e == null) {
            return true;
        }
        Object loopLastElement = ((AbstractChainEntry)e).key();
        while ((e = ((AbstractChainEntry)e).next) != null) {
            Object element = ((AbstractChainEntry)e).key();
            if (comparator.compare(loopLastElement, element) > 0) {
                return false;
            }
            loopLastElement = element;
        }
        return true;
    }

    @Override
    @SafeVarargs
    public final void keySet(int offset, K ... elements) {
        ChainStorage.Entry e = this.getRangeChainEntry(offset, elements.length);
        int i = 0;
        while (i < elements.length) {
            ((AbstractChainEntry)e).setKey(elements[i]);
            e = ((AbstractChainEntry)e).next;
            ++i;
        }
    }

    @Override
    public final void keySet(int offset, K[] elements, int elementsOffset, int elementsLength) {
        ChainStorage.Entry e = this.getRangeChainEntry(offset, elementsLength);
        int d = XArrays.validateArrayRange(elements, elementsOffset, elementsLength);
        int i = elementsOffset;
        int bound = elementsOffset + elementsLength;
        while (i != bound) {
            ((AbstractChainEntry)e).setKey(elements[i]);
            e = ((AbstractChainEntry)e).next;
            i += d;
        }
    }

    /*
     * Unable to fully structure code
     * Could not resolve type clashes
     */
    @Override
    public final void keyFill(int offset, int length, K element) {
        block3: {
            e /* !! */  = this.getRangeChainEntry(offset, length);
            if (e /* !! */  == null) {
                return;
            }
            bound = offset + length;
            if (length <= 0) ** GOTO lbl17
            while (offset != bound) {
                e /* !! */ .setKey(element);
                e /* !! */  = e /* !! */ .next;
                ++offset;
            }
            break block3;
lbl-1000:
            // 1 sources

            {
                e /* !! */ .setKey(element);
                e /* !! */  = e /* !! */ .prev;
                --offset;
lbl17:
                // 2 sources

                ** while (offset != bound)
            }
        }
    }

    @Override
    public final int keyReplaceOne(K element, K replacement) {
        int i = 0;
        Object e = this.head.next;
        while (e != null) {
            if (((AbstractChainEntry)e).key() == element) {
                ((AbstractChainEntry)e).setKey(replacement);
                return i;
            }
            ++i;
            e = ((AbstractChainEntry)e).next;
        }
        return -1;
    }

    @Override
    public final int keyReplace(K element, K replacement) {
        int replaceCount = 0;
        Object e = this.head.next;
        while (e != null) {
            if (((AbstractChainEntry)e).key() == element) {
                ((AbstractChainEntry)e).setKey(replacement);
                ++replaceCount;
            }
            e = ((AbstractChainEntry)e).next;
        }
        return replaceCount;
    }

    @Override
    public final int keyReplaceAll(K[] elements, int elementsOffset, int elementsLength, K replacement) {
        int d = ChainStorageStrong.validateArrayIteration(elements, elementsOffset, elementsLength);
        if (d == 0) {
            return 0;
        }
        int elementsBound = elementsOffset + elementsLength;
        int replaceCount = 0;
        Object e = this.head.next;
        while (e != null) {
            Object element = ((AbstractChainEntry)e).key();
            int i = elementsOffset;
            while (i != elementsBound) {
                if (element == elements[i]) {
                    ((AbstractChainEntry)e).setKey(replacement);
                    ++replaceCount;
                    break;
                }
                i += d;
            }
            e = ((AbstractChainEntry)e).next;
        }
        return replaceCount;
    }

    @Override
    public final int keyReplaceAll(XGettingCollection<? extends K> elements, final K replacement) {
        if (elements instanceof AbstractSimpleArrayCollection) {
            return this.keyReplaceAll(AbstractSimpleArrayCollection.internalGetStorageArray((AbstractSimpleArrayCollection)((Object)elements)), 0, XTypes.to_int(elements.size()), replacement);
        }
        return elements.iterate(new Consumer<K>(){
            int replaceCount;

            @Override
            public void accept(K e) {
                this.replaceCount += ChainStrongStrongStorage.this.keyReplace(e, replacement);
            }
        }).replaceCount;
    }

    @Override
    public final int keySubstituteOne(Predicate<? super K> predicate, K substitute) {
        try {
            int i = 0;
            Object e = this.head.next;
            while (e != null) {
                if (predicate.test(((AbstractChainEntry)e).key())) {
                    ((AbstractChainEntry)e).setKey(substitute);
                    return i;
                }
                ++i;
                e = ((AbstractChainEntry)e).next;
            }
        }
        catch (ThrowBreak throwBreak) {
            // empty catch block
        }
        return -1;
    }

    @Override
    public final int keySubstitute(Predicate<? super K> predicate, K substitute) {
        int replaceCount = 0;
        Object e = this.head.next;
        while (e != null) {
            if (predicate.test(((AbstractChainEntry)e).key())) {
                ((AbstractChainEntry)e).setKey(substitute);
                ++replaceCount;
            }
            e = ((AbstractChainEntry)e).next;
        }
        return replaceCount;
    }

    @Override
    public final long keySubstitute(Function<? super K, ? extends K> mapper, BiConsumer<EN, K> callback) {
        long count = 0L;
        try {
            AbstractChainEntry entry = this.head;
            while ((entry = entry.next) != null) {
                K newElement = mapper.apply(entry.key());
                if (newElement == entry.key()) continue;
                callback.accept(entry, newElement);
                ++count;
            }
        }
        catch (ThrowBreak throwBreak) {
            // empty catch block
        }
        return count;
    }

    @Override
    public final int keySubstitute(Predicate<? super K> predicate, Function<? super K, ? extends K> mapper) {
        int replaceCount = 0;
        try {
            Object e = this.head.next;
            while (e != null) {
                if (predicate.test(((AbstractChainEntry)e).key())) {
                    ((AbstractChainEntry)e).setKey(mapper.apply(((AbstractChainEntry)e).key()));
                    ++replaceCount;
                }
                e = ((AbstractChainEntry)e).next;
            }
        }
        catch (ThrowBreak throwBreak) {
            // empty catch block
        }
        return replaceCount;
    }

    /*
     * Unable to fully structure code
     * Could not resolve type clashes
     */
    @Override
    public final int keyCopyToArray(int offset, int length, Object[] target, int targetOffset) {
        block5: {
            e /* !! */  = this.getRangeChainEntry(offset, length);
            if (e /* !! */  == null) {
                return 0;
            }
            if (targetOffset < 0) {
                throw new ArrayIndexOutOfBoundsException(targetOffset);
            }
            if ((length < 0 ? -length : length) + targetOffset > target.length) {
                throw new ArrayIndexOutOfBoundsException((length < 0 ? -length : length) + targetOffset);
            }
            t = targetOffset;
            if (length <= 0) ** GOTO lbl17
            while (length-- > 0) {
                target[t++] = e /* !! */ .key();
                e /* !! */  = e /* !! */ .next;
            }
            break block5;
lbl-1000:
            // 1 sources

            {
                target[t++] = e /* !! */ .key();
                e /* !! */  = e /* !! */ .prev;
lbl17:
                // 2 sources

                ** while (length++ < 0)
            }
        }
        return t - targetOffset;
    }

    @Override
    public final VarString keyAppendTo(VarString vc) {
        AbstractChainEntry entry = this.head;
        while ((entry = entry.next) != null) {
            vc.add(entry.key());
        }
        return vc;
    }

    @Override
    public final VarString keyAppendTo(VarString vc, char separator) {
        if (this.head.next == null) {
            return vc;
        }
        AbstractChainEntry entry = this.head;
        while ((entry = entry.next) != null) {
            vc.add(entry.key()).add(separator);
        }
        return vc.deleteLast();
    }

    @Override
    public final VarString keyAppendTo(VarString vc, String separator) {
        if (separator == null || separator.isEmpty()) {
            return this.valuesAppendTo(vc);
        }
        Object entry = this.head.next;
        if (entry == null) {
            return vc;
        }
        vc.add(((AbstractChainEntry)entry).value());
        char[] sepp = XChars.readChars(separator);
        while ((entry = ((AbstractChainEntry)entry).next) != null) {
            vc.add(sepp).add(((AbstractChainEntry)entry).value());
        }
        return vc;
    }

    @Override
    public final VarString keyAppendTo(VarString vc, BiConsumer<VarString, ? super K> keyAppender) {
        Object entry = this.head.next;
        while (entry != null) {
            keyAppender.accept(vc, ((AbstractChainEntry)entry).key());
            entry = ((AbstractChainEntry)entry).next;
        }
        return vc;
    }

    @Override
    public final VarString keyAppendTo(VarString vc, BiConsumer<VarString, ? super K> keyAppender, char separator) {
        Object entry = this.head.next;
        if (entry == null) {
            return vc;
        }
        keyAppender.accept(vc, ((AbstractChainEntry)entry).key());
        while ((entry = ((AbstractChainEntry)entry).next) != null) {
            keyAppender.accept(vc.append(separator), ((AbstractChainEntry)entry).key());
        }
        return vc;
    }

    @Override
    public final VarString keyAppendTo(VarString vc, BiConsumer<VarString, ? super K> keyAppender, String separator) {
        if (separator == null || separator.isEmpty()) {
            return this.keyAppendTo(vc, keyAppender);
        }
        Object entry = this.head.next;
        if (entry == null) {
            return vc;
        }
        char[] sepp = XChars.readChars(separator);
        keyAppender.accept(vc, ((AbstractChainEntry)entry).key());
        while ((entry = ((AbstractChainEntry)entry).next) != null) {
            keyAppender.accept(vc.add(sepp), ((AbstractChainEntry)entry).key());
        }
        return vc;
    }

    /*
     * Unable to fully structure code
     */
    private static <K, V, EN extends AbstractChainEntry<KeyValue<K, V>, K, V, EN>> void valuesMergesortHead(EN head, Comparator<? super V> comparator) {
        block4: {
            try {
                entry = ChainStrongStrongStorage.valuesMergesort0(head.next, comparator);
                break block4;
            }
            catch (Throwable e) {
                entry = head.prev;
                if (true) ** GOTO lbl9
            }
            do {
                entry.next = last;
lbl9:
                // 2 sources

                last = entry;
            } while ((entry = last.prev) != head);
            throw e;
        }
        head.next = entry;
        entry.prev = head;
        if (true) ** GOTO lbl18
        do {
            entry.prev = last;
lbl18:
            // 2 sources

            last = entry;
        } while ((entry = last.next) != null);
        head.prev = last;
    }

    /*
     * Handled impossible loop by duplicating code
     * Enabled aggressive block sorting
     */
    private static <K, V, EN extends AbstractChainEntry<KeyValue<K, V>, K, V, EN>> EN valuesMergesort0(EN chain, Comparator<? super V> comparator) {
        Object chain2;
        if (chain == null || chain.next == null) {
            return chain;
        }
        EN t1 = chain;
        Object t2 = chain2 = t1.next;
        if (true) {
            return ChainStrongStrongStorage.valuesMerge1(ChainStrongStrongStorage.valuesMergesort0(chain, comparator), ChainStrongStrongStorage.valuesMergesort0(chain2, comparator), comparator);
        }
        do {
            t2 = ((AbstractChainEntry)t2).next = t1.next;
            if (t2 == null) return ChainStrongStrongStorage.valuesMerge1(ChainStrongStrongStorage.valuesMergesort0(chain, comparator), ChainStrongStrongStorage.valuesMergesort0(chain2, comparator), comparator);
            t1.next = ((AbstractChainEntry)t2).next;
            t1 = t1.next;
        } while (t1.next != null);
        return ChainStrongStrongStorage.valuesMerge1(ChainStrongStrongStorage.valuesMergesort0(chain, comparator), ChainStrongStrongStorage.valuesMergesort0(chain2, comparator), comparator);
    }

    private static <K, V, EN extends AbstractChainEntry<KeyValue<K, V>, K, V, EN>> EN valuesMerge1(EN c1, EN c2, Comparator<? super V> cmp) {
        EN c;
        if (c1 == null) {
            return c2;
        }
        if (c2 == null) {
            return c1;
        }
        if (cmp.compare(c1.value(), c2.value()) < 0) {
            c = c1;
            c1 = c.next;
        } else {
            c = c2;
            c2 = c.next;
        }
        EN t = c;
        while (true) {
            if (c1 == null) {
                t.next = c2;
                break;
            }
            if (c2 == null) {
                t.next = c1;
                break;
            }
            if (cmp.compare(c1.value(), c2.value()) < 0) {
                t.next = c1;
                t = t.next;
                c1 = ((AbstractChainEntry)t.next).next;
                continue;
            }
            t.next = c2;
            t = t.next;
            c2 = ((AbstractChainEntry)t.next).next;
        }
        return c;
    }

    @Override
    public final Iterator<V> valuesIterator() {
        return new ValueItr();
    }

    @Override
    public final ListIterator<V> valuesListIterator(long index) {
        return new ValueListItr(X.checkArrayRange(index));
    }

    @Override
    public final boolean valuesEqualsContent(XGettingCollection<? extends V> other, final Equalator<? super V> equalator) {
        if (XTypes.to_int(this.parent.size()) != XTypes.to_int(other.size())) {
            return false;
        }
        if (other instanceof AbstractSimpleArrayCollection) {
            int otherSize = XTypes.to_int(other.size());
            E[] otherData = AbstractSimpleArrayCollection.internalGetStorageArray((AbstractSimpleArrayCollection)((Object)other));
            Object entry = this.head.next;
            int i = 0;
            while (i < otherSize) {
                if (!equalator.equal(((AbstractChainEntry)entry).value(), otherData[i])) {
                    return false;
                }
                ++i;
                entry = ((AbstractChainEntry)entry).next;
            }
            return true;
        }
        Aggregator agg = new Aggregator<V, Boolean>(){
            private EN entry;
            private boolean notEqual;
            {
                this.entry = ChainStrongStrongStorage.this.head;
            }

            @Override
            public final void accept(V element) {
                this.entry = ((AbstractChainEntry)this.entry).next;
                if (this.entry == null) {
                    this.notEqual = true;
                    throw X.BREAK();
                }
                if (!equalator.equal(element, ((AbstractChainEntry)this.entry).value())) {
                    this.notEqual = true;
                    throw X.BREAK();
                }
            }

            @Override
            public final Boolean yield() {
                return this.notEqual || this.entry == null || (this.entry = ((AbstractChainEntry)this.entry).next) != null ? Boolean.FALSE : Boolean.TRUE;
            }
        };
        other.iterate(agg);
        return (Boolean)agg.yield();
    }

    @Override
    public final boolean hasVolatileValues() {
        return false;
    }

    @Override
    public final ReferenceType getValueReferenceType() {
        return ReferenceType.STRONG;
    }

    @Override
    public final boolean valuesContainsNull() {
        Object e = this.head.next;
        while (e != null) {
            if (((AbstractChainEntry)e).hasNullKey()) {
                return true;
            }
            e = ((AbstractChainEntry)e).next;
        }
        return false;
    }

    @Override
    public final boolean valuesContainsId(V element) {
        Object e = this.head.next;
        while (e != null) {
            if (((AbstractChainEntry)e).value() == element) {
                return true;
            }
            e = ((AbstractChainEntry)e).next;
        }
        return false;
    }

    @Override
    public final boolean valuesContains(V element) {
        Object e = this.head.next;
        while (e != null) {
            if (((AbstractChainEntry)e).value() == element) {
                return true;
            }
            e = ((AbstractChainEntry)e).next;
        }
        return false;
    }

    @Override
    public final boolean valuesContains(V sample, Equalator<? super V> equalator) {
        Object e = this.head.next;
        while (e != null) {
            if (equalator.equal(((AbstractChainEntry)e).value(), sample)) {
                return true;
            }
            e = ((AbstractChainEntry)e).next;
        }
        return false;
    }

    @Override
    public final boolean valuesContainsAll(V[] elements, int elementsOffset, int elementsLength) {
        Object first = this.head.next;
        if (first == null) {
            return false;
        }
        int d = ChainStorageStrong.validateArrayIteration(elements, elementsOffset, elementsLength);
        if (d == 0) {
            return true;
        }
        int elementsBound = elementsOffset + elementsLength;
        int ei = elementsOffset;
        while (ei != elementsBound) {
            block5: {
                V element = elements[ei];
                Object e = first;
                while (e != null) {
                    if (((AbstractChainEntry)e).value() != element) {
                        e = ((AbstractChainEntry)e).next;
                        continue;
                    }
                    break block5;
                }
                return false;
            }
            ei += d;
        }
        return true;
    }

    @Override
    public final boolean valuesContainsAll(V[] elements, int elementsOffset, int elementsLength, Equalator<? super V> equalator) {
        Object first = this.head.next;
        if (first == null) {
            return false;
        }
        int d = ChainStorageStrong.validateArrayIteration(elements, elementsOffset, elementsLength);
        if (d == 0) {
            return true;
        }
        int elementsBound = elementsOffset + elementsLength;
        int ei = elementsOffset;
        while (ei != elementsBound) {
            block5: {
                V element = elements[ei];
                Object e = first;
                while (e != null) {
                    if (!equalator.equal(((AbstractChainEntry)e).value(), element)) {
                        e = ((AbstractChainEntry)e).next;
                        continue;
                    }
                    break block5;
                }
                return false;
            }
            ei += d;
        }
        return true;
    }

    @Override
    public final boolean valuesContainsAll(XGettingCollection<? extends V> elements) {
        if (elements instanceof AbstractSimpleArrayCollection) {
            return this.valuesContainsAll(AbstractSimpleArrayCollection.internalGetStorageArray((AbstractSimpleArrayCollection)((Object)elements)), 0, XTypes.to_int(elements.size()));
        }
        return elements.applies(e -> this.valuesContains(e));
    }

    @Override
    public final boolean valuesContainsAll(XGettingCollection<? extends V> elements, Equalator<? super V> equalator) {
        if (elements instanceof AbstractSimpleArrayCollection) {
            return this.valuesContainsAll(AbstractSimpleArrayCollection.internalGetStorageArray((AbstractSimpleArrayCollection)((Object)elements)), 0, XTypes.to_int(elements.size()), equalator);
        }
        Object first = this.head.next;
        return elements.applies(e -> {
            AbstractChainEntry entry = first;
            while (entry != null) {
                if (equalator.equal((Object)entry.value(), (Object)e)) {
                    return true;
                }
                entry = entry.next;
            }
            return false;
        });
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public final boolean valuesApplies(Predicate<? super V> predicate) {
        try {
            Object e = this.head.next;
            while (true) {
                if (e == null) {
                    return false;
                }
                if (predicate.test(((AbstractChainEntry)e).value())) {
                    return true;
                }
                e = ((AbstractChainEntry)e).next;
            }
        }
        catch (ThrowBreak throwBreak) {
            // empty catch block
        }
        return false;
    }

    /*
     * Unable to fully structure code
     */
    @Override
    public final boolean valuesAppliesAll(Predicate<? super V> predicate) {
        e = this.head;
        if (e.next != null) ** GOTO lbl6
        return false;
lbl-1000:
        // 1 sources

        {
            if (predicate.test(e.value())) continue;
            return false;
lbl6:
            // 2 sources

            ** while ((e = e.next) != null)
        }
lbl7:
        // 1 sources

        return true;
    }

    @Override
    public final int valuesCount(V element) {
        int count = 0;
        Object e = this.head.next;
        while (e != null) {
            if (((AbstractChainEntry)e).value() == element) {
                ++count;
            }
            e = ((AbstractChainEntry)e).next;
        }
        return count;
    }

    @Override
    public final int valuesCount(V sample, Equalator<? super V> equalator) {
        int count = 0;
        Object e = this.head.next;
        while (e != null) {
            if (equalator.equal(((AbstractChainEntry)e).value(), sample)) {
                ++count;
            }
            e = ((AbstractChainEntry)e).next;
        }
        return count;
    }

    @Override
    public final int valuesCount(Predicate<? super V> predicate) {
        int count = 0;
        try {
            Object e = this.head.next;
            while (e != null) {
                if (predicate.test(((AbstractChainEntry)e).value())) {
                    ++count;
                }
                e = ((AbstractChainEntry)e).next;
            }
        }
        catch (ThrowBreak throwBreak) {
            // empty catch block
        }
        return count;
    }

    @Override
    public final <C extends Consumer<? super V>> C valuesIntersect(XGettingCollection<? extends V> samples, Equalator<? super V> equalator, C target) {
        if (samples instanceof AbstractSimpleArrayCollection) {
            E[] array = AbstractSimpleArrayCollection.internalGetStorageArray((AbstractSimpleArrayCollection)((Object)samples));
            int size = XTypes.to_int(samples.size());
            Object entry = this.head.next;
            while (entry != null) {
                Object element = ((AbstractChainEntry)entry).value();
                int i = 0;
                while (i < size) {
                    if (equalator.equal(element, array[i])) {
                        target.accept(element);
                        break;
                    }
                    ++i;
                }
                entry = ((AbstractChainEntry)entry).next;
            }
            return target;
        }
        CachedSampleEquality<? super V> equalCurrentElement = new CachedSampleEquality<V>(equalator);
        Object entry = this.head.next;
        while (entry != null) {
            equalCurrentElement.sample = ((AbstractChainEntry)entry).value();
            if (samples.containsSearched(equalCurrentElement)) {
                target.accept(equalCurrentElement.sample);
            }
            entry = ((AbstractChainEntry)entry).next;
        }
        return target;
    }

    @Override
    public final <C extends Consumer<? super V>> C valuesExcept(XGettingCollection<? extends V> samples, Equalator<? super V> equalator, C target) {
        if (samples instanceof AbstractSimpleArrayCollection) {
            E[] array = AbstractSimpleArrayCollection.internalGetStorageArray((AbstractSimpleArrayCollection)((Object)samples));
            int size = XTypes.to_int(samples.size());
            Object entry = this.head.next;
            while (entry != null) {
                block6: {
                    Object element = ((AbstractChainEntry)entry).value();
                    int i = 0;
                    while (i < size) {
                        if (!equalator.equal(element, array[i])) {
                            ++i;
                            continue;
                        }
                        break block6;
                    }
                    target.accept(element);
                }
                entry = ((AbstractChainEntry)entry).next;
            }
            return target;
        }
        CachedSampleEquality<? super V> equalCurrentElement = new CachedSampleEquality<V>(equalator);
        Object entry = this.head.next;
        while (entry != null) {
            equalCurrentElement.sample = ((AbstractChainEntry)entry).value();
            if (!samples.containsSearched(equalCurrentElement)) {
                target.accept(equalCurrentElement.sample);
            }
            entry = ((AbstractChainEntry)entry).next;
        }
        return target;
    }

    @Override
    public final <C extends Consumer<? super V>> C valuesUnion(XGettingCollection<? extends V> samples, Equalator<? super V> equalator, C target) {
        this.valuesCopyTo(target);
        if (samples instanceof AbstractSimpleArrayCollection) {
            E[] array = AbstractSimpleArrayCollection.internalGetStorageArray((AbstractSimpleArrayCollection)((Object)samples));
            int size = XTypes.to_int(samples.size());
            int i = 0;
            while (i < size) {
                block4: {
                    Object sample = array[i];
                    Object entry = this.head.next;
                    while (entry != null) {
                        if (!equalator.equal(((AbstractChainEntry)entry).value(), sample)) {
                            entry = ((AbstractChainEntry)entry).next;
                            continue;
                        }
                        break block4;
                    }
                    target.accept(sample);
                }
                ++i;
            }
            return target;
        }
        samples.iterate(e -> {
            Equalator equalator2 = equalator;
            Object entry = this.head.next;
            while (entry != null) {
                if (equalator2.equal(e, ((AbstractChainEntry)entry).value())) {
                    return;
                }
                entry = ((AbstractChainEntry)entry).next;
            }
            target.accept(e);
        });
        return target;
    }

    @Override
    public final <C extends Consumer<? super V>> C valuesCopyTo(C target) {
        Object e = this.head.next;
        while (e != null) {
            target.accept(((AbstractChainEntry)e).value());
            e = ((AbstractChainEntry)e).next;
        }
        return target;
    }

    @Override
    public final <C extends Consumer<? super V>> C valuesCopySelection(C target, long ... indices) {
        int length = indices.length;
        int size = XTypes.to_int(this.parent.size());
        int i = 0;
        while (i < length) {
            if (indices[i] < 0L || indices[i] >= (long)size) {
                throw new IndexOutOfBoundsException(ChainStrongStrongStorage.exceptionIndexOutOfBounds(size, indices[i]));
            }
            ++i;
        }
        i = 0;
        while (i < length) {
            target.accept(((AbstractChainEntry)this.getChainEntry(indices[i])).value());
            ++i;
        }
        return target;
    }

    /*
     * Unable to fully structure code
     * Could not resolve type clashes
     */
    @Override
    public final int valuesCopyToArray(long offset, int length, Object[] target, int targetOffset) {
        block5: {
            e /* !! */  = this.getRangeChainEntry(offset, length);
            if (e /* !! */  == null) {
                return 0;
            }
            if (targetOffset < 0) {
                throw new ArrayIndexOutOfBoundsException(targetOffset);
            }
            if ((length < 0 ? -length : length) + targetOffset > target.length) {
                throw new ArrayIndexOutOfBoundsException((length < 0 ? -length : length) + targetOffset);
            }
            t = targetOffset;
            if (length <= 0) ** GOTO lbl17
            while (length-- > 0) {
                target[t++] = e /* !! */ .value();
                e /* !! */  = e /* !! */ .next;
            }
            break block5;
lbl-1000:
            // 1 sources

            {
                target[t++] = e /* !! */ .value();
                e /* !! */  = e /* !! */ .prev;
lbl17:
                // 2 sources

                ** while (length++ < 0)
            }
        }
        return t - targetOffset;
    }

    @Override
    public final <C extends Consumer<? super V>> C valuesCopyTo(C target, Predicate<? super V> predicate) {
        try {
            Object e = this.head.next;
            while (e != null) {
                if (predicate.test(((AbstractChainEntry)e).value())) {
                    target.accept(((AbstractChainEntry)e).value());
                }
                e = ((AbstractChainEntry)e).next;
            }
        }
        catch (ThrowBreak throwBreak) {
            // empty catch block
        }
        return target;
    }

    @Override
    public final Object[] valuesToArray() {
        Object[] array = new Object[XTypes.to_int(this.parent.size())];
        this.valuesCopyToArray(0L, XTypes.to_int(this.parent.size()), array, 0);
        return array;
    }

    @Override
    public final V[] valuesToArray(Class<V> type) {
        Object[] array = X.Array(type, XTypes.to_int(this.parent.size()));
        this.valuesCopyToArray(0L, XTypes.to_int(this.parent.size()), array, 0);
        return array;
    }

    @Override
    public final V valuesFirst() {
        return this.head.next == null ? null : (V)((AbstractChainEntry)this.head.next).value();
    }

    @Override
    public final V valuesLast() {
        return this.head.prev == this.head ? null : (V)((AbstractChainEntry)this.head.prev).value();
    }

    @Override
    public final V valuesGet(long index) {
        return ((AbstractChainEntry)this.getChainEntry(index)).value();
    }

    @Override
    public final V valuesSeek(V element) {
        Object e = this.head.next;
        while (e != null) {
            if (((AbstractChainEntry)e).value() == element) {
                return ((AbstractChainEntry)e).value();
            }
            e = ((AbstractChainEntry)e).next;
        }
        return null;
    }

    @Override
    public final V valuesSearch(V sample, Equalator<? super V> equalator) {
        Object e = this.head.next;
        while (e != null) {
            if (equalator.equal(((AbstractChainEntry)e).value(), sample)) {
                return ((AbstractChainEntry)e).value();
            }
            e = ((AbstractChainEntry)e).next;
        }
        return null;
    }

    @Override
    public final V valuesSearch(Predicate<? super V> predicate) {
        try {
            Object e = this.head.next;
            while (e != null) {
                if (predicate.test(((AbstractChainEntry)e).value())) {
                    return ((AbstractChainEntry)e).value();
                }
                e = ((AbstractChainEntry)e).next;
            }
        }
        catch (ThrowBreak throwBreak) {
            // empty catch block
        }
        return null;
    }

    @Override
    public final V valuesMin(Comparator<? super V> comparator) {
        Object e = this.head.next;
        if (e == null) {
            return null;
        }
        Object loopMinElement = ((AbstractChainEntry)e).value();
        e = ((AbstractChainEntry)e).next;
        while (e != null) {
            Object element = ((AbstractChainEntry)e).value();
            if (comparator.compare(loopMinElement, element) > 0) {
                loopMinElement = element;
            }
            e = ((AbstractChainEntry)e).next;
        }
        return loopMinElement;
    }

    @Override
    public final V valuesMax(Comparator<? super V> comparator) {
        Object e = this.head.next;
        if (e == null) {
            return null;
        }
        Object loopMaxElement = ((AbstractChainEntry)e).value();
        e = ((AbstractChainEntry)e).next;
        while (e != null) {
            Object element = ((AbstractChainEntry)e).value();
            if (comparator.compare(loopMaxElement, element) < 0) {
                loopMaxElement = element;
            }
            e = ((AbstractChainEntry)e).next;
        }
        return loopMaxElement;
    }

    @Override
    public final void valuesIterate(Consumer<? super V> procedure) {
        try {
            Object e = this.head.next;
            while (e != null) {
                procedure.accept(((AbstractChainEntry)e).value());
                e = ((AbstractChainEntry)e).next;
            }
        }
        catch (ThrowBreak throwBreak) {
            // empty catch block
        }
    }

    @Override
    public final void valuesIterateIndexed(IndexedAcceptor<? super V> procedure) {
        try {
            int i = -1;
            AbstractChainEntry entry = this.head;
            while ((entry = entry.next) != null) {
                procedure.accept(entry.value(), ++i);
            }
        }
        catch (ThrowBreak throwBreak) {
            // empty catch block
        }
    }

    @Override
    public final <A> void valuesJoin(BiConsumer<? super V, A> joiner, A aggregate) {
        try {
            AbstractChainEntry entry = this.head;
            while ((entry = entry.next) != null) {
                joiner.accept(entry.value(), aggregate);
            }
        }
        catch (ThrowBreak throwBreak) {
            // empty catch block
        }
    }

    @Override
    public final void valuesIterate(Predicate<? super V> predicate, Consumer<? super V> procedure) {
        try {
            Object e = this.head.next;
            while (e != null) {
                if (predicate.test(((AbstractChainEntry)e).value())) {
                    procedure.accept(((AbstractChainEntry)e).value());
                }
                e = ((AbstractChainEntry)e).next;
            }
        }
        catch (ThrowBreak throwBreak) {
            // empty catch block
        }
    }

    @Override
    public final int valuesIndexOf(V element) {
        int i = 0;
        Object e = this.head.next;
        while (e != null) {
            if (((AbstractChainEntry)e).value() == element) {
                return i;
            }
            e = ((AbstractChainEntry)e).next;
            ++i;
        }
        return -1;
    }

    @Override
    public final int valuesIndexOf(V sample, Equalator<? super V> equalator) {
        int i = 0;
        Object e = this.head.next;
        while (e != null) {
            if (equalator.equal(((AbstractChainEntry)e).value(), sample)) {
                return i;
            }
            e = ((AbstractChainEntry)e).next;
            ++i;
        }
        return -1;
    }

    @Override
    public final int valuesIndexBy(Predicate<? super V> predicate) {
        int i = 0;
        try {
            Object e = this.head.next;
            while (e != null) {
                if (predicate.test(((AbstractChainEntry)e).value())) {
                    return i;
                }
                e = ((AbstractChainEntry)e).next;
                ++i;
            }
        }
        catch (ThrowBreak throwBreak) {
            // empty catch block
        }
        return -1;
    }

    @Override
    public final int valuesLastIndexOf(V element) {
        int i = 0;
        Object e = this.head.prev;
        while (e != this.head) {
            if (((AbstractChainEntry)e).value() == element) {
                return i;
            }
            e = ((AbstractChainEntry)e).prev;
            ++i;
        }
        return -1;
    }

    @Override
    public final int valuesLastIndexOf(V sample, Equalator<? super V> equalator) {
        int i = 0;
        Object e = this.head.prev;
        while (e != this.head) {
            if (equalator.equal(((AbstractChainEntry)e).value(), sample)) {
                return i;
            }
            e = ((AbstractChainEntry)e).prev;
            ++i;
        }
        return -1;
    }

    @Override
    public final int valuesLastIndexBy(Predicate<? super V> predicate) {
        int i = 0;
        try {
            Object e = this.head.prev;
            while (e != this.head) {
                if (predicate.test(((AbstractChainEntry)e).value())) {
                    return i;
                }
                e = ((AbstractChainEntry)e).prev;
                ++i;
            }
        }
        catch (ThrowBreak throwBreak) {
            // empty catch block
        }
        return -1;
    }

    @Override
    public final int valuesMinIndex(Comparator<? super V> comparator) {
        Object e = this.head.next;
        if (e == null) {
            return -1;
        }
        Object loopMinElement = ((AbstractChainEntry)e).value();
        int loopMinIndex = 0;
        int i = 1;
        e = ((AbstractChainEntry)e).next;
        while (e != null) {
            Object element = ((AbstractChainEntry)e).value();
            if (comparator.compare(loopMinElement, element) > 0) {
                loopMinElement = element;
                loopMinIndex = i;
            }
            e = ((AbstractChainEntry)e).next;
            ++i;
        }
        return loopMinIndex;
    }

    @Override
    public final int valuesMaxIndex(Comparator<? super V> comparator) {
        Object e = this.head.next;
        if (e == null) {
            return -1;
        }
        Object loopMaxElement = ((AbstractChainEntry)e).value();
        int loopMaxIndex = 0;
        int i = 1;
        e = ((AbstractChainEntry)e).next;
        while (e != null) {
            Object element = ((AbstractChainEntry)e).value();
            if (comparator.compare(loopMaxElement, element) < 0) {
                loopMaxElement = element;
                loopMaxIndex = i;
            }
            e = ((AbstractChainEntry)e).next;
            ++i;
        }
        return loopMaxIndex;
    }

    @Override
    public final int valuesScan(Predicate<? super V> predicate) {
        int foundIndex = -1;
        try {
            int i = 0;
            Object e = this.head.next;
            while (e != null) {
                if (predicate.test(((AbstractChainEntry)e).value())) {
                    foundIndex = i;
                }
                e = ((AbstractChainEntry)e).next;
                ++i;
            }
        }
        catch (ThrowBreak throwBreak) {
            // empty catch block
        }
        return foundIndex;
    }

    @Override
    public final boolean valuesHasDistinctValues() {
        Object e = this.head.next;
        while (e != null) {
            Object element = ((AbstractChainEntry)e).value();
            Object lookAhead = ((AbstractChainEntry)e).next;
            while (lookAhead != null) {
                if (element == ((AbstractChainEntry)lookAhead).value()) {
                    return false;
                }
                lookAhead = ((AbstractChainEntry)lookAhead).next;
            }
            e = ((AbstractChainEntry)e).next;
        }
        return true;
    }

    @Override
    public final boolean valuesHasDistinctValues(Equalator<? super V> equalator) {
        Object e = this.head.next;
        while (e != null) {
            Object element = ((AbstractChainEntry)e).value();
            Object lookAhead = ((AbstractChainEntry)e).next;
            while (lookAhead != null) {
                if (equalator.equal(element, ((AbstractChainEntry)lookAhead).value())) {
                    return false;
                }
                lookAhead = ((AbstractChainEntry)lookAhead).next;
            }
            e = ((AbstractChainEntry)e).next;
        }
        return true;
    }

    @Override
    public final <C extends Consumer<? super V>> C valuesDistinct(C target) {
        Object e = this.head.next;
        while (e != null) {
            block3: {
                Object element = ((AbstractChainEntry)e).value();
                Object lookAhead = ((AbstractChainEntry)e).next;
                while (lookAhead != null) {
                    if (element != ((AbstractChainEntry)lookAhead).value()) {
                        lookAhead = ((AbstractChainEntry)lookAhead).next;
                        continue;
                    }
                    break block3;
                }
                target.accept(element);
            }
            e = ((AbstractChainEntry)e).next;
        }
        return target;
    }

    @Override
    public final <C extends Consumer<? super V>> C valuesDistinct(C target, Equalator<? super V> equalator) {
        Object e = this.head.next;
        while (e != null) {
            block3: {
                Object element = ((AbstractChainEntry)e).value();
                Object lookAhead = ((AbstractChainEntry)e).next;
                while (lookAhead != null) {
                    if (!equalator.equal(element, ((AbstractChainEntry)lookAhead).value())) {
                        lookAhead = ((AbstractChainEntry)lookAhead).next;
                        continue;
                    }
                    break block3;
                }
                target.accept(element);
            }
            e = ((AbstractChainEntry)e).next;
        }
        return target;
    }

    @Override
    public final VarString valuesAppendTo(VarString vc) {
        AbstractChainEntry entry = this.head;
        while ((entry = entry.next) != null) {
            vc.add(entry.value());
        }
        return vc;
    }

    @Override
    public final VarString valuesAppendTo(VarString vc, char separator) {
        if (this.head.next == null) {
            return vc;
        }
        AbstractChainEntry entry = this.head;
        while ((entry = entry.next) != null) {
            vc.add(entry.value()).add(separator);
        }
        return vc.deleteLast();
    }

    @Override
    public final VarString valuesAppendTo(VarString vc, String separator) {
        if (separator == null || separator.isEmpty()) {
            return this.valuesAppendTo(vc);
        }
        Object entry = this.head.next;
        if (entry == null) {
            return vc;
        }
        vc.add(((AbstractChainEntry)entry).value());
        char[] sepp = XChars.readChars(separator);
        while ((entry = ((AbstractChainEntry)entry).next) != null) {
            vc.add(sepp).add(((AbstractChainEntry)entry).value());
        }
        return vc;
    }

    @Override
    public final VarString valuesAppendTo(VarString vc, BiConsumer<VarString, ? super V> appender) {
        Object entry = this.head.next;
        while (entry != null) {
            appender.accept(vc, ((AbstractChainEntry)entry).value());
            entry = ((AbstractChainEntry)entry).next;
        }
        return vc;
    }

    @Override
    public final VarString valuesAppendTo(VarString vc, BiConsumer<VarString, ? super V> appender, char separator) {
        Object entry = this.head.next;
        if (entry == null) {
            return vc;
        }
        appender.accept(vc, ((AbstractChainEntry)entry).value());
        while ((entry = ((AbstractChainEntry)entry).next) != null) {
            appender.accept(vc.append(separator), ((AbstractChainEntry)entry).value());
        }
        return vc;
    }

    @Override
    public final VarString valuesAppendTo(VarString vc, BiConsumer<VarString, ? super V> appender, String separator) {
        if (separator == null || separator.isEmpty()) {
            return this.valuesAppendTo(vc, appender);
        }
        Object entry = this.head.next;
        if (entry == null) {
            return vc;
        }
        char[] sepp = XChars.readChars(separator);
        appender.accept(vc, ((AbstractChainEntry)entry).value());
        while ((entry = ((AbstractChainEntry)entry).next) != null) {
            appender.accept(vc.add(sepp), ((AbstractChainEntry)entry).value());
        }
        return vc;
    }

    @Override
    public final String valuesToString() {
        VarString vc = VarString.New((int)((float)XTypes.to_int(this.parent.size()) * 5.0f));
        Object e = this.head.next;
        while (e != null) {
            vc.append('(').add(((AbstractChainEntry)e).value()).add(')', '-');
            e = ((AbstractChainEntry)e).next;
        }
        if (vc.isEmpty()) {
            vc.add('(', ')');
        } else {
            vc.deleteLast();
        }
        return vc.toString();
    }

    @Override
    public final V valuesRemove(long index) {
        ChainStorage.Entry e = this.getChainEntry(index);
        ((AbstractChainEntry)e).removeFrom(this.parent);
        return ((AbstractChainEntry)e).value();
    }

    @Override
    public final int valuesRemoveNull() {
        AbstractChainCollection parent = this.parent;
        int removeCount = 0;
        Object e = this.head.next;
        while (e != null) {
            if (((AbstractChainEntry)e).hasNullKey()) {
                ((AbstractChainEntry)e).removeFrom(parent);
                ++removeCount;
            }
            e = ((AbstractChainEntry)e).next;
        }
        return removeCount;
    }

    @Override
    public final V valuesRetrieve(V element) {
        AbstractChainCollection parent = this.parent;
        Object e = this.head.next;
        while (e != null) {
            if (((AbstractChainEntry)e).value() == element) {
                ((AbstractChainEntry)e).removeFrom(parent);
                return ((AbstractChainEntry)e).value();
            }
            e = ((AbstractChainEntry)e).next;
        }
        return null;
    }

    @Override
    public final V valuesRetrieve(Predicate<? super V> predicate) {
        AbstractChainCollection parent = this.parent;
        Object e = this.head.next;
        while (e != null) {
            if (predicate.test(((AbstractChainEntry)e).value())) {
                ((AbstractChainEntry)e).removeFrom(parent);
                return ((AbstractChainEntry)e).value();
            }
            e = ((AbstractChainEntry)e).next;
        }
        return null;
    }

    @Override
    public final int valuesRemove(V element) {
        int oldSize = XTypes.to_int(this.parent.size());
        AbstractChainCollection parent = this.parent;
        Object e = this.head.next;
        while (e != null) {
            if (((AbstractChainEntry)e).value() == element) {
                ((AbstractChainEntry)e).removeFrom(parent);
            }
            e = ((AbstractChainEntry)e).next;
        }
        return oldSize - XTypes.to_int(this.parent.size());
    }

    @Override
    public final int valuesRemove(V sample, Equalator<? super V> equalator) {
        int oldSize = XTypes.to_int(this.parent.size());
        AbstractChainCollection parent = this.parent;
        Object e = this.head.next;
        while (e != null) {
            if (equalator.equal(((AbstractChainEntry)e).value(), sample)) {
                ((AbstractChainEntry)e).removeFrom(parent);
            }
            e = ((AbstractChainEntry)e).next;
        }
        return oldSize - XTypes.to_int(this.parent.size());
    }

    @Override
    public final int valuesRemoveAll(V[] elements, int elementsOffset, int elementsLength) {
        int d = ChainStorageStrong.validateArrayIteration(elements, elementsOffset, elementsLength);
        if (d == 0) {
            return 0;
        }
        int elementsBound = elementsOffset + elementsLength;
        AbstractChainCollection parent = this.parent;
        int removeCount = 0;
        Object e = this.head.next;
        while (e != null) {
            Object element = ((AbstractChainEntry)e).value();
            int i = elementsOffset;
            while (i != elementsBound) {
                if (element == elements[i]) {
                    ((AbstractChainEntry)e).removeFrom(parent);
                    ++removeCount;
                    break;
                }
                i += d;
            }
            e = ((AbstractChainEntry)e).next;
        }
        return removeCount;
    }

    @Override
    public final int valuesRemoveAll(V[] samples, int samplesOffset, int samplesLength, Equalator<? super V> equalator) {
        int d = ChainStorageStrong.validateArrayIteration(samples, samplesOffset, samplesLength);
        if (d == 0) {
            return 0;
        }
        int elementsBound = samplesOffset + samplesLength;
        AbstractChainCollection parent = this.parent;
        int removeCount = 0;
        Object e = this.head.next;
        while (e != null) {
            Object element = ((AbstractChainEntry)e).value();
            int i = samplesOffset;
            while (i != elementsBound) {
                if (equalator.equal(element, samples[i])) {
                    ((AbstractChainEntry)e).removeFrom(parent);
                    ++removeCount;
                    break;
                }
                i += d;
            }
            e = ((AbstractChainEntry)e).next;
        }
        return removeCount;
    }

    @Override
    public final int valuesRemoveAll(XGettingCollection<? extends V> elements) {
        if (elements instanceof AbstractSimpleArrayCollection) {
            return this.valuesRemoveAll(AbstractSimpleArrayCollection.internalGetStorageArray((AbstractSimpleArrayCollection)((Object)elements)), 0, XTypes.to_int(elements.size()));
        }
        return elements.iterate(new Consumer<V>(){
            int removeCount;

            @Override
            public void accept(V e) {
                this.removeCount += ChainStrongStrongStorage.this.valuesRemove(e);
            }
        }).removeCount;
    }

    @Override
    public final int valuesRemoveAll(XGettingCollection<? extends V> samples, final Equalator<? super V> equalator) {
        if (samples instanceof AbstractSimpleArrayCollection) {
            return this.valuesRemoveAll(AbstractSimpleArrayCollection.internalGetStorageArray((AbstractSimpleArrayCollection)((Object)samples)), 0, XTypes.to_int(samples.size()), equalator);
        }
        return samples.iterate(new Consumer<V>(){
            int removeCount;

            @Override
            public void accept(V e) {
                this.removeCount += ChainStrongStrongStorage.this.valuesRemove(e, equalator);
            }
        }).removeCount;
    }

    @Override
    public final int valuesRemoveDuplicates() {
        AbstractChainCollection parent = this.parent;
        int removeCount = 0;
        Object e = this.head.next;
        while (e != null) {
            Object element = ((AbstractChainEntry)e).value();
            Object lookAhead = ((AbstractChainEntry)e).next;
            while (lookAhead != null) {
                if (element == ((AbstractChainEntry)lookAhead).value()) {
                    ((AbstractChainEntry)lookAhead).removeFrom(parent);
                    ++removeCount;
                }
                lookAhead = ((AbstractChainEntry)lookAhead).next;
            }
            e = ((AbstractChainEntry)e).next;
        }
        return removeCount;
    }

    @Override
    public final int valuesRemoveDuplicates(Equalator<? super V> equalator) {
        AbstractChainCollection parent = this.parent;
        int removeCount = 0;
        Object e = this.head.next;
        while (e != null) {
            Object element = ((AbstractChainEntry)e).value();
            Object lookAhead = ((AbstractChainEntry)e).next;
            while (lookAhead != null) {
                if (equalator.equal(element, ((AbstractChainEntry)lookAhead).value())) {
                    ((AbstractChainEntry)lookAhead).removeFrom(parent);
                    ++removeCount;
                }
                lookAhead = ((AbstractChainEntry)lookAhead).next;
            }
            e = ((AbstractChainEntry)e).next;
        }
        return removeCount;
    }

    @Override
    public final int valuesReduce(Predicate<? super V> predicate) {
        int removeCount = 0;
        try {
            AbstractChainCollection parent = this.parent;
            Object e = this.head.next;
            while (e != null) {
                if (predicate.test(((AbstractChainEntry)e).value())) {
                    ((AbstractChainEntry)e).removeFrom(parent);
                    ++removeCount;
                }
                e = ((AbstractChainEntry)e).next;
            }
        }
        catch (ThrowBreak throwBreak) {
            // empty catch block
        }
        return removeCount;
    }

    @Override
    public final int valuesRetainAll(V[] elements, int elementsOffset, int elementsLength) {
        int d = ChainStorageStrong.validateArrayIteration(elements, elementsOffset, elementsLength);
        if (d == 0) {
            return 0;
        }
        int elementsBound = elementsOffset + elementsLength;
        AbstractChainCollection parent = this.parent;
        int removeCount = 0;
        Object e = this.head.next;
        while (e != null) {
            block4: {
                Object element = ((AbstractChainEntry)e).value();
                int i = elementsOffset;
                while (i != elementsBound) {
                    if (element != elements[i]) {
                        i += d;
                        continue;
                    }
                    break block4;
                }
                ((AbstractChainEntry)e).removeFrom(parent);
                ++removeCount;
            }
            e = ((AbstractChainEntry)e).next;
        }
        return removeCount;
    }

    @Override
    public final int valuesRetainAll(V[] samples, int samplesOffset, int samplesLength, Equalator<? super V> equalator) {
        int d = ChainStorageStrong.validateArrayIteration(samples, samplesOffset, samplesLength);
        if (d == 0) {
            return 0;
        }
        int samplesBound = samplesOffset + samplesLength;
        AbstractChainCollection parent = this.parent;
        int removeCount = 0;
        Object e = this.head.next;
        while (e != null) {
            block4: {
                Object element = ((AbstractChainEntry)e).value();
                int i = samplesOffset;
                while (i != samplesBound) {
                    if (!equalator.equal(element, samples[i])) {
                        i += d;
                        continue;
                    }
                    break block4;
                }
                ((AbstractChainEntry)e).removeFrom(parent);
                ++removeCount;
            }
            e = ((AbstractChainEntry)e).next;
        }
        return removeCount;
    }

    @Override
    public final int valuesRetainAll(XGettingCollection<? extends V> elements) {
        if (elements instanceof AbstractSimpleArrayCollection) {
            return this.valuesRetainAll(AbstractSimpleArrayCollection.internalGetStorageArray((AbstractSimpleArrayCollection)((Object)elements)), 0, XTypes.to_int(elements.size()));
        }
        ElementIsContained currentElement = new ElementIsContained();
        AbstractChainCollection parent = this.parent;
        int removeCount = 0;
        Object e = this.head.next;
        while (e != null) {
            currentElement.element = ((AbstractChainEntry)e).value();
            if (!elements.containsSearched(currentElement)) {
                ((AbstractChainEntry)e).removeFrom(parent);
                ++removeCount;
            }
            e = ((AbstractChainEntry)e).next;
        }
        return removeCount;
    }

    @Override
    public final int valuesRetainAll(XGettingCollection<? extends V> samples, Equalator<? super V> equalator) {
        if (samples instanceof AbstractSimpleArrayCollection) {
            return this.valuesRetainAll(AbstractSimpleArrayCollection.internalGetStorageArray((AbstractSimpleArrayCollection)((Object)samples)), 0, XTypes.to_int(samples.size()), equalator);
        }
        CachedSampleEquality<? super V> equalCurrentElement = new CachedSampleEquality<V>(equalator);
        AbstractChainCollection parent = this.parent;
        int removeCount = 0;
        Object e = this.head.next;
        while (e != null) {
            equalCurrentElement.sample = ((AbstractChainEntry)e).value();
            if (!samples.containsSearched(equalCurrentElement)) {
                ((AbstractChainEntry)e).removeFrom(parent);
                ++removeCount;
            }
            e = ((AbstractChainEntry)e).next;
        }
        return removeCount;
    }

    @Override
    public final int valuesProcess(Consumer<? super V> procedure) {
        AbstractChainCollection parent = this.parent;
        int removeCount = 0;
        try {
            Object e = this.head.next;
            while (e != null) {
                procedure.accept(((AbstractChainEntry)e).value());
                ((AbstractChainEntry)e).removeFrom(parent);
                ++removeCount;
                e = ((AbstractChainEntry)e).next;
            }
        }
        catch (ThrowBreak b) {
            removeCount += parent.internalClear();
        }
        return removeCount;
    }

    /*
     * Unable to fully structure code
     * Could not resolve type clashes
     */
    @Override
    public final int valuesMoveRange(int offset, int length, Consumer<? super V> target) {
        block3: {
            e /* !! */  = this.getRangeChainEntry(offset, length);
            if (e /* !! */  == null) {
                return 0;
            }
            parent = this.parent;
            bound = offset + length;
            if (length <= 0) ** GOTO lbl18
            while (offset != bound) {
                target.accept(e /* !! */ .value());
                e /* !! */ .removeFrom(parent);
                e /* !! */  = e /* !! */ .next;
                ++offset;
            }
            break block3;
lbl-1000:
            // 1 sources

            {
                target.accept(e /* !! */ .value());
                e /* !! */ .removeFrom(parent);
                e /* !! */  = e /* !! */ .prev;
                --offset;
lbl18:
                // 2 sources

                ** while (offset != bound)
            }
        }
        return length < 0 ? -length : length;
    }

    @Override
    public final int valuesMoveSelection(Consumer<? super V> target, long ... indices) {
        int indicesLength = indices.length;
        int size = XTypes.to_int(this.parent.size());
        int i = 0;
        while (i < indicesLength) {
            if (indices[i] < 0L || indices[i] >= (long)size) {
                throw new IndexOutOfBoundsException(ChainStrongStrongStorage.exceptionIndexOutOfBounds(size, indices[i]));
            }
            ++i;
        }
        AbstractChainCollection parent = this.parent;
        int i2 = 0;
        while (i2 < indicesLength) {
            ChainStorage.Entry e = this.getChainEntry(indices[i2]);
            target.accept(((AbstractChainEntry)e).value());
            ((AbstractChainEntry)e).removeFrom(parent);
            ++i2;
        }
        return indicesLength;
    }

    @Override
    public final int valuesMoveTo(Consumer<? super V> target, Predicate<? super V> predicate) {
        int removeCount = 0;
        try {
            AbstractChainCollection parent = this.parent;
            Object e = this.head.next;
            while (e != null) {
                Object element = ((AbstractChainEntry)e).value();
                if (predicate.test(element)) {
                    target.accept(element);
                    ((AbstractChainEntry)e).removeFrom(parent);
                    ++removeCount;
                }
                e = ((AbstractChainEntry)e).next;
            }
        }
        catch (ThrowBreak throwBreak) {
            // empty catch block
        }
        return removeCount;
    }

    @Override
    public final void valuesSort(Comparator<? super V> comparator) {
        if (comparator == null) {
            throw new NullPointerException();
        }
        if (XTypes.to_int(this.parent.size()) <= 1) {
            return;
        }
        ChainStrongStrongStorage.valuesMergesortHead(this.head, comparator);
    }

    @Override
    public final boolean valuesIsSorted(Comparator<? super V> comparator) {
        Object e = this.head.next;
        if (e == null) {
            return true;
        }
        Object loopLastElement = ((AbstractChainEntry)e).value();
        while ((e = ((AbstractChainEntry)e).next) != null) {
            Object element = ((AbstractChainEntry)e).value();
            if (comparator.compare(loopLastElement, element) > 0) {
                return false;
            }
            loopLastElement = element;
        }
        return true;
    }

    @Override
    public final V valuesSet(long offset, V value) {
        return ((AbstractChainEntry)this.getChainEntry(offset)).setValue(value);
    }

    @Override
    public final void valuesSet(long offset, V[] elements) {
        ChainStorage.Entry e = this.getRangeChainEntry(offset, elements.length);
        int i = 0;
        while (i < elements.length) {
            ((AbstractChainEntry)e).setValue(elements[i]);
            e = ((AbstractChainEntry)e).next;
            ++i;
        }
    }

    @Override
    public final void valuesSet(long offset, V[] elements, int elementsOffset, int elementsLength) {
        ChainStorage.Entry e = this.getRangeChainEntry(offset, elementsLength);
        int d = XArrays.validateArrayRange(elements, elementsOffset, elementsLength);
        int i = elementsOffset;
        int bound = elementsOffset + elementsLength;
        while (i != bound) {
            ((AbstractChainEntry)e).setValue(elements[i]);
            e = ((AbstractChainEntry)e).next;
            i += d;
        }
    }

    /*
     * Unable to fully structure code
     * Could not resolve type clashes
     */
    @Override
    public final void valuesFill(long offset, long length, V element) {
        block3: {
            e /* !! */  = this.getRangeChainEntry(offset, length);
            if (e /* !! */  == null) {
                return;
            }
            bound = offset + length;
            if (length <= 0L) ** GOTO lbl17
            while (offset != bound) {
                e /* !! */ .setValue(element);
                e /* !! */  = e /* !! */ .next;
                ++offset;
            }
            break block3;
lbl-1000:
            // 1 sources

            {
                e /* !! */ .setValue(element);
                e /* !! */  = e /* !! */ .prev;
                --offset;
lbl17:
                // 2 sources

                ** while (offset != bound)
            }
        }
    }

    @Override
    public final boolean valuesReplaceOne(V element, V replacement) {
        Object e = this.head.next;
        while (e != null) {
            if (((AbstractChainEntry)e).value() == element) {
                ((AbstractChainEntry)e).setValue(replacement);
                return true;
            }
            e = ((AbstractChainEntry)e).next;
        }
        return false;
    }

    @Override
    public final boolean valuesReplaceOne(V sample, Equalator<? super V> equalator, V replacement) {
        Object e = this.head.next;
        while (e != null) {
            if (equalator.equal(((AbstractChainEntry)e).value(), sample)) {
                ((AbstractChainEntry)e).setValue(replacement);
                return true;
            }
            e = ((AbstractChainEntry)e).next;
        }
        return false;
    }

    @Override
    public final int valuesReplace(V element, V replacement) {
        int replaceCount = 0;
        Object e = this.head.next;
        while (e != null) {
            if (((AbstractChainEntry)e).value() == element) {
                ((AbstractChainEntry)e).setValue(replacement);
                ++replaceCount;
            }
            e = ((AbstractChainEntry)e).next;
        }
        return replaceCount;
    }

    @Override
    public final int valuesReplace(V sample, Equalator<? super V> equalator, V replacement) {
        int replaceCount = 0;
        Object e = this.head.next;
        while (e != null) {
            if (equalator.equal(((AbstractChainEntry)e).value(), sample)) {
                ((AbstractChainEntry)e).setValue(replacement);
                ++replaceCount;
            }
            e = ((AbstractChainEntry)e).next;
        }
        return replaceCount;
    }

    @Override
    public final int valuesReplaceAll(V[] elements, int elementsOffset, int elementsLength, V replacement) {
        int d = ChainStorageStrong.validateArrayIteration(elements, elementsOffset, elementsLength);
        if (d == 0) {
            return 0;
        }
        int elementsBound = elementsOffset + elementsLength;
        int replaceCount = 0;
        Object e = this.head.next;
        while (e != null) {
            Object element = ((AbstractChainEntry)e).value();
            int i = elementsOffset;
            while (i != elementsBound) {
                if (element == elements[i]) {
                    ((AbstractChainEntry)e).setValue(replacement);
                    ++replaceCount;
                    break;
                }
                i += d;
            }
            e = ((AbstractChainEntry)e).next;
        }
        return replaceCount;
    }

    @Override
    public final int valuesReplaceAll(V[] samples, int samplesOffset, int samplesLength, Equalator<? super V> equalator, V replacement) {
        int d = ChainStorageStrong.validateArrayIteration(samples, samplesOffset, samplesLength);
        if (d == 0) {
            return 0;
        }
        int elementsBound = samplesOffset + samplesLength;
        int replaceCount = 0;
        Object e = this.head.next;
        while (e != null) {
            Object element = ((AbstractChainEntry)e).value();
            int i = samplesOffset;
            while (i != elementsBound) {
                if (equalator.equal(element, samples[i])) {
                    ((AbstractChainEntry)e).setValue(replacement);
                    ++replaceCount;
                    break;
                }
                i += d;
            }
            e = ((AbstractChainEntry)e).next;
        }
        return replaceCount;
    }

    @Override
    public final int valuesReplaceAll(XGettingCollection<? extends V> elements, final V replacement) {
        if (elements instanceof AbstractSimpleArrayCollection) {
            return this.valuesReplaceAll(AbstractSimpleArrayCollection.internalGetStorageArray((AbstractSimpleArrayCollection)((Object)elements)), 0, XTypes.to_int(elements.size()), replacement);
        }
        return elements.iterate(new Consumer<V>(){
            int replaceCount;

            @Override
            public void accept(V e) {
                this.replaceCount += ChainStrongStrongStorage.this.valuesReplace(e, replacement);
            }
        }).replaceCount;
    }

    @Override
    public final int valuesReplaceAll(XGettingCollection<? extends V> samples, final Equalator<? super V> equalator, final V replacement) {
        if (samples instanceof AbstractSimpleArrayCollection) {
            return this.valuesReplaceAll(AbstractSimpleArrayCollection.internalGetStorageArray((AbstractSimpleArrayCollection)((Object)samples)), 0, XTypes.to_int(samples.size()), equalator, replacement);
        }
        return samples.iterate(new Consumer<V>(){
            int replaceCount;

            @Override
            public void accept(V e) {
                this.replaceCount += ChainStrongStrongStorage.this.valuesReplace(e, equalator, replacement);
            }
        }).replaceCount;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public final boolean valuesSubstituteOne(Predicate<? super V> predicate, V substitute) {
        try {
            Object e = this.head.next;
            while (true) {
                if (e == null) {
                    return false;
                }
                if (predicate.test(((AbstractChainEntry)e).value())) {
                    ((AbstractChainEntry)e).setValue(substitute);
                    return true;
                }
                e = ((AbstractChainEntry)e).next;
            }
        }
        catch (ThrowBreak throwBreak) {
            // empty catch block
        }
        return false;
    }

    @Override
    public final int valuesSubstitute(Predicate<? super V> predicate, V substitute) {
        int replaceCount = 0;
        try {
            Object e = this.head.next;
            while (e != null) {
                if (predicate.test(((AbstractChainEntry)e).value())) {
                    ((AbstractChainEntry)e).setValue(substitute);
                    ++replaceCount;
                }
                e = ((AbstractChainEntry)e).next;
            }
        }
        catch (ThrowBreak throwBreak) {
            // empty catch block
        }
        return replaceCount;
    }

    @Override
    public final int valuesSubstitute(Function<? super V, ? extends V> mapper) {
        int replaceCount = 0;
        try {
            Object e = this.head.next;
            while (e != null) {
                V replacement = mapper.apply(((AbstractChainEntry)e).value());
                if (replacement != ((AbstractChainEntry)e).value()) {
                    ((AbstractChainEntry)e).setValue(replacement);
                    ++replaceCount;
                }
                e = ((AbstractChainEntry)e).next;
            }
        }
        catch (ThrowBreak throwBreak) {
            // empty catch block
        }
        return replaceCount;
    }

    @Override
    public final int valuesSubstitute(Predicate<? super V> predicate, Function<V, V> mapper) {
        int replaceCount = 0;
        try {
            Object e = this.head.next;
            while (e != null) {
                if (predicate.test(((AbstractChainEntry)e).value())) {
                    ((AbstractChainEntry)e).setValue(mapper.apply(((AbstractChainEntry)e).value()));
                    ++replaceCount;
                }
                e = ((AbstractChainEntry)e).next;
            }
        }
        catch (ThrowBreak throwBreak) {
            // empty catch block
        }
        return replaceCount;
    }

    @Override
    public final boolean valuesRemoveOne(V element) {
        throw new NotImplementedYetError();
    }

    @Override
    public final boolean valuesRemoveOne(V sample, Equalator<? super V> equalator) {
        throw new NotImplementedYetError();
    }

    final class KeyItr
    implements Iterator<K> {
        private EN current;

        KeyItr() {
            this.current = ChainStrongStrongStorage.this.head;
        }

        @Override
        public final boolean hasNext() {
            return ((AbstractChainEntry)this.current).next != null;
        }

        @Override
        public final K next() {
            if (((AbstractChainEntry)this.current).next == null) {
                throw new NoSuchElementException();
            }
            this.current = ((AbstractChainEntry)this.current).next;
            return ((AbstractChainEntry)this.current).key();
        }

        @Override
        public final void remove() {
            throw new UnsupportedOperationException();
        }
    }

    final class ValueItr
    implements Iterator<V> {
        private EN current;

        ValueItr() {
            this.current = ChainStrongStrongStorage.this.head;
        }

        @Override
        public final boolean hasNext() {
            return ((AbstractChainEntry)this.current).next != null;
        }

        @Override
        public final V next() {
            if (((AbstractChainEntry)this.current).next == null) {
                throw new NoSuchElementException();
            }
            this.current = ((AbstractChainEntry)this.current).next;
            return ((AbstractChainEntry)this.current).value();
        }

        @Override
        public final void remove() {
            throw new UnsupportedOperationException();
        }
    }

    final class ValueListItr
    implements ListIterator<V> {
        private int index;
        private EN current;

        ValueListItr(int index) {
            this.current = ChainStrongStrongStorage.this.getChainEntry(index);
            this.index = index;
        }

        @Override
        public final void add(V e) {
            throw new UnsupportedOperationException();
        }

        @Override
        public final boolean hasNext() {
            return ((AbstractChainEntry)this.current).next != null;
        }

        @Override
        public final boolean hasPrevious() {
            return ((AbstractChainEntry)this.current).prev != ChainStrongStrongStorage.this.head;
        }

        @Override
        public final V next() {
            Object element = this.current;
            this.current = ((AbstractChainEntry)this.current).next;
            ++this.index;
            return element.value();
        }

        @Override
        public final int nextIndex() {
            return this.index + 1;
        }

        @Override
        public final V previous() {
            Object element = this.current;
            this.current = ((AbstractChainEntry)this.current).prev;
            --this.index;
            return element.value();
        }

        @Override
        public final int previousIndex() {
            return this.index - 1;
        }

        @Override
        public final void remove() {
            Object next = ((AbstractChainEntry)this.current).next;
            ((AbstractChainEntry)this.current).removeFrom(ChainStrongStrongStorage.this.parent);
            this.current = next;
        }

        @Override
        public final void set(V value) {
            ((AbstractChainEntry)this.current).setValue(value);
        }
    }
}

