/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.serializer.collections;

import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Predicate;
import org.eclipse.serializer.collections.AbstractArrayStorage;
import org.eclipse.serializer.collections.AbstractSimpleArrayCollection;
import org.eclipse.serializer.collections.ConstList;
import org.eclipse.serializer.collections.SubListView;
import org.eclipse.serializer.collections.XArrays;
import org.eclipse.serializer.collections.old.AbstractOldGettingList;
import org.eclipse.serializer.collections.types.XGettingCollection;
import org.eclipse.serializer.collections.types.XGettingList;
import org.eclipse.serializer.collections.types.XImmutableList;
import org.eclipse.serializer.equality.Equalator;
import org.eclipse.serializer.exceptions.IndexBoundsException;
import org.eclipse.serializer.functional.IndexedAcceptor;
import org.eclipse.serializer.typing.XTypes;
import org.eclipse.serializer.util.X;
import org.eclipse.serializer.util.iterables.ReadOnlyListIterator;

public final class ArrayView<E>
extends AbstractSimpleArrayCollection<E>
implements XGettingList<E> {
    private static final Object[] DUMMY = new Object[0];
    E[] data;
    int size;

    public ArrayView() {
        this.data = DUMMY;
        this.size = 0;
    }

    public ArrayView(ArrayView<? extends E> original) throws NullPointerException {
        this.data = original.data;
        this.size = original.size;
    }

    public ArrayView(E ... elements) throws NullPointerException {
        this.data = elements != null ? elements : DUMMY;
        this.size = this.data.length;
    }

    public E[] getArray() {
        return this.data == DUMMY ? null : this.data;
    }

    @Override
    public Equalator<? super E> equality() {
        return Equalator.identity();
    }

    @Override
    protected int internalCountingAddAll(E[] elements) throws UnsupportedOperationException {
        throw new UnsupportedOperationException();
    }

    @Override
    protected int internalCountingAddAll(E[] elements, int offset, int length) throws UnsupportedOperationException {
        throw new UnsupportedOperationException();
    }

    @Override
    protected int internalCountingAddAll(XGettingCollection<? extends E> elements) throws UnsupportedOperationException {
        throw new UnsupportedOperationException();
    }

    @Override
    protected int internalCountingPutAll(E[] elements) throws UnsupportedOperationException {
        throw new UnsupportedOperationException();
    }

    @Override
    protected int internalCountingPutAll(E[] elements, int offset, int length) throws UnsupportedOperationException {
        throw new UnsupportedOperationException();
    }

    @Override
    protected int internalCountingPutAll(XGettingCollection<? extends E> elements) throws UnsupportedOperationException {
        throw new UnsupportedOperationException();
    }

    public ArrayView<E> setArray(E[] array) {
        if (array == null) {
            this.data = DUMMY;
            this.size = 0;
            return this;
        }
        if (this.size < 0 || this.size > array.length) {
            throw new ArrayIndexOutOfBoundsException(this.size);
        }
        this.data = array;
        this.size = array.length;
        return this;
    }

    @Override
    protected E[] internalGetStorageArray() {
        return this.data;
    }

    @Override
    protected int internalSize() {
        return this.size;
    }

    @Override
    protected int[] internalGetSectionIndices() {
        int[] nArray = new int[2];
        nArray[1] = this.size;
        return nArray;
    }

    @Override
    public ArrayView<E> copy() {
        return new ArrayView<E>(this);
    }

    @Override
    public XImmutableList<E> immure() {
        return ConstList.New(this);
    }

    @Override
    public ArrayView<E> toReversed() {
        E[] rData = X.ArrayOfSameType(this.data, this.size);
        E[] data = this.data;
        int i = this.size;
        int r = 0;
        while (i-- > 0) {
            rData[r++] = data[i];
        }
        return new ArrayView<E>(rData);
    }

    @Override
    public E[] toArray(Class<E> type) {
        E[] array = X.Array(type, this.size);
        System.arraycopy(this.data, 0, array, 0, this.size);
        return array;
    }

    @Override
    public <P extends Consumer<? super E>> P iterate(P procedure) {
        AbstractArrayStorage.iterate(this.data, this.size, procedure);
        return procedure;
    }

    @Override
    public final <A> A join(BiConsumer<? super E, ? super A> joiner, A aggregate) {
        AbstractArrayStorage.join(this.data, this.size, joiner, aggregate);
        return aggregate;
    }

    @Override
    public final <P extends IndexedAcceptor<? super E>> P iterateIndexed(P procedure) {
        AbstractArrayStorage.iterate(this.data, this.size, procedure);
        return procedure;
    }

    @Override
    public long count(E element) {
        return AbstractArrayStorage.forwardCount(this.data, 0, this.size, element);
    }

    @Override
    public long countBy(Predicate<? super E> predicate) {
        return AbstractArrayStorage.forwardConditionalCount(this.data, 0, this.size, predicate);
    }

    @Override
    public long indexOf(E element) {
        return AbstractArrayStorage.forwardIndexOf(this.data, 0, this.size, element);
    }

    @Override
    public long indexBy(Predicate<? super E> predicate) {
        return AbstractArrayStorage.forwardConditionalIndexOf(this.data, 0, this.size, predicate);
    }

    @Override
    public long lastIndexOf(E element) {
        return AbstractArrayStorage.rangedIndexOF(this.data, this.size, this.size - 1, -this.size, element);
    }

    @Override
    public long lastIndexBy(Predicate<? super E> predicate) {
        return AbstractArrayStorage.lastIndexOf(this.data, this.size, predicate);
    }

    @Override
    public long maxIndex(Comparator<? super E> comparator) {
        return AbstractArrayStorage.maxIndex(this.data, this.size, comparator);
    }

    @Override
    public long minIndex(Comparator<? super E> comparator) {
        return AbstractArrayStorage.minIndex(this.data, this.size, comparator);
    }

    @Override
    public long scan(Predicate<? super E> predicate) {
        return AbstractArrayStorage.forwardScan(this.data, 0, this.size, predicate);
    }

    @Override
    public E get() {
        return this.data[0];
    }

    @Override
    public E first() {
        return this.data[0];
    }

    @Override
    public E last() {
        return this.data[this.size - 1];
    }

    @Override
    public E poll() {
        return this.size == 0 ? null : (E)this.data[0];
    }

    @Override
    public E peek() {
        return this.size == 0 ? null : (E)this.data[this.size - 1];
    }

    @Override
    public E seek(E sample) {
        return (E)(AbstractArrayStorage.forwardContainsSame(this.data, 0, this.size, sample) ? sample : null);
    }

    @Override
    public E search(Predicate<? super E> predicate) {
        return AbstractArrayStorage.forwardQueryElement(this.data, 0, this.size, predicate, null);
    }

    @Override
    public E max(Comparator<? super E> comparator) {
        return AbstractArrayStorage.max(this.data, this.size, comparator);
    }

    @Override
    public E min(Comparator<? super E> comparator) {
        return AbstractArrayStorage.min(this.data, this.size, comparator);
    }

    @Override
    public boolean hasVolatileElements() {
        return false;
    }

    @Override
    public boolean nullAllowed() {
        return true;
    }

    @Override
    public boolean isSorted(Comparator<? super E> comparator) {
        return AbstractArrayStorage.isSorted(this.data, this.size, comparator);
    }

    @Override
    public boolean containsSearched(Predicate<? super E> predicate) {
        return AbstractArrayStorage.forwardContains(this.data, 0, this.size, predicate);
    }

    @Override
    public boolean applies(Predicate<? super E> predicate) {
        return AbstractArrayStorage.forwardApplies(this.data, 0, this.size, predicate);
    }

    @Override
    public boolean nullContained() {
        return AbstractArrayStorage.forwardNullContained(this.data, 0, this.size);
    }

    @Override
    public boolean containsId(E element) {
        return AbstractArrayStorage.forwardContainsSame(this.data, 0, this.size, element);
    }

    @Override
    public boolean contains(E element) {
        return AbstractArrayStorage.forwardContainsSame(this.data, 0, this.size, element);
    }

    @Override
    public boolean containsAll(XGettingCollection<? extends E> elements) {
        return AbstractArrayStorage.containsAll(this.data, this.size, elements);
    }

    @Override
    public boolean equals(XGettingCollection<? extends E> samples, Equalator<? super E> equalator) {
        if (samples == null || !(samples instanceof ArrayView) || XTypes.to_int(samples.size()) != this.size) {
            return false;
        }
        if (samples == this) {
            return true;
        }
        return XArrays.equals(this.data, 0, ((ArrayView)samples).data, 0, this.size, equalator);
    }

    @Override
    public boolean equalsContent(XGettingCollection<? extends E> samples, Equalator<? super E> equalator) {
        if (samples == null || XTypes.to_int(samples.size()) != this.size) {
            return false;
        }
        if (samples == this) {
            return true;
        }
        return AbstractArrayStorage.equalsContent(this.data, this.size, samples, equalator);
    }

    @Override
    public <C extends Consumer<? super E>> C intersect(XGettingCollection<? extends E> samples, Equalator<? super E> equalator, C target) {
        return AbstractArrayStorage.intersect(this.data, this.size, samples, equalator, target);
    }

    @Override
    public <C extends Consumer<? super E>> C except(XGettingCollection<? extends E> samples, Equalator<? super E> equalator, C target) {
        return AbstractArrayStorage.except(this.data, this.size, samples, equalator, target);
    }

    @Override
    public <C extends Consumer<? super E>> C union(XGettingCollection<? extends E> samples, Equalator<? super E> equalator, C target) {
        return AbstractArrayStorage.union(this.data, this.size, samples, equalator, target);
    }

    @Override
    public <C extends Consumer<? super E>> C copyTo(C target) {
        return AbstractArrayStorage.forwardCopyTo(this.data, 0, this.size, target);
    }

    @Override
    public <C extends Consumer<? super E>> C filterTo(C target, Predicate<? super E> predicate) {
        return AbstractArrayStorage.forwardCopyTo(this.data, 0, this.size, target, predicate);
    }

    public <T> T[] rngCopyTo(int startIndex, int length, T[] target, int offset) {
        return AbstractArrayStorage.rangedCopyTo(this.data, this.size, startIndex, length, target, offset);
    }

    @Override
    public <C extends Consumer<? super E>> C distinct(C target) {
        return AbstractArrayStorage.distinct(this.data, this.size, target);
    }

    @Override
    public <C extends Consumer<? super E>> C distinct(C target, Equalator<? super E> equalator) {
        return AbstractArrayStorage.distinct(this.data, this.size, target, equalator);
    }

    @Override
    public <C extends Consumer<? super E>> C copySelection(C target, long ... indices) {
        return AbstractArrayStorage.copySelection(this.data, this.size, indices, target);
    }

    @Override
    public boolean isEmpty() {
        return this.size == 0;
    }

    @Override
    public Iterator<E> iterator() {
        return new ReadOnlyListIterator(this);
    }

    @Override
    public ListIterator<E> listIterator() {
        return new ReadOnlyListIterator(this);
    }

    @Override
    public ListIterator<E> listIterator(long index) {
        ArrayView.validateIndex(this.size, index);
        return new ReadOnlyListIterator(this, (int)index);
    }

    @Override
    public long size() {
        return this.size;
    }

    @Override
    public long maximumCapacity() {
        return this.size;
    }

    @Override
    public boolean isFull() {
        return true;
    }

    @Override
    public long remainingCapacity() {
        return 0L;
    }

    @Override
    public ArrayView<E> view() {
        return this;
    }

    @Override
    public SubListView<E> view(long fromIndex, long toIndex) {
        return new SubListView(this, fromIndex, toIndex);
    }

    @Override
    public SubListView<E> range(long fromIndex, long toIndex) {
        return new SubListView(this, fromIndex, toIndex);
    }

    public String toString() {
        return AbstractArrayStorage.toString(this.data, this.size);
    }

    @Override
    public Object[] toArray() {
        Object[] array = new Object[this.size];
        System.arraycopy(this.data, 0, array, 0, this.size);
        return array;
    }

    @Override
    public E at(long index) throws ArrayIndexOutOfBoundsException {
        if (index >= (long)this.size) {
            throw new IndexBoundsException((long)this.size, index);
        }
        return this.data[(int)index];
    }

    @Override
    @Deprecated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o == null || !(o instanceof List)) {
            return false;
        }
        List list = (List)o;
        if (this.size != list.size()) {
            return false;
        }
        E[] data = this.data;
        int i = 0;
        for (Object e2 : list) {
            E e1;
            if (!((e1 = data[i++]) == null ? e2 != null : !e1.equals(e2))) continue;
            return false;
        }
        return true;
    }

    @Override
    @Deprecated
    public int hashCode() {
        return XArrays.arrayHashCode(this.data, this.size);
    }

    @Override
    public OldArrayView<E> old() {
        return new OldArrayView(this);
    }

    public static final class OldArrayView<E>
    extends AbstractOldGettingList<E> {
        OldArrayView(ArrayView<E> list) {
            super(list);
        }

        @Override
        public ArrayView<E> parent() {
            return (ArrayView)super.parent();
        }
    }
}

