/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.serializer.collections;

import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import org.eclipse.serializer.collections.AbstractArrayStorage;
import org.eclipse.serializer.collections.AbstractSimpleArrayCollection;
import org.eclipse.serializer.collections.ConstList;
import org.eclipse.serializer.collections.IndexExceededException;
import org.eclipse.serializer.collections.ListView;
import org.eclipse.serializer.collections.SubListAccessor;
import org.eclipse.serializer.collections.SubListView;
import org.eclipse.serializer.collections.XArrays;
import org.eclipse.serializer.collections.XSort;
import org.eclipse.serializer.collections.old.AbstractOldSettingList;
import org.eclipse.serializer.collections.types.XGettingCollection;
import org.eclipse.serializer.collections.types.XGettingSequence;
import org.eclipse.serializer.collections.types.XImmutableList;
import org.eclipse.serializer.collections.types.XSettingList;
import org.eclipse.serializer.equality.Equalator;
import org.eclipse.serializer.exceptions.IndexBoundsException;
import org.eclipse.serializer.functional.IndexedAcceptor;
import org.eclipse.serializer.typing.XTypes;
import org.eclipse.serializer.util.X;
import org.eclipse.serializer.util.iterables.ReadOnlyListIterator;

public final class ArrayAccessor<E>
extends AbstractSimpleArrayCollection<E>
implements XSettingList<E> {
    private static final Object MARKER = new Object();
    private static final Object[] DUMMY = new Object[0];
    private E[] data;
    private int size;

    private static String exceptionStringRange(long size, long startIndex, long length) {
        return "Range [" + (length < 0L ? String.valueOf(startIndex + length + 1L) + ";" + startIndex : String.valueOf(startIndex) + ";" + (startIndex + length - 1L)) + "] not in [0;" + (size - 1L) + "]";
    }

    public ArrayAccessor() {
        this.data = DUMMY;
        this.size = 0;
    }

    public ArrayAccessor(ArrayAccessor<? extends E> original) throws NullPointerException {
        this.data = original.data;
        this.size = original.size;
    }

    @SafeVarargs
    public ArrayAccessor(E ... elements) throws NullPointerException {
        this.data = elements;
        this.size = elements.length;
    }

    public E[] getArray() {
        return this.data == DUMMY ? null : this.data;
    }

    @Override
    public Equalator<? super E> equality() {
        return Equalator.identity();
    }

    @Override
    protected int internalCountingAddAll(E[] elements) throws UnsupportedOperationException {
        throw new UnsupportedOperationException();
    }

    @Override
    protected int internalCountingAddAll(E[] elements, int offset, int length) throws UnsupportedOperationException {
        throw new UnsupportedOperationException();
    }

    @Override
    protected int internalCountingAddAll(XGettingCollection<? extends E> elements) throws UnsupportedOperationException {
        throw new UnsupportedOperationException();
    }

    @Override
    protected int internalCountingPutAll(E[] elements) throws UnsupportedOperationException {
        throw new UnsupportedOperationException();
    }

    @Override
    protected int internalCountingPutAll(E[] elements, int offset, int length) throws UnsupportedOperationException {
        throw new UnsupportedOperationException();
    }

    @Override
    protected int internalCountingPutAll(XGettingCollection<? extends E> elements) throws UnsupportedOperationException {
        throw new UnsupportedOperationException();
    }

    public ArrayAccessor<E> setArray(E[] array) {
        if (array == null) {
            this.data = DUMMY;
            this.size = 0;
            return this;
        }
        if (this.size < 0 || this.size > array.length) {
            throw new ArrayIndexOutOfBoundsException(this.size);
        }
        this.data = array;
        this.size = array.length;
        return this;
    }

    @Override
    protected E[] internalGetStorageArray() {
        return this.data;
    }

    @Override
    protected int internalSize() {
        return this.size;
    }

    @Override
    protected int[] internalGetSectionIndices() {
        int[] nArray = new int[2];
        nArray[1] = this.size;
        return nArray;
    }

    @Override
    public ArrayAccessor<E> copy() {
        return new ArrayAccessor<E>(this);
    }

    @Override
    public XImmutableList<E> immure() {
        return ConstList.New(this);
    }

    @Override
    public ArrayAccessor<E> toReversed() {
        E[] rData = X.ArrayOfSameType(this.data, this.size);
        E[] data = this.data;
        int i = this.size;
        int r = 0;
        while (i-- > 0) {
            rData[r++] = data[i];
        }
        return new ArrayAccessor<E>(rData);
    }

    @Override
    public E[] toArray(Class<E> type) {
        E[] array = X.Array(type, this.size);
        System.arraycopy(this.data, 0, array, 0, this.size);
        return array;
    }

    @Override
    public <P extends Consumer<? super E>> P iterate(P procedure) {
        AbstractArrayStorage.iterate(this.data, this.size, procedure);
        return procedure;
    }

    @Override
    public final <A> A join(BiConsumer<? super E, ? super A> joiner, A aggregate) {
        AbstractArrayStorage.join(this.data, this.size, joiner, aggregate);
        return aggregate;
    }

    @Override
    public final <P extends IndexedAcceptor<? super E>> P iterateIndexed(P procedure) {
        AbstractArrayStorage.iterate(this.data, this.size, procedure);
        return procedure;
    }

    @Override
    public long count(E element) {
        return AbstractArrayStorage.forwardCount(this.data, 0, this.size, element);
    }

    @Override
    public long countBy(Predicate<? super E> predicate) {
        return AbstractArrayStorage.forwardConditionalCount(this.data, 0, this.size, predicate);
    }

    @Override
    public long indexOf(E element) {
        return AbstractArrayStorage.forwardIndexOf(this.data, 0, this.size, element);
    }

    @Override
    public long indexBy(Predicate<? super E> predicate) {
        return AbstractArrayStorage.forwardConditionalIndexOf(this.data, 0, this.size, predicate);
    }

    @Override
    public long lastIndexOf(E element) {
        return AbstractArrayStorage.rangedIndexOF(this.data, this.size, this.size - 1, -this.size, element);
    }

    @Override
    public long lastIndexBy(Predicate<? super E> predicate) {
        return AbstractArrayStorage.lastIndexOf(this.data, this.size, predicate);
    }

    @Override
    public long maxIndex(Comparator<? super E> comparator) {
        return AbstractArrayStorage.maxIndex(this.data, this.size, comparator);
    }

    @Override
    public long minIndex(Comparator<? super E> comparator) {
        return AbstractArrayStorage.minIndex(this.data, this.size, comparator);
    }

    @Override
    public long scan(Predicate<? super E> predicate) {
        return AbstractArrayStorage.forwardScan(this.data, 0, this.size, predicate);
    }

    @Override
    public E get() {
        return this.data[0];
    }

    @Override
    public E first() {
        return this.data[0];
    }

    @Override
    public E last() {
        return this.data[this.size - 1];
    }

    @Override
    public E poll() {
        return this.size == 0 ? null : (E)this.data[0];
    }

    @Override
    public E peek() {
        return this.size == 0 ? null : (E)this.data[this.size - 1];
    }

    @Override
    public E search(Predicate<? super E> predicate) {
        return AbstractArrayStorage.forwardQueryElement(this.data, 0, this.size, predicate, null);
    }

    @Override
    public E seek(E sample) {
        return (E)(AbstractArrayStorage.forwardContainsSame(this.data, 0, this.size, sample) ? sample : null);
    }

    @Override
    public E max(Comparator<? super E> comparator) {
        return AbstractArrayStorage.max(this.data, this.size, comparator);
    }

    @Override
    public E min(Comparator<? super E> comparator) {
        return AbstractArrayStorage.min(this.data, this.size, comparator);
    }

    @Override
    public boolean hasVolatileElements() {
        return false;
    }

    @Override
    public boolean nullAllowed() {
        return true;
    }

    @Override
    public boolean isSorted(Comparator<? super E> comparator) {
        return AbstractArrayStorage.isSorted(this.data, this.size, comparator);
    }

    @Override
    public boolean containsSearched(Predicate<? super E> predicate) {
        return AbstractArrayStorage.forwardContains(this.data, 0, this.size, predicate);
    }

    @Override
    public boolean applies(Predicate<? super E> predicate) {
        return AbstractArrayStorage.forwardApplies(this.data, 0, this.size, predicate);
    }

    @Override
    public boolean nullContained() {
        return AbstractArrayStorage.forwardNullContained(this.data, 0, this.size);
    }

    @Override
    public boolean containsId(E element) {
        return AbstractArrayStorage.forwardContainsSame(this.data, 0, this.size, element);
    }

    @Override
    public boolean contains(E element) {
        return AbstractArrayStorage.forwardContainsSame(this.data, 0, this.size, element);
    }

    @Override
    public boolean containsAll(XGettingCollection<? extends E> elements) {
        return AbstractArrayStorage.containsAll(this.data, this.size, elements);
    }

    @Override
    public boolean equals(XGettingCollection<? extends E> samples, Equalator<? super E> equalator) {
        if (samples == null || !(samples instanceof ArrayAccessor) || XTypes.to_int(samples.size()) != this.size) {
            return false;
        }
        if (samples == this) {
            return true;
        }
        return XArrays.equals(this.data, 0, ((ArrayAccessor)samples).data, 0, this.size, equalator);
    }

    @Override
    public boolean equalsContent(XGettingCollection<? extends E> samples, Equalator<? super E> equalator) {
        if (samples == null || XTypes.to_int(samples.size()) != this.size) {
            return false;
        }
        if (samples == this) {
            return true;
        }
        return AbstractArrayStorage.equalsContent(this.data, this.size, samples, equalator);
    }

    @Override
    public <C extends Consumer<? super E>> C intersect(XGettingCollection<? extends E> samples, Equalator<? super E> equalator, C target) {
        return AbstractArrayStorage.intersect(this.data, this.size, samples, equalator, target);
    }

    @Override
    public <C extends Consumer<? super E>> C except(XGettingCollection<? extends E> samples, Equalator<? super E> equalator, C target) {
        return AbstractArrayStorage.except(this.data, this.size, samples, equalator, target);
    }

    @Override
    public <C extends Consumer<? super E>> C union(XGettingCollection<? extends E> samples, Equalator<? super E> equalator, C target) {
        return AbstractArrayStorage.union(this.data, this.size, samples, equalator, target);
    }

    @Override
    public <C extends Consumer<? super E>> C copyTo(C target) {
        return AbstractArrayStorage.forwardCopyTo(this.data, 0, this.size, target);
    }

    @Override
    public <C extends Consumer<? super E>> C filterTo(C target, Predicate<? super E> predicate) {
        return AbstractArrayStorage.forwardCopyTo(this.data, 0, this.size, target, predicate);
    }

    public <T> T[] rngCopyTo(int startIndex, int length, T[] target, int offset) {
        return AbstractArrayStorage.rangedCopyTo(this.data, this.size, startIndex, length, target, offset);
    }

    @Override
    public <C extends Consumer<? super E>> C distinct(C target) {
        return AbstractArrayStorage.distinct(this.data, this.size, target);
    }

    @Override
    public <C extends Consumer<? super E>> C distinct(C target, Equalator<? super E> equalator) {
        return AbstractArrayStorage.distinct(this.data, this.size, target, equalator);
    }

    @Override
    public <C extends Consumer<? super E>> C copySelection(C target, long ... indices) {
        return AbstractArrayStorage.copySelection(this.data, this.size, indices, target);
    }

    @Override
    public ListView<E> view() {
        return new ListView(this);
    }

    @Override
    public SubListView<E> view(long fromIndex, long toIndex) {
        return new SubListView(this, fromIndex, toIndex);
    }

    @Override
    public ArrayAccessor<E> shiftTo(long sourceIndex, long targetIndex) {
        if (sourceIndex >= (long)this.size) {
            throw new IndexExceededException(this.size, sourceIndex);
        }
        if (targetIndex >= (long)this.size) {
            throw new IndexExceededException(this.size, targetIndex);
        }
        if (sourceIndex == targetIndex) {
            if (sourceIndex < 0L) {
                throw new IndexExceededException(this.size, sourceIndex);
            }
            return this;
        }
        E shiftling = this.data[(int)sourceIndex];
        if (sourceIndex < targetIndex) {
            System.arraycopy(this.data, (int)sourceIndex + 1, this.data, (int)sourceIndex, (int)targetIndex - (int)sourceIndex);
        } else {
            System.arraycopy(this.data, (int)targetIndex, this.data, (int)targetIndex + 1, (int)sourceIndex - (int)targetIndex);
        }
        this.data[(int)targetIndex] = shiftling;
        return this;
    }

    @Override
    public ArrayAccessor<E> shiftTo(long sourceIndex, long targetIndex, long length) {
        if (sourceIndex + length >= (long)this.size) {
            throw new IndexBoundsException((long)this.size, sourceIndex);
        }
        if (targetIndex + length >= (long)this.size) {
            throw new IndexBoundsException((long)this.size, targetIndex);
        }
        if (sourceIndex == targetIndex) {
            if (sourceIndex < 0L) {
                throw new IndexBoundsException((long)this.size, sourceIndex);
            }
            return this;
        }
        E[] shiftlings = ArrayAccessor.newArray(X.checkArrayRange(length));
        System.arraycopy(this.data, (int)sourceIndex, shiftlings, 0, (int)length);
        if (sourceIndex < targetIndex) {
            System.arraycopy(this.data, X.checkArrayRange(sourceIndex + length), this.data, (int)sourceIndex, X.checkArrayRange(targetIndex - sourceIndex));
        } else {
            System.arraycopy(this.data, (int)targetIndex, this.data, X.checkArrayRange(targetIndex + length), X.checkArrayRange(sourceIndex - targetIndex));
        }
        System.arraycopy(shiftlings, 0, this.data, (int)targetIndex, (int)length);
        return this;
    }

    @Override
    public ArrayAccessor<E> shiftBy(long sourceIndex, long distance) {
        return this.shiftTo(sourceIndex, sourceIndex + distance);
    }

    @Override
    public ArrayAccessor<E> shiftBy(long sourceIndex, long distance, long length) {
        return this.shiftTo(sourceIndex, sourceIndex + distance, length);
    }

    @Override
    public ArrayAccessor<E> swap(long indexA, long indexB) throws IndexOutOfBoundsException, ArrayIndexOutOfBoundsException {
        if (indexA >= (long)this.size) {
            throw new IndexBoundsException((long)this.size, indexA);
        }
        if (indexB >= (long)this.size) {
            throw new IndexBoundsException((long)this.size, indexB);
        }
        E t = this.data[(int)indexA];
        this.data[(int)indexA] = this.data[(int)indexB];
        this.data[(int)indexB] = t;
        return this;
    }

    @Override
    public ArrayAccessor<E> swap(long indexA, long indexB, long length) {
        AbstractArrayStorage.swap(this.data, this.size, X.checkArrayRange(indexA), X.checkArrayRange(indexB), X.checkArrayRange(length));
        return this;
    }

    @Override
    public ArrayAccessor<E> reverse() {
        AbstractArrayStorage.reverse(this.data, this.size);
        return this;
    }

    @Override
    public void setFirst(E element) {
        this.data[0] = element;
    }

    @Override
    public void setLast(E element) {
        this.data[this.size - 1] = element;
    }

    @Override
    @SafeVarargs
    public final ArrayAccessor<E> setAll(long offset, E ... elements) {
        if (offset < 0L || offset + (long)elements.length > (long)this.size) {
            throw new IndexOutOfBoundsException(ArrayAccessor.exceptionStringRange(this.size, offset, offset + (long)elements.length - 1L));
        }
        System.arraycopy(elements, 0, this.data, X.checkArrayRange(offset), elements.length);
        return this;
    }

    @Override
    public ArrayAccessor<E> set(long offset, E[] src, int srcIndex, int srcLength) {
        AbstractArrayStorage.set(this.data, this.size, X.checkArrayRange(offset), src, srcIndex, srcLength);
        return this;
    }

    @Override
    public ArrayAccessor<E> set(long offset, XGettingSequence<? extends E> elements, long elementsOffset, long elementsLength) {
        AbstractArrayStorage.set(this.data, this.size, X.checkArrayRange(offset), elements, elementsOffset, elementsLength);
        return this;
    }

    @Override
    public ArrayAccessor<E> fill(long offset, long length, E element) {
        AbstractArrayStorage.fill(this.data, this.size, X.checkArrayRange(offset), X.checkArrayRange(length), element);
        return this;
    }

    @Override
    public ArrayAccessor<E> sort(Comparator<? super E> comparator) {
        XSort.mergesort(this.data, 0, this.size, comparator);
        return this;
    }

    @Override
    public boolean replaceOne(E element, E replacement) {
        return AbstractArrayStorage.replaceOne(this.data, this.size, element, replacement);
    }

    @Override
    public boolean replaceOne(Predicate<? super E> predicate, E substitute) {
        return AbstractArrayStorage.substituteOne(this.data, this.size, predicate, substitute);
    }

    @Override
    public long replace(E element, E replacement) {
        return AbstractArrayStorage.replace(this.data, this.size, element, replacement);
    }

    @Override
    public long replace(Predicate<? super E> predicate, E substitute) {
        return AbstractArrayStorage.substitute(this.data, this.size, predicate, substitute);
    }

    @Override
    public long replaceAll(XGettingCollection<? extends E> elements, E replacement) {
        return AbstractArrayStorage.replaceAll(this.data, this.size, elements, replacement, MARKER);
    }

    @Override
    public long substitute(Function<? super E, ? extends E> mapper) {
        return AbstractArrayStorage.substitute(this.data, this.size, mapper);
    }

    @Override
    public long substitute(Predicate<? super E> predicate, Function<E, E> mapper) {
        return AbstractArrayStorage.substitute(this.data, this.size, predicate, mapper);
    }

    @Override
    public boolean isEmpty() {
        return this.size == 0;
    }

    @Override
    public Iterator<E> iterator() {
        return new ReadOnlyListIterator(this);
    }

    @Override
    public ListIterator<E> listIterator() {
        return new ReadOnlyListIterator(this);
    }

    @Override
    public ListIterator<E> listIterator(long index) {
        ArrayAccessor.validateIndex(this.size, index);
        return new ReadOnlyListIterator(this, (int)index);
    }

    @Override
    public boolean set(long index, E element) throws IndexOutOfBoundsException, ArrayIndexOutOfBoundsException {
        if (index >= (long)this.size) {
            throw new IndexBoundsException((long)this.size, index);
        }
        this.data[(int)index] = element;
        return false;
    }

    @Override
    public E setGet(long index, E element) throws IndexOutOfBoundsException, ArrayIndexOutOfBoundsException {
        if (index >= (long)this.size) {
            throw new IndexBoundsException((long)this.size, index);
        }
        E old = this.data[(int)index];
        this.data[(int)index] = element;
        return old;
    }

    @Override
    public long size() {
        return this.size;
    }

    @Override
    public long maximumCapacity() {
        return this.size;
    }

    @Override
    public boolean isFull() {
        return true;
    }

    @Override
    public long remainingCapacity() {
        return 0L;
    }

    @Override
    public SubListAccessor<E> range(long fromIndex, long toIndex) {
        return new SubListAccessor(this, fromIndex, toIndex);
    }

    public String toString() {
        return AbstractArrayStorage.toString(this.data, this.size);
    }

    @Override
    public Object[] toArray() {
        Object[] array = new Object[this.size];
        System.arraycopy(this.data, 0, array, 0, this.size);
        return array;
    }

    @Override
    public E at(long index) throws ArrayIndexOutOfBoundsException {
        if (index >= (long)this.size) {
            throw new IndexBoundsException((long)this.size, index);
        }
        return this.data[(int)index];
    }

    @Override
    @Deprecated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o == null || !(o instanceof List)) {
            return false;
        }
        List list = (List)o;
        if (this.size != list.size()) {
            return false;
        }
        E[] data = this.data;
        int i = 0;
        for (Object e2 : list) {
            E e1;
            if (!((e1 = data[i++]) == null ? e2 != null : !e1.equals(e2))) continue;
            return false;
        }
        return true;
    }

    @Override
    @Deprecated
    public int hashCode() {
        return XArrays.arrayHashCode(this.data, this.size);
    }

    @Override
    public OldArrayAccessor<E> old() {
        return new OldArrayAccessor(this);
    }

    public static final class OldArrayAccessor<E>
    extends AbstractOldSettingList<E> {
        OldArrayAccessor(ArrayAccessor<E> list) {
            super(list);
        }

        @Override
        public ArrayAccessor<E> parent() {
            return (ArrayAccessor)super.parent();
        }
    }
}

