/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.serializer.chars;

import java.util.function.BiConsumer;
import java.util.function.Function;
import java.util.function.Predicate;
import org.eclipse.serializer.branching.ThrowBreak;
import org.eclipse.serializer.collections.ConstList;
import org.eclipse.serializer.collections.EqConstHashEnum;
import org.eclipse.serializer.collections.types.XGettingEnum;
import org.eclipse.serializer.collections.types.XGettingList;
import org.eclipse.serializer.collections.types.XGettingSequence;
import org.eclipse.serializer.collections.types.XImmutableEnum;
import org.eclipse.serializer.collections.types.XImmutableList;
import org.eclipse.serializer.math.XMath;
import org.eclipse.serializer.typing.XTypes;

public interface StringTable {
    public String name();

    public XGettingEnum<String> columnNames();

    public XGettingList<String> columnTypes();

    public XGettingList<String[]> rows();

    public <C extends BiConsumer<String, String>> C mapTo(C var1, Function<String[], String> var2, Function<String[], String> var3);

    public static interface Creator {
        public StringTable createStringTable(String var1, XGettingSequence<String> var2, XGettingList<String> var3, XGettingList<String[]> var4);
    }

    public static final class Default
    implements StringTable {
        private final String name;
        private final EqConstHashEnum<String> columns;
        private final ConstList<String> types;
        private final ConstList<String[]> rows;

        private static void validateColumnCount(int columnCount, XGettingList<String[]> rows) {
            long columnCountMismatchIndex = rows.scan(new ColumnCountValidator(columnCount));
            if (columnCountMismatchIndex >= 0L) {
                throw new IllegalArgumentException("Invalid column count in row " + columnCountMismatchIndex + " (" + columnCount + " required, " + ((String[])rows.at(columnCountMismatchIndex)).length + " available)");
            }
        }

        public Default(XGettingSequence<String> columns, XGettingList<String> columnTypes, XGettingList<String[]> rows) {
            this(null, columns, columnTypes, rows);
        }

        public Default(String name, XGettingSequence<String> columns, XGettingList<String> columnTypes, XGettingList<String[]> rows) {
            this.name = name;
            this.columns = EqConstHashEnum.New(columns);
            Default.validateColumnCount(XTypes.to_int(this.columns.size()), rows);
            this.types = ConstList.New(columnTypes);
            this.rows = ConstList.New(rows);
        }

        @Override
        public final String name() {
            return this.name;
        }

        public final XImmutableEnum<String> columnNames() {
            return this.columns;
        }

        @Override
        public final XGettingList<String> columnTypes() {
            return this.types;
        }

        public final XImmutableList<String[]> rows() {
            return this.rows;
        }

        @Override
        public <C extends BiConsumer<String, String>> C mapTo(C target, Function<String[], String> keyMapper, Function<String[], String> valueMapper) {
            for (String[] row : this.rows) {
                target.accept((String)keyMapper.apply(row), (String)valueMapper.apply(row));
            }
            return target;
        }

        static final class ColumnCountValidator
        implements Predicate<String[]> {
            private final int columnCount;

            ColumnCountValidator(int columnCount) {
                this.columnCount = XMath.notNegative(columnCount);
            }

            @Override
            public final boolean test(String[] row) throws ThrowBreak {
                return row.length != this.columnCount;
            }
        }

        public static final class Creator
        implements org.eclipse.serializer.chars.StringTable$Creator {
            @Override
            public StringTable createStringTable(String name, XGettingSequence<String> columnNames, XGettingList<String> columnTypes, XGettingList<String[]> rows) {
                return new Default(name, columnNames, columnTypes, rows);
            }
        }
    }
}

