/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.serializer.chars;

public final class CharView
implements CharSequence {
    final char[] data;
    final int offset;
    final int length;

    public CharView(char[] data, int offset, int length) {
        this.data = data;
        this.offset = offset;
        this.length = length;
    }

    public void validateIndex(int index) {
        if (index < 0 || index >= this.length) {
            throw new StringIndexOutOfBoundsException(index);
        }
    }

    public void validateRange(int offset, int length) {
        this.validateIndex(offset);
        this.validateIndex(offset + length - 1);
    }

    @Override
    public int length() {
        return this.length;
    }

    @Override
    public char charAt(int index) {
        this.validateIndex(index);
        return this.data[this.offset + index];
    }

    @Override
    public CharSequence subSequence(int start, int end) {
        this.validateIndex(start);
        this.validateIndex(end);
        if (start > end) {
            throw new IllegalArgumentException();
        }
        return new CharView(this.data, this.offset + start, end - start);
    }

    @Override
    public String toString() {
        return new String(this.data, this.offset, this.length);
    }
}

