/*
 * Decompiled with CFR 0.152.
 */
package nl.jj.swingx.gui.utility;

import javax.swing.SwingUtilities;

public abstract class SwingWorker {
    private Object value;
    private WorkerThreadHolder workerThreadHolder;

    protected synchronized Object getValue() {
        return this.value;
    }

    private synchronized void setValue(Object obj) {
        this.value = obj;
    }

    public abstract Object construct();

    public void finished() {
    }

    public void interrupt() {
        Thread workerThread = this.workerThreadHolder.getWorkerThread();
        if (workerThread != null) {
            workerThread.interrupt();
        }
        this.workerThreadHolder.clear();
    }

    public Object get() {
        Thread workerThread;
        while ((workerThread = this.workerThreadHolder.getWorkerThread()) != null) {
            try {
                workerThread.join();
            }
            catch (InterruptedException ie) {
                Thread.currentThread().interrupt();
                return null;
            }
        }
        return this.getValue();
    }

    public SwingWorker() {
        final Runnable doFinished = new Runnable(){

            public void run() {
                SwingWorker.this.finished();
            }
        };
        Runnable doConstruct = new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() {
                try {
                    SwingWorker.this.setValue(SwingWorker.this.construct());
                }
                finally {
                    SwingWorker.this.workerThreadHolder.clear();
                }
                SwingUtilities.invokeLater(doFinished);
            }
        };
        Thread workerThread = new Thread(doConstruct);
        this.workerThreadHolder = new WorkerThreadHolder(workerThread);
    }

    public void start() {
        Thread workerThread = this.workerThreadHolder.getWorkerThread();
        if (workerThread != null) {
            workerThread.start();
        }
    }

    private static final class WorkerThreadHolder {
        private Thread workerThread;

        WorkerThreadHolder(Thread workerThread) {
            this.workerThread = workerThread;
        }

        synchronized Thread getWorkerThread() {
            return this.workerThread;
        }

        synchronized void clear() {
            this.workerThread = null;
        }
    }
}

