/*
 * Decompiled with CFR 0.152.
 */
package nl.jj.swingx.gui.modal;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.EventQueue;
import java.awt.Graphics;
import java.awt.GraphicsConfiguration;
import java.awt.KeyboardFocusManager;
import java.awt.Point;
import java.awt.Window;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowEvent;
import java.util.Collection;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.JPanel;
import javax.swing.JWindow;
import nl.jj.swingx.gui.modal.InputBlocker;
import nl.jj.swingx.gui.modal.JBusyPanel;
import nl.jj.swingx.gui.modal.JModalConfiguration;
import nl.jj.swingx.gui.modal.JModalEventQueue;
import nl.jj.swingx.gui.modal.JModalHelper;
import nl.jj.swingx.gui.modal.JModalInternalFrame;
import nl.jj.swingx.gui.utility.Utils;

public class JModalWindow
extends JWindow
implements InputBlocker {
    public static final int DEFAULT_DRAG_BORDER_DISTANCE = 1;
    private static Window sharedOwner;
    private Window modalToOwner;
    private Vector modalToWindowsAndInputBlockers;
    private Vector blockingWindows;
    private boolean notifiedModalToWindow;
    private Component returnFocus;
    private JPanel contentPanel;
    private Point priorDragLocation;
    private Point cursorDragAnchor;
    private int windowDragBorderDistance;
    private JPanel busyPanel;
    private Color blurColor;
    private Component oldGlassPane = null;
    private boolean oldGlassPaneVisible = false;

    public JModalWindow() {
        this(null, null, true);
    }

    public JModalWindow(boolean modal) {
        this(null, null, modal);
    }

    public JModalWindow(Window owner) {
        this(owner, null, true);
    }

    public JModalWindow(Window owner, boolean modal) {
        this(owner, null, modal);
    }

    public JModalWindow(Window owner, Component returnFocus) {
        this(owner, returnFocus, true);
    }

    public JModalWindow(GraphicsConfiguration gc) {
        this(null, null, true, gc);
    }

    public JModalWindow(boolean modal, GraphicsConfiguration gc) {
        this(null, null, modal, gc);
    }

    public JModalWindow(Window owner, GraphicsConfiguration gc) {
        this(owner, null, true, gc);
    }

    public JModalWindow(Window owner, boolean modal, GraphicsConfiguration gc) {
        this(owner, null, modal, gc);
    }

    public JModalWindow(Window owner, Component returnFocus, GraphicsConfiguration gc) {
        this(owner, returnFocus, true, gc);
    }

    public JModalWindow(Window owner, Component returnFocus, boolean modal) {
        super(owner == null ? JModalWindow.getSharedOwnerFrame() : owner);
        this.jmodalWindowInit(owner, returnFocus, modal);
    }

    public JModalWindow(Window owner, Component returnFocus, boolean modal, GraphicsConfiguration gc) {
        super(owner == null ? JModalWindow.getSharedOwnerFrame() : owner, gc);
        this.jmodalWindowInit(owner, returnFocus, modal);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void jmodalWindowInit(Window owner, Component returnFocus, boolean modal) {
        this.returnFocus = returnFocus;
        this.windowDragBorderDistance = JModalConfiguration.getWindowDragBorderDistance();
        this.contentPanel = new JPanel();
        this.contentPanel.setBorder(BorderFactory.createBevelBorder(0));
        this.contentPanel.setLayout(new BorderLayout(){

            public void addLayoutComponent(Component comp, Object constraints) {
                if (constraints == null) {
                    constraints = "Center";
                }
                super.addLayoutComponent(comp, constraints);
            }
        });
        this.setContentPane(this.contentPanel);
        JModalWindow jModalWindow = this;
        synchronized (jModalWindow) {
            this.notifiedModalToWindow = true;
            this.modalToWindowsAndInputBlockers = new Vector();
            this.blockingWindows = new Vector();
            if (modal && owner != null) {
                this.modalToOwner = owner;
                this.modalToWindowsAndInputBlockers.add(owner);
            }
        }
        this.enableEvents(96L);
        this.initBusyPanel();
    }

    protected Window getModalToOwner() {
        return this.modalToOwner;
    }

    protected static Window getSharedOwnerFrame() {
        if (sharedOwner == null) {
            sharedOwner = new JWindow().getOwner();
        }
        return sharedOwner;
    }

    private void initBusyPanel() {
        this.blurColor = JModalConfiguration.getBlurColor(this.getContentPane().getBackground());
        this.busyPanel = new JBusyPanel(this.blurColor, JModalConfiguration.getBlurStyle());
        this.busyPanel.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent mouseEvent) {
                JModalWindow.this.checkActivationAllowed();
            }
        });
    }

    public void addAdditionalModalToWindow(Window window) {
        if (window != null && !this.modalToWindowsAndInputBlockers.contains(window)) {
            this.modalToWindowsAndInputBlockers.add(window);
        }
    }

    public void addAdditionalModalToComponent(InputBlocker inputBlocker) {
        if (inputBlocker != null && !this.modalToWindowsAndInputBlockers.contains(inputBlocker)) {
            this.modalToWindowsAndInputBlockers.add(inputBlocker);
        }
    }

    public boolean activateFirstAvailableBlockingWindow(WindowEvent windowEvent) {
        return JModalHelper.activateFirstAvailableBlockingWindow(this.blockingWindows, windowEvent);
    }

    public boolean isBusy() {
        return this.blockingWindows.size() > 0;
    }

    public void setBusy(boolean busy, Window blockingWindow) {
        this.setBusyStatus(busy, blockingWindow);
    }

    public void setBusy(boolean busy, JModalInternalFrame blockingIFrame) {
        this.setBusyStatus(busy, blockingIFrame);
    }

    private void setBusyStatus(boolean busy, Component blockingWindowOrInternalFrame) {
        if (busy) {
            if (this.blockingWindows.size() == 0) {
                this.oldGlassPane = this.getGlassPane();
                this.oldGlassPaneVisible = this.getGlassPane().isVisible();
                this.setGlassPane(this.busyPanel);
            }
            this.getGlassPane().setVisible(true);
            if (!this.blockingWindows.contains(blockingWindowOrInternalFrame)) {
                this.blockingWindows.add(blockingWindowOrInternalFrame);
            }
            if (this.equals(KeyboardFocusManager.getCurrentKeyboardFocusManager().getFocusedWindow())) {
                this.busyPanel.grabFocus();
            }
        } else {
            this.blockingWindows.remove(blockingWindowOrInternalFrame);
            if (this.blockingWindows.size() == 0) {
                this.getGlassPane().setVisible(false);
                this.setGlassPane(this.oldGlassPane);
                this.getGlassPane().setVisible(this.oldGlassPaneVisible);
            }
        }
    }

    public void centerOfScreen() {
        Utils.centerOfScreen(this);
    }

    public void centerOfOwner() {
        Utils.centerOfOwner(this, this.getOwner());
    }

    public void relativeToOwnerChild(Component child) {
        Utils.relativeToOwnerChild(this, this.getOwner(), child);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void restoreOwner() {
        JModalWindow jModalWindow = this;
        synchronized (jModalWindow) {
            if (this.modalToWindowsAndInputBlockers.size() > 0 && !this.notifiedModalToWindow) {
                JModalHelper.unblockWindows((Collection)this.modalToWindowsAndInputBlockers, this, this.returnFocus);
                this.notifiedModalToWindow = true;
            }
        }
    }

    protected void processMouseMotionEvent(MouseEvent mouseEvent) {
        switch (mouseEvent.getID()) {
            case 503: {
                this.checkDragZone(mouseEvent);
                break;
            }
            case 506: {
                this.dragWindow(mouseEvent);
                break;
            }
        }
        super.processMouseMotionEvent(mouseEvent);
    }

    private void checkDragZone(MouseEvent mouseEvent) {
        if (!JModalConfiguration.isWindowDraggingEnabled()) {
            return;
        }
        this.priorDragLocation = mouseEvent.getPoint();
        this.cursorDragAnchor = null;
        if (mouseEvent.getX() < this.windowDragBorderDistance || mouseEvent.getX() >= this.getWidth() - this.windowDragBorderDistance) {
            this.setCursor(Cursor.getPredefinedCursor(13));
        } else if (mouseEvent.getY() < this.windowDragBorderDistance || mouseEvent.getY() >= this.getHeight() - this.windowDragBorderDistance) {
            this.setCursor(Cursor.getPredefinedCursor(13));
        } else {
            this.setCursor(Cursor.getPredefinedCursor(0));
        }
    }

    private void dragWindow(MouseEvent mouseEvent) {
        if (!JModalConfiguration.isWindowDraggingEnabled()) {
            return;
        }
        Point cursorRelativePosition = mouseEvent.getPoint();
        if (this.cursorDragAnchor == null) {
            this.cursorDragAnchor = cursorRelativePosition;
        }
        if (this.getCursor().equals(Cursor.getPredefinedCursor(13))) {
            if (this.priorDragLocation == null) {
                this.priorDragLocation = mouseEvent.getPoint();
            } else {
                int deltaX = mouseEvent.getX() - this.priorDragLocation.x;
                int deltaY = mouseEvent.getY() - this.priorDragLocation.y;
                int x = this.getX() + (deltaX += cursorRelativePosition.x - this.cursorDragAnchor.x);
                int y = this.getY() + (deltaY += cursorRelativePosition.y - this.cursorDragAnchor.y);
                if (x != this.getX() || y != this.getY()) {
                    Utils.keepWindowPartiallyOnScreen(this, x, y);
                }
                this.priorDragLocation = null;
            }
        }
    }

    protected void processWindowEvent(WindowEvent windowEvent) {
        switch (windowEvent.getID()) {
            case 201: {
                this.tryToDispose(windowEvent);
                break;
            }
            case 202: {
                this.close(windowEvent);
                break;
            }
            default: {
                super.processWindowEvent(windowEvent);
            }
        }
    }

    private void tryToDispose(WindowEvent windowEvent) {
        if (this.isBusy()) {
            return;
        }
        this.dispose();
        super.processWindowEvent(windowEvent);
    }

    private void close(WindowEvent windowEvent) {
        this.restoreOwner();
        this.release();
        super.processWindowEvent(windowEvent);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public final synchronized void waitForClose() {
        if (EventQueue.isDispatchThread()) {
            if (!JModalConfiguration.simulateWaitOnEDT()) throw new Error("Cannot call wait from the event dispatcher thread or use JModalConfiguration.enableWaitOnEDT([JModalEventQueue]).");
            EventQueue queue = this.getToolkit().getSystemEventQueue();
            if (!(queue instanceof JModalEventQueue)) throw new Error("Cannot call wait from the event dispatcher thread due to wrong EventQueue class.");
            ((JModalEventQueue)queue).waitForClose(this);
            return;
        }
        try {
            this.wait();
            return;
        }
        catch (InterruptedException ie) {
            ie.printStackTrace(System.out);
        }
    }

    public final synchronized void release() {
        this.notifyAll();
    }

    public void paint(Graphics gfx) {
        gfx.draw3DRect(0, 0, this.getWidth(), this.getHeight(), false);
        super.paint(gfx);
    }

    public void setBackground(Color color) {
        super.setBackground(color);
        this.contentPanel.setBackground(color);
    }

    public void setForeground(Color color) {
        super.setForeground(color);
        this.contentPanel.setForeground(color);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void show() {
        JModalWindow jModalWindow = this;
        synchronized (jModalWindow) {
            if (this.modalToWindowsAndInputBlockers.size() > 0 && this.notifiedModalToWindow) {
                JModalHelper.blockWindows((Collection)this.modalToWindowsAndInputBlockers, this);
                this.notifiedModalToWindow = false;
            }
        }
        super.show();
    }

    public void setVisible(boolean visible) {
        if (!visible) {
            if (this.isBusy()) {
                this.setVisible(true);
                return;
            }
            this.restoreOwner();
            this.release();
        }
        super.setVisible(visible);
    }

    private void checkActivationAllowed() {
        if (this.isBusy()) {
            JModalHelper.activateFirstAvailableBlockingWindow(this.blockingWindows, null);
        }
    }
}

