/*
 * Decompiled with CFR 0.152.
 */
package nl.jj.swingx.gui.modal;

import java.awt.Component;
import java.awt.Frame;
import java.awt.KeyboardFocusManager;
import java.awt.Window;
import java.awt.event.WindowEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyVetoException;
import java.util.Collection;
import java.util.Iterator;
import javax.swing.JDesktopPane;
import javax.swing.JInternalFrame;
import javax.swing.SwingUtilities;
import nl.jj.swingx.gui.modal.InputBlocker;
import nl.jj.swingx.gui.modal.JModalConfiguration;
import nl.jj.swingx.gui.modal.JModalFrame;
import nl.jj.swingx.gui.modal.JModalInternalFrame;
import nl.jj.swingx.gui.utility.Utils;

class JModalHelper
implements PropertyChangeListener {
    private static final String FOCUSED_WINDOW_PROPERTY = "focusedWindow";
    private static final String PERMANENT_FOCUS_OWNER_PROPERTY = "permanentFocusOwner";
    protected static final JModalHelper jmodalHelper = new JModalHelper();
    private Window flagActivateWindow;
    private JInternalFrame flagActivateInternalFrame;
    private Window activateTriggerFrame;
    private Window ignoreTriggerFrame;

    private JModalHelper() {
        this.setDelayedActivation(null, null, null);
        KeyboardFocusManager.getCurrentKeyboardFocusManager().addPropertyChangeListener(FOCUSED_WINDOW_PROPERTY, this);
        KeyboardFocusManager.getCurrentKeyboardFocusManager().addPropertyChangeListener(PERMANENT_FOCUS_OWNER_PROPERTY, this);
    }

    protected static void blockWindows(Collection modalToWindowsAndInputBlockers, JModalInternalFrame iframe) {
        Iterator iterator = modalToWindowsAndInputBlockers.iterator();
        while (iterator.hasNext()) {
            JModalHelper.blockWindow(iterator.next(), iframe);
        }
    }

    private static void blockWindow(Object windowOrInputBlocker, JModalInternalFrame iframe) {
        if (windowOrInputBlocker instanceof InputBlocker) {
            ((InputBlocker)windowOrInputBlocker).setBusy(true, iframe);
        } else {
            ((Window)windowOrInputBlocker).setEnabled(false);
        }
    }

    protected static void blockWindows(Collection modalToWindowsAndInputBlockers, Window blockingWindow) {
        Iterator iterator = modalToWindowsAndInputBlockers.iterator();
        while (iterator.hasNext()) {
            JModalHelper.blockWindow(iterator.next(), blockingWindow);
        }
    }

    private static void blockWindow(Object windowOrInputBlocker, Window blockingWindow) {
        if (windowOrInputBlocker instanceof InputBlocker) {
            ((InputBlocker)windowOrInputBlocker).setBusy(true, blockingWindow);
        } else {
            ((Window)windowOrInputBlocker).setEnabled(false);
        }
    }

    protected static void unblockWindows(Collection modalToWindowsAndInputBlockers, JModalInternalFrame iframe, Component returnFocus) {
        Iterator iterator = modalToWindowsAndInputBlockers.iterator();
        while (iterator.hasNext()) {
            JModalHelper.unblockWindow(iterator.next(), iframe);
        }
        JModalHelper.returnFocusToComponent(modalToWindowsAndInputBlockers, returnFocus);
    }

    private static void unblockWindow(Object windowOrInputBlocker, JModalInternalFrame iframe) {
        if (windowOrInputBlocker instanceof InputBlocker) {
            ((InputBlocker)windowOrInputBlocker).setBusy(false, iframe);
        } else {
            ((Window)windowOrInputBlocker).setEnabled(true);
        }
    }

    protected static void unblockWindows(Collection modalToWindowsAndInputBlockers, Window blockingWindow, Component returnFocus) {
        Iterator iterator = modalToWindowsAndInputBlockers.iterator();
        while (iterator.hasNext()) {
            JModalHelper.unblockWindow(iterator.next(), blockingWindow);
        }
        JModalHelper.returnFocusToComponent(modalToWindowsAndInputBlockers, returnFocus);
    }

    private static void unblockWindow(Object windowOrInputBlocker, Window blockingWindow) {
        if (windowOrInputBlocker instanceof InputBlocker) {
            ((InputBlocker)windowOrInputBlocker).setBusy(false, blockingWindow);
        } else {
            ((Window)windowOrInputBlocker).setEnabled(true);
        }
    }

    private static void returnFocusToComponent(Collection modalToWindowsAndInputBlockers, Component returnFocus) {
        if (returnFocus == null) {
            JModalHelper.activateFirstAvailableBlockingWindow(modalToWindowsAndInputBlockers, null);
        } else {
            boolean stillBusy;
            Window returnFocusWindow = Utils.windowForComponent(returnFocus);
            if (returnFocusWindow == null) {
                stillBusy = true;
            } else if (returnFocusWindow instanceof InputBlocker) {
                stillBusy = ((InputBlocker)((Object)returnFocusWindow)).isBusy();
            } else {
                boolean bl = stillBusy = !returnFocusWindow.isEnabled();
            }
            if (stillBusy) {
                JModalHelper.activateFirstAvailableBlockingWindow(modalToWindowsAndInputBlockers, null);
            } else {
                JInternalFrame childIFrame = null;
                Component parent = Utils.parentForComponentRootPane(returnFocus);
                if (parent instanceof JInternalFrame) {
                    childIFrame = (JInternalFrame)parent;
                }
                JModalHelper.activate(returnFocusWindow, childIFrame, null);
                JModalHelper.setDelayedReturnFocus(returnFocus);
            }
        }
    }

    protected static boolean activateFirstAvailableBlockingWindow(Collection blockingWindows, WindowEvent windowEvent) {
        Iterator iteratorDirectBlockingWindows = blockingWindows.iterator();
        while (iteratorDirectBlockingWindows.hasNext()) {
            if (!JModalHelper.tryToActivate(iteratorDirectBlockingWindows.next(), windowEvent, false)) continue;
            return true;
        }
        Iterator iteratorIndirectBlockingWindows = blockingWindows.iterator();
        while (iteratorIndirectBlockingWindows.hasNext()) {
            if (!JModalHelper.tryToActivate(iteratorIndirectBlockingWindows.next(), windowEvent, true)) continue;
            return true;
        }
        return false;
    }

    private static boolean tryToActivate(Object windowOrInputBlocker, WindowEvent windowEvent, boolean recursive) {
        if (windowOrInputBlocker instanceof Window) {
            return JModalHelper.tryToActivate((Window)windowOrInputBlocker, null, windowEvent, recursive);
        }
        if (windowOrInputBlocker instanceof InputBlocker && ((InputBlocker)windowOrInputBlocker).isBusy()) {
            return ((InputBlocker)windowOrInputBlocker).activateFirstAvailableBlockingWindow(windowEvent);
        }
        if (windowOrInputBlocker instanceof Component) {
            Window window = Utils.windowForComponent((Component)windowOrInputBlocker);
            JInternalFrame childIFrame = null;
            if (windowOrInputBlocker instanceof JInternalFrame) {
                childIFrame = (JInternalFrame)windowOrInputBlocker;
            }
            return JModalHelper.tryToActivate(window, childIFrame, windowEvent, recursive);
        }
        return false;
    }

    private static boolean tryToActivate(Window window, JInternalFrame childIFrame, WindowEvent windowEvent, boolean recursive) {
        if (window instanceof InputBlocker) {
            InputBlocker inputBlocker = (InputBlocker)((Object)window);
            if (inputBlocker.isBusy()) {
                if (recursive) {
                    return inputBlocker.activateFirstAvailableBlockingWindow(windowEvent);
                }
                return false;
            }
            Frame ownerFrame = JModalHelper.getOwnerFrame(window);
            if (windowEvent != null && ownerFrame.equals(windowEvent.getOppositeWindow()) && JModalHelper.isIconified(windowEvent.getOppositeWindow())) {
                return false;
            }
            JModalHelper.activate(window, childIFrame, JModalHelper.delayFocusWindow(windowEvent));
            return true;
        }
        if (window.isEnabled()) {
            JModalHelper.activate(window, childIFrame, JModalHelper.delayFocusWindow(windowEvent));
            return true;
        }
        return false;
    }

    private static Window delayFocusWindow(WindowEvent windowEvent) {
        if (windowEvent == null) {
            return null;
        }
        return windowEvent.getWindow();
    }

    private static void activate(Window window, JInternalFrame childIFrame, Window delayFocusedWindow) {
        if (jmodalHelper.ignore(delayFocusedWindow)) {
            return;
        }
        if (window == null) {
            return;
        }
        if (delayFocusedWindow != null && KeyboardFocusManager.getCurrentKeyboardFocusManager().getFocusedWindow() == null) {
            jmodalHelper.setDelayedActivation(window, childIFrame, delayFocusedWindow);
            return;
        }
        JModalHelper.activate(window, childIFrame);
    }

    private static void activate(Window window, JInternalFrame childIFrame) {
        if (window == null) {
            return;
        }
        if (window instanceof Frame) {
            window.toFront();
            JModalHelper.tryToDeiconify(window);
        } else {
            Frame ownerFrame = JModalHelper.getOwnerFrame(window);
            if (ownerFrame != null && JModalHelper.isIconified(ownerFrame)) {
                ownerFrame.toFront();
                JModalHelper.tryToDeiconify(ownerFrame);
            }
            window.toFront();
        }
        if (childIFrame != null) {
            try {
                childIFrame.setIcon(false);
                childIFrame.toFront();
                childIFrame.setSelected(true);
            }
            catch (PropertyVetoException pve) {
                pve.printStackTrace(System.out);
            }
        }
    }

    private static void tryToDeiconify(Window window) {
        Frame frame;
        if (window instanceof Frame && (frame = (Frame)window).getState() != 0) {
            frame.setState(0);
        }
    }

    private static void tryToIconify(Window window) {
        Frame frame;
        if (window instanceof Frame && (frame = (Frame)window).getState() != 1) {
            frame.setState(1);
        }
    }

    private static boolean isIconified(Window window) {
        if (window == null) {
            return false;
        }
        if (window instanceof Frame) {
            return JModalHelper.isIconified((Frame)window);
        }
        return JModalHelper.isIconified(window.getOwner());
    }

    private static boolean isIconified(Frame frame) {
        return frame.getState() != 0;
    }

    private static Frame getOwnerFrame(Window window) {
        Window owner;
        if (window instanceof Frame) {
            return (Frame)window;
        }
        for (owner = window.getOwner(); owner != null && !(owner instanceof Frame); owner = owner.getOwner()) {
        }
        return (Frame)owner;
    }

    private void setDelayedActivation(Window flagActivateWindow, JInternalFrame flagActivateInternalFrame, Window activateTriggerFrame) {
        this.flagActivateWindow = flagActivateWindow;
        this.flagActivateInternalFrame = flagActivateInternalFrame;
        this.activateTriggerFrame = activateTriggerFrame;
    }

    protected static void setDelayedReturnFocus(final Component returnFocus) {
        if (returnFocus != null) {
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    returnFocus.requestFocus();
                }
            });
        }
    }

    public void propertyChange(PropertyChangeEvent evt) {
        Window focusedWindow;
        if (this.flagActivateWindow != null && FOCUSED_WINDOW_PROPERTY.equals(evt.getPropertyName()) && (focusedWindow = KeyboardFocusManager.getCurrentKeyboardFocusManager().getFocusedWindow()) != null) {
            if (focusedWindow.equals(this.activateTriggerFrame)) {
                this.needToActivateModalToWindow();
                JModalHelper.activate(this.flagActivateWindow, this.flagActivateInternalFrame);
            }
            this.setDelayedActivation(null, null, null);
        }
        if (PERMANENT_FOCUS_OWNER_PROPERTY.equals(evt.getPropertyName()) && evt.getNewValue() != null && evt.getNewValue() instanceof Component) {
            this.handleIFrameFocus((Component)evt.getNewValue());
        }
    }

    private void handleIFrameFocus(Component cmp) {
        Component parent = Utils.parentForComponentRootPane(cmp);
        if (parent instanceof JInternalFrame) {
            InputBlocker inputBlocker;
            JInternalFrame iframe = (JInternalFrame)parent;
            if (iframe instanceof InputBlocker && (inputBlocker = (InputBlocker)((Object)iframe)).isBusy()) {
                inputBlocker.activateFirstAvailableBlockingWindow(null);
                return;
            }
            if (!iframe.isSelected()) {
                JDesktopPane desktop = iframe.getDesktopPane();
                if (desktop == null) {
                    return;
                }
                JInternalFrame selectedIFrame = desktop.getSelectedFrame();
                if (selectedIFrame != null) {
                    selectedIFrame.toFront();
                    return;
                }
                JInternalFrame[] frames = iframe.getDesktopPane().getAllFrames();
                if (frames != null && frames.length > 0) {
                    try {
                        frames[0].setSelected(true);
                    }
                    catch (PropertyVetoException pve) {
                        pve.printStackTrace(System.out);
                    }
                }
            }
        }
    }

    private void needToActivateModalToWindow() {
        if (JModalConfiguration.keepModalToWindowInFront() && this.flagActivateWindow instanceof JModalFrame) {
            Window modalToOwner = ((JModalFrame)this.flagActivateWindow).getModalToOwner();
            boolean activateOwner = !this.activateTriggerFrame.equals(modalToOwner);
            this.activateTriggerFrame = null;
            if (activateOwner && this.setIgnoreTriggerFrame(modalToOwner)) {
                JModalHelper.activate(modalToOwner, null, null);
            }
        }
    }

    private boolean setIgnoreTriggerFrame(Window modalToWindow) {
        Frame ownerFrame = JModalHelper.getOwnerFrame(modalToWindow);
        if (ownerFrame == null || JModalHelper.isIconified(ownerFrame)) {
            return false;
        }
        this.ignoreTriggerFrame = ownerFrame;
        return true;
    }

    private boolean ignore(Window delayFocusedWindow) {
        boolean ignore = false;
        if (this.ignoreTriggerFrame != null) {
            if (this.ignoreTriggerFrame.equals(delayFocusedWindow)) {
                ignore = true;
            }
            JModalHelper.jmodalHelper.ignoreTriggerFrame = null;
        }
        return ignore;
    }
}

