/*
 * Decompiled with CFR 0.152.
 */
package nl.jj.swingx.gui.modal;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.GraphicsConfiguration;
import java.awt.Image;
import java.awt.KeyboardFocusManager;
import java.awt.Window;
import java.awt.event.ComponentEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowEvent;
import java.util.Collection;
import java.util.Vector;
import javax.swing.JFrame;
import javax.swing.JPanel;
import nl.jj.swingx.gui.modal.CloseBlocker;
import nl.jj.swingx.gui.modal.InputBlocker;
import nl.jj.swingx.gui.modal.JBusyPanel;
import nl.jj.swingx.gui.modal.JModalConfiguration;
import nl.jj.swingx.gui.modal.JModalEventQueue;
import nl.jj.swingx.gui.modal.JModalHelper;
import nl.jj.swingx.gui.modal.JModalInternalFrame;
import nl.jj.swingx.gui.utility.Utils;

public class JModalFrame
extends JFrame
implements InputBlocker,
CloseBlocker {
    private Window modalToOwner;
    private Vector modalToWindowsAndInputBlockers;
    private Vector blockingWindows;
    private Vector blockedIFrames;
    private boolean notifiedModalToWindow;
    private Component returnFocus;
    private JPanel busyPanel;
    private Color blurColor;
    private Component oldGlassPane = null;
    private boolean oldGlassPaneVisible = false;
    private int minWidth;
    private int minHeight;

    public JModalFrame() {
        this(null, null, "", true);
    }

    public JModalFrame(boolean modal) {
        this(null, null, "", modal);
    }

    public JModalFrame(String title) {
        this(null, null, title, true);
    }

    public JModalFrame(String title, boolean modal) {
        this(null, null, title, modal);
    }

    public JModalFrame(Window owner) {
        this(owner, null, "", true);
    }

    public JModalFrame(Window owner, boolean modal) {
        this(owner, null, "", modal);
    }

    public JModalFrame(Window owner, Component returnFocus) {
        this(owner, returnFocus, "", true);
    }

    public JModalFrame(Window owner, Component returnFocus, boolean modal) {
        this(owner, returnFocus, "", modal);
    }

    public JModalFrame(Window owner, String title) {
        this(owner, null, title, true);
    }

    public JModalFrame(Window owner, String title, boolean modal) {
        this(owner, null, title, modal);
    }

    public JModalFrame(Window owner, Component returnFocus, String title) {
        this(owner, returnFocus, title, true);
    }

    public JModalFrame(Window owner, Component returnFocus, String title, boolean modal) {
        super(title);
        this.jmodalFrameInit(owner, returnFocus, modal);
    }

    public JModalFrame(GraphicsConfiguration gc) {
        this(null, null, "", true, gc);
    }

    public JModalFrame(boolean modal, GraphicsConfiguration gc) {
        this(null, null, "", modal, gc);
    }

    public JModalFrame(String title, GraphicsConfiguration gc) {
        this(null, null, title, true, gc);
    }

    public JModalFrame(String title, boolean modal, GraphicsConfiguration gc) {
        this(null, null, title, modal, gc);
    }

    public JModalFrame(Window owner, GraphicsConfiguration gc) {
        this(owner, null, "", true, gc);
    }

    public JModalFrame(Window owner, boolean modal, GraphicsConfiguration gc) {
        this(owner, null, "", modal, gc);
    }

    public JModalFrame(Window owner, Component returnFocus, GraphicsConfiguration gc) {
        this(owner, returnFocus, "", true, gc);
    }

    public JModalFrame(Window owner, Component returnFocus, boolean modal, GraphicsConfiguration gc) {
        this(owner, returnFocus, "", modal, gc);
    }

    public JModalFrame(Window owner, String title, GraphicsConfiguration gc) {
        this(owner, null, title, true, gc);
    }

    public JModalFrame(Window owner, String title, boolean modal, GraphicsConfiguration gc) {
        this(owner, null, title, modal, gc);
    }

    public JModalFrame(Window owner, Component returnFocus, String title, GraphicsConfiguration gc) {
        this(owner, returnFocus, title, true, gc);
    }

    public JModalFrame(Window owner, Component returnFocus, String title, boolean modal, GraphicsConfiguration gc) {
        super(title, gc);
        this.jmodalFrameInit(owner, returnFocus, modal);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void jmodalFrameInit(Window owner, Component returnFocus, boolean modal) {
        JModalFrame jModalFrame = this;
        synchronized (jModalFrame) {
            this.notifiedModalToWindow = true;
            this.modalToWindowsAndInputBlockers = new Vector();
            this.blockingWindows = new Vector();
            this.blockedIFrames = new Vector();
            if (modal && owner != null) {
                this.modalToOwner = owner;
                this.modalToWindowsAndInputBlockers.add(owner);
            }
        }
        this.returnFocus = returnFocus;
        this.enableEvents(65L);
        Image optionalFrameIcon = JModalConfiguration.getOptionalFrameIcon();
        if (optionalFrameIcon != null) {
            this.setIconImage(optionalFrameIcon);
        }
        this.initBusyPanel();
    }

    protected Window getModalToOwner() {
        return this.modalToOwner;
    }

    private void initBusyPanel() {
        this.blurColor = JModalConfiguration.getBlurColor(this.getContentPane().getBackground());
        this.busyPanel = new JBusyPanel(this.blurColor, JModalConfiguration.getBlurStyle());
        this.busyPanel.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent mouseEvent) {
                JModalFrame.this.checkActivationAllowed();
            }
        });
    }

    public void addAdditionalModalToWindow(Window window) {
        if (window != null && !this.modalToWindowsAndInputBlockers.contains(window)) {
            this.modalToWindowsAndInputBlockers.add(window);
        }
    }

    public void addAdditionalModalToComponent(InputBlocker inputBlocker) {
        if (inputBlocker != null && !this.modalToWindowsAndInputBlockers.contains(inputBlocker)) {
            this.modalToWindowsAndInputBlockers.add(inputBlocker);
        }
    }

    public boolean activateFirstAvailableBlockingWindow(WindowEvent windowEvent) {
        return JModalHelper.activateFirstAvailableBlockingWindow(this.blockingWindows, windowEvent);
    }

    public boolean isBusy() {
        return this.blockingWindows.size() > 0;
    }

    public void setBusy(boolean busy, Window blockingWindow) {
        this.setBusyStatus(busy, blockingWindow);
    }

    public void setBusy(boolean busy, JModalInternalFrame blockingIFrame) {
        this.setBusyStatus(busy, blockingIFrame);
    }

    private void setBusyStatus(boolean busy, Component blockingWindowOrInternalFrame) {
        if (busy) {
            if (this.blockingWindows.size() == 0) {
                this.oldGlassPane = this.getGlassPane();
                this.oldGlassPaneVisible = this.getGlassPane().isVisible();
                this.setGlassPane(this.busyPanel);
            }
            this.getGlassPane().setVisible(true);
            if (!this.blockingWindows.contains(blockingWindowOrInternalFrame)) {
                this.blockingWindows.add(blockingWindowOrInternalFrame);
            }
            if (this.equals(KeyboardFocusManager.getCurrentKeyboardFocusManager().getFocusedWindow())) {
                this.busyPanel.grabFocus();
            }
        } else {
            this.blockingWindows.remove(blockingWindowOrInternalFrame);
            if (this.blockingWindows.size() == 0) {
                this.getGlassPane().setVisible(false);
                this.setGlassPane(this.oldGlassPane);
                this.getGlassPane().setVisible(this.oldGlassPaneVisible);
            }
        }
    }

    public void setClosable(JModalInternalFrame modalIFrame) {
        if (modalIFrame.isBusy()) {
            if (!this.blockedIFrames.contains(modalIFrame)) {
                this.blockedIFrames.add(modalIFrame);
            }
        } else if (this.blockedIFrames.contains(modalIFrame)) {
            this.blockedIFrames.remove(modalIFrame);
        }
    }

    public boolean isClosable() {
        return this.blockedIFrames.size() == 0;
    }

    public void centerOfScreen() {
        Utils.centerOfScreen(this);
    }

    public void centerOfOwner() {
        Utils.centerOfOwner(this, this.getOwner());
    }

    public void relativeToOwnerChild(Component child) {
        Utils.relativeToOwnerChild(this, this.getOwner(), child);
    }

    public void setMinSize(Dimension dim) {
        this.setMinSize(dim.width, dim.height);
    }

    public void setMinSize(int width, int height) {
        this.minWidth = width;
        this.minHeight = height;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void restoreOwner() {
        JModalFrame jModalFrame = this;
        synchronized (jModalFrame) {
            if (this.modalToWindowsAndInputBlockers.size() > 0 && !this.notifiedModalToWindow) {
                JModalHelper.unblockWindows((Collection)this.modalToWindowsAndInputBlockers, this, this.returnFocus);
                this.notifiedModalToWindow = true;
            }
        }
    }

    public int getDefaultCloseOperation() {
        if (this.isBusy() || !this.isClosable()) {
            return 0;
        }
        return super.getDefaultCloseOperation();
    }

    protected void processWindowEvent(WindowEvent windowEvent) {
        switch (windowEvent.getID()) {
            case 205: {
                this.checkActivationAllowed(windowEvent);
                break;
            }
            case 201: {
                this.tryToDispose(windowEvent);
                break;
            }
            case 202: {
                this.close(windowEvent);
                break;
            }
            default: {
                super.processWindowEvent(windowEvent);
            }
        }
    }

    private void checkActivationAllowed(WindowEvent windowEvent) {
        super.processWindowEvent(windowEvent);
        if (this.isBusy()) {
            JModalHelper.activateFirstAvailableBlockingWindow(this.blockingWindows, windowEvent);
        }
    }

    private void checkActivationAllowed() {
        if (this.isBusy()) {
            JModalHelper.activateFirstAvailableBlockingWindow(this.blockingWindows, null);
        }
    }

    private void tryToDispose(WindowEvent windowEvent) {
        if (this.isBusy() || !this.isClosable()) {
            return;
        }
        this.close(windowEvent);
    }

    private void close(WindowEvent windowEvent) {
        this.restoreOwner();
        this.release();
        super.processWindowEvent(windowEvent);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public final synchronized void waitForClose() {
        if (EventQueue.isDispatchThread()) {
            if (!JModalConfiguration.simulateWaitOnEDT()) throw new Error("Cannot call wait from the event dispatcher thread or use JModalConfiguration.enableWaitOnEDT([JModalEventQueue]).");
            EventQueue queue = this.getToolkit().getSystemEventQueue();
            if (!(queue instanceof JModalEventQueue)) throw new Error("Cannot call wait from the event dispatcher thread due to wrong EventQueue class.");
            ((JModalEventQueue)queue).waitForClose(this);
            return;
        }
        try {
            this.wait();
            return;
        }
        catch (InterruptedException ie) {
            ie.printStackTrace(System.out);
        }
    }

    public final synchronized void release() {
        this.notifyAll();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void show() {
        JModalFrame jModalFrame = this;
        synchronized (jModalFrame) {
            if (this.modalToWindowsAndInputBlockers.size() > 0 && this.notifiedModalToWindow) {
                JModalHelper.blockWindows((Collection)this.modalToWindowsAndInputBlockers, this);
                this.notifiedModalToWindow = false;
            }
        }
        super.show();
    }

    public void setVisible(boolean visible) {
        if (!visible) {
            if (this.isBusy() || !this.isClosable()) {
                this.setVisible(true);
                return;
            }
            this.restoreOwner();
            this.release();
        }
        super.setVisible(visible);
    }

    protected void processComponentEvent(ComponentEvent componentEvent) {
        int eventId = componentEvent.getID();
        switch (eventId) {
            case 101: {
                if (this.hasAtLeastMinimumSize()) break;
                return;
            }
        }
        super.processComponentEvent(componentEvent);
    }

    private boolean hasAtLeastMinimumSize() {
        int width = this.getWidth();
        int height = this.getHeight();
        if (this.minWidth > 0 && width < this.minWidth) {
            width = this.minWidth;
        }
        if (this.minHeight > 0 && height < this.minHeight) {
            height = this.minHeight;
        }
        if (width != this.getWidth() || height != this.getHeight()) {
            this.setSize(width, height);
            return false;
        }
        return true;
    }
}

