/*
 * Decompiled with CFR 0.152.
 */
package nl.jj.swingx.gui.modal;

import java.awt.Color;
import java.awt.Cursor;
import java.awt.EventQueue;
import java.awt.Image;
import java.awt.Toolkit;
import javax.swing.Icon;
import javax.swing.UIManager;
import nl.jj.swingx.gui.modal.JModalEventQueue;
import nl.jj.swingx.gui.utility.Utils;

public class JModalConfiguration {
    private int blurStyle = 2;
    private Color blurColor = null;
    private Cursor busyCursor = null;
    private boolean busyCursorEnabled = true;
    private Image optionalFrameIcon = null;
    private Icon optionalIFrameIcon = null;
    private boolean windowDragEnabled = true;
    private int windowDragBorderDistance = 1;
    private int windowDragScreenSafetyMargin = 100;
    private boolean alsoKeepModalToWindowInFront = false;
    private boolean allowIconifyForBlockedInternalFrame = true;
    private boolean enableWaitOnEDT = false;
    private static JModalConfiguration configuration;

    private JModalConfiguration() {
    }

    private static JModalConfiguration getInstance() {
        if (configuration == null) {
            configuration = new JModalConfiguration();
        }
        return configuration;
    }

    public static int getBlurStyle() {
        return JModalConfiguration.getInstance().blurStyle;
    }

    public static synchronized void setBlurStyle(int blurStyle) {
        JModalConfiguration.getInstance().blurStyle = blurStyle;
    }

    public static synchronized void setBlurStyleNone() {
        JModalConfiguration.setBlurStyle(-1);
    }

    public static synchronized void setBlurStyleAlphaChannel() {
        JModalConfiguration.setBlurStyle(2);
    }

    public static Color getBlurColor() {
        return JModalConfiguration.getInstance().blurColor;
    }

    public static Color getBlurColor(Color backgroundColor) {
        if (JModalConfiguration.getBlurColor() == null) {
            return new Color(backgroundColor.getRed(), backgroundColor.getGreen(), backgroundColor.getBlue(), 128);
        }
        return JModalConfiguration.getBlurColor();
    }

    public static synchronized void setBlurColor(Color blurColor) {
        JModalConfiguration.getInstance().blurColor = blurColor == null || blurColor.getAlpha() != 255 ? blurColor : new Color(blurColor.getRed(), blurColor.getGreen(), blurColor.getBlue(), 128);
    }

    public static Cursor getBusyCursor() {
        if (JModalConfiguration.getInstance().busyCursor == null) {
            return Utils.getBusyCursor();
        }
        return JModalConfiguration.getInstance().busyCursor;
    }

    public static synchronized void setBusyCursor(Cursor busyCursor) {
        JModalConfiguration.getInstance().busyCursor = busyCursor;
    }

    public static boolean isBusyCursorEnabled() {
        return JModalConfiguration.getInstance().busyCursorEnabled;
    }

    public static synchronized void enableBusyCursor() {
        JModalConfiguration.getInstance().busyCursorEnabled = true;
    }

    public static synchronized void disableBusyCursor() {
        JModalConfiguration.getInstance().busyCursorEnabled = false;
    }

    public static Image getOptionalFrameIcon() {
        Image optionalFrameIcon = JModalConfiguration.getInstance().optionalFrameIcon;
        if (optionalFrameIcon != null) {
            return optionalFrameIcon;
        }
        String uiOptionalFrameIcon = UIManager.getString("swingx.frame.icon");
        if (uiOptionalFrameIcon != null) {
            return Utils.getIcon(uiOptionalFrameIcon).getImage();
        }
        return null;
    }

    public static synchronized void setOptionalFrameIcon(Image optionalFrameIcon) {
        JModalConfiguration.getInstance().optionalFrameIcon = optionalFrameIcon;
    }

    public static Icon getOptionalIFrameIcon() {
        Icon optionalIFrameIcon = JModalConfiguration.getInstance().optionalIFrameIcon;
        if (optionalIFrameIcon != null) {
            return optionalIFrameIcon;
        }
        String uiOptionalIFrameIcon = UIManager.getString("swingx.iframe.icon");
        if (uiOptionalIFrameIcon != null) {
            return Utils.getIcon(uiOptionalIFrameIcon);
        }
        return null;
    }

    public static synchronized void setOptionalIFrameIcon(Icon optionalIFrameIcon) {
        JModalConfiguration.getInstance().optionalIFrameIcon = optionalIFrameIcon;
    }

    public static boolean isWindowDraggingEnabled() {
        return JModalConfiguration.getInstance().windowDragEnabled;
    }

    public static synchronized void enableWindowDragging() {
        JModalConfiguration.getInstance().windowDragEnabled = true;
    }

    public static synchronized void disableWindowDragging() {
        JModalConfiguration.getInstance().windowDragEnabled = false;
    }

    public static int getWindowDragBorderDistance() {
        return JModalConfiguration.getInstance().windowDragBorderDistance;
    }

    public static synchronized void setWindowDragBorderDistance(int windowDragBorderDistance) {
        JModalConfiguration.getInstance().windowDragBorderDistance = windowDragBorderDistance;
    }

    public static int getWindowDragScreenSafetyMargin() {
        return JModalConfiguration.getInstance().windowDragScreenSafetyMargin;
    }

    public static synchronized void setWindowDragScreenSafetyMargin(int windowDragScreenSafetyMargin) {
        JModalConfiguration.getInstance().windowDragScreenSafetyMargin = windowDragScreenSafetyMargin;
    }

    public static boolean keepModalToWindowInFront() {
        return JModalConfiguration.getInstance().alsoKeepModalToWindowInFront;
    }

    public static synchronized void enableKeepModalToWindowInFront() {
        JModalConfiguration.getInstance().alsoKeepModalToWindowInFront = true;
    }

    public static synchronized void disableKeepModalToWindowInFront() {
        JModalConfiguration.getInstance().alsoKeepModalToWindowInFront = false;
    }

    public static boolean allowIconifyForBlockedInternalFrame() {
        return JModalConfiguration.getInstance().allowIconifyForBlockedInternalFrame;
    }

    public static synchronized void disableIconifyForBlockedInternalFrame() {
        JModalConfiguration.getInstance().allowIconifyForBlockedInternalFrame = false;
    }

    public static synchronized void enableIconifyForBlockedInternalFrame() {
        JModalConfiguration.getInstance().allowIconifyForBlockedInternalFrame = true;
    }

    public static boolean simulateWaitOnEDT() {
        return JModalConfiguration.getInstance().enableWaitOnEDT;
    }

    public static synchronized void enableWaitOnEDT() {
        JModalConfiguration.enableWaitOnEDT(new JModalEventQueue());
    }

    public static synchronized void enableWaitOnEDT(JModalEventQueue customEventQueue) {
        EventQueue currentQueue = Toolkit.getDefaultToolkit().getSystemEventQueue();
        if (!(currentQueue instanceof JModalEventQueue)) {
            Toolkit.getDefaultToolkit().getSystemEventQueue().push(customEventQueue);
        }
        JModalConfiguration.getInstance().enableWaitOnEDT = true;
    }

    public static synchronized void disableWaitOnEDT() {
        JModalConfiguration.getInstance().enableWaitOnEDT = false;
    }
}

