/*
 * Decompiled with CFR 0.152.
 */
package com.schneide.werp.module.render.pdf.lowlevel;

import com.schneide.werp.module.render.pdf.detail.Column;
import com.schneide.werp.module.render.pdf.detail.Cursor;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.pdfbox.pdmodel.PDDocument;
import org.apache.pdfbox.pdmodel.PDPageContentStream;
import org.apache.pdfbox.pdmodel.font.PDFont;
import org.apache.pdfbox.pdmodel.graphics.image.JPEGFactory;
import org.apache.pdfbox.pdmodel.graphics.image.PDImageXObject;

public final class Rendering {
    private static final String subsededBegin = "<sub>";
    private static final String subsededEnd = "</sub>";
    private static final String supersededBegin = "<sup>";
    private static final String supersededEnd = "</sup>";

    private Rendering() {
    }

    protected static List<TextRenderable> verticallyChangingText(String text, PDFont font, float fontSize) throws IOException {
        ArrayList<TextRenderable> parts = new ArrayList<TextRenderable>();
        int currentPosition = 0;
        String remaining = text;
        while (!remaining.isEmpty()) {
            int openingTag = Rendering.nextOccurrenceOf("<su", remaining);
            String normalPart = remaining.substring(0, openingTag);
            parts.add(new Text(normalPart, font, fontSize));
            remaining = remaining.substring(openingTag);
            if (remaining.isEmpty()) break;
            Function<String, TextRenderable> changedPart = Rendering.adjustmentFor(font, fontSize, remaining);
            int closingTag = Rendering.nextOccurrenceOf("</su", remaining);
            String changedText = remaining.substring(subsededBegin.length(), closingTag);
            parts.add(changedPart.apply(changedText));
            currentPosition = closingTag + subsededEnd.length();
            remaining = remaining.substring(currentPosition);
        }
        return parts;
    }

    private static Function<String, TextRenderable> adjustmentFor(PDFont font, float fontSize, String remaining) {
        Function<String, TextRenderable> changedPart = t -> new Text((String)t, font, fontSize);
        if (remaining.startsWith(subsededBegin)) {
            changedPart = t -> new SubscriptText((String)t, font, fontSize);
        }
        if (remaining.startsWith(supersededBegin)) {
            changedPart = t -> new SuperscriptText((String)t, font, fontSize);
        }
        return changedPart;
    }

    private static int nextOccurrenceOf(String token, String inText) {
        int openingTag = inText.indexOf(token);
        if (-1 == openingTag) {
            return inText.length();
        }
        return openingTag;
    }

    private static Stream<String> verticals() {
        return Stream.of(subsededBegin, subsededEnd, supersededBegin, supersededEnd);
    }

    public static void textAt(PDPageContentStream content, Cursor position, String text, PDFont font, float fontSize) throws IOException {
        content.setFont(font, fontSize);
        content.beginText();
        position.applyForTextIn(content);
        boolean containsVerticals = Rendering.verticals().anyMatch(text::contains);
        if (containsVerticals) {
            new Texts(Rendering.verticallyChangingText(text, font, fontSize)).render(content);
            content.endText();
            return;
        }
        content.showText(text);
        content.endText();
    }

    public static void multilineTextAt(PDPageContentStream content, Cursor position, String text, PDFont font, float fontSize) throws IOException {
        content.setFont(font, fontSize);
        String[] lines = text.split("\n");
        Column column = new Column(font, fontSize);
        for (String line : lines) {
            column.add(line);
        }
        column.draw(content, position);
    }

    public static void textRightAlignedAt(PDPageContentStream content, Cursor position, String text, PDFont font, float fontSize) throws IOException {
        content.setFont(font, fontSize);
        content.beginText();
        position.applyForTextIn(content);
        new RightAligned(new Text(text, font, fontSize)).render(content);
        content.endText();
    }

    public static void textCenteredAt(PDPageContentStream content, Cursor position, String text, PDFont font, float fontSize) throws IOException {
        content.setFont(font, fontSize);
        content.beginText();
        position.applyTo(content);
        Rendering.drawStringCentered(content, text, font, fontSize);
        content.endText();
    }

    public static float widthOf(String text, PDFont font, float fontSize) throws IOException {
        return font.getStringWidth(Rendering.withoutModifiers(text)) / 1000.0f * fontSize;
    }

    private static String withoutModifiers(String text) {
        if (null == text) {
            return "";
        }
        String result = text;
        for (String each : Rendering.verticals().collect(Collectors.toList())) {
            result = result.replace(each, "");
        }
        return result;
    }

    public static void drawStringCentered(PDPageContentStream content, String text, PDFont font, float fontSize) throws IOException {
        float textWidth = Rendering.widthOf(text, font, fontSize);
        float halfTextWidth = textWidth / 2.0f;
        content.newLineAtOffset(-halfTextWidth, 0.0f);
        content.showText(text);
        content.newLineAtOffset(halfTextWidth, 0.0f);
    }

    public static void drawRectangle(PDPageContentStream content, Cursor startPosition, Cursor endPosition) throws IOException {
        List<Cursor> corners = startPosition.encloseAreaWith(endPosition);
        Cursor previous = startPosition;
        for (Cursor each : corners) {
            Rendering.drawLine(content, previous, each);
            previous = each;
        }
    }

    public static void drawImage(PDPageContentStream content, Cursor startPosition, PDDocument document, BufferedImage image) throws IOException {
        Rendering.drawImage(content, startPosition, document, image, 1.0f);
    }

    public static void drawImage(PDPageContentStream content, Cursor startPosition, PDDocument document, BufferedImage image, float scalingFactor) throws IOException {
        PDImageXObject xObject = JPEGFactory.createFromImage((PDDocument)document, (BufferedImage)image);
        startPosition.perform((horizontal, vertical) -> content.drawImage(xObject, horizontal, vertical, (float)xObject.getWidth() * scalingFactor, (float)xObject.getHeight() * scalingFactor));
    }

    public static void drawLine(PDPageContentStream content, Cursor startPosition, Cursor endPosition) throws IOException {
        startPosition.applyTo(content);
        endPosition.perform((arg_0, arg_1) -> ((PDPageContentStream)content).lineTo(arg_0, arg_1));
        content.stroke();
    }

    public static class Text
    implements TextRenderable {
        private final String text;
        private final PDFont font;
        private final float fontSize;

        public Text(String text, PDFont font, float fontSize) {
            this.text = text;
            this.font = font;
            this.fontSize = fontSize;
        }

        @Override
        public void render(PDPageContentStream content) throws IOException {
            content.setFont(this.font, this.fontSize);
            content.showText(this.text);
        }

        @Override
        public float width() throws IOException {
            return this.font.getStringWidth(this.text) / 1000.0f * this.fontSize;
        }

        public String toString() {
            return "Text [text=" + this.text + "]";
        }
    }

    public static interface TextRenderable {
        public void render(PDPageContentStream var1) throws IOException;

        public float width() throws IOException;
    }

    public static class Texts
    implements TextRenderable {
        private final Iterable<TextRenderable> texts;

        public Texts(List<TextRenderable> texts) {
            this.texts = texts;
        }

        @Override
        public void render(PDPageContentStream content) throws IOException {
            float xOffset = 0.0f;
            for (TextRenderable text : this.texts) {
                content.newLineAtOffset(xOffset, 0.0f);
                text.render(content);
                content.newLineAtOffset(-xOffset, 0.0f);
                xOffset += text.width();
            }
        }

        @Override
        public float width() throws IOException {
            float width = 0.0f;
            for (TextRenderable text : this.texts) {
                width += text.width();
            }
            return width;
        }
    }

    public static class RightAligned
    implements TextRenderable {
        private final TextRenderable text;

        public RightAligned(TextRenderable text) {
            this.text = text;
        }

        @Override
        public void render(PDPageContentStream content) throws IOException {
            float textWidth = this.width();
            content.newLineAtOffset(-textWidth, 0.0f);
            this.text.render(content);
            content.newLineAtOffset(textWidth, 0.0f);
        }

        @Override
        public float width() throws IOException {
            return this.text.width();
        }
    }

    public static class SuperscriptText
    implements TextRenderable {
        private final Text text;

        public SuperscriptText(String text, PDFont font, float fontSize) {
            this.text = new Text(text, font, fontSize - 3.0f);
        }

        @Override
        public void render(PDPageContentStream content) throws IOException {
            float yOffset = 2.5f;
            content.newLineAtOffset(0.0f, 2.5f);
            this.text.render(content);
            content.newLineAtOffset(0.0f, -2.5f);
        }

        @Override
        public float width() throws IOException {
            return this.text.width();
        }

        public String toString() {
            return "SuperscriptText [text=" + String.valueOf(this.text) + "]";
        }
    }

    public static class SubscriptText
    implements TextRenderable {
        private final Text text;

        public SubscriptText(String text, PDFont font, float fontSize) {
            this.text = new Text(text, font, fontSize - 3.0f);
        }

        @Override
        public void render(PDPageContentStream content) throws IOException {
            float yOffset = 2.5f;
            content.newLineAtOffset(0.0f, -2.5f);
            this.text.render(content);
            content.newLineAtOffset(0.0f, 2.5f);
        }

        @Override
        public float width() throws IOException {
            return this.text.width();
        }

        public String toString() {
            return "SubscriptText [text=" + String.valueOf(this.text) + "]";
        }
    }
}

