/*
 * Decompiled with CFR 0.152.
 */
package com.schneide.werp.module.render.pdf.engine;

import com.schneide.base.functional.No;
import com.schneide.werp.domain.publishing.detail.Seitengr\u00f6\u00dfe;
import com.schneide.werp.module.render.pdf.detail.Cursor;
import com.schneide.werp.module.render.pdf.detail.FontSpecification;
import com.schneide.werp.module.render.pdf.detail.Page;
import com.schneide.werp.module.render.pdf.detail.PageNettoContent;
import com.schneide.werp.module.render.pdf.engine.RenderEngine;
import com.schneide.werp.module.render.pdf.lowlevel.Rendering;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.List;
import org.apache.pdfbox.pdmodel.PDDocument;
import org.apache.pdfbox.pdmodel.PDPage;
import org.apache.pdfbox.pdmodel.PDPageContentStream;
import org.apache.pdfbox.pdmodel.font.PDFont;
import org.apache.pdfbox.pdmodel.font.PDType1Font;

public class PDFBoxRenderEngine
implements RenderEngine {
    private final PDDocument document;
    private final Page pageFormat;
    private PageHeader header;
    private final List<PDPageContentStream> allStreams;
    private final PageNettoContent pageNetto;
    private PDPageContentStream currentPageContent;
    private final List<ReportContent> stamping = new ArrayList<ReportContent>();
    private ReportContent pageBreakContent;
    private PDFont currentFont;
    private float currentFontSize;
    private float lineSpacing;
    private Cursor currentPosition;
    private boolean outOfBandPrinting;

    public PDFBoxRenderEngine(Seitengr\u00f6\u00dfe format, PDDocument document) {
        this.allStreams = new ArrayList<PDPageContentStream>();
        this.document = document;
        this.pageFormat = Page.f\u00fcr(format);
        this.header = cs -> No.op();
        this.pageBreakContent = render -> No.op();
        this.outOfBandPrinting = false;
        this.pageNetto = new PageNettoContent();
    }

    @Override
    public void stampWith(ReportContent newStamping) {
        this.stamping.add(newStamping);
    }

    private void newPage(boolean initial) throws IOException {
        if (!initial && this.pageNetto.isEmpty()) {
            return;
        }
        this.pageNetto.clear();
        this.pageNetto.disable();
        PDPage page = this.pageFormat.neueSeite();
        PDPageContentStream result = new PDPageContentStream(this.document, page);
        this.document.addPage(page);
        this.currentPageContent = result;
        this.allStreams.add(result);
        this.resetCursor();
        this.printOutOfBand(this.stamping);
        this.resetCursor();
        this.header.addTo(this);
        this.pageBreakContent.addTo(this);
        this.pageNetto.enable();
    }

    private void resetCursor() throws IOException {
        this.currentPosition = Cursor.topLeftOn(this.pageFormat);
        this.relativeTo(this.currentPosition().startOfNettoArea());
        this.changeFontTo((PDFont)PDType1Font.HELVETICA, 10.0f);
    }

    @Override
    public void changePageHeaderTo(PageHeader newHeader) {
        this.header = newHeader;
    }

    @Override
    public Cursor currentPosition() {
        return this.currentPosition;
    }

    @Override
    public float fromRight(float horizontally) {
        return this.pageFormat.width - 2.0f * this.pageFormat.verticalMargin - horizontally;
    }

    @Override
    public void relativeTo(Cursor newPosition) throws IOException {
        this.currentPosition = newPosition;
        newPosition.applyTo(this.currentPageContent);
        this.checkForPageBreak();
    }

    @Override
    public void feedPaper(float vertically) throws IOException {
        this.relativeTo(this.currentPosition().down(vertically));
    }

    @Override
    public void feedLine() throws IOException {
        this.feedLine(1.0f);
    }

    @Override
    public void feedLine(float factor) throws IOException {
        this.feedPaper(this.lineSpacing * factor);
    }

    @Override
    public void changeFontTo(PDFont newFont, float newSize) throws IOException {
        this.currentFont = newFont;
        this.currentFontSize = newSize;
        this.lineSpacing = 6.0f;
        this.currentPageContent.setFont(newFont, newSize);
    }

    @Override
    public float lineSpacing() {
        return this.lineSpacing;
    }

    @Override
    public void changeLineSpacingTo(float millimeters) {
        this.lineSpacing = millimeters;
    }

    @Override
    public void changeFontSizeTo(float newSize) throws IOException {
        this.changeFontTo(this.currentFont, newSize);
    }

    @Override
    public float widthOf(String text) throws IOException {
        return this.widthOf(text, new FontSpecification(this.currentFont, this.currentFontSize));
    }

    @Override
    public float widthOf(String text, FontSpecification font) throws IOException {
        return Rendering.widthOf(text, font.font, font.size) / 72.0f * 25.4f;
    }

    @Override
    public void printImage(BufferedImage image) throws IOException {
        this.printImage(image, 1.0f);
    }

    @Override
    public void printImage(BufferedImage image, float scalingFactor) throws IOException {
        this.pageNetto.add("Image");
        Rendering.drawImage(this.currentPageContent, this.currentPosition, this.document, image, scalingFactor);
    }

    @Override
    public Cursor.Offset printText(String text, double lineHeightFactor) throws IOException {
        float lineHeight = this.lineSpacing * (float)lineHeightFactor;
        this.moveDown(lineHeight);
        this.pageNetto.add("Text");
        Rendering.textAt(this.currentPageContent, this.currentPosition.down(this.lineSpacing), text, this.currentFont, this.currentFontSize);
        return new Cursor.Offset(this.widthOf(text), lineHeight);
    }

    private void moveDown(float vertically) throws IOException {
        this.currentPosition = this.currentPosition.down(vertically);
        this.checkForPageBreak();
    }

    private void checkForPageBreak() throws IOException {
        if (this.wouldTriggerPageBreak(this.currentPosition)) {
            this.newPage(false);
            this.returnToLeft();
        }
    }

    @Override
    public boolean wouldTriggerPageBreak(Cursor somePosition) {
        return !this.outOfBandPrinting && somePosition.below(this.pageFormat);
    }

    @Override
    public void returnToLeft() throws IOException {
        this.relativeTo(this.currentPosition.horizontallyAt(0.0f));
    }

    @Override
    public void printHorizontalLine() throws IOException {
        this.moveDown(this.lineSpacing);
        List<Cursor> lineEndPoints = this.pageFormat.acrossAtHeightOf(this.currentPosition.down(0.5f * this.lineSpacing));
        this.pageNetto.add("Horizontal Line");
        Rendering.drawLine(this.currentPageContent, lineEndPoints.get(0), lineEndPoints.get(1));
    }

    @Override
    public void printBoxFrom(Cursor topLeft, Cursor bottomRight) throws IOException {
        this.currentPosition = bottomRight;
        this.checkForPageBreak();
        this.pageNetto.add("Box");
        Rendering.drawRectangle(this.currentPageContent, topLeft, bottomRight);
    }

    @Override
    public void feedPage() throws IOException {
        this.newPage(false);
    }

    @Override
    public void start() throws IOException {
        this.newPage(true);
    }

    @Override
    public void stop(boolean mitSeitenzahlen, boolean mitDatum) throws IOException {
        if (mitSeitenzahlen) {
            this.printPageNumbers();
        }
        if (mitDatum) {
            this.printCurrentDate();
        }
        for (PDPageContentStream each : this.allStreams) {
            each.close();
        }
    }

    private void printPageNumbers() throws IOException {
        this.printOutOfBand((RenderEngine rendering) -> {
            int pageNumber = 0;
            for (PDPageContentStream each : this.allStreams) {
                try {
                    this.currentPageContent = each;
                    this.resetCursor();
                    String text = "Seite " + (pageNumber + 1) + " von " + this.allStreams.size();
                    this.relativeTo(this.currentPosition().down(this.pageFormat.height - 2.0f * this.pageFormat.horizontalMargin));
                    this.relativeTo(this.currentPosition().right(this.pageFormat.width - 2.0f * this.pageFormat.verticalMargin - this.widthOf(text)));
                    this.printText(text, 1.0);
                    ++pageNumber;
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        });
    }

    private void printOutOfBand(ReportContent content) throws IOException {
        this.printOutOfBand(List.of(content));
    }

    private void printOutOfBand(Iterable<ReportContent> content) throws IOException {
        this.outOfBandPrinting = true;
        for (ReportContent each : content) {
            this.resetCursor();
            each.addTo(this);
        }
        this.outOfBandPrinting = false;
    }

    private void printCurrentDate() throws IOException {
        this.printOutOfBand((RenderEngine rendering) -> {
            for (PDPageContentStream each : this.allStreams) {
                try {
                    this.currentPageContent = each;
                    this.resetCursor();
                    DateTimeFormatter justDay = DateTimeFormatter.ofPattern("dd.MM.yyyy");
                    String text = "Stand " + LocalDateTime.now().format(justDay);
                    this.relativeTo(this.currentPosition().down(this.pageFormat.height - 2.0f * this.pageFormat.horizontalMargin));
                    this.relativeTo(this.currentPosition().right(0.5f * (this.pageFormat.width - 2.0f * this.pageFormat.verticalMargin) - 0.5f * this.widthOf(text)));
                    this.printText(text, 1.0);
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        });
    }

    @Override
    public void rewindPaper(float vertically) throws IOException {
        this.relativeTo(this.currentPosition.up(vertically));
    }

    @Override
    public void onPageBreak(ReportContent content) {
        this.pageBreakContent = content;
    }

    @Override
    public void nothingOnPageBreak() {
        this.pageBreakContent = render -> No.op();
    }

    public static interface PageHeader {
        public void addTo(RenderEngine var1) throws IOException;
    }

    public static interface ReportContent {
        public void addTo(RenderEngine var1) throws IOException;
    }
}

