/*
 * Decompiled with CFR 0.152.
 */
package com.schneide.werp.module.render.pdf;

import com.schneide.werp.domain.publishing.LineSection;
import com.schneide.werp.module.render.pdf.RenderAsPDF;
import com.schneide.werp.module.render.pdf.detail.FontSpecification;
import com.schneide.werp.module.render.pdf.engine.RenderEngine;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.function.Function;

public class ColumnLayout {
    private static final float columnMargin = 5.0f;

    public List<RenderAsPDF.OffsetProvider> columnize(RenderEngine pdf, List<List<LineSection>> content) throws IOException {
        int columnCount = this.columnsIn(content);
        List<Float> columnWidths = this.determineMaximumWidthsOf(content, pdf, Function.identity());
        ArrayList<RenderAsPDF.OffsetProvider> result = new ArrayList<RenderAsPDF.OffsetProvider>();
        result.add(s -> 0.0f);
        if (columnCount > 1) {
            float startOfSecondColumn = columnWidths.get(0).floatValue() + 5.0f;
            result.add(s -> startOfSecondColumn);
            if (4 == columnCount) {
                float rightMostColumn = pdf.fromRight(columnWidths.get(3).floatValue());
                float secondToRightColumn = rightMostColumn - columnWidths.get(2).floatValue() - 5.0f;
                result.add(s -> secondToRightColumn);
                result.add(s -> rightMostColumn);
            }
            if (6 == columnCount) {
                float startOfThirdColumn = startOfSecondColumn + columnWidths.get(1).floatValue() + 5.0f;
                result.add(s -> startOfThirdColumn);
                float maximumFractionalWidth = this.maximumWidthOf(this.columnAt(3, content), pdf, this.onlyFractionalDigits());
                float startOfFourthColumn = startOfThirdColumn + columnWidths.get(2).floatValue() + 5.0f;
                result.add(this.alignedAtDecimalSeparator(startOfFourthColumn, columnWidths.get(3).floatValue(), maximumFractionalWidth, pdf));
                float startOfFifthColumn = startOfFourthColumn + columnWidths.get(3).floatValue() + 2.5f;
                result.add(s -> startOfFifthColumn);
                result.add(s -> startOfFifthColumn);
            }
            if (13 == columnCount) {
                List<ColumnAlignment> alignments = Arrays.asList(ColumnAlignment.leftAtSeparator, ColumnAlignment.left, ColumnAlignment.leftAtSeparator, ColumnAlignment.left, ColumnAlignment.left, ColumnAlignment.left, ColumnAlignment.left, ColumnAlignment.left, ColumnAlignment.leftAtSeparator, ColumnAlignment.left, ColumnAlignment.left, ColumnAlignment.leftAtSeparator);
                float cursor = startOfSecondColumn;
                result.remove(1);
                int index = 1;
                for (ColumnAlignment each : alignments) {
                    if (ColumnAlignment.leftAtSeparator == each) {
                        result.add(this.leftAtSeparator(pdf, content, columnWidths, cursor, index));
                    }
                    if (ColumnAlignment.left == each) {
                        result.add(this.left(pdf, content, columnWidths, cursor, index));
                    }
                    cursor = cursor + columnWidths.get(index).floatValue() + 2.5f;
                    ++index;
                }
            }
        }
        return result;
    }

    private RenderAsPDF.OffsetProvider left(RenderEngine pdf, List<List<LineSection>> content, List<Float> columnWidths, float cursor, int index) throws IOException {
        return s -> cursor;
    }

    private RenderAsPDF.OffsetProvider leftAtSeparator(RenderEngine pdf, List<List<LineSection>> content, List<Float> columnWidths, float cursor, int index) throws IOException {
        float maximumFractionalWidth = this.maximumWidthOf(this.columnAt(index, content), pdf, this.onlyFractionalDigits());
        return this.alignedAtDecimalSeparator(cursor, columnWidths.get(index).floatValue(), maximumFractionalWidth, pdf);
    }

    private List<Float> determineMaximumWidthsOf(List<List<LineSection>> content, RenderEngine pdf, Function<String, String> textConversion) throws IOException {
        int columnCount = this.columnsIn(content);
        ArrayList<Float> columnWidths = new ArrayList<Float>();
        for (int columnIndex = 0; columnIndex < columnCount; ++columnIndex) {
            List<LineSection> currentColumn = this.columnAt(columnIndex, content);
            float maximumColumnWidth = this.maximumWidthOf(currentColumn, pdf, textConversion);
            columnWidths.add(Float.valueOf(maximumColumnWidth));
        }
        return columnWidths;
    }

    protected RenderAsPDF.OffsetProvider alignedAtDecimalSeparator(float leftEdge, float maximumWidth, float maximumFractionWidth, RenderEngine pdf) {
        return section -> {
            String value = this.onlyValue().apply(section.text());
            String integralPartOfValue = this.onlyIntegralDigits().apply(value);
            float integralPartWidth = pdf.widthOf(integralPartOfValue, FontSpecification.from(section.style()));
            return leftEdge + (maximumWidth - maximumFractionWidth - integralPartWidth);
        };
    }

    private Function<String, String> onlyValue() {
        return text -> {
            String[] parts = text.split("\\s+");
            String value = parts[0];
            return value;
        };
    }

    private Function<String, String> onlyIntegralDigits() {
        return text -> {
            String[] parts = text.split("\\,+");
            String integral = parts[0];
            return integral;
        };
    }

    private Function<String, String> onlyFractionalDigits() {
        return text -> {
            String[] parts = text.split("\\,+");
            String result = parts[parts.length - 1];
            return result;
        };
    }

    private int columnsIn(List<List<LineSection>> content) {
        int result = 0;
        for (List<LineSection> each : content) {
            result = Math.max(result, each.size());
        }
        return result;
    }

    private List<LineSection> columnAt(int columnIndex, List<List<LineSection>> content) {
        ArrayList<LineSection> result = new ArrayList<LineSection>();
        for (List<LineSection> each : content) {
            if (each.size() > columnIndex) {
                result.add(each.get(columnIndex));
                continue;
            }
            result.add(LineSection.empty);
        }
        return result;
    }

    private float maximumWidthOf(List<LineSection> texts, RenderEngine pdf, Function<String, String> textConversion) throws IOException {
        float result = 0.0f;
        for (LineSection each : texts) {
            float width = pdf.widthOf(textConversion.apply(each.text()), FontSpecification.from(each.style()));
            if (!(width > result)) continue;
            result = width;
        }
        return result;
    }

    private static enum ColumnAlignment {
        left,
        leftAtSeparator;

    }
}

