/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.serializer.persistence.types;

import java.lang.ref.WeakReference;
import org.eclipse.serializer.collections.BulkList;
import org.eclipse.serializer.collections.types.XList;
import org.eclipse.serializer.persistence.types.PersistenceStorerDeactivatable;
import org.eclipse.serializer.persistence.types.PersistenceStorerDeactivatableRegistry;
import org.eclipse.serializer.util.logging.Logging;
import org.slf4j.Logger;

public class StorerModeController
implements PersistenceStorerDeactivatableRegistry {
    private static final Logger logger = Logging.getLogger(StorerModeController.class);
    private XList<WeakReference<PersistenceStorerDeactivatable>> registry = BulkList.New();
    private boolean enabledWrites = true;
    private CleaningThread cleaningThread;
    private boolean active = true;

    public synchronized boolean isActive() {
        return this.active;
    }

    public synchronized void shutdown() {
        this.active = false;
    }

    public void setWriteEnabled(boolean enableWrites) {
        if (enableWrites) {
            this.enableWrites();
        } else {
            this.disableWrites();
        }
    }

    public synchronized boolean isWriteEnabled() {
        return this.enabledWrites;
    }

    public synchronized void enableWrites() {
        this.enabledWrites = true;
        this.enableAll();
    }

    public synchronized void disableWrites() {
        this.enabledWrites = false;
        this.disableAll();
    }

    @Override
    public synchronized PersistenceStorerDeactivatable register(PersistenceStorerDeactivatable deactivatableStorer) {
        this.registry.add(new WeakReference<PersistenceStorerDeactivatable>(deactivatableStorer));
        deactivatableStorer.setWriteEnabled(this.enabledWrites);
        this.startCleaningTask();
        return deactivatableStorer;
    }

    @Override
    public synchronized boolean hasRegisteredStorers() {
        return this.registry.size() > 0L;
    }

    @Override
    public synchronized void clean() {
        BulkList newRegistry = BulkList.New();
        this.registry.forEach(arg_0 -> StorerModeController.lambda$clean$0((XList)newRegistry, arg_0));
        this.registry = newRegistry;
        logger.trace("Active storers after cleanup: {}", (Object)this.registry.size());
    }

    private void startCleaningTask() {
        if (this.cleaningThread == null || !this.cleaningThread.isAlive()) {
            logger.debug("Starting new cleaning task");
            this.cleaningThread = new CleaningThread(this);
            this.cleaningThread.start();
        }
    }

    private void enableAll() {
        this.registry.forEach(r -> {
            PersistenceStorerDeactivatable storer = (PersistenceStorerDeactivatable)r.get();
            if (storer != null) {
                storer.enableWrites();
            }
        });
    }

    private void disableAll() {
        this.registry.forEach(r -> {
            PersistenceStorerDeactivatable storer = (PersistenceStorerDeactivatable)r.get();
            if (storer != null) {
                storer.disableWrites();
            }
        });
    }

    private static /* synthetic */ void lambda$clean$0(XList newRegistry, WeakReference e) {
        Object referent = e.get();
        if (referent != null) {
            newRegistry.add((Object)e);
        }
    }

    private static class CleaningThread
    extends Thread {
        StorerModeController controller;

        public CleaningThread(StorerModeController controller) {
            super("Microstream-StorerModeController");
            this.controller = controller;
        }

        @Override
        public void run() {
            while (this.controller.hasRegisteredStorers() && this.controller.isActive()) {
                try {
                    Thread.sleep(1000L);
                }
                catch (InterruptedException e) {
                    logger.debug("Ignored an InterruptedException while sleeping!");
                }
                this.controller.clean();
            }
        }
    }
}

