/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.serializer.persistence.types;

import org.eclipse.serializer.persistence.types.Persistence;
import org.eclipse.serializer.reflect.ClassLoaderProvider;
import org.eclipse.serializer.reflect.XReflect;
import org.eclipse.serializer.util.X;

public interface PersistenceTypeResolver {
    default public String substituteClassIdentifierSeparator() {
        return Persistence.substituteClassIdentifierSeparator();
    }

    default public String deriveTypeName(Class<?> type) {
        return Persistence.derivePersistentTypeName(type, this.substituteClassIdentifierSeparator());
    }

    default public ClassLoader getTypeResolvingClassLoader(String typeName) {
        return XReflect.defaultTypeResolvingClassLoader();
    }

    default public Class<?> resolveType(String typeName) {
        return Persistence.resolveType(typeName, this.getTypeResolvingClassLoader(typeName), this.substituteClassIdentifierSeparator());
    }

    default public Class<?> tryResolveType(String typeName) {
        return Persistence.tryResolveType(typeName, this.getTypeResolvingClassLoader(typeName));
    }

    public static PersistenceTypeResolver New(ClassLoaderProvider classLoaderProvider) {
        return new Default((ClassLoaderProvider)X.notNull((Object)classLoaderProvider));
    }

    public static final class Default
    implements PersistenceTypeResolver {
        private final ClassLoaderProvider classLoaderProvider;

        Default(ClassLoaderProvider classLoaderProvider) {
            this.classLoaderProvider = classLoaderProvider;
        }

        @Override
        public ClassLoader getTypeResolvingClassLoader(String typeName) {
            return this.classLoaderProvider.provideClassLoader(typeName);
        }
    }
}

