/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.serializer.persistence.types;

import java.util.function.BiConsumer;
import org.eclipse.serializer.collections.HashMapIdObject;
import org.eclipse.serializer.collections.HashMapObjectId;
import org.eclipse.serializer.persistence.exceptions.PersistenceException;
import org.eclipse.serializer.persistence.exceptions.PersistenceExceptionConsistency;
import org.eclipse.serializer.persistence.exceptions.PersistenceExceptionConsistencyWrongType;
import org.eclipse.serializer.persistence.exceptions.PersistenceExceptionConsistencyWrongTypeId;
import org.eclipse.serializer.persistence.types.PersistenceTypeLink;
import org.eclipse.serializer.persistence.types.PersistenceTypeLookup;
import org.eclipse.serializer.reference.Swizzling;

public interface PersistenceTypeRegistry
extends PersistenceTypeLookup {
    public boolean registerType(long var1, Class<?> var3) throws PersistenceExceptionConsistency;

    public boolean registerTypes(Iterable<? extends PersistenceTypeLink> var1) throws PersistenceExceptionConsistency;

    public void iteratePerIds(BiConsumer<Long, ? super Class<?>> var1);

    public static Default New() {
        return new Default();
    }

    public static final class Default
    implements PersistenceTypeRegistry {
        private final HashMapIdObject<Class<?>> typesPerIds = HashMapIdObject.New();
        private final HashMapObjectId<Class<?>> idsPerTypes = HashMapObjectId.New();

        Default() {
        }

        @Override
        public final synchronized long lookupTypeId(Class<?> type) {
            return this.idsPerTypes.get(type, Swizzling.notFoundId());
        }

        @Override
        public final synchronized <T> Class<T> lookupType(long typeId) {
            return (Class)this.typesPerIds.get(typeId);
        }

        @Override
        public final synchronized boolean validateTypeMapping(long typeId, Class<?> type) throws PersistenceExceptionConsistency {
            if (Swizzling.isNotProperId((long)typeId)) {
                throw new PersistenceException("Not a proper TypeId: " + typeId + " for type " + type);
            }
            Class registeredType = (Class)this.typesPerIds.get(typeId);
            long registeredTypeId = this.idsPerTypes.get(type, Swizzling.notFoundId());
            if (registeredType == null) {
                if (Swizzling.isNotFoundId((long)registeredTypeId)) {
                    return false;
                }
                throw new PersistenceExceptionConsistencyWrongTypeId(type, registeredTypeId, typeId);
            }
            if (registeredType == type) {
                if (registeredTypeId == typeId) {
                    return true;
                }
                throw new PersistenceExceptionConsistencyWrongTypeId(type, registeredTypeId, typeId);
            }
            throw new PersistenceExceptionConsistencyWrongType(typeId, registeredType, type);
        }

        @Override
        public final synchronized boolean validateTypeMappings(Iterable<? extends PersistenceTypeLink> mappings) throws PersistenceExceptionConsistency {
            boolean containsAll = true;
            for (PersistenceTypeLink persistenceTypeLink : mappings) {
                if (this.validateTypeMapping(persistenceTypeLink.typeId(), persistenceTypeLink.type())) continue;
                containsAll = false;
            }
            return containsAll;
        }

        private void synchRegisterType(long typeId, Class<?> type) {
            this.typesPerIds.add(typeId, type);
            this.idsPerTypes.add(type, typeId);
        }

        @Override
        public final synchronized boolean registerType(long typeId, Class<?> type) throws PersistenceExceptionConsistency {
            if (this.validateTypeMapping(typeId, type)) {
                return false;
            }
            this.synchRegisterType(typeId, type);
            return true;
        }

        @Override
        public final synchronized boolean registerTypes(Iterable<? extends PersistenceTypeLink> types) throws PersistenceExceptionConsistency {
            if (this.validateTypeMappings(types)) {
                return false;
            }
            for (PersistenceTypeLink persistenceTypeLink : types) {
                this.synchRegisterType(persistenceTypeLink.typeId(), persistenceTypeLink.type());
            }
            return true;
        }

        @Override
        public void iteratePerIds(BiConsumer<Long, ? super Class<?>> consumer) {
            this.typesPerIds.iterate(c -> consumer.accept((Long)c.key(), (Class<?>)c.value()));
        }
    }
}

