/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.serializer.persistence.types;

import org.eclipse.serializer.chars.VarString;
import org.eclipse.serializer.collections.types.XGettingEnum;
import org.eclipse.serializer.persistence.exceptions.PersistenceException;
import org.eclipse.serializer.persistence.types.PersistenceTypeDictionary;
import org.eclipse.serializer.persistence.types.PersistenceTypeHandler;

public interface PersistenceTypeMismatchValidator<D> {
    public void validateTypeMismatches(PersistenceTypeDictionary var1, XGettingEnum<PersistenceTypeHandler<D, ?>> var2);

    public static <D> Failing<D> Failing() {
        return new Failing();
    }

    public static <D> NoOp<D> NoOp() {
        return new NoOp();
    }

    public static final class NoOp<D>
    implements PersistenceTypeMismatchValidator<D> {
        @Override
        public void validateTypeMismatches(PersistenceTypeDictionary typeDictionary, XGettingEnum<PersistenceTypeHandler<D, ?>> unmatchableTypeHandlers) {
        }
    }

    public static final class Failing<D>
    implements PersistenceTypeMismatchValidator<D> {
        @Override
        public void validateTypeMismatches(PersistenceTypeDictionary typeDictionary, XGettingEnum<PersistenceTypeHandler<D, ?>> unmatchableTypeHandlers) {
            if (unmatchableTypeHandlers.isEmpty()) {
                return;
            }
            VarString vs = VarString.New((String)"[");
            unmatchableTypeHandlers.iterate(th -> vs.add(',').add(th.type().getName()));
            vs.deleteLast().setLast(']');
            throw new PersistenceException("Persistence type definition mismatch for the following types: " + vs);
        }
    }
}

