/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.serializer.persistence.types;

import org.eclipse.serializer.chars.XChars;
import org.eclipse.serializer.collections.EqHashTable;
import org.eclipse.serializer.collections.types.XGettingTable;
import org.eclipse.serializer.persistence.exceptions.PersistenceException;
import org.eclipse.serializer.persistence.types.PersistenceTypeDefinition;
import org.eclipse.serializer.persistence.types.PersistenceTypeDescriptionMember;
import org.eclipse.serializer.persistence.types.PersistenceTypeLineageView;
import org.eclipse.serializer.util.X;

public interface PersistenceTypeLineage {
    public String typeName();

    public Class<?> type();

    public XGettingTable<Long, PersistenceTypeDefinition> entries();

    public PersistenceTypeDefinition latest();

    public PersistenceTypeDefinition runtimeDefinition();

    public PersistenceTypeLineageView view();

    public boolean registerTypeDefinition(PersistenceTypeDefinition var1);

    public boolean setRuntimeTypeDefinition(PersistenceTypeDefinition var1);

    public static Default New(String runtimeTypeName, Class<?> runtimeType) {
        return new Default((String)X.mayNull((Object)runtimeTypeName), (Class)X.mayNull(runtimeType));
    }

    public static final class Default
    implements PersistenceTypeLineage {
        final String runtimeTypeName;
        final Class<?> runtimeType;
        final EqHashTable<Long, PersistenceTypeDefinition> entries;
        PersistenceTypeDefinition runtimeDefinition;

        Default(String runtimeTypeName, Class<?> runtimeType) {
            this.runtimeTypeName = runtimeTypeName;
            this.runtimeType = runtimeType;
            this.entries = EqHashTable.New();
        }

        @Override
        public final String typeName() {
            return this.runtimeTypeName;
        }

        @Override
        public final Class<?> type() {
            return this.runtimeType;
        }

        @Override
        public final XGettingTable<Long, PersistenceTypeDefinition> entries() {
            return this.entries;
        }

        @Override
        public final synchronized PersistenceTypeDefinition runtimeDefinition() {
            return this.runtimeDefinition;
        }

        @Override
        public final synchronized PersistenceTypeDefinition latest() {
            return (PersistenceTypeDefinition)this.entries.values().peek();
        }

        private void validate(PersistenceTypeDefinition typeDefinition) {
            if (this.isValid(typeDefinition)) {
                return;
            }
            throw new PersistenceException("Invalid type definition for type lineage " + this.typeName());
        }

        private boolean isValid(PersistenceTypeDefinition typeDefinition) {
            if (!XChars.isEqual((String)this.runtimeTypeName, (String)typeDefinition.runtimeTypeName())) {
                return false;
            }
            PersistenceTypeDefinition alreadyRegistered = (PersistenceTypeDefinition)this.entries.get((Object)typeDefinition.typeId());
            if (alreadyRegistered == null) {
                return true;
            }
            return PersistenceTypeDescriptionMember.equalStructures(typeDefinition.allMembers(), alreadyRegistered.allMembers());
        }

        @Override
        public synchronized boolean registerTypeDefinition(PersistenceTypeDefinition typeDefinition) {
            this.validate(typeDefinition);
            return this.synchRegisterTypeDefinition(typeDefinition);
        }

        private boolean synchRegisterTypeDefinition(PersistenceTypeDefinition typeDefinition) {
            if (this.entries.put((Object)typeDefinition.typeId(), (Object)typeDefinition)) {
                this.entries.keys().sort(Long::compare);
                return true;
            }
            return false;
        }

        @Override
        public final synchronized boolean setRuntimeTypeDefinition(PersistenceTypeDefinition runtimeDefinition) {
            if (!this.synchCheckViability(runtimeDefinition)) {
                return false;
            }
            this.runtimeDefinition = runtimeDefinition;
            this.entries.put((Object)runtimeDefinition.typeId(), (Object)runtimeDefinition);
            return true;
        }

        private boolean synchCheckViability(PersistenceTypeDefinition runtimeDefinition) {
            if (this.runtimeDefinition != null) {
                if (this.runtimeDefinition == runtimeDefinition) {
                    return false;
                }
                throw new PersistenceException("Runtime definition already initialized");
            }
            if (this.isValid(runtimeDefinition)) {
                return true;
            }
            throw new PersistenceException("Invalid runtime definition for " + this.typeName() + " with type id: " + runtimeDefinition.typeId());
        }

        @Override
        public synchronized PersistenceTypeLineageView view() {
            return PersistenceTypeLineageView.New(this);
        }

        public String toString() {
            return PersistenceTypeLineage.class.getSimpleName() + " " + this.runtimeTypeName + " " + this.entries.keys();
        }
    }
}

