/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.serializer.persistence.types;

import org.eclipse.serializer.collections.ConstHashTable;
import org.eclipse.serializer.collections.types.XGettingMap;
import org.eclipse.serializer.persistence.types.PersistenceInstantiator;
import org.eclipse.serializer.persistence.types.PersistenceTypeInstantiator;
import org.eclipse.serializer.util.X;

public interface PersistenceTypeInstantiatorProvider<D> {
    public <T> PersistenceTypeInstantiator<D, T> provideTypeInstantiator(Class<T> var1);

    public static <D> PersistenceTypeInstantiatorProvider<D> Provider() {
        return new PersistenceInstantiator.Default();
    }

    public static <D> PersistenceTypeInstantiatorProvider<D> New(PersistenceInstantiator<D> instantiator) {
        return new Default((PersistenceInstantiator)X.notNull(instantiator));
    }

    public static <D> PersistenceTypeInstantiatorProvider<D> New(XGettingMap<Class<?>, PersistenceTypeInstantiator<D, ?>> instantiatorMapping, PersistenceInstantiator<D> instantiator) {
        return instantiatorMapping.isEmpty() ? PersistenceTypeInstantiatorProvider.New(instantiator) : new Mapped(ConstHashTable.New(instantiatorMapping), (PersistenceInstantiator)X.notNull(instantiator));
    }

    public static final class Mapped<D>
    extends Default<D> {
        private final ConstHashTable<Class<?>, PersistenceTypeInstantiator<D, ?>> instantiatorMapping;

        Mapped(ConstHashTable<Class<?>, PersistenceTypeInstantiator<D, ?>> instantiatorMapping, PersistenceInstantiator<D> universalInstantiator) {
            super(universalInstantiator);
            this.instantiatorMapping = instantiatorMapping;
        }

        @Override
        public final <T> PersistenceTypeInstantiator<D, T> provideTypeInstantiator(Class<T> type) {
            PersistenceTypeInstantiator mappedInstatiator = (PersistenceTypeInstantiator)this.instantiatorMapping.get(type);
            PersistenceTypeInstantiator casted = mappedInstatiator != null ? mappedInstatiator : super.provideTypeInstantiator(type);
            return casted;
        }
    }

    public static class Default<D>
    implements PersistenceTypeInstantiatorProvider<D> {
        private final PersistenceInstantiator<D> instantiator;

        Default(PersistenceInstantiator<D> instantiator) {
            this.instantiator = instantiator;
        }

        @Override
        public <T> PersistenceTypeInstantiator<D, T> provideTypeInstantiator(Class<T> type) {
            return PersistenceTypeInstantiator.New(type, this.instantiator);
        }
    }
}

