/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.serializer.persistence.types;

import org.eclipse.serializer.persistence.types.Persistence;
import org.eclipse.serializer.persistence.types.PersistenceTypeIdHolder;

public interface PersistenceTypeIdProvider
extends PersistenceTypeIdHolder {
    public long provideNextTypeId();

    public PersistenceTypeIdProvider initializeTypeId();

    public PersistenceTypeIdProvider updateCurrentTypeId(long var1);

    public static PersistenceTypeIdProvider Transient() {
        return new Transient(Persistence.defaultStartTypeId());
    }

    public static PersistenceTypeIdProvider Transient(long startingTypeId) {
        return new Transient(Persistence.validateTypeId(startingTypeId));
    }

    public static Failing Failing() {
        return new Failing();
    }

    public static final class Failing
    implements PersistenceTypeIdProvider {
        private long currentTypeId;

        Failing() {
        }

        @Override
        public Failing initializeTypeId() {
            return this;
        }

        @Override
        public long currentTypeId() {
            return this.currentTypeId;
        }

        @Override
        public Failing updateCurrentTypeId(long currentTypeId) {
            this.currentTypeId = currentTypeId;
            return this;
        }

        @Override
        public long provideNextTypeId() {
            throw new UnsupportedOperationException();
        }
    }

    public static final class Transient
    implements PersistenceTypeIdProvider {
        private long currentTypeId;

        Transient(long startingTypeId) {
            this.currentTypeId = startingTypeId;
        }

        @Override
        public final synchronized long provideNextTypeId() {
            return ++this.currentTypeId;
        }

        @Override
        public final synchronized long currentTypeId() {
            return this.currentTypeId;
        }

        @Override
        public final Transient initializeTypeId() {
            return this;
        }

        @Override
        public final synchronized PersistenceTypeIdProvider updateCurrentTypeId(long currentTypeId) {
            this.currentTypeId = currentTypeId;
            return this;
        }
    }
}

