/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.serializer.persistence.types;

import java.lang.reflect.Field;
import java.util.function.Consumer;
import org.eclipse.serializer.collections.EqHashEnum;
import org.eclipse.serializer.collections.types.XGettingEnum;
import org.eclipse.serializer.collections.types.XGettingSequence;
import org.eclipse.serializer.collections.types.XImmutableEnum;
import org.eclipse.serializer.collections.types.XImmutableSequence;
import org.eclipse.serializer.hashing.HashEqualator;
import org.eclipse.serializer.persistence.exceptions.PersistenceException;
import org.eclipse.serializer.persistence.exceptions.PersistenceExceptionTypeConsistency;
import org.eclipse.serializer.persistence.exceptions.PersistenceExceptionTypeNotPersistable;
import org.eclipse.serializer.persistence.types.Persistence;
import org.eclipse.serializer.persistence.types.PersistenceDataTypeHolder;
import org.eclipse.serializer.persistence.types.PersistenceFieldLengthResolver;
import org.eclipse.serializer.persistence.types.PersistenceFunction;
import org.eclipse.serializer.persistence.types.PersistenceLoadHandler;
import org.eclipse.serializer.persistence.types.PersistenceReferenceLoader;
import org.eclipse.serializer.persistence.types.PersistenceStoreHandler;
import org.eclipse.serializer.persistence.types.PersistenceTypeDefinition;
import org.eclipse.serializer.persistence.types.PersistenceTypeDefinitionMember;
import org.eclipse.serializer.persistence.types.PersistenceTypeDefinitionMemberFieldReflective;
import org.eclipse.serializer.persistence.types.PersistenceTypeDescriptionMember;
import org.eclipse.serializer.persistence.types.PersistenceTypeDescriptionMemberFieldReflective;
import org.eclipse.serializer.reference.Swizzling;
import org.eclipse.serializer.reflect.XReflect;
import org.eclipse.serializer.util.X;

public interface PersistenceTypeHandler<D, T>
extends PersistenceTypeDefinition,
PersistenceDataTypeHolder<D> {
    @Override
    public Class<D> dataType();

    public Class<T> type();

    default public boolean isValidEntityType(Class<? extends T> type) {
        return this.type().isAssignableFrom(type);
    }

    default public void validateEntityType(Class<? extends T> type) {
        if (this.isValidEntityType(type)) {
            return;
        }
        throw new PersistenceExceptionTypeConsistency("Invalid entity type " + type + " for type handler " + this.toTypeIdentifier());
    }

    @Override
    public XGettingEnum<? extends PersistenceTypeDefinitionMember> allMembers();

    @Override
    public XGettingEnum<? extends PersistenceTypeDefinitionMember> instanceMembers();

    public void iterateInstanceReferences(T var1, PersistenceFunction var2);

    public void iterateLoadableReferences(D var1, PersistenceReferenceLoader var2);

    public void store(D var1, T var2, long var3, PersistenceStoreHandler<D> var5);

    public T create(D var1, PersistenceLoadHandler var2);

    default public void initializeState(D data, T instance, PersistenceLoadHandler handler) {
        this.updateState(data, instance, handler);
    }

    public void updateState(D var1, T var2, PersistenceLoadHandler var3);

    public void complete(D var1, T var2, PersistenceLoadHandler var3);

    public PersistenceTypeHandler<D, T> initialize(long var1);

    public <C extends Consumer<? super Class<?>>> C iterateMemberTypes(C var1);

    default public XGettingEnum<? extends PersistenceTypeDefinitionMember> membersInDeclaredOrder() {
        return this.allMembers();
    }

    default public XGettingEnum<? extends PersistenceTypeDescriptionMember> storingMembers() {
        return this.instanceMembers();
    }

    default public XGettingEnum<? extends PersistenceTypeDescriptionMember> settingMembers() {
        return this.storingMembers();
    }

    default public void guaranteeSpecificInstanceViablity() throws PersistenceExceptionTypeNotPersistable {
    }

    default public boolean isSpecificInstanceViable() {
        return true;
    }

    default public void guaranteeSubTypeInstanceViablity() throws PersistenceExceptionTypeNotPersistable {
    }

    default public boolean isSubTypeInstanceViable() {
        return true;
    }

    default public Object[] collectEnumConstants() {
        throw new UnsupportedOperationException();
    }

    default public int getPersistedEnumOrdinal(D data) {
        throw new UnsupportedOperationException();
    }

    public static <T, M> T resolveEnumConstant(Class<T> type, int ordinal) {
        Object enumConstantInstance;
        Object enumConstantinstance = enumConstantInstance = XReflect.resolveEnumConstantInstance(type, (int)ordinal);
        return (T)enumConstantinstance;
    }

    public static abstract class Abstract<D, T>
    implements PersistenceTypeHandler<D, T> {
        private final Class<T> type;
        private final String typeName;
        private long typeId = Swizzling.notFoundId();

        public static <D extends PersistenceTypeDefinitionMember> XImmutableEnum<D> validateAndImmure(XGettingSequence<D> members) {
            if (members == null) {
                return null;
            }
            EqHashEnum validatedMembers = EqHashEnum.New((HashEqualator)PersistenceTypeDescriptionMember.identityHashEqualator());
            validatedMembers.addAll(members);
            if (validatedMembers.size() != members.size()) {
                throw new PersistenceExceptionTypeConsistency("Duplicate member descriptions.");
            }
            return validatedMembers.immure();
        }

        public static final PersistenceTypeDefinitionMemberFieldReflective declaredField(Field field, PersistenceFieldLengthResolver lengthResolver) {
            return PersistenceTypeDefinitionMemberFieldReflective.New(field, lengthResolver.resolveMinimumLengthFromField(field), lengthResolver.resolveMaximumLengthFromField(field));
        }

        public static final XImmutableSequence<PersistenceTypeDescriptionMemberFieldReflective> declaredFields(PersistenceTypeDescriptionMemberFieldReflective ... declaredFields) {
            return X.ConstList((Object[])declaredFields);
        }

        protected static final String deriveTypeName(Class<?> type) {
            return Persistence.derivePersistentTypeName(type);
        }

        protected Abstract(Class<T> type) {
            this(type, type.getName());
        }

        protected Abstract(Class<T> type, String typeName) {
            this.type = (Class)X.notNull(type);
            this.typeName = (String)X.notNull((Object)typeName);
        }

        protected final void validateInstance(T instance) {
            if (this.type.isInstance(instance)) {
                return;
            }
            throw new PersistenceExceptionTypeConsistency();
        }

        @Override
        public final Class<T> type() {
            return this.type;
        }

        @Override
        public final long typeId() {
            return this.typeId;
        }

        @Override
        public final String typeName() {
            return this.typeName;
        }

        protected void internalInitialize() {
        }

        @Override
        public synchronized PersistenceTypeHandler<D, T> initialize(long typeId) {
            if (Swizzling.isFoundId((long)this.typeId)) {
                if (this.typeId == typeId) {
                    return this;
                }
                throw new PersistenceException("Specified type ID " + typeId + " conflicts with already initalized type ID " + this.typeId);
            }
            this.typeId = typeId;
            this.internalInitialize();
            return this;
        }

        public final String toString() {
            return this.toRuntimeTypeIdentifier();
        }
    }
}

