/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.serializer.persistence.types;

import org.eclipse.serializer.collections.BulkList;
import org.eclipse.serializer.collections.EqHashEnum;
import org.eclipse.serializer.collections.EqHashTable;
import org.eclipse.serializer.collections.XSort;
import org.eclipse.serializer.collections.types.XAddingSequence;
import org.eclipse.serializer.collections.types.XGettingEnum;
import org.eclipse.serializer.collections.types.XGettingSequence;
import org.eclipse.serializer.collections.types.XGettingTable;
import org.eclipse.serializer.collections.types.XSortableSequence;
import org.eclipse.serializer.hashing.HashEqualator;
import org.eclipse.serializer.persistence.exceptions.PersistenceException;
import org.eclipse.serializer.persistence.types.PersistenceTypeDefinition;
import org.eclipse.serializer.persistence.types.PersistenceTypeDefinitionCreator;
import org.eclipse.serializer.persistence.types.PersistenceTypeDefinitionMember;
import org.eclipse.serializer.persistence.types.PersistenceTypeDefinitionMemberCreator;
import org.eclipse.serializer.persistence.types.PersistenceTypeDescription;
import org.eclipse.serializer.persistence.types.PersistenceTypeDescriptionMember;
import org.eclipse.serializer.persistence.types.PersistenceTypeDescriptionResolver;
import org.eclipse.serializer.persistence.types.PersistenceTypeDescriptionResolverProvider;
import org.eclipse.serializer.persistence.types.PersistenceTypeDictionary;
import org.eclipse.serializer.persistence.types.PersistenceTypeDictionaryCreator;
import org.eclipse.serializer.persistence.types.PersistenceTypeDictionaryEntry;
import org.eclipse.serializer.util.X;

@FunctionalInterface
public interface PersistenceTypeDictionaryBuilder {
    public PersistenceTypeDictionary buildTypeDictionary(XGettingSequence<? extends PersistenceTypeDictionaryEntry> var1);

    public static XGettingTable<Long, PersistenceTypeDictionaryEntry> ensureUniqueTypeIds(XGettingSequence<? extends PersistenceTypeDictionaryEntry> entries) {
        EqHashTable uniqueTypeIdEntries = EqHashTable.New();
        if (entries != null) {
            for (PersistenceTypeDictionaryEntry e : entries) {
                if (uniqueTypeIdEntries.add((Object)e.typeId(), (Object)e)) continue;
                throw new PersistenceException("TypeId conflict for " + e.typeId() + " " + e.typeName());
            }
            XSort.valueSort((XSortableSequence)uniqueTypeIdEntries.keys(), Long::compare);
        }
        return uniqueTypeIdEntries;
    }

    public static PersistenceTypeDictionary buildTypeDictionary(PersistenceTypeDictionaryCreator typeDictionaryCreator, PersistenceTypeDefinitionCreator typeDefinitionCreator, PersistenceTypeDescriptionResolver typeResolver, XGettingSequence<? extends PersistenceTypeDictionaryEntry> entries) {
        XGettingTable<Long, PersistenceTypeDictionaryEntry> uniqueTypeIdEntries = PersistenceTypeDictionaryBuilder.ensureUniqueTypeIds(entries);
        PersistenceTypeDefinitionMemberCreator.Default memberCreator = PersistenceTypeDefinitionMemberCreator.New((XGettingSequence<? extends PersistenceTypeDescription>)uniqueTypeIdEntries.values(), typeResolver);
        BulkList typeDefs = BulkList.New((long)uniqueTypeIdEntries.size());
        for (PersistenceTypeDescription e : uniqueTypeIdEntries.values()) {
            EqHashEnum allMembers = EqHashEnum.New((HashEqualator)PersistenceTypeDescriptionMember.identityHashEqualator());
            EqHashEnum instanceMembers = EqHashEnum.New((HashEqualator)PersistenceTypeDescriptionMember.identityHashEqualator());
            PersistenceTypeDictionaryBuilder.buildDefinitionMembers(memberCreator, e, (XAddingSequence<? super PersistenceTypeDefinitionMember>)allMembers, (XAddingSequence<? super PersistenceTypeDefinitionMember>)instanceMembers);
            String runtimeTypeName = typeResolver.resolveRuntimeTypeName(e);
            Class<?> type = runtimeTypeName == null ? null : typeResolver.tryResolveType(runtimeTypeName);
            PersistenceTypeDefinition typeDef = typeDefinitionCreator.createTypeDefinition(e.typeId(), e.typeName(), runtimeTypeName, type, (XGettingEnum<? extends PersistenceTypeDefinitionMember>)allMembers, (XGettingEnum<? extends PersistenceTypeDefinitionMember>)instanceMembers);
            typeDefs.add((Object)typeDef);
        }
        PersistenceTypeDictionary typeDictionary = typeDictionaryCreator.createTypeDictionary();
        typeDictionary.registerTypeDefinitions((Iterable<? extends PersistenceTypeDefinition>)typeDefs);
        return typeDictionary;
    }

    public static void buildDefinitionMembers(PersistenceTypeDefinitionMemberCreator memberCreator, PersistenceTypeDescription typeDescription, XAddingSequence<? super PersistenceTypeDefinitionMember> allMembers, XAddingSequence<? super PersistenceTypeDefinitionMember> instanceMembers) {
        for (PersistenceTypeDescriptionMember member : typeDescription.allMembers()) {
            PersistenceTypeDefinitionMember definitionMember = member.createDefinitionMember(memberCreator);
            if (!allMembers.add((Object)definitionMember)) {
                throw new PersistenceException("Duplicate type member entry: " + member.identifier());
            }
            if (!definitionMember.isInstanceMember()) continue;
            instanceMembers.add((Object)definitionMember);
        }
    }

    public static Default New(PersistenceTypeDictionaryCreator typeDictionaryCreator, PersistenceTypeDefinitionCreator typeDefinitionCreator, PersistenceTypeDescriptionResolverProvider typeResolverProvider) {
        return new Default((PersistenceTypeDictionaryCreator)X.notNull((Object)typeDictionaryCreator), (PersistenceTypeDefinitionCreator)X.notNull((Object)typeDefinitionCreator), (PersistenceTypeDescriptionResolverProvider)X.notNull((Object)typeResolverProvider));
    }

    public static class Default
    implements PersistenceTypeDictionaryBuilder {
        final PersistenceTypeDictionaryCreator typeDictionaryCreator;
        final PersistenceTypeDefinitionCreator typeDefinitionCreator;
        final PersistenceTypeDescriptionResolverProvider typeResolverProvider;

        Default(PersistenceTypeDictionaryCreator typeDictionaryCreator, PersistenceTypeDefinitionCreator typeDefinitionCreator, PersistenceTypeDescriptionResolverProvider typeResolverProvider) {
            this.typeDictionaryCreator = typeDictionaryCreator;
            this.typeDefinitionCreator = typeDefinitionCreator;
            this.typeResolverProvider = typeResolverProvider;
        }

        @Override
        public PersistenceTypeDictionary buildTypeDictionary(XGettingSequence<? extends PersistenceTypeDictionaryEntry> entries) {
            return PersistenceTypeDictionaryBuilder.buildTypeDictionary(this.typeDictionaryCreator, this.typeDefinitionCreator, this.typeResolverProvider.provideTypeDescriptionResolver(), entries);
        }
    }
}

