/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.serializer.persistence.types;

import java.util.function.Consumer;
import org.eclipse.serializer.chars.VarString;
import org.eclipse.serializer.collections.EqHashTable;
import org.eclipse.serializer.collections.XSort;
import org.eclipse.serializer.collections.types.XGettingCollection;
import org.eclipse.serializer.collections.types.XGettingTable;
import org.eclipse.serializer.persistence.exceptions.PersistenceException;
import org.eclipse.serializer.persistence.exceptions.PersistenceExceptionTypeConsistencyDictionary;
import org.eclipse.serializer.persistence.types.PersistenceTypeDefinition;
import org.eclipse.serializer.persistence.types.PersistenceTypeDefinitionRegistrationObserver;
import org.eclipse.serializer.persistence.types.PersistenceTypeDictionaryView;
import org.eclipse.serializer.persistence.types.PersistenceTypeLineage;
import org.eclipse.serializer.persistence.types.PersistenceTypeLineageCreator;
import org.eclipse.serializer.reference.Swizzling;
import org.eclipse.serializer.reflect.XReflect;
import org.eclipse.serializer.typing.KeyValue;
import org.eclipse.serializer.util.X;

public interface PersistenceTypeDictionary {
    public PersistenceTypeDefinition lookupTypeByName(String var1);

    public PersistenceTypeDefinition lookupTypeById(long var1);

    public XGettingTable<String, ? extends PersistenceTypeLineage> typeLineages();

    public PersistenceTypeLineage lookupTypeLineage(Class<?> var1);

    public PersistenceTypeLineage lookupTypeLineage(String var1);

    public XGettingTable<Long, PersistenceTypeDefinition> allTypeDefinitions();

    public boolean isEmpty();

    public long determineHighestTypeId();

    public PersistenceTypeDictionaryView view();

    default public <C extends Consumer<? super PersistenceTypeDefinition>> C iterateAllTypeDefinitions(C logic) {
        return (C)this.allTypeDefinitions().values().iterate(logic);
    }

    default public <C extends Consumer<? super PersistenceTypeDefinition>> C iterateRuntimeDefinitions(C logic) {
        this.iterateTypeLineageViews(tl -> logic.accept(tl.runtimeDefinition()));
        return logic;
    }

    default public <C extends Consumer<? super PersistenceTypeDefinition>> C resolveTypeIds(Iterable<Long> typeIds, C collector) {
        for (Long typeId : typeIds) {
            PersistenceTypeDefinition typeDefinition = this.lookupTypeById(typeId);
            if (typeDefinition == null) {
                throw new PersistenceExceptionTypeConsistencyDictionary("TypeId cannot be resolved: " + typeId);
            }
            collector.accept((PersistenceTypeDefinition)typeDefinition);
        }
        return collector;
    }

    default public <C extends Consumer<? super PersistenceTypeDefinition>> C iterateLatestTypes(C logic) {
        this.iterateTypeLineageViews(tl -> logic.accept(tl.latest()));
        return logic;
    }

    default public <C extends Consumer<? super PersistenceTypeLineage>> C iterateTypeLineageViews(C logic) {
        return (C)this.typeLineages().values().iterate(logic);
    }

    public PersistenceTypeLineage ensureTypeLineage(Class<?> var1);

    public boolean registerTypeDefinition(PersistenceTypeDefinition var1);

    public boolean registerTypeDefinitions(Iterable<? extends PersistenceTypeDefinition> var1);

    public boolean registerRuntimeTypeDefinition(PersistenceTypeDefinition var1);

    public boolean registerRuntimeTypeDefinitions(Iterable<? extends PersistenceTypeDefinition> var1);

    public PersistenceTypeDictionary setTypeDescriptionRegistrationObserver(PersistenceTypeDefinitionRegistrationObserver var1);

    public PersistenceTypeDefinitionRegistrationObserver getTypeDescriptionRegistrationObserver();

    public static void validateTypeId(PersistenceTypeDefinition typeDefinition) {
        if (Swizzling.isFoundId((long)typeDefinition.typeId())) {
            return;
        }
        throw new PersistenceException("Uninitialized TypeId for type definition " + typeDefinition.typeName());
    }

    public static void validateTypeIds(Iterable<? extends PersistenceTypeDefinition> typeDefinitions) {
        typeDefinitions.forEach(PersistenceTypeDictionary::validateTypeId);
    }

    default public <C extends Consumer<? super PersistenceTypeLineage>> C iterateTypeLineages(C logic) {
        return (C)this.typeLineages().values().iterate(logic);
    }

    public static <D extends PersistenceTypeDictionary> D registerTypes(D typeDictionary, XGettingCollection<? extends PersistenceTypeDefinition> typeDefinitions) {
        typeDictionary.registerTypeDefinitions((Iterable<? extends PersistenceTypeDefinition>)typeDefinitions);
        return typeDictionary;
    }

    public static VarString assembleTypesPerTypeId(VarString vs, XGettingTable<Long, PersistenceTypeDefinition> allTypesPerTypeId) {
        for (PersistenceTypeDefinition type : allTypesPerTypeId.values()) {
            vs.add((Object)type).lf();
        }
        return vs;
    }

    public static long determineHighestTypeId(XGettingTable<Long, PersistenceTypeDefinition> allTypesPerTypeId) {
        long maxTypeId = Swizzling.notFoundId();
        for (Long typeId : allTypesPerTypeId.keys()) {
            if (typeId < maxTypeId) continue;
            maxTypeId = typeId;
        }
        return maxTypeId;
    }

    public static PersistenceTypeDictionary New(PersistenceTypeLineageCreator typeLineageCreator) {
        return new Default((PersistenceTypeLineageCreator)X.notNull((Object)typeLineageCreator));
    }

    public static PersistenceTypeDictionary New(PersistenceTypeLineageCreator typeLineageCreator, XGettingCollection<? extends PersistenceTypeDefinition> typeDefinitions) {
        return PersistenceTypeDictionary.registerTypes(PersistenceTypeDictionary.New(typeLineageCreator), typeDefinitions);
    }

    public static boolean isVariableLength(String typeName) {
        switch (typeName) {
            case "[byte]": 
            case "[char]": 
            case "[list]": {
                return true;
            }
        }
        return false;
    }

    public static String fullQualifiedFieldName(String qualifier, String fieldName) {
        if (qualifier == null) {
            return fieldName;
        }
        return PersistenceTypeDictionary.fullQualifiedFieldName(VarString.New(), qualifier, fieldName).toString();
    }

    public static char fullQualifiedFieldNameSeparator() {
        return Symbols.MEMBER_FIELD_QUALIFIER_SEPERATOR;
    }

    public static VarString fullQualifiedFieldName(VarString vc, String qualifier, String fieldName) {
        if (qualifier != null) {
            vc.add(qualifier).add(PersistenceTypeDictionary.fullQualifiedFieldNameSeparator());
        }
        return vc.add(fieldName);
    }

    public static KeyValue<String, String> splitFullQualifiedFieldName(String identifier) {
        int index = identifier.lastIndexOf(PersistenceTypeDictionary.fullQualifiedFieldNameSeparator());
        return index < 0 ? X.KeyValue(null, (Object)identifier) : X.KeyValue((Object)identifier.substring(0, index).trim(), (Object)identifier.substring(index + 1).trim());
    }

    public static boolean isInlinedComplexType(String typeName) {
        return "[list]".equals(typeName);
    }

    public static boolean isInlinedVariableLengthType(String typeName) {
        return "[byte]".equals(typeName) || "[char]".equals(typeName) || PersistenceTypeDictionary.isInlinedComplexType(typeName);
    }

    public static class Symbols {
        protected static final transient char TYPE_START = '{';
        protected static final transient char TYPE_END = '}';
        protected static final transient char MEMBER_FIELD_QUALIFIER_SEPERATOR = XReflect.fieldIdentifierDelimiter();
        protected static final transient char MEMBER_TERMINATOR = ',';
        protected static final transient char MEMBER_COMPLEX_DEF_START = '(';
        protected static final transient char MEMBER_COMPLEX_DEF_END = ')';
        protected static final transient String KEYWORD_PRIMITIVE = "primitive";
        protected static final transient String KEYWORD_ENUM = XReflect.typename_enum();
        protected static final transient String TYPE_CHARS = "[char]";
        protected static final transient String TYPE_BYTES = "[byte]";
        protected static final transient String TYPE_COMPLEX = "[list]";
        protected static final transient char[] ARRAY_KEYWORD_PRIMITIVE = "primitive".toCharArray();
        protected static final transient char[] ARRAY_KEYWORD_ENUM = KEYWORD_ENUM.toCharArray();
        protected static final transient char[] ARRAY_TYPE_CHARS = "[char]".toCharArray();
        protected static final transient char[] ARRAY_TYPE_BYTES = "[byte]".toCharArray();
        protected static final transient char[] ARRAY_TYPE_COMPLEX = "[list]".toCharArray();

        public static final String typeChars() {
            return TYPE_CHARS;
        }

        public static final String typeBytes() {
            return TYPE_BYTES;
        }

        public static final String typeComplex() {
            return TYPE_COMPLEX;
        }

        protected Symbols() {
        }
    }

    public static final class Default
    implements PersistenceTypeDictionary {
        private final PersistenceTypeLineageCreator typeLineageCreator;
        private final EqHashTable<String, PersistenceTypeLineage> typeLineages = EqHashTable.New();
        private final EqHashTable<Long, PersistenceTypeDefinition> allTypesPerTypeId = EqHashTable.New();
        private PersistenceTypeDefinitionRegistrationObserver registrationObserver;

        Default(PersistenceTypeLineageCreator typeLineageCreator) {
            this.typeLineageCreator = typeLineageCreator;
        }

        public final XGettingTable<String, PersistenceTypeLineage> typeLineages() {
            return this.typeLineages;
        }

        @Override
        public synchronized PersistenceTypeLineage lookupTypeLineage(Class<?> type) {
            return this.synchLookupTypeLineage(type.getName());
        }

        @Override
        public synchronized PersistenceTypeLineage lookupTypeLineage(String typeName) {
            return this.synchLookupTypeLineage(typeName);
        }

        private <T> PersistenceTypeLineage synchLookupTypeLineage(String typeName) {
            PersistenceTypeLineage lineage = (PersistenceTypeLineage)this.typeLineages.get((Object)typeName);
            return lineage;
        }

        @Override
        public synchronized PersistenceTypeLineage ensureTypeLineage(Class<?> type) {
            PersistenceTypeLineage lineage = this.lookupTypeLineage(type);
            if (lineage != null) {
                return lineage;
            }
            return this.synchRegisterTypeLineage(this.typeLineageCreator.createTypeLineage(type));
        }

        private <T> PersistenceTypeLineage synchRegisterTypeLineage(PersistenceTypeLineage lineage) {
            this.typeLineages.add((Object)lineage.typeName(), (Object)lineage);
            this.synchSortTypeLineages();
            return lineage;
        }

        public synchronized PersistenceTypeLineage ensureTypeLineage(PersistenceTypeDefinition typeDefinition) {
            PersistenceTypeLineage typeLineage = this.lookupTypeLineage(typeDefinition.runtimeTypeName());
            if (typeLineage == null) {
                typeLineage = this.typeLineageCreator.createTypeLineage(typeDefinition.runtimeTypeName(), typeDefinition.type());
                this.synchRegisterTypeLineage(typeLineage);
            }
            return typeLineage;
        }

        final <T> boolean synchRegisterType(PersistenceTypeDefinition typeDefinition) {
            PersistenceTypeLineage lineage = this.ensureTypeLineage(typeDefinition);
            boolean hasChanged = lineage.registerTypeDefinition(typeDefinition);
            this.allTypesPerTypeId.put((Object)typeDefinition.typeId(), (Object)typeDefinition);
            if (this.registrationObserver != null) {
                this.registrationObserver.observeTypeDefinitionRegistration(typeDefinition);
            }
            return hasChanged;
        }

        private void synchSortTypeLineages() {
            this.typeLineages.keys().sort(XSort::compare);
        }

        private void internalSort() {
            this.allTypesPerTypeId.keys().sort(XSort::compare);
        }

        @Override
        public final synchronized PersistenceTypeDictionary setTypeDescriptionRegistrationObserver(PersistenceTypeDefinitionRegistrationObserver registrationObserver) {
            this.registrationObserver = registrationObserver;
            return this;
        }

        @Override
        public final synchronized PersistenceTypeDefinitionRegistrationObserver getTypeDescriptionRegistrationObserver() {
            return this.registrationObserver;
        }

        @Override
        public final synchronized XGettingTable<Long, PersistenceTypeDefinition> allTypeDefinitions() {
            return this.allTypesPerTypeId;
        }

        @Override
        public final synchronized boolean isEmpty() {
            return this.allTypesPerTypeId.isEmpty();
        }

        @Override
        public final synchronized boolean registerTypeDefinition(PersistenceTypeDefinition typeDefinition) {
            PersistenceTypeDictionary.validateTypeId(typeDefinition);
            if (this.synchRegisterType(typeDefinition)) {
                this.internalSort();
                return true;
            }
            return false;
        }

        @Override
        public final synchronized boolean registerTypeDefinitions(Iterable<? extends PersistenceTypeDefinition> typeDefinitions) {
            PersistenceTypeDictionary.validateTypeIds(typeDefinitions);
            long oldSize = this.allTypesPerTypeId.size();
            for (PersistenceTypeDefinition persistenceTypeDefinition : typeDefinitions) {
                this.synchRegisterType(persistenceTypeDefinition);
            }
            if (this.allTypesPerTypeId.size() != oldSize) {
                this.internalSort();
                return true;
            }
            return false;
        }

        @Override
        public final synchronized boolean registerRuntimeTypeDefinition(PersistenceTypeDefinition typeDefinition) {
            boolean returnValue = this.registerTypeDefinition(typeDefinition);
            this.synchSetRuntimeTypeDefinition(typeDefinition);
            return returnValue;
        }

        @Override
        public final synchronized boolean registerRuntimeTypeDefinitions(Iterable<? extends PersistenceTypeDefinition> typeDefinitions) {
            boolean returnValue = this.registerTypeDefinitions(typeDefinitions);
            for (PersistenceTypeDefinition persistenceTypeDefinition : typeDefinitions) {
                this.synchSetRuntimeTypeDefinition(persistenceTypeDefinition);
            }
            return returnValue;
        }

        private <T> void synchSetRuntimeTypeDefinition(PersistenceTypeDefinition td) {
            PersistenceTypeLineage lineage = this.lookupTypeLineage(td.runtimeTypeName());
            lineage.setRuntimeTypeDefinition(td);
        }

        @Override
        public final synchronized PersistenceTypeDefinition lookupTypeByName(String typeName) {
            PersistenceTypeLineage lineage = this.lookupTypeLineage(typeName);
            return lineage == null ? null : lineage.latest();
        }

        @Override
        public final synchronized PersistenceTypeDefinition lookupTypeById(long typeId) {
            return (PersistenceTypeDefinition)this.allTypesPerTypeId.get((Object)typeId);
        }

        @Override
        public final synchronized long determineHighestTypeId() {
            return PersistenceTypeDictionary.determineHighestTypeId(this.allTypesPerTypeId);
        }

        @Override
        public synchronized PersistenceTypeDictionaryView view() {
            return PersistenceTypeDictionaryView.New(this);
        }

        public final synchronized String toString() {
            return PersistenceTypeDictionary.assembleTypesPerTypeId(VarString.New(), this.allTypesPerTypeId).toString();
        }
    }
}

