/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.serializer.persistence.types;

import org.eclipse.serializer.persistence.exceptions.PersistenceException;
import org.eclipse.serializer.persistence.types.PersistenceTypeDescriptionMember;
import org.eclipse.serializer.persistence.types.PersistenceTypeDictionary;

public interface PersistenceTypeDescriptionMemberField
extends PersistenceTypeDescriptionMember {
    @Override
    public String typeName();

    @Override
    public String qualifier();

    @Override
    public String name();

    @Override
    default public boolean isInstanceMember() {
        return true;
    }

    public static abstract class Abstract
    implements PersistenceTypeDescriptionMemberField {
        private final String typeName;
        private final String qualifier;
        private final String name;
        private final boolean isReference;
        private final boolean isPrimitive;
        private final boolean hasReferences;
        private final long persistentMinimumLength;
        private final long persistentMaximumLength;
        private final String qualifiedFieldName;

        protected Abstract(String typeName, String qualifier, String name, boolean isReference, boolean isPrimitive, boolean hasReferences, long persistentMinimumLength, long persistentMaximumLength) {
            this.typeName = typeName;
            this.qualifier = qualifier;
            this.name = name;
            this.isReference = isReference;
            this.isPrimitive = isPrimitive;
            this.hasReferences = hasReferences;
            this.persistentMinimumLength = persistentMinimumLength;
            this.persistentMaximumLength = persistentMaximumLength;
            this.qualifiedFieldName = PersistenceTypeDictionary.fullQualifiedFieldName(qualifier, name);
        }

        @Override
        public final String typeName() {
            return this.typeName;
        }

        @Override
        public final String qualifier() {
            return this.qualifier;
        }

        @Override
        public final String name() {
            return this.name;
        }

        @Override
        public final String identifier() {
            return this.qualifiedFieldName;
        }

        @Override
        public final boolean isReference() {
            return this.isReference;
        }

        @Override
        public final boolean isPrimitive() {
            return this.isPrimitive;
        }

        @Override
        public final boolean isPrimitiveDefinition() {
            return false;
        }

        @Override
        public final boolean isEnumConstant() {
            return false;
        }

        @Override
        public boolean hasReferences() {
            return this.hasReferences;
        }

        @Override
        public long persistentMinimumLength() {
            return this.persistentMinimumLength;
        }

        @Override
        public long persistentMaximumLength() {
            return this.persistentMaximumLength;
        }

        @Override
        public boolean isValidPersistentLength(long persistentLength) {
            return persistentLength >= this.persistentMinimumLength && persistentLength <= this.persistentMaximumLength;
        }

        @Override
        public void validatePersistentLength(long persistentLength) {
            if (this.isValidPersistentLength(persistentLength)) {
                return;
            }
            throw new PersistenceException("Invalid persistent length: " + persistentLength + " not in [" + this.persistentMinimumLength + ";" + this.persistentMaximumLength + "]");
        }

        @Override
        public final boolean isInstanceMember() {
            return true;
        }

        public String toString() {
            return this.typeName() + " " + this.identifier();
        }
    }
}

