/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.serializer.persistence.types;

import org.eclipse.serializer.persistence.types.PersistenceFoundation;
import org.eclipse.serializer.persistence.types.PersistenceObjectManager;
import org.eclipse.serializer.persistence.types.PersistenceStorer;
import org.eclipse.serializer.persistence.types.PersistenceStorerDeactivatable;
import org.eclipse.serializer.persistence.types.PersistenceStorerDeactivatableRegistry;
import org.eclipse.serializer.persistence.types.PersistenceTarget;
import org.eclipse.serializer.persistence.types.PersistenceTypeHandlerManager;
import org.eclipse.serializer.reference.ObjectSwizzling;
import org.eclipse.serializer.util.BufferSizeProviderIncremental;
import org.eclipse.serializer.util.logging.Logging;
import org.slf4j.Logger;

public class PersistenceStorerCreatorDeactivatable<D>
implements PersistenceStorer.Creator<D> {
    private static final Logger logger = Logging.getLogger(PersistenceStorerCreatorDeactivatable.class);
    private final PersistenceStorer.Creator<D> creator;
    private final PersistenceStorerDeactivatableRegistry storerRegistry;

    public static <D> PersistenceStorerCreatorDeactivatable<D> New(PersistenceFoundation<D, ?> connectionFoundation, PersistenceStorerDeactivatableRegistry storerRegistry) {
        return new PersistenceStorerCreatorDeactivatable<D>(connectionFoundation.getStorerCreator(), storerRegistry);
    }

    public PersistenceStorerCreatorDeactivatable(PersistenceStorer.Creator<D> creator, PersistenceStorerDeactivatableRegistry storerModeController) {
        this.creator = creator;
        this.storerRegistry = storerModeController;
    }

    @Override
    public PersistenceStorer createLazyStorer(PersistenceTypeHandlerManager<D> typeManager, PersistenceObjectManager<D> objectManager, ObjectSwizzling objectRetriever, PersistenceTarget<D> target, BufferSizeProviderIncremental bufferSizeProvider) {
        logger.debug("Creating lazy storer");
        return this.storerRegistry.register(new PersistenceStorerDeactivatable(this.creator.createLazyStorer(typeManager, objectManager, objectRetriever, target, bufferSizeProvider)));
    }

    @Override
    public PersistenceStorer createEagerStorer(PersistenceTypeHandlerManager<D> typeManager, PersistenceObjectManager<D> objectManager, ObjectSwizzling objectRetriever, PersistenceTarget<D> target, BufferSizeProviderIncremental bufferSizeProvider) {
        logger.debug("Creating eager storer");
        return this.storerRegistry.register(new PersistenceStorerDeactivatable(this.creator.createEagerStorer(typeManager, objectManager, objectRetriever, target, bufferSizeProvider)));
    }
}

