/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.serializer.persistence.types;

import java.lang.reflect.Field;
import java.lang.reflect.Member;
import java.util.function.Function;
import java.util.function.Supplier;
import org.eclipse.serializer.collections.EqConstHashTable;
import org.eclipse.serializer.collections.EqHashEnum;
import org.eclipse.serializer.collections.EqHashTable;
import org.eclipse.serializer.collections.types.XGettingEnum;
import org.eclipse.serializer.collections.types.XGettingTable;
import org.eclipse.serializer.collections.types.XMap;
import org.eclipse.serializer.collections.types.XTable;
import org.eclipse.serializer.persistence.exceptions.PersistenceException;
import org.eclipse.serializer.persistence.types.PersistenceMetaIdentifiers;
import org.eclipse.serializer.persistence.types.PersistenceRootEntry;
import org.eclipse.serializer.persistence.types.PersistenceRootReference;
import org.eclipse.serializer.persistence.types.PersistenceTypeDescriptionResolver;
import org.eclipse.serializer.persistence.types.PersistenceTypeDescriptionResolverProvider;
import org.eclipse.serializer.persistence.types.PersistenceTypeHandler;
import org.eclipse.serializer.persistence.types.PersistenceTypeHandlerManager;
import org.eclipse.serializer.reference.Reference;
import org.eclipse.serializer.reflect.XReflect;
import org.eclipse.serializer.typing.KeyValue;
import org.eclipse.serializer.util.X;

public interface PersistenceRootResolver {
    public String rootIdentifier();

    public PersistenceRootReference root();

    public PersistenceRootEntry resolveRootInstance(String var1);

    public XGettingTable<String, PersistenceRootEntry> definedEntries();

    default public PersistenceRootEntry rootEntry() {
        return (PersistenceRootEntry)this.definedEntries().get((Object)this.rootIdentifier());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    default public void resolveRootEntries(XMap<String, PersistenceRootEntry> resolvedEntriesAcceptor, XGettingEnum<String> identifiers) {
        EqHashEnum unresolvedIdentifiers = EqHashEnum.New();
        PersistenceRootResolver persistenceRootResolver = this;
        synchronized (persistenceRootResolver) {
            for (String identifier : identifiers) {
                PersistenceRootEntry resolvedRootEntry = this.resolveRootInstance(identifier);
                if (resolvedRootEntry != null) {
                    resolvedEntriesAcceptor.add((Object)identifier, (Object)resolvedRootEntry);
                    continue;
                }
                if (resolvedEntriesAcceptor.keys().contains((Object)identifier)) continue;
                unresolvedIdentifiers.add((Object)identifier);
            }
            if (!unresolvedIdentifiers.isEmpty()) {
                throw new PersistenceException("The following root identifiers cannot be resolved: " + unresolvedIdentifiers);
            }
        }
    }

    default public XGettingTable<String, Object> resolveDefinedRootInstances() {
        return this.resolveRootInstances(this.definedEntries());
    }

    default public XTable<String, Object> resolveRootInstances(XGettingTable<String, PersistenceRootEntry> entries) {
        EqHashTable resolvedRoots = EqHashTable.New();
        for (PersistenceRootEntry entry : entries.values()) {
            if (entry == null) continue;
            String rootIdentifier = entry.identifier();
            Object rootInstance = entry.instance();
            resolvedRoots.add((Object)rootIdentifier, rootInstance);
        }
        return resolvedRoots;
    }

    public static XGettingTable<String, Supplier<?>> deriveRoots(Class<?> ... types) {
        return PersistenceRootResolver.deriveRoots(XReflect::deriveFieldIdentifier, types);
    }

    public static XGettingTable<String, Supplier<?>> deriveRoots(Function<Field, String> rootIdentifierDeriver, Class<?> ... types) {
        EqHashTable roots = EqHashTable.New();
        PersistenceRootResolver.addRoots(roots, rootIdentifierDeriver, types);
        return roots;
    }

    public static void addRoots(EqHashTable<String, Supplier<?>> roots, Function<Field, String> rootIdentifierDeriver, Class<?> ... types) {
        for (Class<?> type : types) {
            PersistenceRootResolver.addRoots(roots, rootIdentifierDeriver, type);
        }
    }

    public static void addRoots(EqHashTable<String, Supplier<?>> roots, Function<Field, String> rootIdentifierDeriver, Class<?> type) {
        for (Field field : type.getDeclaredFields()) {
            String rootIdentifier;
            if (!XReflect.isStatic((Member)field) || !XReflect.isReference((Field)field) || field.getName().startsWith("$SWITCH_TABLE") || (rootIdentifier = rootIdentifierDeriver.apply(field)) == null) continue;
            field.setAccessible(true);
            roots.add((Object)rootIdentifier, () -> XReflect.getFieldValue((Field)field, null));
        }
    }

    public static Supplier<?> wrapCustomRoot(Object customRootInstance) {
        X.notNull((Object)customRootInstance);
        return () -> customRootInstance;
    }

    public static PersistenceRootResolver Wrap(PersistenceRootResolver actualRootResolver, PersistenceTypeDescriptionResolverProvider refactoringMappingProvider) {
        return new MappingWrapper(actualRootResolver, refactoringMappingProvider);
    }

    public static final class MappingWrapper
    implements PersistenceRootResolver {
        final PersistenceRootResolver actualRootResolver;
        final PersistenceTypeDescriptionResolverProvider refactoringMappingProvider;

        MappingWrapper(PersistenceRootResolver actualRootResolver, PersistenceTypeDescriptionResolverProvider refactoringMappingProvider) {
            this.actualRootResolver = actualRootResolver;
            this.refactoringMappingProvider = refactoringMappingProvider;
        }

        @Override
        public final String rootIdentifier() {
            return this.actualRootResolver.rootIdentifier();
        }

        @Override
        public final PersistenceRootReference root() {
            return this.actualRootResolver.root();
        }

        @Override
        public final XGettingTable<String, PersistenceRootEntry> definedEntries() {
            return this.actualRootResolver.definedEntries();
        }

        @Override
        public final PersistenceRootEntry resolveRootInstance(String identifier) {
            String sourceIdentifier;
            PersistenceTypeDescriptionResolver resolver = this.refactoringMappingProvider.provideTypeDescriptionResolver();
            KeyValue<String, String> mapping = resolver.lookup(sourceIdentifier = PersistenceMetaIdentifiers.normalizeIdentifier(identifier));
            if (mapping == null) {
                return this.actualRootResolver.resolveRootInstance(sourceIdentifier);
            }
            String targetIdentifier = PersistenceMetaIdentifiers.normalizeIdentifier((String)mapping.value());
            if (targetIdentifier == null) {
                return PersistenceRootEntry.New(sourceIdentifier, null);
            }
            PersistenceRootEntry mappedEntry = this.actualRootResolver.resolveRootInstance(targetIdentifier);
            if (mappedEntry == null) {
                throw new PersistenceException("Refactoring mapping target identifier cannot be resolved: " + targetIdentifier);
            }
            return mappedEntry;
        }
    }

    public static final class Default
    implements PersistenceRootResolver {
        private final String rootIdentifier;
        private final PersistenceRootReference rootReference;
        private final EqConstHashTable<String, PersistenceRootEntry> definedRootEntries;
        private final Reference<? extends PersistenceTypeHandlerManager<?>> referenceTypeHandlerManager;
        private transient PersistenceTypeHandlerManager<?> cachedTypeHandlerManager;

        Default(String rootIdentifier, PersistenceRootReference rootReference, EqConstHashTable<String, PersistenceRootEntry> definedRootEntries, Reference<? extends PersistenceTypeHandlerManager<?>> referenceTypeHandlerManager) {
            this.rootIdentifier = rootIdentifier;
            this.rootReference = rootReference;
            this.definedRootEntries = definedRootEntries;
            this.referenceTypeHandlerManager = referenceTypeHandlerManager;
        }

        @Override
        public final String rootIdentifier() {
            return this.rootIdentifier;
        }

        @Override
        public final PersistenceRootReference root() {
            return this.rootReference;
        }

        @Override
        public final XGettingTable<String, PersistenceRootEntry> definedEntries() {
            return this.definedRootEntries;
        }

        private PersistenceTypeHandlerManager<?> typeHandlerManager() {
            if (this.cachedTypeHandlerManager == null) {
                this.cachedTypeHandlerManager = (PersistenceTypeHandlerManager)this.referenceTypeHandlerManager.get();
            }
            return this.cachedTypeHandlerManager;
        }

        @Override
        public final PersistenceRootEntry resolveRootInstance(String identifier) {
            PersistenceRootEntry rootEntry = (PersistenceRootEntry)this.definedRootEntries.get((Object)identifier);
            if (rootEntry != null) {
                return rootEntry;
            }
            return this.resolveRootEnumConstants(identifier);
        }

        private PersistenceRootEntry resolveRootEnumConstants(String identifier) {
            PersistenceTypeHandlerManager<?> typeHandlerManager = this.typeHandlerManager();
            Long enumTypeId = typeHandlerManager.parseEnumRootIdentifierTypeId(identifier);
            if (enumTypeId == null) {
                return null;
            }
            PersistenceTypeHandler<?, ?> enumTypeHandler = typeHandlerManager.lookupTypeHandler(enumTypeId);
            if (enumTypeHandler == null) {
                typeHandlerManager.ensureTypeHandlersByTypeIds((XGettingEnum<Long>)X.Enum((Object[])new Long[]{enumTypeId}));
                enumTypeHandler = typeHandlerManager.lookupTypeHandler(enumTypeId);
                if (enumTypeHandler == null) {
                    throw new PersistenceException("No PersistenceTypeHandler found for root enum constant with TypeId: " + enumTypeId);
                }
            }
            Object[] enumConstants = typeHandlerManager.collectEnumConstants(enumTypeHandler);
            return PersistenceRootEntry.New(identifier, () -> enumConstants);
        }
    }
}

